/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import io.leangen.graphql.generator.MappedType;
import io.leangen.graphql.util.ClassUtils;
import io.leangen.graphql.util.Directives;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeRegistry {
    private final Map<String, Map<String, MappedType>> covariantOutputTypes = new ConcurrentHashMap<String, Map<String, MappedType>>();
    private final Set<GraphQLObjectType> discoveredTypes = new HashSet<GraphQLObjectType>();
    private static final Logger log = LoggerFactory.getLogger(TypeRegistry.class);

    public TypeRegistry(Collection<GraphQLType> knownTypes) {
        knownTypes.stream().filter(type -> type instanceof GraphQLObjectType && Directives.isMappedType(type)).map(type -> (GraphQLObjectType)type).forEach(obj -> obj.getInterfaces().forEach(inter -> this.registerCovariantType(inter.getName(), Directives.getMappedType((GraphQLType)obj), (GraphQLOutputType)obj)));
        knownTypes.stream().filter(type -> type instanceof GraphQLUnionType).map(type -> (GraphQLUnionType)type).forEach(union -> union.getTypes().stream().filter(type -> type instanceof GraphQLObjectType && Directives.isMappedType((GraphQLType)type)).map(type -> (GraphQLObjectType)type).forEach(obj -> this.registerCovariantType(union.getName(), Directives.getMappedType((GraphQLType)obj), (GraphQLOutputType)obj)));
    }

    public void registerDiscoveredCovariantType(String compositeTypeName, AnnotatedType javaSubType, GraphQLObjectType subType) {
        this.discoveredTypes.add(subType);
        this.registerCovariantType(compositeTypeName, javaSubType, (GraphQLOutputType)subType);
    }

    public void registerCovariantType(String compositeTypeName, AnnotatedType javaSubType, GraphQLOutputType subType) {
        this.covariantOutputTypes.putIfAbsent(compositeTypeName, new ConcurrentHashMap());
        Map<String, MappedType> covariantTypes = this.covariantOutputTypes.get(compositeTypeName);
        if (subType instanceof GraphQLObjectType || covariantTypes.get(subType.getName()) == null || covariantTypes.get((Object)subType.getName()).graphQLType instanceof GraphQLTypeReference) {
            covariantTypes.put(subType.getName(), new MappedType(javaSubType, subType));
        }
    }

    public List<MappedType> getOutputTypes(String compositeTypeName, Class objectType) {
        Map<String, MappedType> mappedTypes = this.covariantOutputTypes.get(compositeTypeName);
        if (mappedTypes == null) {
            return Collections.emptyList();
        }
        if (objectType == null) {
            return new ArrayList<MappedType>(mappedTypes.values());
        }
        return mappedTypes.values().stream().filter(mappedType -> ClassUtils.getRawType(mappedType.javaType.getType()).isAssignableFrom(objectType)).collect(Collectors.toList());
    }

    public List<MappedType> getOutputTypes(String compositeTypeName) {
        return new ArrayList<MappedType>(this.covariantOutputTypes.get(compositeTypeName).values());
    }

    public Set<GraphQLObjectType> getDiscoveredTypes() {
        return this.discoveredTypes;
    }

    void resolveTypeReferences(Map<String, GraphQLType> resolvedTypes) {
        for (Map<String, MappedType> covariantTypes : this.covariantOutputTypes.values()) {
            HashSet<String> toRemove = new HashSet<String>();
            for (Map.Entry<String, MappedType> entry : covariantTypes.entrySet()) {
                if (!(entry.getValue().graphQLType instanceof GraphQLTypeReference)) continue;
                GraphQLOutputType resolvedType = (GraphQLOutputType)resolvedTypes.get(entry.getKey());
                if (resolvedType != null) {
                    entry.setValue(new MappedType(entry.getValue().javaType, resolvedType));
                    continue;
                }
                log.warn("Type reference " + entry.getKey() + " could not be replaced correctly. This can occur when the schema generator is initialized with additional types not built by GraphQL SPQR. If this type implements Node, in some edge cases it may end up not exposed via the 'node' query.");
                toRemove.add(entry.getKey());
            }
            toRemove.forEach(covariantTypes::remove);
            covariantTypes.replaceAll((typeName, mapped) -> mapped.graphQLType instanceof GraphQLTypeReference ? new MappedType(mapped.javaType, (GraphQLOutputType)resolvedTypes.get(typeName)) : mapped);
        }
    }
}

