/*
 * Decompiled with CFR 0.152.
 */
package io.leangen.graphql.generator;

import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import io.leangen.graphql.generator.TypeRegistry;
import io.leangen.graphql.util.GraphQLUtils;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TypeCache {
    private final Map<String, GraphQLType> knownTypes;

    TypeCache(Collection<GraphQLType> knownTypes) {
        this.knownTypes = knownTypes.stream().collect(Collectors.toMap(GraphQLType::getName, Function.identity()));
    }

    public void register(String typeName) {
        this.knownTypes.put(typeName, null);
    }

    public boolean contains(String typeName) {
        return this.knownTypes.containsKey(typeName);
    }

    GraphQLType resolveType(String typeName) {
        GraphQLType resolved = this.knownTypes.get(typeName);
        if (resolved instanceof GraphQLTypeReference) {
            throw new IllegalStateException("Type " + typeName + " is not yet resolvable");
        }
        return resolved;
    }

    void completeType(GraphQLOutputType type) {
        if (!((type = (GraphQLOutputType)GraphQLUtils.unwrap((GraphQLType)type)) instanceof GraphQLTypeReference)) {
            this.knownTypes.put(type.getName(), (GraphQLType)type);
        }
    }

    void resolveTypeReferences(TypeRegistry typeRegistry) {
        typeRegistry.resolveTypeReferences(this.knownTypes);
    }
}

