/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.credentials.Authentication;
import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Supplier;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class RefreshAuthentication
implements Authentication,
Interceptor {
    private Instant expiry = Instant.MIN;
    private Duration refreshPeriod;
    private String token;
    private Supplier<String> tokenSupplier;
    private Clock clock;

    public RefreshAuthentication(Supplier<String> tokenSupplier, Duration refreshPeriod) {
        this(tokenSupplier, refreshPeriod, Clock.systemUTC());
    }

    public RefreshAuthentication(Supplier<String> tokenSupplier, Duration refreshPeriod, Clock clock) {
        this.refreshPeriod = refreshPeriod;
        this.token = tokenSupplier.get();
        this.tokenSupplier = tokenSupplier;
        this.clock = clock;
    }

    private String getToken() {
        if (Instant.now(this.clock).isAfter(this.expiry)) {
            this.token = this.tokenSupplier.get();
            this.expiry = Instant.now(this.clock).plusSeconds(this.refreshPeriod.toSeconds());
        }
        return this.token;
    }

    public Duration getRefreshPeriod() {
        return this.refreshPeriod;
    }

    public void setExpiry(Instant expiry) {
        this.expiry = expiry;
    }

    @Override
    public void provide(ApiClient client) {
        OkHttpClient withInterceptor = client.getHttpClient().newBuilder().addInterceptor((Interceptor)this).build();
        client.setHttpClient(withInterceptor);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Request newRequest = request.newBuilder().header("Authorization", "Bearer " + this.getToken()).build();
        return chain.proceed(newRequest);
    }
}

