/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util.credentials;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.util.SSLUtils;
import io.kubernetes.client.util.credentials.Authentication;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.KeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCertificateAuthentication
implements Authentication {
    private static final Logger log = LoggerFactory.getLogger(ClientCertificateAuthentication.class);
    private final byte[] certificate;
    private final byte[] key;

    public ClientCertificateAuthentication(byte[] certificate, byte[] key) {
        this.certificate = certificate;
        this.key = key;
    }

    @Override
    public void provide(ApiClient client) {
        String algo = SSLUtils.recognizePrivateKeyAlgo(this.key);
        try {
            KeyManager[] keyManagers = SSLUtils.keyManagers(this.certificate, this.key, algo, "", null, null);
            client.setKeyManagers(keyManagers);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | InvalidKeySpecException e) {
            log.warn("Could not create key manager for Client Certificate authentication.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

