/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client;

import io.kubernetes.client.ApiClient;
import io.kubernetes.client.ApiException;
import io.kubernetes.client.Configuration;
import io.kubernetes.client.models.V1Pod;
import io.kubernetes.client.util.WebSocketStreamHandler;
import io.kubernetes.client.util.WebSockets;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;

public class Exec {
    private ApiClient apiClient;

    public Exec() {
        this(Configuration.getDefaultApiClient());
    }

    public Exec(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private String makePath(String namespace, String name, String[] command, String container, boolean stdin, boolean tty) {
        String path = "/api/v1/namespaces/" + namespace + "/pods/" + name + "/exec?stdin=" + stdin + "&tty=" + tty + (container != null ? "&container=" + container : "") + "&command=" + StringUtils.join((Object[])command, (String)"&command=");
        return path;
    }

    public Process exec(String namespace, String name, String[] command, boolean stdin) throws ApiException, IOException {
        return this.exec(namespace, name, command, null, stdin, false);
    }

    public Process exec(V1Pod pod, String[] command, boolean stdin) throws ApiException, IOException {
        return this.exec(pod, command, null, stdin, false);
    }

    public Process exec(String namespace, String name, String[] command, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.exec(namespace, name, command, null, stdin, tty);
    }

    public Process exec(V1Pod pod, String[] command, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.exec(pod, command, null, stdin, tty);
    }

    public Process exec(V1Pod pod, String[] command, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        return this.exec(pod.getMetadata().getNamespace(), pod.getMetadata().getName(), command, container, stdin, tty);
    }

    public Process exec(String namespace, String name, String[] command, String container, boolean stdin, boolean tty) throws ApiException, IOException {
        String path = this.makePath(namespace, name, command, container, stdin, tty);
        WebSocketStreamHandler handler = new WebSocketStreamHandler();
        ExecProcess exec = new ExecProcess(handler);
        WebSockets.stream(path, "GET", this.apiClient, handler);
        return exec;
    }

    private static class ExecProcess
    extends Process {
        WebSocketStreamHandler streamHandler;
        private int statusCode;

        public ExecProcess(WebSocketStreamHandler handler) throws IOException {
            this.streamHandler = handler;
            this.statusCode = -1;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.streamHandler.getOutputStream(0);
        }

        @Override
        public InputStream getInputStream() {
            return this.streamHandler.getInputStream(1);
        }

        @Override
        public InputStream getErrorStream() {
            return this.streamHandler.getInputStream(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int waitFor() throws InterruptedException {
            ExecProcess execProcess = this;
            synchronized (execProcess) {
                this.wait();
            }
            return this.statusCode;
        }

        @Override
        public int exitValue() {
            return this.statusCode;
        }

        @Override
        public void destroy() {
            this.streamHandler.close();
        }
    }
}

