/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.spring.extended.network.endpoints;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import io.kubernetes.client.apimachinery.NamespaceName;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.spring.extended.network.endpoints.EndpointsGetter;
import java.time.Duration;

public class PollingEndpointsGetter
implements EndpointsGetter {
    private static final Cache<NamespaceName, V1Endpoints> lastObservedEndpoints = Caffeine.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build();
    private final ApiClient apiClient;

    public PollingEndpointsGetter(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public V1Endpoints get(String namespace, String name) {
        CoreV1Api coreV1Api = new CoreV1Api(this.apiClient);
        return (V1Endpoints)lastObservedEndpoints.get((Object)new NamespaceName(namespace, name), k -> {
            try {
                return coreV1Api.readNamespacedEndpoints(name, namespace, null);
            }
            catch (ApiException e) {
                throw new IllegalStateException(e);
            }
        });
    }
}

