/*
Copyright 2021 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.proto;

public final class V1beta1Apps {
  private V1beta1Apps() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface ControllerRevisionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.ControllerRevision)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    boolean hasData();
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    io.kubernetes.client.proto.Runtime.RawExtension getData();
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder getDataOrBuilder();

    /**
     *
     *
     * <pre>
     * Revision indicates the revision of the state represented by Data.
     * </pre>
     *
     * <code>optional int64 revision = 3;</code>
     */
    boolean hasRevision();
    /**
     *
     *
     * <pre>
     * Revision indicates the revision of the state represented by Data.
     * </pre>
     *
     * <code>optional int64 revision = 3;</code>
     */
    long getRevision();
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision. See the
   * release notes for more information.
   * ControllerRevision implements an immutable snapshot of state data. Clients
   * are responsible for serializing and deserializing the objects that contain
   * their internal state.
   * Once a ControllerRevision has been successfully created, it can not be updated.
   * The API Server will fail validation of all requests that attempt to mutate
   * the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both
   * the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However,
   * it may be subject to name and representation changes in future releases, and clients should not
   * depend on its stability. It is primarily for internal use by controllers.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.ControllerRevision}
   */
  public static final class ControllerRevision extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.ControllerRevision)
      ControllerRevisionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ControllerRevision.newBuilder() to construct.
    private ControllerRevision(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ControllerRevision() {
      revision_ = 0L;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ControllerRevision(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.Runtime.RawExtension.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = data_.toBuilder();
                }
                data_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Runtime.RawExtension.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(data_);
                  data_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 24:
              {
                bitField0_ |= 0x00000004;
                revision_ = input.readInt64();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_ControllerRevision_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_ControllerRevision_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.class,
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int DATA_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.Runtime.RawExtension data_;
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    public boolean hasData() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    public io.kubernetes.client.proto.Runtime.RawExtension getData() {
      return data_ == null
          ? io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()
          : data_;
    }
    /**
     *
     *
     * <pre>
     * Data is the serialized representation of the state.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
     */
    public io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder getDataOrBuilder() {
      return data_ == null
          ? io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()
          : data_;
    }

    public static final int REVISION_FIELD_NUMBER = 3;
    private long revision_;
    /**
     *
     *
     * <pre>
     * Revision indicates the revision of the state represented by Data.
     * </pre>
     *
     * <code>optional int64 revision = 3;</code>
     */
    public boolean hasRevision() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Revision indicates the revision of the state represented by Data.
     * </pre>
     *
     * <code>optional int64 revision = 3;</code>
     */
    public long getRevision() {
      return revision_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getData());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt64(3, revision_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getData());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, revision_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.ControllerRevision)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.ControllerRevision other =
          (io.kubernetes.client.proto.V1beta1Apps.ControllerRevision) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasData() == other.hasData());
      if (hasData()) {
        result = result && getData().equals(other.getData());
      }
      result = result && (hasRevision() == other.hasRevision());
      if (hasRevision()) {
        result = result && (getRevision() == other.getRevision());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasData()) {
        hash = (37 * hash) + DATA_FIELD_NUMBER;
        hash = (53 * hash) + getData().hashCode();
      }
      if (hasRevision()) {
        hash = (37 * hash) + REVISION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRevision());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevision prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED - This group version of ControllerRevision is deprecated by apps/v1beta2/ControllerRevision. See the
     * release notes for more information.
     * ControllerRevision implements an immutable snapshot of state data. Clients
     * are responsible for serializing and deserializing the objects that contain
     * their internal state.
     * Once a ControllerRevision has been successfully created, it can not be updated.
     * The API Server will fail validation of all requests that attempt to mutate
     * the Data field. ControllerRevisions may, however, be deleted. Note that, due to its use by both
     * the DaemonSet and StatefulSet controllers for update and rollback, this object is beta. However,
     * it may be subject to name and representation changes in future releases, and clients should not
     * depend on its stability. It is primarily for internal use by controllers.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.ControllerRevision}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.ControllerRevision)
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ControllerRevision_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ControllerRevision_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.class,
                io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getDataFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (dataBuilder_ == null) {
          data_ = null;
        } else {
          dataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        revision_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ControllerRevision_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision build() {
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevision result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevision result =
            new io.kubernetes.client.proto.V1beta1Apps.ControllerRevision(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (dataBuilder_ == null) {
          result.data_ = data_;
        } else {
          result.data_ = dataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.revision_ = revision_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.ControllerRevision) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.ControllerRevision) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.ControllerRevision other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasData()) {
          mergeData(other.getData());
        }
        if (other.hasRevision()) {
          setRevision(other.getRevision());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevision parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.ControllerRevision) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.Runtime.RawExtension data_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Runtime.RawExtension,
              io.kubernetes.client.proto.Runtime.RawExtension.Builder,
              io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder>
          dataBuilder_;
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public boolean hasData() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public io.kubernetes.client.proto.Runtime.RawExtension getData() {
        if (dataBuilder_ == null) {
          return data_ == null
              ? io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()
              : data_;
        } else {
          return dataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public Builder setData(io.kubernetes.client.proto.Runtime.RawExtension value) {
        if (dataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          data_ = value;
          onChanged();
        } else {
          dataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public Builder setData(
          io.kubernetes.client.proto.Runtime.RawExtension.Builder builderForValue) {
        if (dataBuilder_ == null) {
          data_ = builderForValue.build();
          onChanged();
        } else {
          dataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public Builder mergeData(io.kubernetes.client.proto.Runtime.RawExtension value) {
        if (dataBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && data_ != null
              && data_ != io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()) {
            data_ =
                io.kubernetes.client.proto.Runtime.RawExtension.newBuilder(data_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            data_ = value;
          }
          onChanged();
        } else {
          dataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public Builder clearData() {
        if (dataBuilder_ == null) {
          data_ = null;
          onChanged();
        } else {
          dataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public io.kubernetes.client.proto.Runtime.RawExtension.Builder getDataBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      public io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder getDataOrBuilder() {
        if (dataBuilder_ != null) {
          return dataBuilder_.getMessageOrBuilder();
        } else {
          return data_ == null
              ? io.kubernetes.client.proto.Runtime.RawExtension.getDefaultInstance()
              : data_;
        }
      }
      /**
       *
       *
       * <pre>
       * Data is the serialized representation of the state.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.runtime.RawExtension data = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Runtime.RawExtension,
              io.kubernetes.client.proto.Runtime.RawExtension.Builder,
              io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder>
          getDataFieldBuilder() {
        if (dataBuilder_ == null) {
          dataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Runtime.RawExtension,
                  io.kubernetes.client.proto.Runtime.RawExtension.Builder,
                  io.kubernetes.client.proto.Runtime.RawExtensionOrBuilder>(
                  getData(), getParentForChildren(), isClean());
          data_ = null;
        }
        return dataBuilder_;
      }

      private long revision_;
      /**
       *
       *
       * <pre>
       * Revision indicates the revision of the state represented by Data.
       * </pre>
       *
       * <code>optional int64 revision = 3;</code>
       */
      public boolean hasRevision() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Revision indicates the revision of the state represented by Data.
       * </pre>
       *
       * <code>optional int64 revision = 3;</code>
       */
      public long getRevision() {
        return revision_;
      }
      /**
       *
       *
       * <pre>
       * Revision indicates the revision of the state represented by Data.
       * </pre>
       *
       * <code>optional int64 revision = 3;</code>
       */
      public Builder setRevision(long value) {
        bitField0_ |= 0x00000004;
        revision_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Revision indicates the revision of the state represented by Data.
       * </pre>
       *
       * <code>optional int64 revision = 3;</code>
       */
      public Builder clearRevision() {
        bitField0_ = (bitField0_ & ~0x00000004);
        revision_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.ControllerRevision)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.ControllerRevision)
    private static final io.kubernetes.client.proto.V1beta1Apps.ControllerRevision DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.ControllerRevision();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevision getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ControllerRevision> PARSER =
        new com.google.protobuf.AbstractParser<ControllerRevision>() {
          @java.lang.Override
          public ControllerRevision parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ControllerRevision(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ControllerRevision> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ControllerRevision> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ControllerRevisionListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.ControllerRevisionList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1beta1Apps.ControllerRevision> getItemsList();
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.ControllerRevision getItems(int index);
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * ControllerRevisionList is a resource containing a list of ControllerRevision objects.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.ControllerRevisionList}
   */
  public static final class ControllerRevisionList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.ControllerRevisionList)
      ControllerRevisionListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ControllerRevisionList.newBuilder() to construct.
    private ControllerRevisionList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ControllerRevisionList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ControllerRevisionList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1beta1Apps.ControllerRevision>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_ControllerRevisionList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_ControllerRevisionList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList.class,
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1beta1Apps.ControllerRevision> items_;
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1beta1Apps.ControllerRevision>
        getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    public java.util.List<
            ? extends io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Items is the list of ControllerRevisions
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder getItemsOrBuilder(
        int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList other =
          (io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ControllerRevisionList is a resource containing a list of ControllerRevision objects.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.ControllerRevisionList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.ControllerRevisionList)
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ControllerRevisionList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ControllerRevisionList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList.class,
                io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ControllerRevisionList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList build() {
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList result =
            new io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList other) {
        if (other
            == io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1beta1Apps.ControllerRevision> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1beta1Apps.ControllerRevision>(
                  items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevision,
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder,
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1beta1Apps.ControllerRevision>
          getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1beta1Apps.ControllerRevision value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder setItems(
          int index,
          io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1beta1Apps.ControllerRevision value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1beta1Apps.ControllerRevision value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder addItems(
          io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder addItems(
          int index,
          io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1beta1Apps.ControllerRevision>
              values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder getItemsBuilder(
          int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder getItemsOrBuilder(
          int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(
                io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder addItemsBuilder(
          int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index,
                io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of ControllerRevisions
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.ControllerRevision items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevision,
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder,
              io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.ControllerRevision,
                  io.kubernetes.client.proto.V1beta1Apps.ControllerRevision.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.ControllerRevisionList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.ControllerRevisionList)
    private static final io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ControllerRevisionList> PARSER =
        new com.google.protobuf.AbstractParser<ControllerRevisionList>() {
          @java.lang.Override
          public ControllerRevisionList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ControllerRevisionList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ControllerRevisionList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ControllerRevisionList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.ControllerRevisionList
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.Deployment)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec getSpec();
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentSpecOrBuilder getSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus getStatus();
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentStatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment. See the release notes for
   * more information.
   * Deployment enables declarative updates for Pods and ReplicaSets.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.Deployment}
   */
  public static final class Deployment extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.Deployment)
      DeploymentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Deployment.newBuilder() to construct.
    private Deployment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Deployment() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Deployment(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = status_.toBuilder();
                }
                status_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(status_);
                  status_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_Deployment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_Deployment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.Deployment.class,
              io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec spec_;
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.getDefaultInstance()
          : spec_;
    }

    public static final int STATUS_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus status_;
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus getStatus() {
      return status_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.getDefaultInstance()
          : status_;
    }
    /**
     *
     *
     * <pre>
     * Most recently observed status of the Deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatusOrBuilder getStatusOrBuilder() {
      return status_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.getDefaultInstance()
          : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getStatus());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStatus());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.Deployment)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.Deployment other =
          (io.kubernetes.client.proto.V1beta1Apps.Deployment) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1beta1Apps.Deployment prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED - This group version of Deployment is deprecated by apps/v1beta2/Deployment. See the release notes for
     * more information.
     * Deployment enables declarative updates for Pods and ReplicaSets.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.Deployment}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.Deployment)
        io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_Deployment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_Deployment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.Deployment.class,
                io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.Deployment.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (statusBuilder_ == null) {
          status_ = null;
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_Deployment_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.Deployment getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.Deployment.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.Deployment build() {
        io.kubernetes.client.proto.V1beta1Apps.Deployment result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.Deployment buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.Deployment result =
            new io.kubernetes.client.proto.V1beta1Apps.Deployment(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (statusBuilder_ == null) {
          result.status_ = status_;
        } else {
          result.status_ = statusBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.Deployment) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.Deployment) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.Deployment other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.Deployment.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.Deployment parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.Deployment) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentSpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_
                  != io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus status_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      public Builder setStatus(io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
          onChanged();
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      public Builder setStatus(
          io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
          onChanged();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      public Builder mergeStatus(io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && status_ != null
              && status_
                  != io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.getDefaultInstance()) {
            status_ =
                io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.newBuilder(status_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            status_ = value;
          }
          onChanged();
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      public Builder clearStatus() {
        if (statusBuilder_ == null) {
          status_ = null;
          onChanged();
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.Builder getStatusBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.getDefaultInstance()
              : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * Most recently observed status of the Deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStatus status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.Deployment)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.Deployment)
    private static final io.kubernetes.client.proto.V1beta1Apps.Deployment DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.Deployment();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Deployment getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<Deployment> PARSER =
        new com.google.protobuf.AbstractParser<Deployment>() {
          @java.lang.Override
          public Deployment parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Deployment(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Deployment> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Deployment> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.Deployment getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.DeploymentCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    java.lang.String getStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    com.google.protobuf.ByteString getStatusBytes();

    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    boolean hasLastUpdateTime();
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    io.kubernetes.client.proto.Meta.Time getLastUpdateTime();
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    io.kubernetes.client.proto.Meta.TimeOrBuilder getLastUpdateTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    boolean hasLastTransitionTime();
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    io.kubernetes.client.proto.Meta.Time getLastTransitionTime();
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    boolean hasReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    java.lang.String getReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    com.google.protobuf.ByteString getReasonBytes();

    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    boolean hasMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    com.google.protobuf.ByteString getMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * DeploymentCondition describes the state of a deployment at a certain point.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentCondition}
   */
  public static final class DeploymentCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.DeploymentCondition)
      DeploymentConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentCondition.newBuilder() to construct.
    private DeploymentCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentCondition() {
      type_ = "";
      status_ = "";
      reason_ = "";
      message_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentCondition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                type_ = bs;
                break;
              }
            case 18:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                status_ = bs;
                break;
              }
            case 34:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                reason_ = bs;
                break;
              }
            case 42:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000020;
                message_ = bs;
                break;
              }
            case 50:
              {
                io.kubernetes.client.proto.Meta.Time.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = lastUpdateTime_.toBuilder();
                }
                lastUpdateTime_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.Time.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(lastUpdateTime_);
                  lastUpdateTime_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 58:
              {
                io.kubernetes.client.proto.Meta.Time.Builder subBuilder = null;
                if (((bitField0_ & 0x00000008) == 0x00000008)) {
                  subBuilder = lastTransitionTime_.toBuilder();
                }
                lastTransitionTime_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.Time.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(lastTransitionTime_);
                  lastTransitionTime_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000008;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.class,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of deployment condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private volatile java.lang.Object status_;
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          status_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LASTUPDATETIME_FIELD_NUMBER = 6;
    private io.kubernetes.client.proto.Meta.Time lastUpdateTime_;
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    public boolean hasLastUpdateTime() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    public io.kubernetes.client.proto.Meta.Time getLastUpdateTime() {
      return lastUpdateTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastUpdateTime_;
    }
    /**
     *
     *
     * <pre>
     * The last time this condition was updated.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
     */
    public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastUpdateTimeOrBuilder() {
      return lastUpdateTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastUpdateTime_;
    }

    public static final int LASTTRANSITIONTIME_FIELD_NUMBER = 7;
    private io.kubernetes.client.proto.Meta.Time lastTransitionTime_;
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    public boolean hasLastTransitionTime() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
     */
    public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }

    public static final int REASON_FIELD_NUMBER = 4;
    private volatile java.lang.Object reason_;
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public boolean hasReason() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public java.lang.String getReason() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          reason_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public com.google.protobuf.ByteString getReasonBytes() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MESSAGE_FIELD_NUMBER = 5;
    private volatile java.lang.Object message_;
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          message_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, status_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, reason_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, message_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(6, getLastUpdateTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(7, getLastTransitionTime());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, status_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, reason_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, message_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getLastUpdateTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(7, getLastTransitionTime());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition other =
          (io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition) obj;

      boolean result = true;
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && getType().equals(other.getType());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && (hasLastUpdateTime() == other.hasLastUpdateTime());
      if (hasLastUpdateTime()) {
        result = result && getLastUpdateTime().equals(other.getLastUpdateTime());
      }
      result = result && (hasLastTransitionTime() == other.hasLastTransitionTime());
      if (hasLastTransitionTime()) {
        result = result && getLastTransitionTime().equals(other.getLastTransitionTime());
      }
      result = result && (hasReason() == other.hasReason());
      if (hasReason()) {
        result = result && getReason().equals(other.getReason());
      }
      result = result && (hasMessage() == other.hasMessage());
      if (hasMessage()) {
        result = result && getMessage().equals(other.getMessage());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      if (hasLastUpdateTime()) {
        hash = (37 * hash) + LASTUPDATETIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastUpdateTime().hashCode();
      }
      if (hasLastTransitionTime()) {
        hash = (37 * hash) + LASTTRANSITIONTIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastTransitionTime().hashCode();
      }
      if (hasReason()) {
        hash = (37 * hash) + REASON_FIELD_NUMBER;
        hash = (53 * hash) + getReason().hashCode();
      }
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentCondition describes the state of a deployment at a certain point.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.DeploymentCondition)
        io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.class,
                io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLastUpdateTimeFieldBuilder();
          getLastTransitionTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = null;
        } else {
          lastUpdateTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        reason_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        message_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentCondition_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition build() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition result =
            new io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (lastUpdateTimeBuilder_ == null) {
          result.lastUpdateTime_ = lastUpdateTime_;
        } else {
          result.lastUpdateTime_ = lastUpdateTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (lastTransitionTimeBuilder_ == null) {
          result.lastTransitionTime_ = lastTransitionTime_;
        } else {
          result.lastTransitionTime_ = lastTransitionTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.reason_ = reason_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.message_ = message_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition other) {
        if (other
            == io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.getDefaultInstance())
          return this;
        if (other.hasType()) {
          bitField0_ |= 0x00000001;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasStatus()) {
          bitField0_ |= 0x00000002;
          status_ = other.status_;
          onChanged();
        }
        if (other.hasLastUpdateTime()) {
          mergeLastUpdateTime(other.getLastUpdateTime());
        }
        if (other.hasLastTransitionTime()) {
          mergeLastTransitionTime(other.getLastTransitionTime());
        }
        if (other.hasReason()) {
          bitField0_ |= 0x00000010;
          reason_ = other.reason_;
          onChanged();
        }
        if (other.hasMessage()) {
          bitField0_ |= 0x00000020;
          message_ = other.message_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of deployment condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object status_ = "";
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public java.lang.String getStatus() {
        java.lang.Object ref = status_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            status_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public com.google.protobuf.ByteString getStatusBytes() {
        java.lang.Object ref = status_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          status_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatus(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = getDefaultInstance().getStatus();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatusBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.Time lastUpdateTime_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          lastUpdateTimeBuilder_;
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public boolean hasLastUpdateTime() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public io.kubernetes.client.proto.Meta.Time getLastUpdateTime() {
        if (lastUpdateTimeBuilder_ == null) {
          return lastUpdateTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastUpdateTime_;
        } else {
          return lastUpdateTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public Builder setLastUpdateTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastUpdateTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastUpdateTime_ = value;
          onChanged();
        } else {
          lastUpdateTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public Builder setLastUpdateTime(
          io.kubernetes.client.proto.Meta.Time.Builder builderForValue) {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = builderForValue.build();
          onChanged();
        } else {
          lastUpdateTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public Builder mergeLastUpdateTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastUpdateTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && lastUpdateTime_ != null
              && lastUpdateTime_ != io.kubernetes.client.proto.Meta.Time.getDefaultInstance()) {
            lastUpdateTime_ =
                io.kubernetes.client.proto.Meta.Time.newBuilder(lastUpdateTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastUpdateTime_ = value;
          }
          onChanged();
        } else {
          lastUpdateTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public Builder clearLastUpdateTime() {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTime_ = null;
          onChanged();
        } else {
          lastUpdateTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public io.kubernetes.client.proto.Meta.Time.Builder getLastUpdateTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getLastUpdateTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastUpdateTimeOrBuilder() {
        if (lastUpdateTimeBuilder_ != null) {
          return lastUpdateTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastUpdateTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastUpdateTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * The last time this condition was updated.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastUpdateTime = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          getLastUpdateTimeFieldBuilder() {
        if (lastUpdateTimeBuilder_ == null) {
          lastUpdateTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.Time,
                  io.kubernetes.client.proto.Meta.Time.Builder,
                  io.kubernetes.client.proto.Meta.TimeOrBuilder>(
                  getLastUpdateTime(), getParentForChildren(), isClean());
          lastUpdateTime_ = null;
        }
        return lastUpdateTimeBuilder_;
      }

      private io.kubernetes.client.proto.Meta.Time lastTransitionTime_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          lastTransitionTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public boolean hasLastTransitionTime() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        } else {
          return lastTransitionTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public Builder setLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastTransitionTime_ = value;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public Builder setLastTransitionTime(
          io.kubernetes.client.proto.Meta.Time.Builder builderForValue) {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = builderForValue.build();
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public Builder mergeLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)
              && lastTransitionTime_ != null
              && lastTransitionTime_ != io.kubernetes.client.proto.Meta.Time.getDefaultInstance()) {
            lastTransitionTime_ =
                io.kubernetes.client.proto.Meta.Time.newBuilder(lastTransitionTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastTransitionTime_ = value;
          }
          onChanged();
        } else {
          lastTransitionTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public Builder clearLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public io.kubernetes.client.proto.Meta.Time.Builder getLastTransitionTimeBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getLastTransitionTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
        if (lastTransitionTimeBuilder_ != null) {
          return lastTransitionTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          getLastTransitionTimeFieldBuilder() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.Time,
                  io.kubernetes.client.proto.Meta.Time.Builder,
                  io.kubernetes.client.proto.Meta.TimeOrBuilder>(
                  getLastTransitionTime(), getParentForChildren(), isClean());
          lastTransitionTime_ = null;
        }
        return lastTransitionTimeBuilder_;
      }

      private java.lang.Object reason_ = "";
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public boolean hasReason() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public java.lang.String getReason() {
        java.lang.Object ref = reason_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            reason_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public com.google.protobuf.ByteString getReasonBytes() {
        java.lang.Object ref = reason_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          reason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReason(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        reason_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder clearReason() {
        bitField0_ = (bitField0_ & ~0x00000010);
        reason_ = getDefaultInstance().getReason();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReasonBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        reason_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public boolean hasMessage() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            message_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        message_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000020);
        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        message_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.DeploymentCondition)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.DeploymentCondition)
    private static final io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentCondition> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentCondition>() {
          @java.lang.Override
          public DeploymentCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentCondition(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.DeploymentList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1beta1Apps.Deployment> getItemsList();
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.Deployment getItems(int index);
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * DeploymentList is a list of Deployments.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentList}
   */
  public static final class DeploymentList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.DeploymentList)
      DeploymentListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentList.newBuilder() to construct.
    private DeploymentList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ =
                      new java.util.ArrayList<io.kubernetes.client.proto.V1beta1Apps.Deployment>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.Deployment.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.DeploymentList.class,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1beta1Apps.Deployment> items_;
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1beta1Apps.Deployment> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.Deployment getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Deployments.
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder getItemsOrBuilder(int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.DeploymentList other =
          (io.kubernetes.client.proto.V1beta1Apps.DeploymentList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.DeploymentList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentList is a list of Deployments.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.DeploymentList)
        io.kubernetes.client.proto.V1beta1Apps.DeploymentListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.DeploymentList.class,
                io.kubernetes.client.proto.V1beta1Apps.DeploymentList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.DeploymentList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.DeploymentList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentList build() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentList buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentList result =
            new io.kubernetes.client.proto.V1beta1Apps.DeploymentList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentList) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.DeploymentList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.DeploymentList other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.DeploymentList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.DeploymentList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1beta1Apps.Deployment> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1beta1Apps.Deployment>(items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.Deployment,
              io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1beta1Apps.Deployment> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.Deployment getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder setItems(int index, io.kubernetes.client.proto.V1beta1Apps.Deployment value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1beta1Apps.Deployment value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder addItems(int index, io.kubernetes.client.proto.V1beta1Apps.Deployment value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder addItems(
          io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1beta1Apps.Deployment> values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder getItemsBuilder(int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder getItemsOrBuilder(
          int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1beta1Apps.Deployment.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder addItemsBuilder(int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1beta1Apps.Deployment.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Deployments.
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.Deployment items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.Deployment,
              io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.Deployment,
                  io.kubernetes.client.proto.V1beta1Apps.Deployment.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.DeploymentList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.DeploymentList)
    private static final io.kubernetes.client.proto.V1beta1Apps.DeploymentList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.DeploymentList();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentList> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentList>() {
          @java.lang.Override
          public DeploymentList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentRollbackOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.DeploymentRollback)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required: This must match the Name of a deployment.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    boolean hasName();
    /**
     *
     *
     * <pre>
     * Required: This must match the Name of a deployment.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Required: This must match the Name of a deployment.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    int getUpdatedAnnotationsCount();
    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    boolean containsUpdatedAnnotations(java.lang.String key);
    /** Use {@link #getUpdatedAnnotationsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getUpdatedAnnotations();
    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getUpdatedAnnotationsMap();
    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    java.lang.String getUpdatedAnnotationsOrDefault(
        java.lang.String key, java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    java.lang.String getUpdatedAnnotationsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * The config of this deployment rollback.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
     */
    boolean hasRollbackTo();
    /**
     *
     *
     * <pre>
     * The config of this deployment rollback.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getRollbackTo();
    /**
     *
     *
     * <pre>
     * The config of this deployment rollback.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder getRollbackToOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED.
   * DeploymentRollback stores the information required to rollback a deployment.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentRollback}
   */
  public static final class DeploymentRollback extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.DeploymentRollback)
      DeploymentRollbackOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentRollback.newBuilder() to construct.
    private DeploymentRollback(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentRollback() {
      name_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentRollback(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                name_ = bs;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  updatedAnnotations_ =
                      com.google.protobuf.MapField.newMapField(
                          UpdatedAnnotationsDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000002;
                }
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    updatedAnnotations__ =
                        input.readMessage(
                            UpdatedAnnotationsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                updatedAnnotations_
                    .getMutableMap()
                    .put(updatedAnnotations__.getKey(), updatedAnnotations__.getValue());
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = rollbackTo_.toBuilder();
                }
                rollbackTo_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(rollbackTo_);
                  rollbackTo_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentRollback_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetUpdatedAnnotations();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentRollback_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback.class,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Required: This must match the Name of a deployment.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Required: This must match the Name of a deployment.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required: This must match the Name of a deployment.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int UPDATEDANNOTATIONS_FIELD_NUMBER = 2;

    private static final class UpdatedAnnotationsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              io.kubernetes.client.proto.V1beta1Apps
                  .internal_static_k8s_io_api_apps_v1beta1_DeploymentRollback_UpdatedAnnotationsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> updatedAnnotations_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetUpdatedAnnotations() {
      if (updatedAnnotations_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            UpdatedAnnotationsDefaultEntryHolder.defaultEntry);
      }
      return updatedAnnotations_;
    }

    public int getUpdatedAnnotationsCount() {
      return internalGetUpdatedAnnotations().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    public boolean containsUpdatedAnnotations(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetUpdatedAnnotations().getMap().containsKey(key);
    }
    /** Use {@link #getUpdatedAnnotationsMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getUpdatedAnnotations() {
      return getUpdatedAnnotationsMap();
    }
    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getUpdatedAnnotationsMap() {
      return internalGetUpdatedAnnotations().getMap();
    }
    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    public java.lang.String getUpdatedAnnotationsOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetUpdatedAnnotations().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * The annotations to be updated to a deployment
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
     */
    public java.lang.String getUpdatedAnnotationsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetUpdatedAnnotations().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int ROLLBACKTO_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1beta1Apps.RollbackConfig rollbackTo_;
    /**
     *
     *
     * <pre>
     * The config of this deployment rollback.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
     */
    public boolean hasRollbackTo() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * The config of this deployment rollback.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getRollbackTo() {
      return rollbackTo_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()
          : rollbackTo_;
    }
    /**
     *
     *
     * <pre>
     * The config of this deployment rollback.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder getRollbackToOrBuilder() {
      return rollbackTo_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()
          : rollbackTo_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output,
          internalGetUpdatedAnnotations(),
          UpdatedAnnotationsDefaultEntryHolder.defaultEntry,
          2);
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(3, getRollbackTo());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetUpdatedAnnotations().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> updatedAnnotations__ =
            UpdatedAnnotationsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, updatedAnnotations__);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getRollbackTo());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback other =
          (io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback) obj;

      boolean result = true;
      result = result && (hasName() == other.hasName());
      if (hasName()) {
        result = result && getName().equals(other.getName());
      }
      result =
          result && internalGetUpdatedAnnotations().equals(other.internalGetUpdatedAnnotations());
      result = result && (hasRollbackTo() == other.hasRollbackTo());
      if (hasRollbackTo()) {
        result = result && getRollbackTo().equals(other.getRollbackTo());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (!internalGetUpdatedAnnotations().getMap().isEmpty()) {
        hash = (37 * hash) + UPDATEDANNOTATIONS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetUpdatedAnnotations().hashCode();
      }
      if (hasRollbackTo()) {
        hash = (37 * hash) + ROLLBACKTO_FIELD_NUMBER;
        hash = (53 * hash) + getRollbackTo().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED.
     * DeploymentRollback stores the information required to rollback a deployment.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentRollback}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.DeploymentRollback)
        io.kubernetes.client.proto.V1beta1Apps.DeploymentRollbackOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentRollback_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 2:
            return internalGetUpdatedAnnotations();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 2:
            return internalGetMutableUpdatedAnnotations();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentRollback_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback.class,
                io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRollbackToFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableUpdatedAnnotations().clear();
        if (rollbackToBuilder_ == null) {
          rollbackTo_ = null;
        } else {
          rollbackToBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentRollback_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback build() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback result =
            new io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        result.updatedAnnotations_ = internalGetUpdatedAnnotations();
        result.updatedAnnotations_.makeImmutable();
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        if (rollbackToBuilder_ == null) {
          result.rollbackTo_ = rollbackTo_;
        } else {
          result.rollbackTo_ = rollbackToBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback.getDefaultInstance())
          return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        internalGetMutableUpdatedAnnotations().mergeFrom(other.internalGetUpdatedAnnotations());
        if (other.hasRollbackTo()) {
          mergeRollbackTo(other.getRollbackTo());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Required: This must match the Name of a deployment.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Required: This must match the Name of a deployment.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required: This must match the Name of a deployment.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required: This must match the Name of a deployment.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required: This must match the Name of a deployment.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required: This must match the Name of a deployment.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> updatedAnnotations_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetUpdatedAnnotations() {
        if (updatedAnnotations_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              UpdatedAnnotationsDefaultEntryHolder.defaultEntry);
        }
        return updatedAnnotations_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableUpdatedAnnotations() {
        onChanged();
        ;
        if (updatedAnnotations_ == null) {
          updatedAnnotations_ =
              com.google.protobuf.MapField.newMapField(
                  UpdatedAnnotationsDefaultEntryHolder.defaultEntry);
        }
        if (!updatedAnnotations_.isMutable()) {
          updatedAnnotations_ = updatedAnnotations_.copy();
        }
        return updatedAnnotations_;
      }

      public int getUpdatedAnnotationsCount() {
        return internalGetUpdatedAnnotations().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * The annotations to be updated to a deployment
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
       */
      public boolean containsUpdatedAnnotations(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        return internalGetUpdatedAnnotations().getMap().containsKey(key);
      }
      /** Use {@link #getUpdatedAnnotationsMap()} instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getUpdatedAnnotations() {
        return getUpdatedAnnotationsMap();
      }
      /**
       *
       *
       * <pre>
       * The annotations to be updated to a deployment
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
       */
      public java.util.Map<java.lang.String, java.lang.String> getUpdatedAnnotationsMap() {
        return internalGetUpdatedAnnotations().getMap();
      }
      /**
       *
       *
       * <pre>
       * The annotations to be updated to a deployment
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
       */
      public java.lang.String getUpdatedAnnotationsOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetUpdatedAnnotations().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * The annotations to be updated to a deployment
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
       */
      public java.lang.String getUpdatedAnnotationsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetUpdatedAnnotations().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearUpdatedAnnotations() {
        internalGetMutableUpdatedAnnotations().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotations to be updated to a deployment
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
       */
      public Builder removeUpdatedAnnotations(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        internalGetMutableUpdatedAnnotations().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableUpdatedAnnotations() {
        return internalGetMutableUpdatedAnnotations().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * The annotations to be updated to a deployment
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
       */
      public Builder putUpdatedAnnotations(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        if (value == null) {
          throw new java.lang.NullPointerException();
        }
        internalGetMutableUpdatedAnnotations().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The annotations to be updated to a deployment
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; updatedAnnotations = 2;</code>
       */
      public Builder putAllUpdatedAnnotations(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableUpdatedAnnotations().getMutableMap().putAll(values);
        return this;
      }

      private io.kubernetes.client.proto.V1beta1Apps.RollbackConfig rollbackTo_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder>
          rollbackToBuilder_;
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      public boolean hasRollbackTo() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getRollbackTo() {
        if (rollbackToBuilder_ == null) {
          return rollbackTo_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()
              : rollbackTo_;
        } else {
          return rollbackToBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      public Builder setRollbackTo(io.kubernetes.client.proto.V1beta1Apps.RollbackConfig value) {
        if (rollbackToBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rollbackTo_ = value;
          onChanged();
        } else {
          rollbackToBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      public Builder setRollbackTo(
          io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder builderForValue) {
        if (rollbackToBuilder_ == null) {
          rollbackTo_ = builderForValue.build();
          onChanged();
        } else {
          rollbackToBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      public Builder mergeRollbackTo(io.kubernetes.client.proto.V1beta1Apps.RollbackConfig value) {
        if (rollbackToBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && rollbackTo_ != null
              && rollbackTo_
                  != io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()) {
            rollbackTo_ =
                io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.newBuilder(rollbackTo_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rollbackTo_ = value;
          }
          onChanged();
        } else {
          rollbackToBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      public Builder clearRollbackTo() {
        if (rollbackToBuilder_ == null) {
          rollbackTo_ = null;
          onChanged();
        } else {
          rollbackToBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder getRollbackToBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getRollbackToFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder
          getRollbackToOrBuilder() {
        if (rollbackToBuilder_ != null) {
          return rollbackToBuilder_.getMessageOrBuilder();
        } else {
          return rollbackTo_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()
              : rollbackTo_;
        }
      }
      /**
       *
       *
       * <pre>
       * The config of this deployment rollback.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder>
          getRollbackToFieldBuilder() {
        if (rollbackToBuilder_ == null) {
          rollbackToBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.RollbackConfig,
                  io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder>(
                  getRollbackTo(), getParentForChildren(), isClean());
          rollbackTo_ = null;
        }
        return rollbackToBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.DeploymentRollback)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.DeploymentRollback)
    private static final io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentRollback> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentRollback>() {
          @java.lang.Override
          public DeploymentRollback parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentRollback(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentRollback> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentRollback> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentRollback getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.DeploymentSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Number of desired pods. This is a pointer to distinguish between explicit
     * zero and not specified. Defaults to 1.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * Number of desired pods. This is a pointer to distinguish between explicit
     * zero and not specified. Defaults to 1.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    boolean hasSelector();
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelector getSelector();
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder();

    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    boolean hasTemplate();
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate();
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder();

    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
     */
    boolean hasStrategy();
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy getStrategy();
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategyOrBuilder getStrategyOrBuilder();

    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 5;</code>
     */
    boolean hasMinReadySeconds();
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 5;</code>
     */
    int getMinReadySeconds();

    /**
     *
     *
     * <pre>
     * The number of old ReplicaSets to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 2.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    boolean hasRevisionHistoryLimit();
    /**
     *
     *
     * <pre>
     * The number of old ReplicaSets to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 2.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    int getRevisionHistoryLimit();

    /**
     *
     *
     * <pre>
     * Indicates that the deployment is paused.
     * +optional
     * </pre>
     *
     * <code>optional bool paused = 7;</code>
     */
    boolean hasPaused();
    /**
     *
     *
     * <pre>
     * Indicates that the deployment is paused.
     * +optional
     * </pre>
     *
     * <code>optional bool paused = 7;</code>
     */
    boolean getPaused();

    /**
     *
     *
     * <pre>
     * DEPRECATED.
     * The config this deployment is rolling back to. Will be cleared after rollback is done.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
     */
    boolean hasRollbackTo();
    /**
     *
     *
     * <pre>
     * DEPRECATED.
     * The config this deployment is rolling back to. Will be cleared after rollback is done.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getRollbackTo();
    /**
     *
     *
     * <pre>
     * DEPRECATED.
     * The config this deployment is rolling back to. Will be cleared after rollback is done.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder getRollbackToOrBuilder();

    /**
     *
     *
     * <pre>
     * The maximum time in seconds for a deployment to make progress before it
     * is considered to be failed. The deployment controller will continue to
     * process failed deployments and a condition with a ProgressDeadlineExceeded
     * reason will be surfaced in the deployment status. Note that progress will
     * not be estimated during the time a deployment is paused. Defaults to 600s.
     * +optional
     * </pre>
     *
     * <code>optional int32 progressDeadlineSeconds = 9;</code>
     */
    boolean hasProgressDeadlineSeconds();
    /**
     *
     *
     * <pre>
     * The maximum time in seconds for a deployment to make progress before it
     * is considered to be failed. The deployment controller will continue to
     * process failed deployments and a condition with a ProgressDeadlineExceeded
     * reason will be surfaced in the deployment status. Note that progress will
     * not be estimated during the time a deployment is paused. Defaults to 600s.
     * +optional
     * </pre>
     *
     * <code>optional int32 progressDeadlineSeconds = 9;</code>
     */
    int getProgressDeadlineSeconds();
  }
  /**
   *
   *
   * <pre>
   * DeploymentSpec is the specification of the desired behavior of the Deployment.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentSpec}
   */
  public static final class DeploymentSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.DeploymentSpec)
      DeploymentSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentSpec.newBuilder() to construct.
    private DeploymentSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentSpec() {
      replicas_ = 0;
      minReadySeconds_ = 0;
      revisionHistoryLimit_ = 0;
      paused_ = false;
      progressDeadlineSeconds_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                replicas_ = input.readInt32();
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.Meta.LabelSelector.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = selector_.toBuilder();
                }
                selector_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.LabelSelector.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(selector_);
                  selector_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1.PodTemplateSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = template_.toBuilder();
                }
                template_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1.PodTemplateSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(template_);
                  template_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 34:
              {
                io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.Builder subBuilder = null;
                if (((bitField0_ & 0x00000008) == 0x00000008)) {
                  subBuilder = strategy_.toBuilder();
                }
                strategy_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(strategy_);
                  strategy_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000008;
                break;
              }
            case 40:
              {
                bitField0_ |= 0x00000010;
                minReadySeconds_ = input.readInt32();
                break;
              }
            case 48:
              {
                bitField0_ |= 0x00000020;
                revisionHistoryLimit_ = input.readInt32();
                break;
              }
            case 56:
              {
                bitField0_ |= 0x00000040;
                paused_ = input.readBool();
                break;
              }
            case 66:
              {
                io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder subBuilder = null;
                if (((bitField0_ & 0x00000080) == 0x00000080)) {
                  subBuilder = rollbackTo_.toBuilder();
                }
                rollbackTo_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(rollbackTo_);
                  rollbackTo_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000080;
                break;
              }
            case 72:
              {
                bitField0_ |= 0x00000100;
                progressDeadlineSeconds_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.class,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.Builder.class);
    }

    private int bitField0_;
    public static final int REPLICAS_FIELD_NUMBER = 1;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * Number of desired pods. This is a pointer to distinguish between explicit
     * zero and not specified. Defaults to 1.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Number of desired pods. This is a pointer to distinguish between explicit
     * zero and not specified. Defaults to 1.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int SELECTOR_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.Meta.LabelSelector selector_;
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public boolean hasSelector() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }
    /**
     *
     *
     * <pre>
     * Label selector for pods. Existing ReplicaSets whose pods are
     * selected by this will be the ones affected by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }

    public static final int TEMPLATE_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1.PodTemplateSpec template_;
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }
    /**
     *
     *
     * <pre>
     * Template describes the pods that will be created.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }

    public static final int STRATEGY_FIELD_NUMBER = 4;
    private io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy strategy_;
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
     */
    public boolean hasStrategy() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy getStrategy() {
      return strategy_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.getDefaultInstance()
          : strategy_;
    }
    /**
     *
     *
     * <pre>
     * The deployment strategy to use to replace existing pods with new ones.
     * +optional
     * +patchStrategy=retainKeys
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategyOrBuilder
        getStrategyOrBuilder() {
      return strategy_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.getDefaultInstance()
          : strategy_;
    }

    public static final int MINREADYSECONDS_FIELD_NUMBER = 5;
    private int minReadySeconds_;
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 5;</code>
     */
    public boolean hasMinReadySeconds() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing, for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 5;</code>
     */
    public int getMinReadySeconds() {
      return minReadySeconds_;
    }

    public static final int REVISIONHISTORYLIMIT_FIELD_NUMBER = 6;
    private int revisionHistoryLimit_;
    /**
     *
     *
     * <pre>
     * The number of old ReplicaSets to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 2.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    public boolean hasRevisionHistoryLimit() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * The number of old ReplicaSets to retain to allow rollback.
     * This is a pointer to distinguish between explicit zero and not specified.
     * Defaults to 2.
     * +optional
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 6;</code>
     */
    public int getRevisionHistoryLimit() {
      return revisionHistoryLimit_;
    }

    public static final int PAUSED_FIELD_NUMBER = 7;
    private boolean paused_;
    /**
     *
     *
     * <pre>
     * Indicates that the deployment is paused.
     * +optional
     * </pre>
     *
     * <code>optional bool paused = 7;</code>
     */
    public boolean hasPaused() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     *
     *
     * <pre>
     * Indicates that the deployment is paused.
     * +optional
     * </pre>
     *
     * <code>optional bool paused = 7;</code>
     */
    public boolean getPaused() {
      return paused_;
    }

    public static final int ROLLBACKTO_FIELD_NUMBER = 8;
    private io.kubernetes.client.proto.V1beta1Apps.RollbackConfig rollbackTo_;
    /**
     *
     *
     * <pre>
     * DEPRECATED.
     * The config this deployment is rolling back to. Will be cleared after rollback is done.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
     */
    public boolean hasRollbackTo() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED.
     * The config this deployment is rolling back to. Will be cleared after rollback is done.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getRollbackTo() {
      return rollbackTo_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()
          : rollbackTo_;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED.
     * The config this deployment is rolling back to. Will be cleared after rollback is done.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder getRollbackToOrBuilder() {
      return rollbackTo_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()
          : rollbackTo_;
    }

    public static final int PROGRESSDEADLINESECONDS_FIELD_NUMBER = 9;
    private int progressDeadlineSeconds_;
    /**
     *
     *
     * <pre>
     * The maximum time in seconds for a deployment to make progress before it
     * is considered to be failed. The deployment controller will continue to
     * process failed deployments and a condition with a ProgressDeadlineExceeded
     * reason will be surfaced in the deployment status. Note that progress will
     * not be estimated during the time a deployment is paused. Defaults to 600s.
     * +optional
     * </pre>
     *
     * <code>optional int32 progressDeadlineSeconds = 9;</code>
     */
    public boolean hasProgressDeadlineSeconds() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     *
     *
     * <pre>
     * The maximum time in seconds for a deployment to make progress before it
     * is considered to be failed. The deployment controller will continue to
     * process failed deployments and a condition with a ProgressDeadlineExceeded
     * reason will be surfaced in the deployment status. Note that progress will
     * not be estimated during the time a deployment is paused. Defaults to 600s.
     * +optional
     * </pre>
     *
     * <code>optional int32 progressDeadlineSeconds = 9;</code>
     */
    public int getProgressDeadlineSeconds() {
      return progressDeadlineSeconds_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, replicas_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSelector());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getTemplate());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeMessage(4, getStrategy());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(5, minReadySeconds_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeInt32(6, revisionHistoryLimit_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBool(7, paused_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeMessage(8, getRollbackTo());
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeInt32(9, progressDeadlineSeconds_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, replicas_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSelector());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTemplate());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getStrategy());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, minReadySeconds_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, revisionHistoryLimit_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(7, paused_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getRollbackTo());
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, progressDeadlineSeconds_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec other =
          (io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec) obj;

      boolean result = true;
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && (hasSelector() == other.hasSelector());
      if (hasSelector()) {
        result = result && getSelector().equals(other.getSelector());
      }
      result = result && (hasTemplate() == other.hasTemplate());
      if (hasTemplate()) {
        result = result && getTemplate().equals(other.getTemplate());
      }
      result = result && (hasStrategy() == other.hasStrategy());
      if (hasStrategy()) {
        result = result && getStrategy().equals(other.getStrategy());
      }
      result = result && (hasMinReadySeconds() == other.hasMinReadySeconds());
      if (hasMinReadySeconds()) {
        result = result && (getMinReadySeconds() == other.getMinReadySeconds());
      }
      result = result && (hasRevisionHistoryLimit() == other.hasRevisionHistoryLimit());
      if (hasRevisionHistoryLimit()) {
        result = result && (getRevisionHistoryLimit() == other.getRevisionHistoryLimit());
      }
      result = result && (hasPaused() == other.hasPaused());
      if (hasPaused()) {
        result = result && (getPaused() == other.getPaused());
      }
      result = result && (hasRollbackTo() == other.hasRollbackTo());
      if (hasRollbackTo()) {
        result = result && getRollbackTo().equals(other.getRollbackTo());
      }
      result = result && (hasProgressDeadlineSeconds() == other.hasProgressDeadlineSeconds());
      if (hasProgressDeadlineSeconds()) {
        result = result && (getProgressDeadlineSeconds() == other.getProgressDeadlineSeconds());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (hasSelector()) {
        hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getSelector().hashCode();
      }
      if (hasTemplate()) {
        hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
        hash = (53 * hash) + getTemplate().hashCode();
      }
      if (hasStrategy()) {
        hash = (37 * hash) + STRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getStrategy().hashCode();
      }
      if (hasMinReadySeconds()) {
        hash = (37 * hash) + MINREADYSECONDS_FIELD_NUMBER;
        hash = (53 * hash) + getMinReadySeconds();
      }
      if (hasRevisionHistoryLimit()) {
        hash = (37 * hash) + REVISIONHISTORYLIMIT_FIELD_NUMBER;
        hash = (53 * hash) + getRevisionHistoryLimit();
      }
      if (hasPaused()) {
        hash = (37 * hash) + PAUSED_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPaused());
      }
      if (hasRollbackTo()) {
        hash = (37 * hash) + ROLLBACKTO_FIELD_NUMBER;
        hash = (53 * hash) + getRollbackTo().hashCode();
      }
      if (hasProgressDeadlineSeconds()) {
        hash = (37 * hash) + PROGRESSDEADLINESECONDS_FIELD_NUMBER;
        hash = (53 * hash) + getProgressDeadlineSeconds();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentSpec is the specification of the desired behavior of the Deployment.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.DeploymentSpec)
        io.kubernetes.client.proto.V1beta1Apps.DeploymentSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.class,
                io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSelectorFieldBuilder();
          getTemplateFieldBuilder();
          getStrategyFieldBuilder();
          getRollbackToFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (selectorBuilder_ == null) {
          selector_ = null;
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (templateBuilder_ == null) {
          template_ = null;
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (strategyBuilder_ == null) {
          strategy_ = null;
        } else {
          strategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        minReadySeconds_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        revisionHistoryLimit_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        paused_ = false;
        bitField0_ = (bitField0_ & ~0x00000040);
        if (rollbackToBuilder_ == null) {
          rollbackTo_ = null;
        } else {
          rollbackToBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        progressDeadlineSeconds_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentSpec_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec build() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec result =
            new io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.replicas_ = replicas_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (selectorBuilder_ == null) {
          result.selector_ = selector_;
        } else {
          result.selector_ = selectorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (templateBuilder_ == null) {
          result.template_ = template_;
        } else {
          result.template_ = templateBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        if (strategyBuilder_ == null) {
          result.strategy_ = strategy_;
        } else {
          result.strategy_ = strategyBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.minReadySeconds_ = minReadySeconds_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.revisionHistoryLimit_ = revisionHistoryLimit_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.paused_ = paused_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000080;
        }
        if (rollbackToBuilder_ == null) {
          result.rollbackTo_ = rollbackTo_;
        } else {
          result.rollbackTo_ = rollbackToBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000100;
        }
        result.progressDeadlineSeconds_ = progressDeadlineSeconds_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec.getDefaultInstance())
          return this;
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        if (other.hasSelector()) {
          mergeSelector(other.getSelector());
        }
        if (other.hasTemplate()) {
          mergeTemplate(other.getTemplate());
        }
        if (other.hasStrategy()) {
          mergeStrategy(other.getStrategy());
        }
        if (other.hasMinReadySeconds()) {
          setMinReadySeconds(other.getMinReadySeconds());
        }
        if (other.hasRevisionHistoryLimit()) {
          setRevisionHistoryLimit(other.getRevisionHistoryLimit());
        }
        if (other.hasPaused()) {
          setPaused(other.getPaused());
        }
        if (other.hasRollbackTo()) {
          mergeRollbackTo(other.getRollbackTo());
        }
        if (other.hasProgressDeadlineSeconds()) {
          setProgressDeadlineSeconds(other.getProgressDeadlineSeconds());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int replicas_;
      /**
       *
       *
       * <pre>
       * Number of desired pods. This is a pointer to distinguish between explicit
       * zero and not specified. Defaults to 1.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Number of desired pods. This is a pointer to distinguish between explicit
       * zero and not specified. Defaults to 1.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * Number of desired pods. This is a pointer to distinguish between explicit
       * zero and not specified. Defaults to 1.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000001;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Number of desired pods. This is a pointer to distinguish between explicit
       * zero and not specified. Defaults to 1.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.LabelSelector selector_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          selectorBuilder_;
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public boolean hasSelector() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
        if (selectorBuilder_ == null) {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        } else {
          return selectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder setSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          selector_ = value;
          onChanged();
        } else {
          selectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder setSelector(
          io.kubernetes.client.proto.Meta.LabelSelector.Builder builderForValue) {
        if (selectorBuilder_ == null) {
          selector_ = builderForValue.build();
          onChanged();
        } else {
          selectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder mergeSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && selector_ != null
              && selector_ != io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()) {
            selector_ =
                io.kubernetes.client.proto.Meta.LabelSelector.newBuilder(selector_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            selector_ = value;
          }
          onChanged();
        } else {
          selectorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder clearSelector() {
        if (selectorBuilder_ == null) {
          selector_ = null;
          onChanged();
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector.Builder getSelectorBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
        if (selectorBuilder_ != null) {
          return selectorBuilder_.getMessageOrBuilder();
        } else {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        }
      }
      /**
       *
       *
       * <pre>
       * Label selector for pods. Existing ReplicaSets whose pods are
       * selected by this will be the ones affected by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          getSelectorFieldBuilder() {
        if (selectorBuilder_ == null) {
          selectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.LabelSelector,
                  io.kubernetes.client.proto.Meta.LabelSelector.Builder,
                  io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>(
                  getSelector(), getParentForChildren(), isClean());
          selector_ = null;
        }
        return selectorBuilder_;
      }

      private io.kubernetes.client.proto.V1.PodTemplateSpec template_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          templateBuilder_;
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public boolean hasTemplate() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
        if (templateBuilder_ == null) {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        } else {
          return templateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder setTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          template_ = value;
          onChanged();
        } else {
          templateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder setTemplate(
          io.kubernetes.client.proto.V1.PodTemplateSpec.Builder builderForValue) {
        if (templateBuilder_ == null) {
          template_ = builderForValue.build();
          onChanged();
        } else {
          templateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder mergeTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && template_ != null
              && template_ != io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()) {
            template_ =
                io.kubernetes.client.proto.V1.PodTemplateSpec.newBuilder(template_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            template_ = value;
          }
          onChanged();
        } else {
          templateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder clearTemplate() {
        if (templateBuilder_ == null) {
          template_ = null;
          onChanged();
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec.Builder getTemplateBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTemplateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
        if (templateBuilder_ != null) {
          return templateBuilder_.getMessageOrBuilder();
        } else {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        }
      }
      /**
       *
       *
       * <pre>
       * Template describes the pods that will be created.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          getTemplateFieldBuilder() {
        if (templateBuilder_ == null) {
          templateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1.PodTemplateSpec,
                  io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
                  io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>(
                  getTemplate(), getParentForChildren(), isClean());
          template_ = null;
        }
        return templateBuilder_;
      }

      private io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy strategy_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategyOrBuilder>
          strategyBuilder_;
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      public boolean hasStrategy() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy getStrategy() {
        if (strategyBuilder_ == null) {
          return strategy_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.getDefaultInstance()
              : strategy_;
        } else {
          return strategyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      public Builder setStrategy(io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy value) {
        if (strategyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          strategy_ = value;
          onChanged();
        } else {
          strategyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      public Builder setStrategy(
          io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.Builder builderForValue) {
        if (strategyBuilder_ == null) {
          strategy_ = builderForValue.build();
          onChanged();
        } else {
          strategyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      public Builder mergeStrategy(
          io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy value) {
        if (strategyBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)
              && strategy_ != null
              && strategy_
                  != io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy
                      .getDefaultInstance()) {
            strategy_ =
                io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.newBuilder(strategy_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            strategy_ = value;
          }
          onChanged();
        } else {
          strategyBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      public Builder clearStrategy() {
        if (strategyBuilder_ == null) {
          strategy_ = null;
          onChanged();
        } else {
          strategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.Builder
          getStrategyBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getStrategyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategyOrBuilder
          getStrategyOrBuilder() {
        if (strategyBuilder_ != null) {
          return strategyBuilder_.getMessageOrBuilder();
        } else {
          return strategy_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.getDefaultInstance()
              : strategy_;
        }
      }
      /**
       *
       *
       * <pre>
       * The deployment strategy to use to replace existing pods with new ones.
       * +optional
       * +patchStrategy=retainKeys
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.DeploymentStrategy strategy = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategyOrBuilder>
          getStrategyFieldBuilder() {
        if (strategyBuilder_ == null) {
          strategyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategyOrBuilder>(
                  getStrategy(), getParentForChildren(), isClean());
          strategy_ = null;
        }
        return strategyBuilder_;
      }

      private int minReadySeconds_;
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 5;</code>
       */
      public boolean hasMinReadySeconds() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 5;</code>
       */
      public int getMinReadySeconds() {
        return minReadySeconds_;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 5;</code>
       */
      public Builder setMinReadySeconds(int value) {
        bitField0_ |= 0x00000010;
        minReadySeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing, for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 5;</code>
       */
      public Builder clearMinReadySeconds() {
        bitField0_ = (bitField0_ & ~0x00000010);
        minReadySeconds_ = 0;
        onChanged();
        return this;
      }

      private int revisionHistoryLimit_;
      /**
       *
       *
       * <pre>
       * The number of old ReplicaSets to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 2.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public boolean hasRevisionHistoryLimit() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       *
       *
       * <pre>
       * The number of old ReplicaSets to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 2.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public int getRevisionHistoryLimit() {
        return revisionHistoryLimit_;
      }
      /**
       *
       *
       * <pre>
       * The number of old ReplicaSets to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 2.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public Builder setRevisionHistoryLimit(int value) {
        bitField0_ |= 0x00000020;
        revisionHistoryLimit_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The number of old ReplicaSets to retain to allow rollback.
       * This is a pointer to distinguish between explicit zero and not specified.
       * Defaults to 2.
       * +optional
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 6;</code>
       */
      public Builder clearRevisionHistoryLimit() {
        bitField0_ = (bitField0_ & ~0x00000020);
        revisionHistoryLimit_ = 0;
        onChanged();
        return this;
      }

      private boolean paused_;
      /**
       *
       *
       * <pre>
       * Indicates that the deployment is paused.
       * +optional
       * </pre>
       *
       * <code>optional bool paused = 7;</code>
       */
      public boolean hasPaused() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       *
       *
       * <pre>
       * Indicates that the deployment is paused.
       * +optional
       * </pre>
       *
       * <code>optional bool paused = 7;</code>
       */
      public boolean getPaused() {
        return paused_;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the deployment is paused.
       * +optional
       * </pre>
       *
       * <code>optional bool paused = 7;</code>
       */
      public Builder setPaused(boolean value) {
        bitField0_ |= 0x00000040;
        paused_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the deployment is paused.
       * +optional
       * </pre>
       *
       * <code>optional bool paused = 7;</code>
       */
      public Builder clearPaused() {
        bitField0_ = (bitField0_ & ~0x00000040);
        paused_ = false;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1beta1Apps.RollbackConfig rollbackTo_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder>
          rollbackToBuilder_;
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      public boolean hasRollbackTo() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getRollbackTo() {
        if (rollbackToBuilder_ == null) {
          return rollbackTo_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()
              : rollbackTo_;
        } else {
          return rollbackToBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      public Builder setRollbackTo(io.kubernetes.client.proto.V1beta1Apps.RollbackConfig value) {
        if (rollbackToBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rollbackTo_ = value;
          onChanged();
        } else {
          rollbackToBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      public Builder setRollbackTo(
          io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder builderForValue) {
        if (rollbackToBuilder_ == null) {
          rollbackTo_ = builderForValue.build();
          onChanged();
        } else {
          rollbackToBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      public Builder mergeRollbackTo(io.kubernetes.client.proto.V1beta1Apps.RollbackConfig value) {
        if (rollbackToBuilder_ == null) {
          if (((bitField0_ & 0x00000080) == 0x00000080)
              && rollbackTo_ != null
              && rollbackTo_
                  != io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()) {
            rollbackTo_ =
                io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.newBuilder(rollbackTo_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rollbackTo_ = value;
          }
          onChanged();
        } else {
          rollbackToBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000080;
        return this;
      }
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      public Builder clearRollbackTo() {
        if (rollbackToBuilder_ == null) {
          rollbackTo_ = null;
          onChanged();
        } else {
          rollbackToBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder getRollbackToBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getRollbackToFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder
          getRollbackToOrBuilder() {
        if (rollbackToBuilder_ != null) {
          return rollbackToBuilder_.getMessageOrBuilder();
        } else {
          return rollbackTo_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance()
              : rollbackTo_;
        }
      }
      /**
       *
       *
       * <pre>
       * DEPRECATED.
       * The config this deployment is rolling back to. Will be cleared after rollback is done.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollbackConfig rollbackTo = 8;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder>
          getRollbackToFieldBuilder() {
        if (rollbackToBuilder_ == null) {
          rollbackToBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.RollbackConfig,
                  io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder>(
                  getRollbackTo(), getParentForChildren(), isClean());
          rollbackTo_ = null;
        }
        return rollbackToBuilder_;
      }

      private int progressDeadlineSeconds_;
      /**
       *
       *
       * <pre>
       * The maximum time in seconds for a deployment to make progress before it
       * is considered to be failed. The deployment controller will continue to
       * process failed deployments and a condition with a ProgressDeadlineExceeded
       * reason will be surfaced in the deployment status. Note that progress will
       * not be estimated during the time a deployment is paused. Defaults to 600s.
       * +optional
       * </pre>
       *
       * <code>optional int32 progressDeadlineSeconds = 9;</code>
       */
      public boolean hasProgressDeadlineSeconds() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       *
       *
       * <pre>
       * The maximum time in seconds for a deployment to make progress before it
       * is considered to be failed. The deployment controller will continue to
       * process failed deployments and a condition with a ProgressDeadlineExceeded
       * reason will be surfaced in the deployment status. Note that progress will
       * not be estimated during the time a deployment is paused. Defaults to 600s.
       * +optional
       * </pre>
       *
       * <code>optional int32 progressDeadlineSeconds = 9;</code>
       */
      public int getProgressDeadlineSeconds() {
        return progressDeadlineSeconds_;
      }
      /**
       *
       *
       * <pre>
       * The maximum time in seconds for a deployment to make progress before it
       * is considered to be failed. The deployment controller will continue to
       * process failed deployments and a condition with a ProgressDeadlineExceeded
       * reason will be surfaced in the deployment status. Note that progress will
       * not be estimated during the time a deployment is paused. Defaults to 600s.
       * +optional
       * </pre>
       *
       * <code>optional int32 progressDeadlineSeconds = 9;</code>
       */
      public Builder setProgressDeadlineSeconds(int value) {
        bitField0_ |= 0x00000100;
        progressDeadlineSeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum time in seconds for a deployment to make progress before it
       * is considered to be failed. The deployment controller will continue to
       * process failed deployments and a condition with a ProgressDeadlineExceeded
       * reason will be surfaced in the deployment status. Note that progress will
       * not be estimated during the time a deployment is paused. Defaults to 600s.
       * +optional
       * </pre>
       *
       * <code>optional int32 progressDeadlineSeconds = 9;</code>
       */
      public Builder clearProgressDeadlineSeconds() {
        bitField0_ = (bitField0_ & ~0x00000100);
        progressDeadlineSeconds_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.DeploymentSpec)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.DeploymentSpec)
    private static final io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentSpec> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentSpec>() {
          @java.lang.Override
          public DeploymentSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.DeploymentStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The generation observed by the deployment controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    boolean hasObservedGeneration();
    /**
     *
     *
     * <pre>
     * The generation observed by the deployment controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    long getObservedGeneration();

    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 3;</code>
     */
    boolean hasUpdatedReplicas();
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 3;</code>
     */
    int getUpdatedReplicas();

    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 7;</code>
     */
    boolean hasReadyReplicas();
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 7;</code>
     */
    int getReadyReplicas();

    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 4;</code>
     */
    boolean hasAvailableReplicas();
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 4;</code>
     */
    int getAvailableReplicas();

    /**
     *
     *
     * <pre>
     * Total number of unavailable pods targeted by this deployment. This is the total number of
     * pods that are still required for the deployment to have 100% available capacity. They may
     * either be pods that are running but not yet available or pods that still have not been created.
     * +optional
     * </pre>
     *
     * <code>optional int32 unavailableReplicas = 5;</code>
     */
    boolean hasUnavailableReplicas();
    /**
     *
     *
     * <pre>
     * Total number of unavailable pods targeted by this deployment. This is the total number of
     * pods that are still required for the deployment to have 100% available capacity. They may
     * either be pods that are running but not yet available or pods that still have not been created.
     * +optional
     * </pre>
     *
     * <code>optional int32 unavailableReplicas = 5;</code>
     */
    int getUnavailableReplicas();

    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition> getConditionsList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition getConditions(int index);
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    int getConditionsCount();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder>
        getConditionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder getConditionsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Count of hash collisions for the Deployment. The Deployment controller uses this
     * field as a collision avoidance mechanism when it needs to create the name for the
     * newest ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 8;</code>
     */
    boolean hasCollisionCount();
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the Deployment. The Deployment controller uses this
     * field as a collision avoidance mechanism when it needs to create the name for the
     * newest ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 8;</code>
     */
    int getCollisionCount();
  }
  /**
   *
   *
   * <pre>
   * DeploymentStatus is the most recently observed status of the Deployment.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentStatus}
   */
  public static final class DeploymentStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.DeploymentStatus)
      DeploymentStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentStatus.newBuilder() to construct.
    private DeploymentStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentStatus() {
      observedGeneration_ = 0L;
      replicas_ = 0;
      updatedReplicas_ = 0;
      readyReplicas_ = 0;
      availableReplicas_ = 0;
      unavailableReplicas_ = 0;
      conditions_ = java.util.Collections.emptyList();
      collisionCount_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                observedGeneration_ = input.readInt64();
                break;
              }
            case 16:
              {
                bitField0_ |= 0x00000002;
                replicas_ = input.readInt32();
                break;
              }
            case 24:
              {
                bitField0_ |= 0x00000004;
                updatedReplicas_ = input.readInt32();
                break;
              }
            case 32:
              {
                bitField0_ |= 0x00000010;
                availableReplicas_ = input.readInt32();
                break;
              }
            case 40:
              {
                bitField0_ |= 0x00000020;
                unavailableReplicas_ = input.readInt32();
                break;
              }
            case 50:
              {
                if (!((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
                  conditions_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition>();
                  mutable_bitField0_ |= 0x00000040;
                }
                conditions_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.PARSER,
                        extensionRegistry));
                break;
              }
            case 56:
              {
                bitField0_ |= 0x00000008;
                readyReplicas_ = input.readInt32();
                break;
              }
            case 64:
              {
                bitField0_ |= 0x00000040;
                collisionCount_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000040) == 0x00000040)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.class,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.Builder.class);
    }

    private int bitField0_;
    public static final int OBSERVEDGENERATION_FIELD_NUMBER = 1;
    private long observedGeneration_;
    /**
     *
     *
     * <pre>
     * The generation observed by the deployment controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    public boolean hasObservedGeneration() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * The generation observed by the deployment controller.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    public long getObservedGeneration() {
      return observedGeneration_;
    }

    public static final int REPLICAS_FIELD_NUMBER = 2;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int UPDATEDREPLICAS_FIELD_NUMBER = 3;
    private int updatedReplicas_;
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 3;</code>
     */
    public boolean hasUpdatedReplicas() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
     * +optional
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 3;</code>
     */
    public int getUpdatedReplicas() {
      return updatedReplicas_;
    }

    public static final int READYREPLICAS_FIELD_NUMBER = 7;
    private int readyReplicas_;
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 7;</code>
     */
    public boolean hasReadyReplicas() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.
     * +optional
     * </pre>
     *
     * <code>optional int32 readyReplicas = 7;</code>
     */
    public int getReadyReplicas() {
      return readyReplicas_;
    }

    public static final int AVAILABLEREPLICAS_FIELD_NUMBER = 4;
    private int availableReplicas_;
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 4;</code>
     */
    public boolean hasAvailableReplicas() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
     * +optional
     * </pre>
     *
     * <code>optional int32 availableReplicas = 4;</code>
     */
    public int getAvailableReplicas() {
      return availableReplicas_;
    }

    public static final int UNAVAILABLEREPLICAS_FIELD_NUMBER = 5;
    private int unavailableReplicas_;
    /**
     *
     *
     * <pre>
     * Total number of unavailable pods targeted by this deployment. This is the total number of
     * pods that are still required for the deployment to have 100% available capacity. They may
     * either be pods that are running but not yet available or pods that still have not been created.
     * +optional
     * </pre>
     *
     * <code>optional int32 unavailableReplicas = 5;</code>
     */
    public boolean hasUnavailableReplicas() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * Total number of unavailable pods targeted by this deployment. This is the total number of
     * pods that are still required for the deployment to have 100% available capacity. They may
     * either be pods that are running but not yet available or pods that still have not been created.
     * +optional
     * </pre>
     *
     * <code>optional int32 unavailableReplicas = 5;</code>
     */
    public int getUnavailableReplicas() {
      return unavailableReplicas_;
    }

    public static final int CONDITIONS_FIELD_NUMBER = 6;
    private java.util.List<io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition> conditions_;
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition>
        getConditionsList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    public java.util.List<
            ? extends io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder>
        getConditionsOrBuilderList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    public int getConditionsCount() {
      return conditions_.size();
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition getConditions(int index) {
      return conditions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a deployment's current state.
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder
        getConditionsOrBuilder(int index) {
      return conditions_.get(index);
    }

    public static final int COLLISIONCOUNT_FIELD_NUMBER = 8;
    private int collisionCount_;
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the Deployment. The Deployment controller uses this
     * field as a collision avoidance mechanism when it needs to create the name for the
     * newest ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 8;</code>
     */
    public boolean hasCollisionCount() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     *
     *
     * <pre>
     * Count of hash collisions for the Deployment. The Deployment controller uses this
     * field as a collision avoidance mechanism when it needs to create the name for the
     * newest ReplicaSet.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 8;</code>
     */
    public int getCollisionCount() {
      return collisionCount_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt64(1, observedGeneration_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, replicas_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, updatedReplicas_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(4, availableReplicas_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeInt32(5, unavailableReplicas_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        output.writeMessage(6, conditions_.get(i));
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(7, readyReplicas_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeInt32(8, collisionCount_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, observedGeneration_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, replicas_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, updatedReplicas_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, availableReplicas_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, unavailableReplicas_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, conditions_.get(i));
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, readyReplicas_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, collisionCount_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus other =
          (io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus) obj;

      boolean result = true;
      result = result && (hasObservedGeneration() == other.hasObservedGeneration());
      if (hasObservedGeneration()) {
        result = result && (getObservedGeneration() == other.getObservedGeneration());
      }
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && (hasUpdatedReplicas() == other.hasUpdatedReplicas());
      if (hasUpdatedReplicas()) {
        result = result && (getUpdatedReplicas() == other.getUpdatedReplicas());
      }
      result = result && (hasReadyReplicas() == other.hasReadyReplicas());
      if (hasReadyReplicas()) {
        result = result && (getReadyReplicas() == other.getReadyReplicas());
      }
      result = result && (hasAvailableReplicas() == other.hasAvailableReplicas());
      if (hasAvailableReplicas()) {
        result = result && (getAvailableReplicas() == other.getAvailableReplicas());
      }
      result = result && (hasUnavailableReplicas() == other.hasUnavailableReplicas());
      if (hasUnavailableReplicas()) {
        result = result && (getUnavailableReplicas() == other.getUnavailableReplicas());
      }
      result = result && getConditionsList().equals(other.getConditionsList());
      result = result && (hasCollisionCount() == other.hasCollisionCount());
      if (hasCollisionCount()) {
        result = result && (getCollisionCount() == other.getCollisionCount());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasObservedGeneration()) {
        hash = (37 * hash) + OBSERVEDGENERATION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
      }
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (hasUpdatedReplicas()) {
        hash = (37 * hash) + UPDATEDREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getUpdatedReplicas();
      }
      if (hasReadyReplicas()) {
        hash = (37 * hash) + READYREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReadyReplicas();
      }
      if (hasAvailableReplicas()) {
        hash = (37 * hash) + AVAILABLEREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getAvailableReplicas();
      }
      if (hasUnavailableReplicas()) {
        hash = (37 * hash) + UNAVAILABLEREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getUnavailableReplicas();
      }
      if (getConditionsCount() > 0) {
        hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionsList().hashCode();
      }
      if (hasCollisionCount()) {
        hash = (37 * hash) + COLLISIONCOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getCollisionCount();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentStatus is the most recently observed status of the Deployment.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.DeploymentStatus)
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.class,
                io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getConditionsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        observedGeneration_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000002);
        updatedReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000004);
        readyReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000008);
        availableReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000010);
        unavailableReplicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
        } else {
          conditionsBuilder_.clear();
        }
        collisionCount_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentStatus_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus build() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus result =
            new io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.observedGeneration_ = observedGeneration_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.replicas_ = replicas_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.updatedReplicas_ = updatedReplicas_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.readyReplicas_ = readyReplicas_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.availableReplicas_ = availableReplicas_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.unavailableReplicas_ = unavailableReplicas_;
        if (conditionsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040)) {
            conditions_ = java.util.Collections.unmodifiableList(conditions_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.conditions_ = conditions_;
        } else {
          result.conditions_ = conditionsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000040;
        }
        result.collisionCount_ = collisionCount_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus.getDefaultInstance())
          return this;
        if (other.hasObservedGeneration()) {
          setObservedGeneration(other.getObservedGeneration());
        }
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        if (other.hasUpdatedReplicas()) {
          setUpdatedReplicas(other.getUpdatedReplicas());
        }
        if (other.hasReadyReplicas()) {
          setReadyReplicas(other.getReadyReplicas());
        }
        if (other.hasAvailableReplicas()) {
          setAvailableReplicas(other.getAvailableReplicas());
        }
        if (other.hasUnavailableReplicas()) {
          setUnavailableReplicas(other.getUnavailableReplicas());
        }
        if (conditionsBuilder_ == null) {
          if (!other.conditions_.isEmpty()) {
            if (conditions_.isEmpty()) {
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureConditionsIsMutable();
              conditions_.addAll(other.conditions_);
            }
            onChanged();
          }
        } else {
          if (!other.conditions_.isEmpty()) {
            if (conditionsBuilder_.isEmpty()) {
              conditionsBuilder_.dispose();
              conditionsBuilder_ = null;
              conditions_ = other.conditions_;
              bitField0_ = (bitField0_ & ~0x00000040);
              conditionsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionsFieldBuilder()
                      : null;
            } else {
              conditionsBuilder_.addAllMessages(other.conditions_);
            }
          }
        }
        if (other.hasCollisionCount()) {
          setCollisionCount(other.getCollisionCount());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private long observedGeneration_;
      /**
       *
       *
       * <pre>
       * The generation observed by the deployment controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 1;</code>
       */
      public boolean hasObservedGeneration() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * The generation observed by the deployment controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 1;</code>
       */
      public long getObservedGeneration() {
        return observedGeneration_;
      }
      /**
       *
       *
       * <pre>
       * The generation observed by the deployment controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 1;</code>
       */
      public Builder setObservedGeneration(long value) {
        bitField0_ |= 0x00000001;
        observedGeneration_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The generation observed by the deployment controller.
       * +optional
       * </pre>
       *
       * <code>optional int64 observedGeneration = 1;</code>
       */
      public Builder clearObservedGeneration() {
        bitField0_ = (bitField0_ & ~0x00000001);
        observedGeneration_ = 0L;
        onChanged();
        return this;
      }

      private int replicas_;
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 2;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 2;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 2;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000002;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment (their labels match the selector).
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 2;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000002);
        replicas_ = 0;
        onChanged();
        return this;
      }

      private int updatedReplicas_;
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedReplicas = 3;</code>
       */
      public boolean hasUpdatedReplicas() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedReplicas = 3;</code>
       */
      public int getUpdatedReplicas() {
        return updatedReplicas_;
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedReplicas = 3;</code>
       */
      public Builder setUpdatedReplicas(int value) {
        bitField0_ |= 0x00000004;
        updatedReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of non-terminated pods targeted by this deployment that have the desired template spec.
       * +optional
       * </pre>
       *
       * <code>optional int32 updatedReplicas = 3;</code>
       */
      public Builder clearUpdatedReplicas() {
        bitField0_ = (bitField0_ & ~0x00000004);
        updatedReplicas_ = 0;
        onChanged();
        return this;
      }

      private int readyReplicas_;
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 7;</code>
       */
      public boolean hasReadyReplicas() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 7;</code>
       */
      public int getReadyReplicas() {
        return readyReplicas_;
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 7;</code>
       */
      public Builder setReadyReplicas(int value) {
        bitField0_ |= 0x00000008;
        readyReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * readyReplicas is the number of pods targeted by this Deployment controller with a Ready Condition.
       * +optional
       * </pre>
       *
       * <code>optional int32 readyReplicas = 7;</code>
       */
      public Builder clearReadyReplicas() {
        bitField0_ = (bitField0_ & ~0x00000008);
        readyReplicas_ = 0;
        onChanged();
        return this;
      }

      private int availableReplicas_;
      /**
       *
       *
       * <pre>
       * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 4;</code>
       */
      public boolean hasAvailableReplicas() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 4;</code>
       */
      public int getAvailableReplicas() {
        return availableReplicas_;
      }
      /**
       *
       *
       * <pre>
       * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 4;</code>
       */
      public Builder setAvailableReplicas(int value) {
        bitField0_ |= 0x00000010;
        availableReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of available pods (ready for at least minReadySeconds) targeted by this deployment.
       * +optional
       * </pre>
       *
       * <code>optional int32 availableReplicas = 4;</code>
       */
      public Builder clearAvailableReplicas() {
        bitField0_ = (bitField0_ & ~0x00000010);
        availableReplicas_ = 0;
        onChanged();
        return this;
      }

      private int unavailableReplicas_;
      /**
       *
       *
       * <pre>
       * Total number of unavailable pods targeted by this deployment. This is the total number of
       * pods that are still required for the deployment to have 100% available capacity. They may
       * either be pods that are running but not yet available or pods that still have not been created.
       * +optional
       * </pre>
       *
       * <code>optional int32 unavailableReplicas = 5;</code>
       */
      public boolean hasUnavailableReplicas() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       *
       *
       * <pre>
       * Total number of unavailable pods targeted by this deployment. This is the total number of
       * pods that are still required for the deployment to have 100% available capacity. They may
       * either be pods that are running but not yet available or pods that still have not been created.
       * +optional
       * </pre>
       *
       * <code>optional int32 unavailableReplicas = 5;</code>
       */
      public int getUnavailableReplicas() {
        return unavailableReplicas_;
      }
      /**
       *
       *
       * <pre>
       * Total number of unavailable pods targeted by this deployment. This is the total number of
       * pods that are still required for the deployment to have 100% available capacity. They may
       * either be pods that are running but not yet available or pods that still have not been created.
       * +optional
       * </pre>
       *
       * <code>optional int32 unavailableReplicas = 5;</code>
       */
      public Builder setUnavailableReplicas(int value) {
        bitField0_ |= 0x00000020;
        unavailableReplicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Total number of unavailable pods targeted by this deployment. This is the total number of
       * pods that are still required for the deployment to have 100% available capacity. They may
       * either be pods that are running but not yet available or pods that still have not been created.
       * +optional
       * </pre>
       *
       * <code>optional int32 unavailableReplicas = 5;</code>
       */
      public Builder clearUnavailableReplicas() {
        bitField0_ = (bitField0_ & ~0x00000020);
        unavailableReplicas_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition>
          conditions_ = java.util.Collections.emptyList();

      private void ensureConditionsIsMutable() {
        if (!((bitField0_ & 0x00000040) == 0x00000040)) {
          conditions_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition>(
                  conditions_);
          bitField0_ |= 0x00000040;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder>
          conditionsBuilder_;

      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition>
          getConditionsList() {
        if (conditionsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditions_);
        } else {
          return conditionsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public int getConditionsCount() {
        if (conditionsBuilder_ == null) {
          return conditions_.size();
        } else {
          return conditionsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition getConditions(int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder setConditions(
          int index, io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.set(index, value);
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder setConditions(
          int index,
          io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addConditions(
          io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addConditions(
          int index, io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition value) {
        if (conditionsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionsIsMutable();
          conditions_.add(index, value);
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addConditions(
          io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addConditions(
          int index,
          io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder builderForValue) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder addAllConditions(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition>
              values) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, conditions_);
          onChanged();
        } else {
          conditionsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder clearConditions() {
        if (conditionsBuilder_ == null) {
          conditions_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          conditionsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public Builder removeConditions(int index) {
        if (conditionsBuilder_ == null) {
          ensureConditionsIsMutable();
          conditions_.remove(index);
          onChanged();
        } else {
          conditionsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder
          getConditionsBuilder(int index) {
        return getConditionsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder
          getConditionsOrBuilder(int index) {
        if (conditionsBuilder_ == null) {
          return conditions_.get(index);
        } else {
          return conditionsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder>
          getConditionsOrBuilderList() {
        if (conditionsBuilder_ != null) {
          return conditionsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditions_);
        }
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder
          addConditionsBuilder() {
        return getConditionsFieldBuilder()
            .addBuilder(
                io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder
          addConditionsBuilder(int index) {
        return getConditionsFieldBuilder()
            .addBuilder(
                index,
                io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Represents the latest available observations of a deployment's current state.
       * +patchMergeKey=type
       * +patchStrategy=merge
       * </pre>
       *
       * <code>repeated .k8s.io.api.apps.v1beta1.DeploymentCondition conditions = 6;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder>
          getConditionsBuilderList() {
        return getConditionsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder>
          getConditionsFieldBuilder() {
        if (conditionsBuilder_ == null) {
          conditionsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentCondition.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.DeploymentConditionOrBuilder>(
                  conditions_,
                  ((bitField0_ & 0x00000040) == 0x00000040),
                  getParentForChildren(),
                  isClean());
          conditions_ = null;
        }
        return conditionsBuilder_;
      }

      private int collisionCount_;
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the Deployment. The Deployment controller uses this
       * field as a collision avoidance mechanism when it needs to create the name for the
       * newest ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 8;</code>
       */
      public boolean hasCollisionCount() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the Deployment. The Deployment controller uses this
       * field as a collision avoidance mechanism when it needs to create the name for the
       * newest ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 8;</code>
       */
      public int getCollisionCount() {
        return collisionCount_;
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the Deployment. The Deployment controller uses this
       * field as a collision avoidance mechanism when it needs to create the name for the
       * newest ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 8;</code>
       */
      public Builder setCollisionCount(int value) {
        bitField0_ |= 0x00000080;
        collisionCount_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Count of hash collisions for the Deployment. The Deployment controller uses this
       * field as a collision avoidance mechanism when it needs to create the name for the
       * newest ReplicaSet.
       * +optional
       * </pre>
       *
       * <code>optional int32 collisionCount = 8;</code>
       */
      public Builder clearCollisionCount() {
        bitField0_ = (bitField0_ & ~0x00000080);
        collisionCount_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.DeploymentStatus)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.DeploymentStatus)
    private static final io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentStatus> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentStatus>() {
          @java.lang.Override
          public DeploymentStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentStatus(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentStatus getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.DeploymentStrategy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    boolean hasRollingUpdate();
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment getRollingUpdate();
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeploymentOrBuilder
        getRollingUpdateOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * DeploymentStrategy describes how to replace existing pods with new ones.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentStrategy}
   */
  public static final class DeploymentStrategy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.DeploymentStrategy)
      DeploymentStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DeploymentStrategy.newBuilder() to construct.
    private DeploymentStrategy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentStrategy() {
      type_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private DeploymentStrategy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                type_ = bs;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.Builder subBuilder =
                    null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = rollingUpdate_.toBuilder();
                }
                rollingUpdate_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(rollingUpdate_);
                  rollingUpdate_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentStrategy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_DeploymentStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.class,
              io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
     * +optional
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ROLLINGUPDATE_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment rollingUpdate_;
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    public boolean hasRollingUpdate() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment getRollingUpdate() {
      return rollingUpdate_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.getDefaultInstance()
          : rollingUpdate_;
    }
    /**
     *
     *
     * <pre>
     * Rolling update config params. Present only if DeploymentStrategyType =
     * RollingUpdate.
     * ---
     * TODO: Update this to follow our convention for oneOf, whatever we decide it
     * to be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeploymentOrBuilder
        getRollingUpdateOrBuilder() {
      return rollingUpdate_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.getDefaultInstance()
          : rollingUpdate_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getRollingUpdate());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getRollingUpdate());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy other =
          (io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy) obj;

      boolean result = true;
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && getType().equals(other.getType());
      }
      result = result && (hasRollingUpdate() == other.hasRollingUpdate());
      if (hasRollingUpdate()) {
        result = result && getRollingUpdate().equals(other.getRollingUpdate());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasRollingUpdate()) {
        hash = (37 * hash) + ROLLINGUPDATE_FIELD_NUMBER;
        hash = (53 * hash) + getRollingUpdate().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DeploymentStrategy describes how to replace existing pods with new ones.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.DeploymentStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.DeploymentStrategy)
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.class,
                io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getRollingUpdateFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = null;
        } else {
          rollingUpdateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_DeploymentStrategy_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy build() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy result =
            new io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (rollingUpdateBuilder_ == null) {
          result.rollingUpdate_ = rollingUpdate_;
        } else {
          result.rollingUpdate_ = rollingUpdateBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy.getDefaultInstance())
          return this;
        if (other.hasType()) {
          bitField0_ |= 0x00000001;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasRollingUpdate()) {
          mergeRollingUpdate(other.getRollingUpdate());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of deployment. Can be "Recreate" or "RollingUpdate". Default is RollingUpdate.
       * +optional
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment rollingUpdate_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment,
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.Builder,
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeploymentOrBuilder>
          rollingUpdateBuilder_;
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public boolean hasRollingUpdate() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment getRollingUpdate() {
        if (rollingUpdateBuilder_ == null) {
          return rollingUpdate_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.getDefaultInstance()
              : rollingUpdate_;
        } else {
          return rollingUpdateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public Builder setRollingUpdate(
          io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment value) {
        if (rollingUpdateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          rollingUpdate_ = value;
          onChanged();
        } else {
          rollingUpdateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public Builder setRollingUpdate(
          io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.Builder builderForValue) {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = builderForValue.build();
          onChanged();
        } else {
          rollingUpdateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public Builder mergeRollingUpdate(
          io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment value) {
        if (rollingUpdateBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && rollingUpdate_ != null
              && rollingUpdate_
                  != io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment
                      .getDefaultInstance()) {
            rollingUpdate_ =
                io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.newBuilder(
                        rollingUpdate_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            rollingUpdate_ = value;
          }
          onChanged();
        } else {
          rollingUpdateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public Builder clearRollingUpdate() {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdate_ = null;
          onChanged();
        } else {
          rollingUpdateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.Builder
          getRollingUpdateBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getRollingUpdateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeploymentOrBuilder
          getRollingUpdateOrBuilder() {
        if (rollingUpdateBuilder_ != null) {
          return rollingUpdateBuilder_.getMessageOrBuilder();
        } else {
          return rollingUpdate_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.getDefaultInstance()
              : rollingUpdate_;
        }
      }
      /**
       *
       *
       * <pre>
       * Rolling update config params. Present only if DeploymentStrategyType =
       * RollingUpdate.
       * ---
       * TODO: Update this to follow our convention for oneOf, whatever we decide it
       * to be.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.RollingUpdateDeployment rollingUpdate = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment,
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.Builder,
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeploymentOrBuilder>
          getRollingUpdateFieldBuilder() {
        if (rollingUpdateBuilder_ == null) {
          rollingUpdateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment,
                  io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeploymentOrBuilder>(
                  getRollingUpdate(), getParentForChildren(), isClean());
          rollingUpdate_ = null;
        }
        return rollingUpdateBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.DeploymentStrategy)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.DeploymentStrategy)
    private static final io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<DeploymentStrategy> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentStrategy>() {
          @java.lang.Override
          public DeploymentStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new DeploymentStrategy(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<DeploymentStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.DeploymentStrategy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RollbackConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.RollbackConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The revision to rollback to. If set to 0, rollback to the last revision.
     * +optional
     * </pre>
     *
     * <code>optional int64 revision = 1;</code>
     */
    boolean hasRevision();
    /**
     *
     *
     * <pre>
     * The revision to rollback to. If set to 0, rollback to the last revision.
     * +optional
     * </pre>
     *
     * <code>optional int64 revision = 1;</code>
     */
    long getRevision();
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.RollbackConfig}
   */
  public static final class RollbackConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.RollbackConfig)
      RollbackConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RollbackConfig.newBuilder() to construct.
    private RollbackConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RollbackConfig() {
      revision_ = 0L;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private RollbackConfig(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                revision_ = input.readInt64();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_RollbackConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_RollbackConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.class,
              io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder.class);
    }

    private int bitField0_;
    public static final int REVISION_FIELD_NUMBER = 1;
    private long revision_;
    /**
     *
     *
     * <pre>
     * The revision to rollback to. If set to 0, rollback to the last revision.
     * +optional
     * </pre>
     *
     * <code>optional int64 revision = 1;</code>
     */
    public boolean hasRevision() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * The revision to rollback to. If set to 0, rollback to the last revision.
     * +optional
     * </pre>
     *
     * <code>optional int64 revision = 1;</code>
     */
    public long getRevision() {
      return revision_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt64(1, revision_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, revision_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.RollbackConfig)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.RollbackConfig other =
          (io.kubernetes.client.proto.V1beta1Apps.RollbackConfig) obj;

      boolean result = true;
      result = result && (hasRevision() == other.hasRevision());
      if (hasRevision()) {
        result = result && (getRevision() == other.getRevision());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasRevision()) {
        hash = (37 * hash) + REVISION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getRevision());
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.RollbackConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.RollbackConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.RollbackConfig)
        io.kubernetes.client.proto.V1beta1Apps.RollbackConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollbackConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollbackConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.class,
                io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        revision_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollbackConfig_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig build() {
        io.kubernetes.client.proto.V1beta1Apps.RollbackConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.RollbackConfig result =
            new io.kubernetes.client.proto.V1beta1Apps.RollbackConfig(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.revision_ = revision_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.RollbackConfig) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.RollbackConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.RollbackConfig other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.RollbackConfig.getDefaultInstance())
          return this;
        if (other.hasRevision()) {
          setRevision(other.getRevision());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.RollbackConfig parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.RollbackConfig) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private long revision_;
      /**
       *
       *
       * <pre>
       * The revision to rollback to. If set to 0, rollback to the last revision.
       * +optional
       * </pre>
       *
       * <code>optional int64 revision = 1;</code>
       */
      public boolean hasRevision() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * The revision to rollback to. If set to 0, rollback to the last revision.
       * +optional
       * </pre>
       *
       * <code>optional int64 revision = 1;</code>
       */
      public long getRevision() {
        return revision_;
      }
      /**
       *
       *
       * <pre>
       * The revision to rollback to. If set to 0, rollback to the last revision.
       * +optional
       * </pre>
       *
       * <code>optional int64 revision = 1;</code>
       */
      public Builder setRevision(long value) {
        bitField0_ |= 0x00000001;
        revision_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The revision to rollback to. If set to 0, rollback to the last revision.
       * +optional
       * </pre>
       *
       * <code>optional int64 revision = 1;</code>
       */
      public Builder clearRevision() {
        bitField0_ = (bitField0_ & ~0x00000001);
        revision_ = 0L;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.RollbackConfig)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.RollbackConfig)
    private static final io.kubernetes.client.proto.V1beta1Apps.RollbackConfig DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.RollbackConfig();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<RollbackConfig> PARSER =
        new com.google.protobuf.AbstractParser<RollbackConfig>() {
          @java.lang.Override
          public RollbackConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new RollbackConfig(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<RollbackConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RollbackConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.RollbackConfig getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RollingUpdateDeploymentOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.RollingUpdateDeployment)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be unavailable during the update.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * Absolute number is calculated from percentage by rounding down.
     * This can not be 0 if MaxSurge is 0.
     * Defaults to 25%.
     * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
     * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
     * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
     * that the total number of pods available at all times during the update is at
     * least 70% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
     */
    boolean hasMaxUnavailable();
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be unavailable during the update.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * Absolute number is calculated from percentage by rounding down.
     * This can not be 0 if MaxSurge is 0.
     * Defaults to 25%.
     * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
     * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
     * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
     * that the total number of pods available at all times during the update is at
     * least 70% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
     */
    io.kubernetes.client.proto.IntStr.IntOrString getMaxUnavailable();
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be unavailable during the update.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * Absolute number is calculated from percentage by rounding down.
     * This can not be 0 if MaxSurge is 0.
     * Defaults to 25%.
     * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
     * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
     * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
     * that the total number of pods available at all times during the update is at
     * least 70% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
     */
    io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder getMaxUnavailableOrBuilder();

    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be scheduled above the desired number of
     * pods.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * This can not be 0 if MaxUnavailable is 0.
     * Absolute number is calculated from percentage by rounding up.
     * Defaults to 25%.
     * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
     * the rolling update starts, such that the total number of old and new pods do not exceed
     * 130% of desired pods. Once old pods have been killed,
     * new ReplicaSet can be scaled up further, ensuring that total number of pods running
     * at any time during the update is at most 130% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
     */
    boolean hasMaxSurge();
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be scheduled above the desired number of
     * pods.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * This can not be 0 if MaxUnavailable is 0.
     * Absolute number is calculated from percentage by rounding up.
     * Defaults to 25%.
     * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
     * the rolling update starts, such that the total number of old and new pods do not exceed
     * 130% of desired pods. Once old pods have been killed,
     * new ReplicaSet can be scaled up further, ensuring that total number of pods running
     * at any time during the update is at most 130% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
     */
    io.kubernetes.client.proto.IntStr.IntOrString getMaxSurge();
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be scheduled above the desired number of
     * pods.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * This can not be 0 if MaxUnavailable is 0.
     * Absolute number is calculated from percentage by rounding up.
     * Defaults to 25%.
     * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
     * the rolling update starts, such that the total number of old and new pods do not exceed
     * 130% of desired pods. Once old pods have been killed,
     * new ReplicaSet can be scaled up further, ensuring that total number of pods running
     * at any time during the update is at most 130% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
     */
    io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder getMaxSurgeOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Spec to control the desired behavior of rolling update.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.RollingUpdateDeployment}
   */
  public static final class RollingUpdateDeployment extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.RollingUpdateDeployment)
      RollingUpdateDeploymentOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RollingUpdateDeployment.newBuilder() to construct.
    private RollingUpdateDeployment(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RollingUpdateDeployment() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private RollingUpdateDeployment(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.IntStr.IntOrString.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = maxUnavailable_.toBuilder();
                }
                maxUnavailable_ =
                    input.readMessage(
                        io.kubernetes.client.proto.IntStr.IntOrString.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(maxUnavailable_);
                  maxUnavailable_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.IntStr.IntOrString.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = maxSurge_.toBuilder();
                }
                maxSurge_ =
                    input.readMessage(
                        io.kubernetes.client.proto.IntStr.IntOrString.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(maxSurge_);
                  maxSurge_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateDeployment_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateDeployment_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.class,
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.Builder.class);
    }

    private int bitField0_;
    public static final int MAXUNAVAILABLE_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.IntStr.IntOrString maxUnavailable_;
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be unavailable during the update.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * Absolute number is calculated from percentage by rounding down.
     * This can not be 0 if MaxSurge is 0.
     * Defaults to 25%.
     * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
     * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
     * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
     * that the total number of pods available at all times during the update is at
     * least 70% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
     */
    public boolean hasMaxUnavailable() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be unavailable during the update.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * Absolute number is calculated from percentage by rounding down.
     * This can not be 0 if MaxSurge is 0.
     * Defaults to 25%.
     * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
     * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
     * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
     * that the total number of pods available at all times during the update is at
     * least 70% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
     */
    public io.kubernetes.client.proto.IntStr.IntOrString getMaxUnavailable() {
      return maxUnavailable_ == null
          ? io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()
          : maxUnavailable_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be unavailable during the update.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * Absolute number is calculated from percentage by rounding down.
     * This can not be 0 if MaxSurge is 0.
     * Defaults to 25%.
     * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
     * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
     * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
     * that the total number of pods available at all times during the update is at
     * least 70% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
     */
    public io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder getMaxUnavailableOrBuilder() {
      return maxUnavailable_ == null
          ? io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()
          : maxUnavailable_;
    }

    public static final int MAXSURGE_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.IntStr.IntOrString maxSurge_;
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be scheduled above the desired number of
     * pods.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * This can not be 0 if MaxUnavailable is 0.
     * Absolute number is calculated from percentage by rounding up.
     * Defaults to 25%.
     * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
     * the rolling update starts, such that the total number of old and new pods do not exceed
     * 130% of desired pods. Once old pods have been killed,
     * new ReplicaSet can be scaled up further, ensuring that total number of pods running
     * at any time during the update is at most 130% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
     */
    public boolean hasMaxSurge() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be scheduled above the desired number of
     * pods.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * This can not be 0 if MaxUnavailable is 0.
     * Absolute number is calculated from percentage by rounding up.
     * Defaults to 25%.
     * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
     * the rolling update starts, such that the total number of old and new pods do not exceed
     * 130% of desired pods. Once old pods have been killed,
     * new ReplicaSet can be scaled up further, ensuring that total number of pods running
     * at any time during the update is at most 130% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
     */
    public io.kubernetes.client.proto.IntStr.IntOrString getMaxSurge() {
      return maxSurge_ == null
          ? io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()
          : maxSurge_;
    }
    /**
     *
     *
     * <pre>
     * The maximum number of pods that can be scheduled above the desired number of
     * pods.
     * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
     * This can not be 0 if MaxUnavailable is 0.
     * Absolute number is calculated from percentage by rounding up.
     * Defaults to 25%.
     * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
     * the rolling update starts, such that the total number of old and new pods do not exceed
     * 130% of desired pods. Once old pods have been killed,
     * new ReplicaSet can be scaled up further, ensuring that total number of pods running
     * at any time during the update is at most 130% of desired pods.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
     */
    public io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder getMaxSurgeOrBuilder() {
      return maxSurge_ == null
          ? io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()
          : maxSurge_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMaxUnavailable());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getMaxSurge());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMaxUnavailable());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getMaxSurge());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment other =
          (io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment) obj;

      boolean result = true;
      result = result && (hasMaxUnavailable() == other.hasMaxUnavailable());
      if (hasMaxUnavailable()) {
        result = result && getMaxUnavailable().equals(other.getMaxUnavailable());
      }
      result = result && (hasMaxSurge() == other.hasMaxSurge());
      if (hasMaxSurge()) {
        result = result && getMaxSurge().equals(other.getMaxSurge());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMaxUnavailable()) {
        hash = (37 * hash) + MAXUNAVAILABLE_FIELD_NUMBER;
        hash = (53 * hash) + getMaxUnavailable().hashCode();
      }
      if (hasMaxSurge()) {
        hash = (37 * hash) + MAXSURGE_FIELD_NUMBER;
        hash = (53 * hash) + getMaxSurge().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Spec to control the desired behavior of rolling update.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.RollingUpdateDeployment}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.RollingUpdateDeployment)
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeploymentOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateDeployment_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateDeployment_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.class,
                io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMaxUnavailableFieldBuilder();
          getMaxSurgeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (maxUnavailableBuilder_ == null) {
          maxUnavailable_ = null;
        } else {
          maxUnavailableBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (maxSurgeBuilder_ == null) {
          maxSurge_ = null;
        } else {
          maxSurgeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateDeployment_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment build() {
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment result =
            new io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (maxUnavailableBuilder_ == null) {
          result.maxUnavailable_ = maxUnavailable_;
        } else {
          result.maxUnavailable_ = maxUnavailableBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (maxSurgeBuilder_ == null) {
          result.maxSurge_ = maxSurge_;
        } else {
          result.maxSurge_ = maxSurgeBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment other) {
        if (other
            == io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment.getDefaultInstance())
          return this;
        if (other.hasMaxUnavailable()) {
          mergeMaxUnavailable(other.getMaxUnavailable());
        }
        if (other.hasMaxSurge()) {
          mergeMaxSurge(other.getMaxSurge());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.IntStr.IntOrString maxUnavailable_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.IntStr.IntOrString,
              io.kubernetes.client.proto.IntStr.IntOrString.Builder,
              io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder>
          maxUnavailableBuilder_;
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      public boolean hasMaxUnavailable() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      public io.kubernetes.client.proto.IntStr.IntOrString getMaxUnavailable() {
        if (maxUnavailableBuilder_ == null) {
          return maxUnavailable_ == null
              ? io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()
              : maxUnavailable_;
        } else {
          return maxUnavailableBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      public Builder setMaxUnavailable(io.kubernetes.client.proto.IntStr.IntOrString value) {
        if (maxUnavailableBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxUnavailable_ = value;
          onChanged();
        } else {
          maxUnavailableBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      public Builder setMaxUnavailable(
          io.kubernetes.client.proto.IntStr.IntOrString.Builder builderForValue) {
        if (maxUnavailableBuilder_ == null) {
          maxUnavailable_ = builderForValue.build();
          onChanged();
        } else {
          maxUnavailableBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      public Builder mergeMaxUnavailable(io.kubernetes.client.proto.IntStr.IntOrString value) {
        if (maxUnavailableBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && maxUnavailable_ != null
              && maxUnavailable_
                  != io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()) {
            maxUnavailable_ =
                io.kubernetes.client.proto.IntStr.IntOrString.newBuilder(maxUnavailable_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            maxUnavailable_ = value;
          }
          onChanged();
        } else {
          maxUnavailableBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      public Builder clearMaxUnavailable() {
        if (maxUnavailableBuilder_ == null) {
          maxUnavailable_ = null;
          onChanged();
        } else {
          maxUnavailableBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      public io.kubernetes.client.proto.IntStr.IntOrString.Builder getMaxUnavailableBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMaxUnavailableFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      public io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder getMaxUnavailableOrBuilder() {
        if (maxUnavailableBuilder_ != null) {
          return maxUnavailableBuilder_.getMessageOrBuilder();
        } else {
          return maxUnavailable_ == null
              ? io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()
              : maxUnavailable_;
        }
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be unavailable during the update.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * Absolute number is calculated from percentage by rounding down.
       * This can not be 0 if MaxSurge is 0.
       * Defaults to 25%.
       * Example: when this is set to 30%, the old ReplicaSet can be scaled down to 70% of desired pods
       * immediately when the rolling update starts. Once new pods are ready, old ReplicaSet
       * can be scaled down further, followed by scaling up the new ReplicaSet, ensuring
       * that the total number of pods available at all times during the update is at
       * least 70% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxUnavailable = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.IntStr.IntOrString,
              io.kubernetes.client.proto.IntStr.IntOrString.Builder,
              io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder>
          getMaxUnavailableFieldBuilder() {
        if (maxUnavailableBuilder_ == null) {
          maxUnavailableBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.IntStr.IntOrString,
                  io.kubernetes.client.proto.IntStr.IntOrString.Builder,
                  io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder>(
                  getMaxUnavailable(), getParentForChildren(), isClean());
          maxUnavailable_ = null;
        }
        return maxUnavailableBuilder_;
      }

      private io.kubernetes.client.proto.IntStr.IntOrString maxSurge_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.IntStr.IntOrString,
              io.kubernetes.client.proto.IntStr.IntOrString.Builder,
              io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder>
          maxSurgeBuilder_;
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      public boolean hasMaxSurge() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      public io.kubernetes.client.proto.IntStr.IntOrString getMaxSurge() {
        if (maxSurgeBuilder_ == null) {
          return maxSurge_ == null
              ? io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()
              : maxSurge_;
        } else {
          return maxSurgeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      public Builder setMaxSurge(io.kubernetes.client.proto.IntStr.IntOrString value) {
        if (maxSurgeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxSurge_ = value;
          onChanged();
        } else {
          maxSurgeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      public Builder setMaxSurge(
          io.kubernetes.client.proto.IntStr.IntOrString.Builder builderForValue) {
        if (maxSurgeBuilder_ == null) {
          maxSurge_ = builderForValue.build();
          onChanged();
        } else {
          maxSurgeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      public Builder mergeMaxSurge(io.kubernetes.client.proto.IntStr.IntOrString value) {
        if (maxSurgeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && maxSurge_ != null
              && maxSurge_ != io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()) {
            maxSurge_ =
                io.kubernetes.client.proto.IntStr.IntOrString.newBuilder(maxSurge_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            maxSurge_ = value;
          }
          onChanged();
        } else {
          maxSurgeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      public Builder clearMaxSurge() {
        if (maxSurgeBuilder_ == null) {
          maxSurge_ = null;
          onChanged();
        } else {
          maxSurgeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      public io.kubernetes.client.proto.IntStr.IntOrString.Builder getMaxSurgeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMaxSurgeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      public io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder getMaxSurgeOrBuilder() {
        if (maxSurgeBuilder_ != null) {
          return maxSurgeBuilder_.getMessageOrBuilder();
        } else {
          return maxSurge_ == null
              ? io.kubernetes.client.proto.IntStr.IntOrString.getDefaultInstance()
              : maxSurge_;
        }
      }
      /**
       *
       *
       * <pre>
       * The maximum number of pods that can be scheduled above the desired number of
       * pods.
       * Value can be an absolute number (ex: 5) or a percentage of desired pods (ex: 10%).
       * This can not be 0 if MaxUnavailable is 0.
       * Absolute number is calculated from percentage by rounding up.
       * Defaults to 25%.
       * Example: when this is set to 30%, the new ReplicaSet can be scaled up immediately when
       * the rolling update starts, such that the total number of old and new pods do not exceed
       * 130% of desired pods. Once old pods have been killed,
       * new ReplicaSet can be scaled up further, ensuring that total number of pods running
       * at any time during the update is at most 130% of desired pods.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.util.intstr.IntOrString maxSurge = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.IntStr.IntOrString,
              io.kubernetes.client.proto.IntStr.IntOrString.Builder,
              io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder>
          getMaxSurgeFieldBuilder() {
        if (maxSurgeBuilder_ == null) {
          maxSurgeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.IntStr.IntOrString,
                  io.kubernetes.client.proto.IntStr.IntOrString.Builder,
                  io.kubernetes.client.proto.IntStr.IntOrStringOrBuilder>(
                  getMaxSurge(), getParentForChildren(), isClean());
          maxSurge_ = null;
        }
        return maxSurgeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.RollingUpdateDeployment)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.RollingUpdateDeployment)
    private static final io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<RollingUpdateDeployment> PARSER =
        new com.google.protobuf.AbstractParser<RollingUpdateDeployment>() {
          @java.lang.Override
          public RollingUpdateDeployment parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new RollingUpdateDeployment(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<RollingUpdateDeployment> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RollingUpdateDeployment> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateDeployment
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface RollingUpdateStatefulSetStrategyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.RollingUpdateStatefulSetStrategy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Partition indicates the ordinal at which the StatefulSet should be
     * partitioned.
     * </pre>
     *
     * <code>optional int32 partition = 1;</code>
     */
    boolean hasPartition();
    /**
     *
     *
     * <pre>
     * Partition indicates the ordinal at which the StatefulSet should be
     * partitioned.
     * </pre>
     *
     * <code>optional int32 partition = 1;</code>
     */
    int getPartition();
  }
  /**
   *
   *
   * <pre>
   * RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.RollingUpdateStatefulSetStrategy}
   */
  public static final class RollingUpdateStatefulSetStrategy
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.RollingUpdateStatefulSetStrategy)
      RollingUpdateStatefulSetStrategyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use RollingUpdateStatefulSetStrategy.newBuilder() to construct.
    private RollingUpdateStatefulSetStrategy(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RollingUpdateStatefulSetStrategy() {
      partition_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private RollingUpdateStatefulSetStrategy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                partition_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateStatefulSetStrategy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateStatefulSetStrategy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy.class,
              io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy.Builder
                  .class);
    }

    private int bitField0_;
    public static final int PARTITION_FIELD_NUMBER = 1;
    private int partition_;
    /**
     *
     *
     * <pre>
     * Partition indicates the ordinal at which the StatefulSet should be
     * partitioned.
     * </pre>
     *
     * <code>optional int32 partition = 1;</code>
     */
    public boolean hasPartition() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Partition indicates the ordinal at which the StatefulSet should be
     * partitioned.
     * </pre>
     *
     * <code>optional int32 partition = 1;</code>
     */
    public int getPartition() {
      return partition_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, partition_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, partition_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy other =
          (io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy) obj;

      boolean result = true;
      result = result && (hasPartition() == other.hasPartition());
      if (hasPartition()) {
        result = result && (getPartition() == other.getPartition());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPartition()) {
        hash = (37 * hash) + PARTITION_FIELD_NUMBER;
        hash = (53 * hash) + getPartition();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * RollingUpdateStatefulSetStrategy is used to communicate parameter for RollingUpdateStatefulSetStrategyType.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.RollingUpdateStatefulSetStrategy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.RollingUpdateStatefulSetStrategy)
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateStatefulSetStrategy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateStatefulSetStrategy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy.class,
                io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy.Builder
                    .class);
      }

      // Construct using
      // io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        partition_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_RollingUpdateStatefulSetStrategy_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
            .getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy build() {
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
          buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy result =
            new io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.partition_ = partition_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy) {
          return mergeFrom(
              (io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy other) {
        if (other
            == io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
                .getDefaultInstance()) return this;
        if (other.hasPartition()) {
          setPartition(other.getPartition());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int partition_;
      /**
       *
       *
       * <pre>
       * Partition indicates the ordinal at which the StatefulSet should be
       * partitioned.
       * </pre>
       *
       * <code>optional int32 partition = 1;</code>
       */
      public boolean hasPartition() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Partition indicates the ordinal at which the StatefulSet should be
       * partitioned.
       * </pre>
       *
       * <code>optional int32 partition = 1;</code>
       */
      public int getPartition() {
        return partition_;
      }
      /**
       *
       *
       * <pre>
       * Partition indicates the ordinal at which the StatefulSet should be
       * partitioned.
       * </pre>
       *
       * <code>optional int32 partition = 1;</code>
       */
      public Builder setPartition(int value) {
        bitField0_ |= 0x00000001;
        partition_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Partition indicates the ordinal at which the StatefulSet should be
       * partitioned.
       * </pre>
       *
       * <code>optional int32 partition = 1;</code>
       */
      public Builder clearPartition() {
        bitField0_ = (bitField0_ & ~0x00000001);
        partition_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.RollingUpdateStatefulSetStrategy)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.RollingUpdateStatefulSetStrategy)
    private static final io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<RollingUpdateStatefulSetStrategy> PARSER =
        new com.google.protobuf.AbstractParser<RollingUpdateStatefulSetStrategy>() {
          @java.lang.Override
          public RollingUpdateStatefulSetStrategy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new RollingUpdateStatefulSetStrategy(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<RollingUpdateStatefulSetStrategy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RollingUpdateStatefulSetStrategy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.RollingUpdateStatefulSetStrategy
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ScaleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.Scale)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.ScaleSpec getSpec();
    /**
     *
     *
     * <pre>
     * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.ScaleSpecOrBuilder getSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.ScaleStatus getStatus();
    /**
     *
     *
     * <pre>
     * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.ScaleStatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Scale represents a scaling request for a resource.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.Scale}
   */
  public static final class Scale extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.Scale)
      ScaleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Scale.newBuilder() to construct.
    private Scale(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Scale() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Scale(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = status_.toBuilder();
                }
                status_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(status_);
                  status_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_Scale_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_Scale_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.Scale.class,
              io.kubernetes.client.proto.V1beta1Apps.Scale.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1beta1Apps.ScaleSpec spec_;
    /**
     *
     *
     * <pre>
     * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.ScaleSpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.ScaleSpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.getDefaultInstance()
          : spec_;
    }

    public static final int STATUS_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1beta1Apps.ScaleStatus status_;
    /**
     *
     *
     * <pre>
     * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.ScaleStatus getStatus() {
      return status_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.getDefaultInstance()
          : status_;
    }
    /**
     *
     *
     * <pre>
     * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.ScaleStatusOrBuilder getStatusOrBuilder() {
      return status_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.getDefaultInstance()
          : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getStatus());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStatus());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.Scale)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.Scale other =
          (io.kubernetes.client.proto.V1beta1Apps.Scale) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1beta1Apps.Scale prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Scale represents a scaling request for a resource.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.Scale}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.Scale)
        io.kubernetes.client.proto.V1beta1Apps.ScaleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_Scale_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_Scale_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.Scale.class,
                io.kubernetes.client.proto.V1beta1Apps.Scale.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.Scale.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (statusBuilder_ == null) {
          status_ = null;
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_Scale_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.Scale getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.Scale.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.Scale build() {
        io.kubernetes.client.proto.V1beta1Apps.Scale result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.Scale buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.Scale result =
            new io.kubernetes.client.proto.V1beta1Apps.Scale(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (statusBuilder_ == null) {
          result.status_ = status_;
        } else {
          result.status_ = statusBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.Scale) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.Scale) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.Scale other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.Scale.getDefaultInstance()) return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.Scale parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (io.kubernetes.client.proto.V1beta1Apps.Scale) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1beta1Apps.ScaleSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.ScaleSpec,
              io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.Builder,
              io.kubernetes.client.proto.V1beta1Apps.ScaleSpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ScaleSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1beta1Apps.ScaleSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1beta1Apps.ScaleSpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_ != io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ScaleSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * defines the behavior of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.ScaleSpec,
              io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.Builder,
              io.kubernetes.client.proto.V1beta1Apps.ScaleSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.ScaleSpec,
                  io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.ScaleSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private io.kubernetes.client.proto.V1beta1Apps.ScaleStatus status_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.ScaleStatus,
              io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.Builder,
              io.kubernetes.client.proto.V1beta1Apps.ScaleStatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ScaleStatus getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      public Builder setStatus(io.kubernetes.client.proto.V1beta1Apps.ScaleStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
          onChanged();
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      public Builder setStatus(
          io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
          onChanged();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      public Builder mergeStatus(io.kubernetes.client.proto.V1beta1Apps.ScaleStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && status_ != null
              && status_
                  != io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.getDefaultInstance()) {
            status_ =
                io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.newBuilder(status_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            status_ = value;
          }
          onChanged();
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      public Builder clearStatus() {
        if (statusBuilder_ == null) {
          status_ = null;
          onChanged();
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.Builder getStatusBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.ScaleStatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.getDefaultInstance()
              : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * current status of the scale. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status. Read-only.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.ScaleStatus status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.ScaleStatus,
              io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.Builder,
              io.kubernetes.client.proto.V1beta1Apps.ScaleStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.ScaleStatus,
                  io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.ScaleStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.Scale)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.Scale)
    private static final io.kubernetes.client.proto.V1beta1Apps.Scale DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.Scale();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.Scale getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<Scale> PARSER =
        new com.google.protobuf.AbstractParser<Scale>() {
          @java.lang.Override
          public Scale parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Scale(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Scale> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Scale> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.Scale getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ScaleSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.ScaleSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * desired number of instances for the scaled object.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * desired number of instances for the scaled object.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    int getReplicas();
  }
  /**
   *
   *
   * <pre>
   * ScaleSpec describes the attributes of a scale subresource
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.ScaleSpec}
   */
  public static final class ScaleSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.ScaleSpec)
      ScaleSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ScaleSpec.newBuilder() to construct.
    private ScaleSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ScaleSpec() {
      replicas_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ScaleSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                replicas_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_ScaleSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_ScaleSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.class,
              io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.Builder.class);
    }

    private int bitField0_;
    public static final int REPLICAS_FIELD_NUMBER = 1;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * desired number of instances for the scaled object.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * desired number of instances for the scaled object.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, replicas_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, replicas_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.ScaleSpec)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.ScaleSpec other =
          (io.kubernetes.client.proto.V1beta1Apps.ScaleSpec) obj;

      boolean result = true;
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1beta1Apps.ScaleSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ScaleSpec describes the attributes of a scale subresource
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.ScaleSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.ScaleSpec)
        io.kubernetes.client.proto.V1beta1Apps.ScaleSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ScaleSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ScaleSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.class,
                io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ScaleSpec_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ScaleSpec getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ScaleSpec build() {
        io.kubernetes.client.proto.V1beta1Apps.ScaleSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ScaleSpec buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.ScaleSpec result =
            new io.kubernetes.client.proto.V1beta1Apps.ScaleSpec(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.replicas_ = replicas_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.ScaleSpec) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.ScaleSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.ScaleSpec other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.ScaleSpec.getDefaultInstance())
          return this;
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.ScaleSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.ScaleSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int replicas_;
      /**
       *
       *
       * <pre>
       * desired number of instances for the scaled object.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * desired number of instances for the scaled object.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * desired number of instances for the scaled object.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000001;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * desired number of instances for the scaled object.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.ScaleSpec)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.ScaleSpec)
    private static final io.kubernetes.client.proto.V1beta1Apps.ScaleSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.ScaleSpec();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ScaleSpec> PARSER =
        new com.google.protobuf.AbstractParser<ScaleSpec>() {
          @java.lang.Override
          public ScaleSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ScaleSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ScaleSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ScaleSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.ScaleSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ScaleStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.ScaleStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * actual number of observed instances of the scaled object.
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * actual number of observed instances of the scaled object.
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    int getSelectorCount();
    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    boolean containsSelector(java.lang.String key);
    /** Use {@link #getSelectorMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getSelector();
    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    java.util.Map<java.lang.String, java.lang.String> getSelectorMap();
    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    java.lang.String getSelectorOrDefault(java.lang.String key, java.lang.String defaultValue);
    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    java.lang.String getSelectorOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * label selector for pods that should match the replicas count. This is a serializated
     * version of both map-based and more expressive set-based selectors. This is done to
     * avoid introspection in the clients. The string will be in the same format as the
     * query-param syntax. If the target type only supports map-based selectors, both this
     * field and map-based selector field are populated.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional string targetSelector = 3;</code>
     */
    boolean hasTargetSelector();
    /**
     *
     *
     * <pre>
     * label selector for pods that should match the replicas count. This is a serializated
     * version of both map-based and more expressive set-based selectors. This is done to
     * avoid introspection in the clients. The string will be in the same format as the
     * query-param syntax. If the target type only supports map-based selectors, both this
     * field and map-based selector field are populated.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional string targetSelector = 3;</code>
     */
    java.lang.String getTargetSelector();
    /**
     *
     *
     * <pre>
     * label selector for pods that should match the replicas count. This is a serializated
     * version of both map-based and more expressive set-based selectors. This is done to
     * avoid introspection in the clients. The string will be in the same format as the
     * query-param syntax. If the target type only supports map-based selectors, both this
     * field and map-based selector field are populated.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional string targetSelector = 3;</code>
     */
    com.google.protobuf.ByteString getTargetSelectorBytes();
  }
  /**
   *
   *
   * <pre>
   * ScaleStatus represents the current status of a scale subresource.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.ScaleStatus}
   */
  public static final class ScaleStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.ScaleStatus)
      ScaleStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ScaleStatus.newBuilder() to construct.
    private ScaleStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ScaleStatus() {
      replicas_ = 0;
      targetSelector_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private ScaleStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                replicas_ = input.readInt32();
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  selector_ =
                      com.google.protobuf.MapField.newMapField(
                          SelectorDefaultEntryHolder.defaultEntry);
                  mutable_bitField0_ |= 0x00000002;
                }
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> selector__ =
                    input.readMessage(
                        SelectorDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                selector_.getMutableMap().put(selector__.getKey(), selector__.getValue());
                break;
              }
            case 26:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                targetSelector_ = bs;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_ScaleStatus_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 2:
          return internalGetSelector();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_ScaleStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.class,
              io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.Builder.class);
    }

    private int bitField0_;
    public static final int REPLICAS_FIELD_NUMBER = 1;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * actual number of observed instances of the scaled object.
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * actual number of observed instances of the scaled object.
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int SELECTOR_FIELD_NUMBER = 2;

    private static final class SelectorDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              io.kubernetes.client.proto.V1beta1Apps
                  .internal_static_k8s_io_api_apps_v1beta1_ScaleStatus_SelectorEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> selector_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetSelector() {
      if (selector_ == null) {
        return com.google.protobuf.MapField.emptyMapField(SelectorDefaultEntryHolder.defaultEntry);
      }
      return selector_;
    }

    public int getSelectorCount() {
      return internalGetSelector().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    public boolean containsSelector(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      return internalGetSelector().getMap().containsKey(key);
    }
    /** Use {@link #getSelectorMap()} instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getSelector() {
      return getSelectorMap();
    }
    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    public java.util.Map<java.lang.String, java.lang.String> getSelectorMap() {
      return internalGetSelector().getMap();
    }
    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    public java.lang.String getSelectorOrDefault(
        java.lang.String key, java.lang.String defaultValue) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSelector().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
     * +optional
     * </pre>
     *
     * <code>map&lt;string, string&gt; selector = 2;</code>
     */
    public java.lang.String getSelectorOrThrow(java.lang.String key) {
      if (key == null) {
        throw new java.lang.NullPointerException();
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetSelector().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int TARGETSELECTOR_FIELD_NUMBER = 3;
    private volatile java.lang.Object targetSelector_;
    /**
     *
     *
     * <pre>
     * label selector for pods that should match the replicas count. This is a serializated
     * version of both map-based and more expressive set-based selectors. This is done to
     * avoid introspection in the clients. The string will be in the same format as the
     * query-param syntax. If the target type only supports map-based selectors, both this
     * field and map-based selector field are populated.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional string targetSelector = 3;</code>
     */
    public boolean hasTargetSelector() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * label selector for pods that should match the replicas count. This is a serializated
     * version of both map-based and more expressive set-based selectors. This is done to
     * avoid introspection in the clients. The string will be in the same format as the
     * query-param syntax. If the target type only supports map-based selectors, both this
     * field and map-based selector field are populated.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional string targetSelector = 3;</code>
     */
    public java.lang.String getTargetSelector() {
      java.lang.Object ref = targetSelector_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          targetSelector_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * label selector for pods that should match the replicas count. This is a serializated
     * version of both map-based and more expressive set-based selectors. This is done to
     * avoid introspection in the clients. The string will be in the same format as the
     * query-param syntax. If the target type only supports map-based selectors, both this
     * field and map-based selector field are populated.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional string targetSelector = 3;</code>
     */
    public com.google.protobuf.ByteString getTargetSelectorBytes() {
      java.lang.Object ref = targetSelector_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        targetSelector_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, replicas_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetSelector(), SelectorDefaultEntryHolder.defaultEntry, 2);
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, targetSelector_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, replicas_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetSelector().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> selector__ =
            SelectorDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, selector__);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, targetSelector_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.ScaleStatus)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.ScaleStatus other =
          (io.kubernetes.client.proto.V1beta1Apps.ScaleStatus) obj;

      boolean result = true;
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && internalGetSelector().equals(other.internalGetSelector());
      result = result && (hasTargetSelector() == other.hasTargetSelector());
      if (hasTargetSelector()) {
        result = result && getTargetSelector().equals(other.getTargetSelector());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (!internalGetSelector().getMap().isEmpty()) {
        hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + internalGetSelector().hashCode();
      }
      if (hasTargetSelector()) {
        hash = (37 * hash) + TARGETSELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getTargetSelector().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1beta1Apps.ScaleStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * ScaleStatus represents the current status of a scale subresource.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.ScaleStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.ScaleStatus)
        io.kubernetes.client.proto.V1beta1Apps.ScaleStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ScaleStatus_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMapField(int number) {
        switch (number) {
          case 2:
            return internalGetSelector();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
        switch (number) {
          case 2:
            return internalGetMutableSelector();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ScaleStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.class,
                io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        internalGetMutableSelector().clear();
        targetSelector_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_ScaleStatus_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ScaleStatus getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ScaleStatus build() {
        io.kubernetes.client.proto.V1beta1Apps.ScaleStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.ScaleStatus buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.ScaleStatus result =
            new io.kubernetes.client.proto.V1beta1Apps.ScaleStatus(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.replicas_ = replicas_;
        result.selector_ = internalGetSelector();
        result.selector_.makeImmutable();
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        result.targetSelector_ = targetSelector_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.ScaleStatus) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.ScaleStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.ScaleStatus other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.ScaleStatus.getDefaultInstance())
          return this;
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        internalGetMutableSelector().mergeFrom(other.internalGetSelector());
        if (other.hasTargetSelector()) {
          bitField0_ |= 0x00000004;
          targetSelector_ = other.targetSelector_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.ScaleStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.ScaleStatus) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int replicas_;
      /**
       *
       *
       * <pre>
       * actual number of observed instances of the scaled object.
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * actual number of observed instances of the scaled object.
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * actual number of observed instances of the scaled object.
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000001;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * actual number of observed instances of the scaled object.
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> selector_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetSelector() {
        if (selector_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              SelectorDefaultEntryHolder.defaultEntry);
        }
        return selector_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableSelector() {
        onChanged();
        ;
        if (selector_ == null) {
          selector_ =
              com.google.protobuf.MapField.newMapField(SelectorDefaultEntryHolder.defaultEntry);
        }
        if (!selector_.isMutable()) {
          selector_ = selector_.copy();
        }
        return selector_;
      }

      public int getSelectorCount() {
        return internalGetSelector().getMap().size();
      }
      /**
       *
       *
       * <pre>
       * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; selector = 2;</code>
       */
      public boolean containsSelector(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        return internalGetSelector().getMap().containsKey(key);
      }
      /** Use {@link #getSelectorMap()} instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getSelector() {
        return getSelectorMap();
      }
      /**
       *
       *
       * <pre>
       * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; selector = 2;</code>
       */
      public java.util.Map<java.lang.String, java.lang.String> getSelectorMap() {
        return internalGetSelector().getMap();
      }
      /**
       *
       *
       * <pre>
       * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; selector = 2;</code>
       */
      public java.lang.String getSelectorOrDefault(
          java.lang.String key, java.lang.String defaultValue) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetSelector().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }
      /**
       *
       *
       * <pre>
       * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; selector = 2;</code>
       */
      public java.lang.String getSelectorOrThrow(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        java.util.Map<java.lang.String, java.lang.String> map = internalGetSelector().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearSelector() {
        internalGetMutableSelector().getMutableMap().clear();
        return this;
      }
      /**
       *
       *
       * <pre>
       * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; selector = 2;</code>
       */
      public Builder removeSelector(java.lang.String key) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        internalGetMutableSelector().getMutableMap().remove(key);
        return this;
      }
      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableSelector() {
        return internalGetMutableSelector().getMutableMap();
      }
      /**
       *
       *
       * <pre>
       * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; selector = 2;</code>
       */
      public Builder putSelector(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new java.lang.NullPointerException();
        }
        if (value == null) {
          throw new java.lang.NullPointerException();
        }
        internalGetMutableSelector().getMutableMap().put(key, value);
        return this;
      }
      /**
       *
       *
       * <pre>
       * label query over pods that should match the replicas count. More info: https://kubernetes.io/docs/user-guide/labels#label-selectors
       * +optional
       * </pre>
       *
       * <code>map&lt;string, string&gt; selector = 2;</code>
       */
      public Builder putAllSelector(java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableSelector().getMutableMap().putAll(values);
        return this;
      }

      private java.lang.Object targetSelector_ = "";
      /**
       *
       *
       * <pre>
       * label selector for pods that should match the replicas count. This is a serializated
       * version of both map-based and more expressive set-based selectors. This is done to
       * avoid introspection in the clients. The string will be in the same format as the
       * query-param syntax. If the target type only supports map-based selectors, both this
       * field and map-based selector field are populated.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional string targetSelector = 3;</code>
       */
      public boolean hasTargetSelector() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * label selector for pods that should match the replicas count. This is a serializated
       * version of both map-based and more expressive set-based selectors. This is done to
       * avoid introspection in the clients. The string will be in the same format as the
       * query-param syntax. If the target type only supports map-based selectors, both this
       * field and map-based selector field are populated.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional string targetSelector = 3;</code>
       */
      public java.lang.String getTargetSelector() {
        java.lang.Object ref = targetSelector_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            targetSelector_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * label selector for pods that should match the replicas count. This is a serializated
       * version of both map-based and more expressive set-based selectors. This is done to
       * avoid introspection in the clients. The string will be in the same format as the
       * query-param syntax. If the target type only supports map-based selectors, both this
       * field and map-based selector field are populated.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional string targetSelector = 3;</code>
       */
      public com.google.protobuf.ByteString getTargetSelectorBytes() {
        java.lang.Object ref = targetSelector_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          targetSelector_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * label selector for pods that should match the replicas count. This is a serializated
       * version of both map-based and more expressive set-based selectors. This is done to
       * avoid introspection in the clients. The string will be in the same format as the
       * query-param syntax. If the target type only supports map-based selectors, both this
       * field and map-based selector field are populated.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional string targetSelector = 3;</code>
       */
      public Builder setTargetSelector(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        targetSelector_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * label selector for pods that should match the replicas count. This is a serializated
       * version of both map-based and more expressive set-based selectors. This is done to
       * avoid introspection in the clients. The string will be in the same format as the
       * query-param syntax. If the target type only supports map-based selectors, both this
       * field and map-based selector field are populated.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional string targetSelector = 3;</code>
       */
      public Builder clearTargetSelector() {
        bitField0_ = (bitField0_ & ~0x00000004);
        targetSelector_ = getDefaultInstance().getTargetSelector();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * label selector for pods that should match the replicas count. This is a serializated
       * version of both map-based and more expressive set-based selectors. This is done to
       * avoid introspection in the clients. The string will be in the same format as the
       * query-param syntax. If the target type only supports map-based selectors, both this
       * field and map-based selector field are populated.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional string targetSelector = 3;</code>
       */
      public Builder setTargetSelectorBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        targetSelector_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.ScaleStatus)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.ScaleStatus)
    private static final io.kubernetes.client.proto.V1beta1Apps.ScaleStatus DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.ScaleStatus();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.ScaleStatus getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<ScaleStatus> PARSER =
        new com.google.protobuf.AbstractParser<ScaleStatus>() {
          @java.lang.Override
          public ScaleStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new ScaleStatus(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<ScaleStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ScaleStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.ScaleStatus getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StatefulSetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.StatefulSet)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Spec defines the desired identities of pods in this set.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * Spec defines the desired identities of pods in this set.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec getSpec();
    /**
     *
     *
     * <pre>
     * Spec defines the desired identities of pods in this set.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpecOrBuilder getSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Status is the current status of Pods in this StatefulSet. This data
     * may be out of date by some window of time.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Status is the current status of Pods in this StatefulSet. This data
     * may be out of date by some window of time.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus getStatus();
    /**
     *
     *
     * <pre>
     * Status is the current status of Pods in this StatefulSet. This data
     * may be out of date by some window of time.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet. See the release notes for
   * more information.
   * StatefulSet represents a set of pods with consistent identities.
   * Identities are defined as:
   *  - Network: A single stable DNS and hostname.
   *  - Storage: As many VolumeClaims as requested.
   * The StatefulSet guarantees that a given network identity will always
   * map to the same storage identity.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSet}
   */
  public static final class StatefulSet extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.StatefulSet)
      StatefulSetOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StatefulSet.newBuilder() to construct.
    private StatefulSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StatefulSet() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private StatefulSet(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = status_.toBuilder();
                }
                status_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(status_);
                  status_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.StatefulSet.class,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec spec_;
    /**
     *
     *
     * <pre>
     * Spec defines the desired identities of pods in this set.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Spec defines the desired identities of pods in this set.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * Spec defines the desired identities of pods in this set.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.getDefaultInstance()
          : spec_;
    }

    public static final int STATUS_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus status_;
    /**
     *
     *
     * <pre>
     * Status is the current status of Pods in this StatefulSet. This data
     * may be out of date by some window of time.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Status is the current status of Pods in this StatefulSet. This data
     * may be out of date by some window of time.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus getStatus() {
      return status_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.getDefaultInstance()
          : status_;
    }
    /**
     *
     *
     * <pre>
     * Status is the current status of Pods in this StatefulSet. This data
     * may be out of date by some window of time.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatusOrBuilder getStatusOrBuilder() {
      return status_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.getDefaultInstance()
          : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getStatus());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStatus());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSet)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.StatefulSet other =
          (io.kubernetes.client.proto.V1beta1Apps.StatefulSet) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1beta1Apps.StatefulSet prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * DEPRECATED - This group version of StatefulSet is deprecated by apps/v1beta2/StatefulSet. See the release notes for
     * more information.
     * StatefulSet represents a set of pods with consistent identities.
     * Identities are defined as:
     *  - Network: A single stable DNS and hostname.
     *  - Storage: As many VolumeClaims as requested.
     * The StatefulSet guarantees that a given network identity will always
     * map to the same storage identity.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSet}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.StatefulSet)
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSet_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSet_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.StatefulSet.class,
                io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.StatefulSet.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (statusBuilder_ == null) {
          status_ = null;
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSet_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSet getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.StatefulSet.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSet build() {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSet result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSet buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSet result =
            new io.kubernetes.client.proto.V1beta1Apps.StatefulSet(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (statusBuilder_ == null) {
          result.status_ = status_;
        } else {
          result.status_ = statusBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSet) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.StatefulSet) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.StatefulSet other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.StatefulSet.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSet parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.StatefulSet) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.Builder,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_
                  != io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Spec defines the desired identities of pods in this set.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.Builder,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec,
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus status_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.Builder,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      public Builder setStatus(io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
          onChanged();
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      public Builder setStatus(
          io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
          onChanged();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      public Builder mergeStatus(io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && status_ != null
              && status_
                  != io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus
                      .getDefaultInstance()) {
            status_ =
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.newBuilder(status_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            status_ = value;
          }
          onChanged();
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      public Builder clearStatus() {
        if (statusBuilder_ == null) {
          status_ = null;
          onChanged();
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.Builder getStatusBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatusOrBuilder
          getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.getDefaultInstance()
              : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * Status is the current status of Pods in this StatefulSet. This data
       * may be out of date by some window of time.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetStatus status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.Builder,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus,
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.StatefulSet)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.StatefulSet)
    private static final io.kubernetes.client.proto.V1beta1Apps.StatefulSet DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.StatefulSet();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSet getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<StatefulSet> PARSER =
        new com.google.protobuf.AbstractParser<StatefulSet>() {
          @java.lang.Override
          public StatefulSet parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new StatefulSet(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<StatefulSet> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StatefulSet> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSet getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StatefulSetConditionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.StatefulSetCondition)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Type of statefulset condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    boolean hasType();
    /**
     *
     *
     * <pre>
     * Type of statefulset condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    java.lang.String getType();
    /**
     *
     *
     * <pre>
     * Type of statefulset condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    com.google.protobuf.ByteString getTypeBytes();

    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    java.lang.String getStatus();
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    com.google.protobuf.ByteString getStatusBytes();

    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    boolean hasLastTransitionTime();
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    io.kubernetes.client.proto.Meta.Time getLastTransitionTime();
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder();

    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    boolean hasReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    java.lang.String getReason();
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    com.google.protobuf.ByteString getReasonBytes();

    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    boolean hasMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    java.lang.String getMessage();
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    com.google.protobuf.ByteString getMessageBytes();
  }
  /**
   *
   *
   * <pre>
   * StatefulSetCondition describes the state of a statefulset at a certain point.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSetCondition}
   */
  public static final class StatefulSetCondition extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.StatefulSetCondition)
      StatefulSetConditionOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StatefulSetCondition.newBuilder() to construct.
    private StatefulSetCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StatefulSetCondition() {
      type_ = "";
      status_ = "";
      reason_ = "";
      message_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private StatefulSetCondition(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                type_ = bs;
                break;
              }
            case 18:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                status_ = bs;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.Meta.Time.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = lastTransitionTime_.toBuilder();
                }
                lastTransitionTime_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.Time.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(lastTransitionTime_);
                  lastTransitionTime_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 34:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000008;
                reason_ = bs;
                break;
              }
            case 42:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                message_ = bs;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSetCondition_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSetCondition_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition.class,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition.Builder.class);
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private volatile java.lang.Object type_;
    /**
     *
     *
     * <pre>
     * Type of statefulset condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Type of statefulset condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          type_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Type of statefulset condition.
     * </pre>
     *
     * <code>optional string type = 1;</code>
     */
    public com.google.protobuf.ByteString getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int STATUS_FIELD_NUMBER = 2;
    private volatile java.lang.Object status_;
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          status_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Status of the condition, one of True, False, Unknown.
     * </pre>
     *
     * <code>optional string status = 2;</code>
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int LASTTRANSITIONTIME_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.Meta.Time lastTransitionTime_;
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public boolean hasLastTransitionTime() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }
    /**
     *
     *
     * <pre>
     * Last time the condition transitioned from one status to another.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
     */
    public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
      return lastTransitionTime_ == null
          ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
          : lastTransitionTime_;
    }

    public static final int REASON_FIELD_NUMBER = 4;
    private volatile java.lang.Object reason_;
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public boolean hasReason() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public java.lang.String getReason() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          reason_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The reason for the condition's last transition.
     * +optional
     * </pre>
     *
     * <code>optional string reason = 4;</code>
     */
    public com.google.protobuf.ByteString getReasonBytes() {
      java.lang.Object ref = reason_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        reason_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MESSAGE_FIELD_NUMBER = 5;
    private volatile java.lang.Object message_;
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public boolean hasMessage() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public java.lang.String getMessage() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          message_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * A human readable message indicating details about the transition.
     * +optional
     * </pre>
     *
     * <code>optional string message = 5;</code>
     */
    public com.google.protobuf.ByteString getMessageBytes() {
      java.lang.Object ref = message_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        message_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, status_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getLastTransitionTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, reason_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, message_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, status_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(3, getLastTransitionTime());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, reason_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, message_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition other =
          (io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition) obj;

      boolean result = true;
      result = result && (hasType() == other.hasType());
      if (hasType()) {
        result = result && getType().equals(other.getType());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && (hasLastTransitionTime() == other.hasLastTransitionTime());
      if (hasLastTransitionTime()) {
        result = result && getLastTransitionTime().equals(other.getLastTransitionTime());
      }
      result = result && (hasReason() == other.hasReason());
      if (hasReason()) {
        result = result && getReason().equals(other.getReason());
      }
      result = result && (hasMessage() == other.hasMessage());
      if (hasMessage()) {
        result = result && getMessage().equals(other.getMessage());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      if (hasLastTransitionTime()) {
        hash = (37 * hash) + LASTTRANSITIONTIME_FIELD_NUMBER;
        hash = (53 * hash) + getLastTransitionTime().hashCode();
      }
      if (hasReason()) {
        hash = (37 * hash) + REASON_FIELD_NUMBER;
        hash = (53 * hash) + getReason().hashCode();
      }
      if (hasMessage()) {
        hash = (37 * hash) + MESSAGE_FIELD_NUMBER;
        hash = (53 * hash) + getMessage().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * StatefulSetCondition describes the state of a statefulset at a certain point.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSetCondition}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.StatefulSetCondition)
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetConditionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetCondition_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetCondition_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition.class,
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLastTransitionTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        type_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        status_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        reason_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        message_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetCondition_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition build() {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition result =
            new io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.status_ = status_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (lastTransitionTimeBuilder_ == null) {
          result.lastTransitionTime_ = lastTransitionTime_;
        } else {
          result.lastTransitionTime_ = lastTransitionTimeBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.reason_ = reason_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.message_ = message_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition other) {
        if (other
            == io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition.getDefaultInstance())
          return this;
        if (other.hasType()) {
          bitField0_ |= 0x00000001;
          type_ = other.type_;
          onChanged();
        }
        if (other.hasStatus()) {
          bitField0_ |= 0x00000002;
          status_ = other.status_;
          onChanged();
        }
        if (other.hasLastTransitionTime()) {
          mergeLastTransitionTime(other.getLastTransitionTime());
        }
        if (other.hasReason()) {
          bitField0_ |= 0x00000008;
          reason_ = other.reason_;
          onChanged();
        }
        if (other.hasMessage()) {
          bitField0_ |= 0x00000010;
          message_ = other.message_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object type_ = "";
      /**
       *
       *
       * <pre>
       * Type of statefulset condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Type of statefulset condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public java.lang.String getType() {
        java.lang.Object ref = type_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            type_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of statefulset condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public com.google.protobuf.ByteString getTypeBytes() {
        java.lang.Object ref = type_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          type_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Type of statefulset condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of statefulset condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = getDefaultInstance().getType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Type of statefulset condition.
       * </pre>
       *
       * <code>optional string type = 1;</code>
       */
      public Builder setTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object status_ = "";
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public java.lang.String getStatus() {
        java.lang.Object ref = status_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            status_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public com.google.protobuf.ByteString getStatusBytes() {
        java.lang.Object ref = status_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          status_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatus(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder clearStatus() {
        bitField0_ = (bitField0_ & ~0x00000002);
        status_ = getDefaultInstance().getStatus();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status of the condition, one of True, False, Unknown.
       * </pre>
       *
       * <code>optional string status = 2;</code>
       */
      public Builder setStatusBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        status_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.Time lastTransitionTime_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          lastTransitionTimeBuilder_;
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public boolean hasLastTransitionTime() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.Time getLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        } else {
          return lastTransitionTimeBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder setLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          lastTransitionTime_ = value;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder setLastTransitionTime(
          io.kubernetes.client.proto.Meta.Time.Builder builderForValue) {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = builderForValue.build();
          onChanged();
        } else {
          lastTransitionTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder mergeLastTransitionTime(io.kubernetes.client.proto.Meta.Time value) {
        if (lastTransitionTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && lastTransitionTime_ != null
              && lastTransitionTime_ != io.kubernetes.client.proto.Meta.Time.getDefaultInstance()) {
            lastTransitionTime_ =
                io.kubernetes.client.proto.Meta.Time.newBuilder(lastTransitionTime_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            lastTransitionTime_ = value;
          }
          onChanged();
        } else {
          lastTransitionTimeBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public Builder clearLastTransitionTime() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTime_ = null;
          onChanged();
        } else {
          lastTransitionTimeBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.Time.Builder getLastTransitionTimeBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getLastTransitionTimeFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      public io.kubernetes.client.proto.Meta.TimeOrBuilder getLastTransitionTimeOrBuilder() {
        if (lastTransitionTimeBuilder_ != null) {
          return lastTransitionTimeBuilder_.getMessageOrBuilder();
        } else {
          return lastTransitionTime_ == null
              ? io.kubernetes.client.proto.Meta.Time.getDefaultInstance()
              : lastTransitionTime_;
        }
      }
      /**
       *
       *
       * <pre>
       * Last time the condition transitioned from one status to another.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.Time lastTransitionTime = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.Time,
              io.kubernetes.client.proto.Meta.Time.Builder,
              io.kubernetes.client.proto.Meta.TimeOrBuilder>
          getLastTransitionTimeFieldBuilder() {
        if (lastTransitionTimeBuilder_ == null) {
          lastTransitionTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.Time,
                  io.kubernetes.client.proto.Meta.Time.Builder,
                  io.kubernetes.client.proto.Meta.TimeOrBuilder>(
                  getLastTransitionTime(), getParentForChildren(), isClean());
          lastTransitionTime_ = null;
        }
        return lastTransitionTimeBuilder_;
      }

      private java.lang.Object reason_ = "";
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public boolean hasReason() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public java.lang.String getReason() {
        java.lang.Object ref = reason_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            reason_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public com.google.protobuf.ByteString getReasonBytes() {
        java.lang.Object ref = reason_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          reason_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReason(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        reason_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder clearReason() {
        bitField0_ = (bitField0_ & ~0x00000008);
        reason_ = getDefaultInstance().getReason();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The reason for the condition's last transition.
       * +optional
       * </pre>
       *
       * <code>optional string reason = 4;</code>
       */
      public Builder setReasonBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        reason_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object message_ = "";
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public boolean hasMessage() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public java.lang.String getMessage() {
        java.lang.Object ref = message_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            message_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public com.google.protobuf.ByteString getMessageBytes() {
        java.lang.Object ref = message_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          message_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessage(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        message_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder clearMessage() {
        bitField0_ = (bitField0_ & ~0x00000010);
        message_ = getDefaultInstance().getMessage();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * A human readable message indicating details about the transition.
       * +optional
       * </pre>
       *
       * <code>optional string message = 5;</code>
       */
      public Builder setMessageBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        message_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.StatefulSetCondition)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.StatefulSetCondition)
    private static final io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<StatefulSetCondition> PARSER =
        new com.google.protobuf.AbstractParser<StatefulSetCondition>() {
          @java.lang.Override
          public StatefulSetCondition parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new StatefulSetCondition(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<StatefulSetCondition> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StatefulSetCondition> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StatefulSetListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.StatefulSetList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSet> getItemsList();
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSet getItems(int index);
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    int getItemsCount();
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder>
        getItemsOrBuilderList();
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * StatefulSetList is a collection of StatefulSets.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSetList}
   */
  public static final class StatefulSetList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.StatefulSetList)
      StatefulSetListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StatefulSetList.newBuilder() to construct.
    private StatefulSetList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StatefulSetList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private StatefulSetList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ =
                      new java.util.ArrayList<io.kubernetes.client.proto.V1beta1Apps.StatefulSet>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.StatefulSet.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSetList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSetList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetList.class,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSet> items_;
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    public java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSet> getItemsList() {
      return items_;
    }
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    public java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    public int getItemsCount() {
      return items_.size();
    }
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSet getItems(int index) {
      return items_.get(index);
    }
    /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder getItemsOrBuilder(
        int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSetList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.StatefulSetList other =
          (io.kubernetes.client.proto.V1beta1Apps.StatefulSetList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * StatefulSetList is a collection of StatefulSets.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSetList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.StatefulSetList)
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetList.class,
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.StatefulSetList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.StatefulSetList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetList build() {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetList buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetList result =
            new io.kubernetes.client.proto.V1beta1Apps.StatefulSetList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSetList) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.StatefulSetList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.StatefulSetList other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.StatefulSetList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.StatefulSetList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSet> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1beta1Apps.StatefulSet>(items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.StatefulSet,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder>
          itemsBuilder_;

      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSet> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSet getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder setItems(int index, io.kubernetes.client.proto.V1beta1Apps.StatefulSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder addItems(io.kubernetes.client.proto.V1beta1Apps.StatefulSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder addItems(int index, io.kubernetes.client.proto.V1beta1Apps.StatefulSet value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder addItems(
          io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1beta1Apps.StatefulSet> values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder getItemsBuilder(int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder getItemsOrBuilder(
          int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1beta1Apps.StatefulSet.getDefaultInstance());
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder addItemsBuilder(int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1beta1Apps.StatefulSet.getDefaultInstance());
      }
      /** <code>repeated .k8s.io.api.apps.v1beta1.StatefulSet items = 2;</code> */
      public java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.StatefulSet,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSet,
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSet.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.StatefulSetList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.StatefulSetList)
    private static final io.kubernetes.client.proto.V1beta1Apps.StatefulSetList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.StatefulSetList();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<StatefulSetList> PARSER =
        new com.google.protobuf.AbstractParser<StatefulSetList>() {
          @java.lang.Override
          public StatefulSetList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new StatefulSetList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<StatefulSetList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StatefulSetList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StatefulSetSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.StatefulSetSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * replicas is the desired number of replicas of the given Template.
     * These are replicas in the sense that they are instantiations of the
     * same Template, but individual replicas also have a consistent identity.
     * If unspecified, defaults to 1.
     * TODO: Consider a rename of this field.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * replicas is the desired number of replicas of the given Template.
     * These are replicas in the sense that they are instantiations of the
     * same Template, but individual replicas also have a consistent identity.
     * If unspecified, defaults to 1.
     * TODO: Consider a rename of this field.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * selector is a label query over pods that should match the replica count.
     * If empty, defaulted to labels on the pod template.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    boolean hasSelector();
    /**
     *
     *
     * <pre>
     * selector is a label query over pods that should match the replica count.
     * If empty, defaulted to labels on the pod template.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelector getSelector();
    /**
     *
     *
     * <pre>
     * selector is a label query over pods that should match the replica count.
     * If empty, defaulted to labels on the pod template.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder();

    /**
     *
     *
     * <pre>
     * template is the object that describes the pod that will be created if
     * insufficient replicas are detected. Each pod stamped out by the StatefulSet
     * will fulfill this Template, but have a unique identity from the rest
     * of the StatefulSet.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    boolean hasTemplate();
    /**
     *
     *
     * <pre>
     * template is the object that describes the pod that will be created if
     * insufficient replicas are detected. Each pod stamped out by the StatefulSet
     * will fulfill this Template, but have a unique identity from the rest
     * of the StatefulSet.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate();
    /**
     *
     *
     * <pre>
     * template is the object that describes the pod that will be created if
     * insufficient replicas are detected. Each pod stamped out by the StatefulSet
     * will fulfill this Template, but have a unique identity from the rest
     * of the StatefulSet.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder();

    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1.PersistentVolumeClaim>
        getVolumeClaimTemplatesList();
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    io.kubernetes.client.proto.V1.PersistentVolumeClaim getVolumeClaimTemplates(int index);
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    int getVolumeClaimTemplatesCount();
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder>
        getVolumeClaimTemplatesOrBuilderList();
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder getVolumeClaimTemplatesOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * serviceName is the name of the service that governs this StatefulSet.
     * This service must exist before the StatefulSet, and is responsible for
     * the network identity of the set. Pods get DNS/hostnames that follow the
     * pattern: pod-specific-string.serviceName.default.svc.cluster.local
     * where "pod-specific-string" is managed by the StatefulSet controller.
     * </pre>
     *
     * <code>optional string serviceName = 5;</code>
     */
    boolean hasServiceName();
    /**
     *
     *
     * <pre>
     * serviceName is the name of the service that governs this StatefulSet.
     * This service must exist before the StatefulSet, and is responsible for
     * the network identity of the set. Pods get DNS/hostnames that follow the
     * pattern: pod-specific-string.serviceName.default.svc.cluster.local
     * where "pod-specific-string" is managed by the StatefulSet controller.
     * </pre>
     *
     * <code>optional string serviceName = 5;</code>
     */
    java.lang.String getServiceName();
    /**
     *
     *
     * <pre>
     * serviceName is the name of the service that governs this StatefulSet.
     * This service must exist before the StatefulSet, and is responsible for
     * the network identity of the set. Pods get DNS/hostnames that follow the
     * pattern: pod-specific-string.serviceName.default.svc.cluster.local
     * where "pod-specific-string" is managed by the StatefulSet controller.
     * </pre>
     *
     * <code>optional string serviceName = 5;</code>
     */
    com.google.protobuf.ByteString getServiceNameBytes();

    /**
     *
     *
     * <pre>
     * podManagementPolicy controls how pods are created during initial scale up,
     * when replacing pods on nodes, or when scaling down. The default policy is
     * `OrderedReady`, where pods are created in increasing order (pod-0, then
     * pod-1, etc) and the controller will wait until each pod is ready before
     * continuing. When scaling down, the pods are removed in the opposite order.
     * The alternative policy is `Parallel` which will create pods in parallel
     * to match the desired scale without waiting, and on scale down will delete
     * all pods at once.
     * +optional
     * </pre>
     *
     * <code>optional string podManagementPolicy = 6;</code>
     */
    boolean hasPodManagementPolicy();
    /**
     *
     *
     * <pre>
     * podManagementPolicy controls how pods are created during initial scale up,
     * when replacing pods on nodes, or when scaling down. The default policy is
     * `OrderedReady`, where pods are created in increasing order (pod-0, then
     * pod-1, etc) and the controller will wait until each pod is ready before
     * continuing. When scaling down, the pods are removed in the opposite order.
     * The alternative policy is `Parallel` which will create pods in parallel
     * to match the desired scale without waiting, and on scale down will delete
     * all pods at once.
     * +optional
     * </pre>
     *
     * <code>optional string podManagementPolicy = 6;</code>
     */
    java.lang.String getPodManagementPolicy();
    /**
     *
     *
     * <pre>
     * podManagementPolicy controls how pods are created during initial scale up,
     * when replacing pods on nodes, or when scaling down. The default policy is
     * `OrderedReady`, where pods are created in increasing order (pod-0, then
     * pod-1, etc) and the controller will wait until each pod is ready before
     * continuing. When scaling down, the pods are removed in the opposite order.
     * The alternative policy is `Parallel` which will create pods in parallel
     * to match the desired scale without waiting, and on scale down will delete
     * all pods at once.
     * +optional
     * </pre>
     *
     * <code>optional string podManagementPolicy = 6;</code>
     */
    com.google.protobuf.ByteString getPodManagementPolicyBytes();

    /**
     *
     *
     * <pre>
     * updateStrategy indicates the StatefulSetUpdateStrategy that will be
     * employed to update Pods in the StatefulSet when a revision is made to
     * Template.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;</code>
     */
    boolean hasUpdateStrategy();
    /**
     *
     *
     * <pre>
     * updateStrategy indicates the StatefulSetUpdateStrategy that will be
     * employed to update Pods in the StatefulSet when a revision is made to
     * Template.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy getUpdateStrategy();
    /**
     *
     *
     * <pre>
     * updateStrategy indicates the StatefulSetUpdateStrategy that will be
     * employed to update Pods in the StatefulSet when a revision is made to
     * Template.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategyOrBuilder
        getUpdateStrategyOrBuilder();

    /**
     *
     *
     * <pre>
     * revisionHistoryLimit is the maximum number of revisions that will
     * be maintained in the StatefulSet's revision history. The revision history
     * consists of all revisions not represented by a currently applied
     * StatefulSetSpec version. The default value is 10.
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 8;</code>
     */
    boolean hasRevisionHistoryLimit();
    /**
     *
     *
     * <pre>
     * revisionHistoryLimit is the maximum number of revisions that will
     * be maintained in the StatefulSet's revision history. The revision history
     * consists of all revisions not represented by a currently applied
     * StatefulSetSpec version. The default value is 10.
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 8;</code>
     */
    int getRevisionHistoryLimit();

    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 9;</code>
     */
    boolean hasMinReadySeconds();
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 9;</code>
     */
    int getMinReadySeconds();
  }
  /**
   *
   *
   * <pre>
   * A StatefulSetSpec is the specification of a StatefulSet.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSetSpec}
   */
  public static final class StatefulSetSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.StatefulSetSpec)
      StatefulSetSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StatefulSetSpec.newBuilder() to construct.
    private StatefulSetSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StatefulSetSpec() {
      replicas_ = 0;
      volumeClaimTemplates_ = java.util.Collections.emptyList();
      serviceName_ = "";
      podManagementPolicy_ = "";
      revisionHistoryLimit_ = 0;
      minReadySeconds_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private StatefulSetSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                replicas_ = input.readInt32();
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.Meta.LabelSelector.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = selector_.toBuilder();
                }
                selector_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.LabelSelector.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(selector_);
                  selector_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1.PodTemplateSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = template_.toBuilder();
                }
                template_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1.PodTemplateSpec.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(template_);
                  template_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 34:
              {
                if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                  volumeClaimTemplates_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1.PersistentVolumeClaim>();
                  mutable_bitField0_ |= 0x00000008;
                }
                volumeClaimTemplates_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1.PersistentVolumeClaim.PARSER,
                        extensionRegistry));
                break;
              }
            case 42:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000008;
                serviceName_ = bs;
                break;
              }
            case 50:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                podManagementPolicy_ = bs;
                break;
              }
            case 58:
              {
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.Builder
                    subBuilder = null;
                if (((bitField0_ & 0x00000020) == 0x00000020)) {
                  subBuilder = updateStrategy_.toBuilder();
                }
                updateStrategy_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(updateStrategy_);
                  updateStrategy_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000020;
                break;
              }
            case 64:
              {
                bitField0_ |= 0x00000040;
                revisionHistoryLimit_ = input.readInt32();
                break;
              }
            case 72:
              {
                bitField0_ |= 0x00000080;
                minReadySeconds_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          volumeClaimTemplates_ = java.util.Collections.unmodifiableList(volumeClaimTemplates_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSetSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSetSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.class,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.Builder.class);
    }

    private int bitField0_;
    public static final int REPLICAS_FIELD_NUMBER = 1;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * replicas is the desired number of replicas of the given Template.
     * These are replicas in the sense that they are instantiations of the
     * same Template, but individual replicas also have a consistent identity.
     * If unspecified, defaults to 1.
     * TODO: Consider a rename of this field.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * replicas is the desired number of replicas of the given Template.
     * These are replicas in the sense that they are instantiations of the
     * same Template, but individual replicas also have a consistent identity.
     * If unspecified, defaults to 1.
     * TODO: Consider a rename of this field.
     * +optional
     * </pre>
     *
     * <code>optional int32 replicas = 1;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int SELECTOR_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.Meta.LabelSelector selector_;
    /**
     *
     *
     * <pre>
     * selector is a label query over pods that should match the replica count.
     * If empty, defaulted to labels on the pod template.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public boolean hasSelector() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * selector is a label query over pods that should match the replica count.
     * If empty, defaulted to labels on the pod template.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }
    /**
     *
     *
     * <pre>
     * selector is a label query over pods that should match the replica count.
     * If empty, defaulted to labels on the pod template.
     * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
      return selector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : selector_;
    }

    public static final int TEMPLATE_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1.PodTemplateSpec template_;
    /**
     *
     *
     * <pre>
     * template is the object that describes the pod that will be created if
     * insufficient replicas are detected. Each pod stamped out by the StatefulSet
     * will fulfill this Template, but have a unique identity from the rest
     * of the StatefulSet.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public boolean hasTemplate() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * template is the object that describes the pod that will be created if
     * insufficient replicas are detected. Each pod stamped out by the StatefulSet
     * will fulfill this Template, but have a unique identity from the rest
     * of the StatefulSet.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }
    /**
     *
     *
     * <pre>
     * template is the object that describes the pod that will be created if
     * insufficient replicas are detected. Each pod stamped out by the StatefulSet
     * will fulfill this Template, but have a unique identity from the rest
     * of the StatefulSet.
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
     */
    public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
      return template_ == null
          ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
          : template_;
    }

    public static final int VOLUMECLAIMTEMPLATES_FIELD_NUMBER = 4;
    private java.util.List<io.kubernetes.client.proto.V1.PersistentVolumeClaim>
        volumeClaimTemplates_;
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1.PersistentVolumeClaim>
        getVolumeClaimTemplatesList() {
      return volumeClaimTemplates_;
    }
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder>
        getVolumeClaimTemplatesOrBuilderList() {
      return volumeClaimTemplates_;
    }
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    public int getVolumeClaimTemplatesCount() {
      return volumeClaimTemplates_.size();
    }
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    public io.kubernetes.client.proto.V1.PersistentVolumeClaim getVolumeClaimTemplates(int index) {
      return volumeClaimTemplates_.get(index);
    }
    /**
     *
     *
     * <pre>
     * volumeClaimTemplates is a list of claims that pods are allowed to reference.
     * The StatefulSet controller is responsible for mapping network identities to
     * claims in a way that maintains the identity of a pod. Every claim in
     * this list must have at least one matching (by name) volumeMount in one
     * container in the template. A claim in this list takes precedence over
     * any volumes in the template, with the same name.
     * TODO: Define the behavior if a claim already exists with the same name.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
     */
    public io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder
        getVolumeClaimTemplatesOrBuilder(int index) {
      return volumeClaimTemplates_.get(index);
    }

    public static final int SERVICENAME_FIELD_NUMBER = 5;
    private volatile java.lang.Object serviceName_;
    /**
     *
     *
     * <pre>
     * serviceName is the name of the service that governs this StatefulSet.
     * This service must exist before the StatefulSet, and is responsible for
     * the network identity of the set. Pods get DNS/hostnames that follow the
     * pattern: pod-specific-string.serviceName.default.svc.cluster.local
     * where "pod-specific-string" is managed by the StatefulSet controller.
     * </pre>
     *
     * <code>optional string serviceName = 5;</code>
     */
    public boolean hasServiceName() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * serviceName is the name of the service that governs this StatefulSet.
     * This service must exist before the StatefulSet, and is responsible for
     * the network identity of the set. Pods get DNS/hostnames that follow the
     * pattern: pod-specific-string.serviceName.default.svc.cluster.local
     * where "pod-specific-string" is managed by the StatefulSet controller.
     * </pre>
     *
     * <code>optional string serviceName = 5;</code>
     */
    public java.lang.String getServiceName() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          serviceName_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * serviceName is the name of the service that governs this StatefulSet.
     * This service must exist before the StatefulSet, and is responsible for
     * the network identity of the set. Pods get DNS/hostnames that follow the
     * pattern: pod-specific-string.serviceName.default.svc.cluster.local
     * where "pod-specific-string" is managed by the StatefulSet controller.
     * </pre>
     *
     * <code>optional string serviceName = 5;</code>
     */
    public com.google.protobuf.ByteString getServiceNameBytes() {
      java.lang.Object ref = serviceName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PODMANAGEMENTPOLICY_FIELD_NUMBER = 6;
    private volatile java.lang.Object podManagementPolicy_;
    /**
     *
     *
     * <pre>
     * podManagementPolicy controls how pods are created during initial scale up,
     * when replacing pods on nodes, or when scaling down. The default policy is
     * `OrderedReady`, where pods are created in increasing order (pod-0, then
     * pod-1, etc) and the controller will wait until each pod is ready before
     * continuing. When scaling down, the pods are removed in the opposite order.
     * The alternative policy is `Parallel` which will create pods in parallel
     * to match the desired scale without waiting, and on scale down will delete
     * all pods at once.
     * +optional
     * </pre>
     *
     * <code>optional string podManagementPolicy = 6;</code>
     */
    public boolean hasPodManagementPolicy() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * podManagementPolicy controls how pods are created during initial scale up,
     * when replacing pods on nodes, or when scaling down. The default policy is
     * `OrderedReady`, where pods are created in increasing order (pod-0, then
     * pod-1, etc) and the controller will wait until each pod is ready before
     * continuing. When scaling down, the pods are removed in the opposite order.
     * The alternative policy is `Parallel` which will create pods in parallel
     * to match the desired scale without waiting, and on scale down will delete
     * all pods at once.
     * +optional
     * </pre>
     *
     * <code>optional string podManagementPolicy = 6;</code>
     */
    public java.lang.String getPodManagementPolicy() {
      java.lang.Object ref = podManagementPolicy_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          podManagementPolicy_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * podManagementPolicy controls how pods are created during initial scale up,
     * when replacing pods on nodes, or when scaling down. The default policy is
     * `OrderedReady`, where pods are created in increasing order (pod-0, then
     * pod-1, etc) and the controller will wait until each pod is ready before
     * continuing. When scaling down, the pods are removed in the opposite order.
     * The alternative policy is `Parallel` which will create pods in parallel
     * to match the desired scale without waiting, and on scale down will delete
     * all pods at once.
     * +optional
     * </pre>
     *
     * <code>optional string podManagementPolicy = 6;</code>
     */
    public com.google.protobuf.ByteString getPodManagementPolicyBytes() {
      java.lang.Object ref = podManagementPolicy_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        podManagementPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int UPDATESTRATEGY_FIELD_NUMBER = 7;
    private io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy updateStrategy_;
    /**
     *
     *
     * <pre>
     * updateStrategy indicates the StatefulSetUpdateStrategy that will be
     * employed to update Pods in the StatefulSet when a revision is made to
     * Template.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;</code>
     */
    public boolean hasUpdateStrategy() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * updateStrategy indicates the StatefulSetUpdateStrategy that will be
     * employed to update Pods in the StatefulSet when a revision is made to
     * Template.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy getUpdateStrategy() {
      return updateStrategy_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.getDefaultInstance()
          : updateStrategy_;
    }
    /**
     *
     *
     * <pre>
     * updateStrategy indicates the StatefulSetUpdateStrategy that will be
     * employed to update Pods in the StatefulSet when a revision is made to
     * Template.
     * </pre>
     *
     * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategyOrBuilder
        getUpdateStrategyOrBuilder() {
      return updateStrategy_ == null
          ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.getDefaultInstance()
          : updateStrategy_;
    }

    public static final int REVISIONHISTORYLIMIT_FIELD_NUMBER = 8;
    private int revisionHistoryLimit_;
    /**
     *
     *
     * <pre>
     * revisionHistoryLimit is the maximum number of revisions that will
     * be maintained in the StatefulSet's revision history. The revision history
     * consists of all revisions not represented by a currently applied
     * StatefulSetSpec version. The default value is 10.
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 8;</code>
     */
    public boolean hasRevisionHistoryLimit() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     *
     *
     * <pre>
     * revisionHistoryLimit is the maximum number of revisions that will
     * be maintained in the StatefulSet's revision history. The revision history
     * consists of all revisions not represented by a currently applied
     * StatefulSetSpec version. The default value is 10.
     * </pre>
     *
     * <code>optional int32 revisionHistoryLimit = 8;</code>
     */
    public int getRevisionHistoryLimit() {
      return revisionHistoryLimit_;
    }

    public static final int MINREADYSECONDS_FIELD_NUMBER = 9;
    private int minReadySeconds_;
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 9;</code>
     */
    public boolean hasMinReadySeconds() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     *
     *
     * <pre>
     * Minimum number of seconds for which a newly created pod should be ready
     * without any of its container crashing for it to be considered available.
     * Defaults to 0 (pod will be considered available as soon as it is ready)
     * This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.
     * +optional
     * </pre>
     *
     * <code>optional int32 minReadySeconds = 9;</code>
     */
    public int getMinReadySeconds() {
      return minReadySeconds_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt32(1, replicas_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSelector());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getTemplate());
      }
      for (int i = 0; i < volumeClaimTemplates_.size(); i++) {
        output.writeMessage(4, volumeClaimTemplates_.get(i));
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, serviceName_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, podManagementPolicy_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeMessage(7, getUpdateStrategy());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeInt32(8, revisionHistoryLimit_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeInt32(9, minReadySeconds_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, replicas_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSelector());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTemplate());
      }
      for (int i = 0; i < volumeClaimTemplates_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4, volumeClaimTemplates_.get(i));
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, serviceName_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, podManagementPolicy_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateStrategy());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, revisionHistoryLimit_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, minReadySeconds_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec other =
          (io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec) obj;

      boolean result = true;
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && (hasSelector() == other.hasSelector());
      if (hasSelector()) {
        result = result && getSelector().equals(other.getSelector());
      }
      result = result && (hasTemplate() == other.hasTemplate());
      if (hasTemplate()) {
        result = result && getTemplate().equals(other.getTemplate());
      }
      result = result && getVolumeClaimTemplatesList().equals(other.getVolumeClaimTemplatesList());
      result = result && (hasServiceName() == other.hasServiceName());
      if (hasServiceName()) {
        result = result && getServiceName().equals(other.getServiceName());
      }
      result = result && (hasPodManagementPolicy() == other.hasPodManagementPolicy());
      if (hasPodManagementPolicy()) {
        result = result && getPodManagementPolicy().equals(other.getPodManagementPolicy());
      }
      result = result && (hasUpdateStrategy() == other.hasUpdateStrategy());
      if (hasUpdateStrategy()) {
        result = result && getUpdateStrategy().equals(other.getUpdateStrategy());
      }
      result = result && (hasRevisionHistoryLimit() == other.hasRevisionHistoryLimit());
      if (hasRevisionHistoryLimit()) {
        result = result && (getRevisionHistoryLimit() == other.getRevisionHistoryLimit());
      }
      result = result && (hasMinReadySeconds() == other.hasMinReadySeconds());
      if (hasMinReadySeconds()) {
        result = result && (getMinReadySeconds() == other.getMinReadySeconds());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (hasSelector()) {
        hash = (37 * hash) + SELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getSelector().hashCode();
      }
      if (hasTemplate()) {
        hash = (37 * hash) + TEMPLATE_FIELD_NUMBER;
        hash = (53 * hash) + getTemplate().hashCode();
      }
      if (getVolumeClaimTemplatesCount() > 0) {
        hash = (37 * hash) + VOLUMECLAIMTEMPLATES_FIELD_NUMBER;
        hash = (53 * hash) + getVolumeClaimTemplatesList().hashCode();
      }
      if (hasServiceName()) {
        hash = (37 * hash) + SERVICENAME_FIELD_NUMBER;
        hash = (53 * hash) + getServiceName().hashCode();
      }
      if (hasPodManagementPolicy()) {
        hash = (37 * hash) + PODMANAGEMENTPOLICY_FIELD_NUMBER;
        hash = (53 * hash) + getPodManagementPolicy().hashCode();
      }
      if (hasUpdateStrategy()) {
        hash = (37 * hash) + UPDATESTRATEGY_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateStrategy().hashCode();
      }
      if (hasRevisionHistoryLimit()) {
        hash = (37 * hash) + REVISIONHISTORYLIMIT_FIELD_NUMBER;
        hash = (53 * hash) + getRevisionHistoryLimit();
      }
      if (hasMinReadySeconds()) {
        hash = (37 * hash) + MINREADYSECONDS_FIELD_NUMBER;
        hash = (53 * hash) + getMinReadySeconds();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * A StatefulSetSpec is the specification of a StatefulSet.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSetSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.apps.v1beta1.StatefulSetSpec)
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.class,
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSelectorFieldBuilder();
          getTemplateFieldBuilder();
          getVolumeClaimTemplatesFieldBuilder();
          getUpdateStrategyFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        replicas_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        if (selectorBuilder_ == null) {
          selector_ = null;
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (templateBuilder_ == null) {
          template_ = null;
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        if (volumeClaimTemplatesBuilder_ == null) {
          volumeClaimTemplates_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          volumeClaimTemplatesBuilder_.clear();
        }
        serviceName_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        podManagementPolicy_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        if (updateStrategyBuilder_ == null) {
          updateStrategy_ = null;
        } else {
          updateStrategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        revisionHistoryLimit_ = 0;
        bitField0_ = (bitField0_ & ~0x00000080);
        minReadySeconds_ = 0;
        bitField0_ = (bitField0_ & ~0x00000100);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1beta1Apps
            .internal_static_k8s_io_api_apps_v1beta1_StatefulSetSpec_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec build() {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec buildPartial() {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec result =
            new io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.replicas_ = replicas_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (selectorBuilder_ == null) {
          result.selector_ = selector_;
        } else {
          result.selector_ = selectorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (templateBuilder_ == null) {
          result.template_ = template_;
        } else {
          result.template_ = templateBuilder_.build();
        }
        if (volumeClaimTemplatesBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            volumeClaimTemplates_ = java.util.Collections.unmodifiableList(volumeClaimTemplates_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.volumeClaimTemplates_ = volumeClaimTemplates_;
        } else {
          result.volumeClaimTemplates_ = volumeClaimTemplatesBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000008;
        }
        result.serviceName_ = serviceName_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000010;
        }
        result.podManagementPolicy_ = podManagementPolicy_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000020;
        }
        if (updateStrategyBuilder_ == null) {
          result.updateStrategy_ = updateStrategy_;
        } else {
          result.updateStrategy_ = updateStrategyBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000040;
        }
        result.revisionHistoryLimit_ = revisionHistoryLimit_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000080;
        }
        result.minReadySeconds_ = minReadySeconds_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec) {
          return mergeFrom((io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec other) {
        if (other == io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec.getDefaultInstance())
          return this;
        if (other.hasReplicas()) {
          setReplicas(other.getReplicas());
        }
        if (other.hasSelector()) {
          mergeSelector(other.getSelector());
        }
        if (other.hasTemplate()) {
          mergeTemplate(other.getTemplate());
        }
        if (volumeClaimTemplatesBuilder_ == null) {
          if (!other.volumeClaimTemplates_.isEmpty()) {
            if (volumeClaimTemplates_.isEmpty()) {
              volumeClaimTemplates_ = other.volumeClaimTemplates_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureVolumeClaimTemplatesIsMutable();
              volumeClaimTemplates_.addAll(other.volumeClaimTemplates_);
            }
            onChanged();
          }
        } else {
          if (!other.volumeClaimTemplates_.isEmpty()) {
            if (volumeClaimTemplatesBuilder_.isEmpty()) {
              volumeClaimTemplatesBuilder_.dispose();
              volumeClaimTemplatesBuilder_ = null;
              volumeClaimTemplates_ = other.volumeClaimTemplates_;
              bitField0_ = (bitField0_ & ~0x00000008);
              volumeClaimTemplatesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getVolumeClaimTemplatesFieldBuilder()
                      : null;
            } else {
              volumeClaimTemplatesBuilder_.addAllMessages(other.volumeClaimTemplates_);
            }
          }
        }
        if (other.hasServiceName()) {
          bitField0_ |= 0x00000010;
          serviceName_ = other.serviceName_;
          onChanged();
        }
        if (other.hasPodManagementPolicy()) {
          bitField0_ |= 0x00000020;
          podManagementPolicy_ = other.podManagementPolicy_;
          onChanged();
        }
        if (other.hasUpdateStrategy()) {
          mergeUpdateStrategy(other.getUpdateStrategy());
        }
        if (other.hasRevisionHistoryLimit()) {
          setRevisionHistoryLimit(other.getRevisionHistoryLimit());
        }
        if (other.hasMinReadySeconds()) {
          setMinReadySeconds(other.getMinReadySeconds());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private int replicas_;
      /**
       *
       *
       * <pre>
       * replicas is the desired number of replicas of the given Template.
       * These are replicas in the sense that they are instantiations of the
       * same Template, but individual replicas also have a consistent identity.
       * If unspecified, defaults to 1.
       * TODO: Consider a rename of this field.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public boolean hasReplicas() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * replicas is the desired number of replicas of the given Template.
       * These are replicas in the sense that they are instantiations of the
       * same Template, but individual replicas also have a consistent identity.
       * If unspecified, defaults to 1.
       * TODO: Consider a rename of this field.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public int getReplicas() {
        return replicas_;
      }
      /**
       *
       *
       * <pre>
       * replicas is the desired number of replicas of the given Template.
       * These are replicas in the sense that they are instantiations of the
       * same Template, but individual replicas also have a consistent identity.
       * If unspecified, defaults to 1.
       * TODO: Consider a rename of this field.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder setReplicas(int value) {
        bitField0_ |= 0x00000001;
        replicas_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * replicas is the desired number of replicas of the given Template.
       * These are replicas in the sense that they are instantiations of the
       * same Template, but individual replicas also have a consistent identity.
       * If unspecified, defaults to 1.
       * TODO: Consider a rename of this field.
       * +optional
       * </pre>
       *
       * <code>optional int32 replicas = 1;</code>
       */
      public Builder clearReplicas() {
        bitField0_ = (bitField0_ & ~0x00000001);
        replicas_ = 0;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.Meta.LabelSelector selector_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          selectorBuilder_;
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public boolean hasSelector() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector getSelector() {
        if (selectorBuilder_ == null) {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        } else {
          return selectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder setSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          selector_ = value;
          onChanged();
        } else {
          selectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder setSelector(
          io.kubernetes.client.proto.Meta.LabelSelector.Builder builderForValue) {
        if (selectorBuilder_ == null) {
          selector_ = builderForValue.build();
          onChanged();
        } else {
          selectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder mergeSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (selectorBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && selector_ != null
              && selector_ != io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()) {
            selector_ =
                io.kubernetes.client.proto.Meta.LabelSelector.newBuilder(selector_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            selector_ = value;
          }
          onChanged();
        } else {
          selectorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public Builder clearSelector() {
        if (selectorBuilder_ == null) {
          selector_ = null;
          onChanged();
        } else {
          selectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector.Builder getSelectorBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getSelectorOrBuilder() {
        if (selectorBuilder_ != null) {
          return selectorBuilder_.getMessageOrBuilder();
        } else {
          return selector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : selector_;
        }
      }
      /**
       *
       *
       * <pre>
       * selector is a label query over pods that should match the replica count.
       * If empty, defaulted to labels on the pod template.
       * More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/#label-selectors
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector selector = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          getSelectorFieldBuilder() {
        if (selectorBuilder_ == null) {
          selectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.LabelSelector,
                  io.kubernetes.client.proto.Meta.LabelSelector.Builder,
                  io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>(
                  getSelector(), getParentForChildren(), isClean());
          selector_ = null;
        }
        return selectorBuilder_;
      }

      private io.kubernetes.client.proto.V1.PodTemplateSpec template_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          templateBuilder_;
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public boolean hasTemplate() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec getTemplate() {
        if (templateBuilder_ == null) {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        } else {
          return templateBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder setTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          template_ = value;
          onChanged();
        } else {
          templateBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder setTemplate(
          io.kubernetes.client.proto.V1.PodTemplateSpec.Builder builderForValue) {
        if (templateBuilder_ == null) {
          template_ = builderForValue.build();
          onChanged();
        } else {
          templateBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder mergeTemplate(io.kubernetes.client.proto.V1.PodTemplateSpec value) {
        if (templateBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && template_ != null
              && template_ != io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()) {
            template_ =
                io.kubernetes.client.proto.V1.PodTemplateSpec.newBuilder(template_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            template_ = value;
          }
          onChanged();
        } else {
          templateBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public Builder clearTemplate() {
        if (templateBuilder_ == null) {
          template_ = null;
          onChanged();
        } else {
          templateBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpec.Builder getTemplateBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getTemplateFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      public io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder getTemplateOrBuilder() {
        if (templateBuilder_ != null) {
          return templateBuilder_.getMessageOrBuilder();
        } else {
          return template_ == null
              ? io.kubernetes.client.proto.V1.PodTemplateSpec.getDefaultInstance()
              : template_;
        }
      }
      /**
       *
       *
       * <pre>
       * template is the object that describes the pod that will be created if
       * insufficient replicas are detected. Each pod stamped out by the StatefulSet
       * will fulfill this Template, but have a unique identity from the rest
       * of the StatefulSet.
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.PodTemplateSpec template = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.PodTemplateSpec,
              io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
              io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>
          getTemplateFieldBuilder() {
        if (templateBuilder_ == null) {
          templateBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1.PodTemplateSpec,
                  io.kubernetes.client.proto.V1.PodTemplateSpec.Builder,
                  io.kubernetes.client.proto.V1.PodTemplateSpecOrBuilder>(
                  getTemplate(), getParentForChildren(), isClean());
          template_ = null;
        }
        return templateBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1.PersistentVolumeClaim>
          volumeClaimTemplates_ = java.util.Collections.emptyList();

      private void ensureVolumeClaimTemplatesIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          volumeClaimTemplates_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1.PersistentVolumeClaim>(
                  volumeClaimTemplates_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1.PersistentVolumeClaim,
              io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder,
              io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder>
          volumeClaimTemplatesBuilder_;

      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1.PersistentVolumeClaim>
          getVolumeClaimTemplatesList() {
        if (volumeClaimTemplatesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(volumeClaimTemplates_);
        } else {
          return volumeClaimTemplatesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public int getVolumeClaimTemplatesCount() {
        if (volumeClaimTemplatesBuilder_ == null) {
          return volumeClaimTemplates_.size();
        } else {
          return volumeClaimTemplatesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public io.kubernetes.client.proto.V1.PersistentVolumeClaim getVolumeClaimTemplates(
          int index) {
        if (volumeClaimTemplatesBuilder_ == null) {
          return volumeClaimTemplates_.get(index);
        } else {
          return volumeClaimTemplatesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder setVolumeClaimTemplates(
          int index, io.kubernetes.client.proto.V1.PersistentVolumeClaim value) {
        if (volumeClaimTemplatesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVolumeClaimTemplatesIsMutable();
          volumeClaimTemplates_.set(index, value);
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder setVolumeClaimTemplates(
          int index, io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder builderForValue) {
        if (volumeClaimTemplatesBuilder_ == null) {
          ensureVolumeClaimTemplatesIsMutable();
          volumeClaimTemplates_.set(index, builderForValue.build());
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder addVolumeClaimTemplates(
          io.kubernetes.client.proto.V1.PersistentVolumeClaim value) {
        if (volumeClaimTemplatesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVolumeClaimTemplatesIsMutable();
          volumeClaimTemplates_.add(value);
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder addVolumeClaimTemplates(
          int index, io.kubernetes.client.proto.V1.PersistentVolumeClaim value) {
        if (volumeClaimTemplatesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureVolumeClaimTemplatesIsMutable();
          volumeClaimTemplates_.add(index, value);
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder addVolumeClaimTemplates(
          io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder builderForValue) {
        if (volumeClaimTemplatesBuilder_ == null) {
          ensureVolumeClaimTemplatesIsMutable();
          volumeClaimTemplates_.add(builderForValue.build());
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder addVolumeClaimTemplates(
          int index, io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder builderForValue) {
        if (volumeClaimTemplatesBuilder_ == null) {
          ensureVolumeClaimTemplatesIsMutable();
          volumeClaimTemplates_.add(index, builderForValue.build());
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder addAllVolumeClaimTemplates(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1.PersistentVolumeClaim>
              values) {
        if (volumeClaimTemplatesBuilder_ == null) {
          ensureVolumeClaimTemplatesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, volumeClaimTemplates_);
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder clearVolumeClaimTemplates() {
        if (volumeClaimTemplatesBuilder_ == null) {
          volumeClaimTemplates_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public Builder removeVolumeClaimTemplates(int index) {
        if (volumeClaimTemplatesBuilder_ == null) {
          ensureVolumeClaimTemplatesIsMutable();
          volumeClaimTemplates_.remove(index);
          onChanged();
        } else {
          volumeClaimTemplatesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder
          getVolumeClaimTemplatesBuilder(int index) {
        return getVolumeClaimTemplatesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder
          getVolumeClaimTemplatesOrBuilder(int index) {
        if (volumeClaimTemplatesBuilder_ == null) {
          return volumeClaimTemplates_.get(index);
        } else {
          return volumeClaimTemplatesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder>
          getVolumeClaimTemplatesOrBuilderList() {
        if (volumeClaimTemplatesBuilder_ != null) {
          return volumeClaimTemplatesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(volumeClaimTemplates_);
        }
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder
          addVolumeClaimTemplatesBuilder() {
        return getVolumeClaimTemplatesFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1.PersistentVolumeClaim.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder
          addVolumeClaimTemplatesBuilder(int index) {
        return getVolumeClaimTemplatesFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1.PersistentVolumeClaim.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * volumeClaimTemplates is a list of claims that pods are allowed to reference.
       * The StatefulSet controller is responsible for mapping network identities to
       * claims in a way that maintains the identity of a pod. Every claim in
       * this list must have at least one matching (by name) volumeMount in one
       * container in the template. A claim in this list takes precedence over
       * any volumes in the template, with the same name.
       * TODO: Define the behavior if a claim already exists with the same name.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.core.v1.PersistentVolumeClaim volumeClaimTemplates = 4;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder>
          getVolumeClaimTemplatesBuilderList() {
        return getVolumeClaimTemplatesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1.PersistentVolumeClaim,
              io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder,
              io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder>
          getVolumeClaimTemplatesFieldBuilder() {
        if (volumeClaimTemplatesBuilder_ == null) {
          volumeClaimTemplatesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1.PersistentVolumeClaim,
                  io.kubernetes.client.proto.V1.PersistentVolumeClaim.Builder,
                  io.kubernetes.client.proto.V1.PersistentVolumeClaimOrBuilder>(
                  volumeClaimTemplates_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          volumeClaimTemplates_ = null;
        }
        return volumeClaimTemplatesBuilder_;
      }

      private java.lang.Object serviceName_ = "";
      /**
       *
       *
       * <pre>
       * serviceName is the name of the service that governs this StatefulSet.
       * This service must exist before the StatefulSet, and is responsible for
       * the network identity of the set. Pods get DNS/hostnames that follow the
       * pattern: pod-specific-string.serviceName.default.svc.cluster.local
       * where "pod-specific-string" is managed by the StatefulSet controller.
       * </pre>
       *
       * <code>optional string serviceName = 5;</code>
       */
      public boolean hasServiceName() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * serviceName is the name of the service that governs this StatefulSet.
       * This service must exist before the StatefulSet, and is responsible for
       * the network identity of the set. Pods get DNS/hostnames that follow the
       * pattern: pod-specific-string.serviceName.default.svc.cluster.local
       * where "pod-specific-string" is managed by the StatefulSet controller.
       * </pre>
       *
       * <code>optional string serviceName = 5;</code>
       */
      public java.lang.String getServiceName() {
        java.lang.Object ref = serviceName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            serviceName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * serviceName is the name of the service that governs this StatefulSet.
       * This service must exist before the StatefulSet, and is responsible for
       * the network identity of the set. Pods get DNS/hostnames that follow the
       * pattern: pod-specific-string.serviceName.default.svc.cluster.local
       * where "pod-specific-string" is managed by the StatefulSet controller.
       * </pre>
       *
       * <code>optional string serviceName = 5;</code>
       */
      public com.google.protobuf.ByteString getServiceNameBytes() {
        java.lang.Object ref = serviceName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serviceName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * serviceName is the name of the service that governs this StatefulSet.
       * This service must exist before the StatefulSet, and is responsible for
       * the network identity of the set. Pods get DNS/hostnames that follow the
       * pattern: pod-specific-string.serviceName.default.svc.cluster.local
       * where "pod-specific-string" is managed by the StatefulSet controller.
       * </pre>
       *
       * <code>optional string serviceName = 5;</code>
       */
      public Builder setServiceName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        serviceName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * serviceName is the name of the service that governs this StatefulSet.
       * This service must exist before the StatefulSet, and is responsible for
       * the network identity of the set. Pods get DNS/hostnames that follow the
       * pattern: pod-specific-string.serviceName.default.svc.cluster.local
       * where "pod-specific-string" is managed by the StatefulSet controller.
       * </pre>
       *
       * <code>optional string serviceName = 5;</code>
       */
      public Builder clearServiceName() {
        bitField0_ = (bitField0_ & ~0x00000010);
        serviceName_ = getDefaultInstance().getServiceName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * serviceName is the name of the service that governs this StatefulSet.
       * This service must exist before the StatefulSet, and is responsible for
       * the network identity of the set. Pods get DNS/hostnames that follow the
       * pattern: pod-specific-string.serviceName.default.svc.cluster.local
       * where "pod-specific-string" is managed by the StatefulSet controller.
       * </pre>
       *
       * <code>optional string serviceName = 5;</code>
       */
      public Builder setServiceNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        serviceName_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object podManagementPolicy_ = "";
      /**
       *
       *
       * <pre>
       * podManagementPolicy controls how pods are created during initial scale up,
       * when replacing pods on nodes, or when scaling down. The default policy is
       * `OrderedReady`, where pods are created in increasing order (pod-0, then
       * pod-1, etc) and the controller will wait until each pod is ready before
       * continuing. When scaling down, the pods are removed in the opposite order.
       * The alternative policy is `Parallel` which will create pods in parallel
       * to match the desired scale without waiting, and on scale down will delete
       * all pods at once.
       * +optional
       * </pre>
       *
       * <code>optional string podManagementPolicy = 6;</code>
       */
      public boolean hasPodManagementPolicy() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       *
       *
       * <pre>
       * podManagementPolicy controls how pods are created during initial scale up,
       * when replacing pods on nodes, or when scaling down. The default policy is
       * `OrderedReady`, where pods are created in increasing order (pod-0, then
       * pod-1, etc) and the controller will wait until each pod is ready before
       * continuing. When scaling down, the pods are removed in the opposite order.
       * The alternative policy is `Parallel` which will create pods in parallel
       * to match the desired scale without waiting, and on scale down will delete
       * all pods at once.
       * +optional
       * </pre>
       *
       * <code>optional string podManagementPolicy = 6;</code>
       */
      public java.lang.String getPodManagementPolicy() {
        java.lang.Object ref = podManagementPolicy_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            podManagementPolicy_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * podManagementPolicy controls how pods are created during initial scale up,
       * when replacing pods on nodes, or when scaling down. The default policy is
       * `OrderedReady`, where pods are created in increasing order (pod-0, then
       * pod-1, etc) and the controller will wait until each pod is ready before
       * continuing. When scaling down, the pods are removed in the opposite order.
       * The alternative policy is `Parallel` which will create pods in parallel
       * to match the desired scale without waiting, and on scale down will delete
       * all pods at once.
       * +optional
       * </pre>
       *
       * <code>optional string podManagementPolicy = 6;</code>
       */
      public com.google.protobuf.ByteString getPodManagementPolicyBytes() {
        java.lang.Object ref = podManagementPolicy_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          podManagementPolicy_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * podManagementPolicy controls how pods are created during initial scale up,
       * when replacing pods on nodes, or when scaling down. The default policy is
       * `OrderedReady`, where pods are created in increasing order (pod-0, then
       * pod-1, etc) and the controller will wait until each pod is ready before
       * continuing. When scaling down, the pods are removed in the opposite order.
       * The alternative policy is `Parallel` which will create pods in parallel
       * to match the desired scale without waiting, and on scale down will delete
       * all pods at once.
       * +optional
       * </pre>
       *
       * <code>optional string podManagementPolicy = 6;</code>
       */
      public Builder setPodManagementPolicy(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        podManagementPolicy_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * podManagementPolicy controls how pods are created during initial scale up,
       * when replacing pods on nodes, or when scaling down. The default policy is
       * `OrderedReady`, where pods are created in increasing order (pod-0, then
       * pod-1, etc) and the controller will wait until each pod is ready before
       * continuing. When scaling down, the pods are removed in the opposite order.
       * The alternative policy is `Parallel` which will create pods in parallel
       * to match the desired scale without waiting, and on scale down will delete
       * all pods at once.
       * +optional
       * </pre>
       *
       * <code>optional string podManagementPolicy = 6;</code>
       */
      public Builder clearPodManagementPolicy() {
        bitField0_ = (bitField0_ & ~0x00000020);
        podManagementPolicy_ = getDefaultInstance().getPodManagementPolicy();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * podManagementPolicy controls how pods are created during initial scale up,
       * when replacing pods on nodes, or when scaling down. The default policy is
       * `OrderedReady`, where pods are created in increasing order (pod-0, then
       * pod-1, etc) and the controller will wait until each pod is ready before
       * continuing. When scaling down, the pods are removed in the opposite order.
       * The alternative policy is `Parallel` which will create pods in parallel
       * to match the desired scale without waiting, and on scale down will delete
       * all pods at once.
       * +optional
       * </pre>
       *
       * <code>optional string podManagementPolicy = 6;</code>
       */
      public Builder setPodManagementPolicyBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        podManagementPolicy_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy updateStrategy_ =
          null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.Builder,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategyOrBuilder>
          updateStrategyBuilder_;
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      public boolean hasUpdateStrategy() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy getUpdateStrategy() {
        if (updateStrategyBuilder_ == null) {
          return updateStrategy_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy
                  .getDefaultInstance()
              : updateStrategy_;
        } else {
          return updateStrategyBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      public Builder setUpdateStrategy(
          io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy value) {
        if (updateStrategyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          updateStrategy_ = value;
          onChanged();
        } else {
          updateStrategyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      public Builder setUpdateStrategy(
          io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.Builder
              builderForValue) {
        if (updateStrategyBuilder_ == null) {
          updateStrategy_ = builderForValue.build();
          onChanged();
        } else {
          updateStrategyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      public Builder mergeUpdateStrategy(
          io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy value) {
        if (updateStrategyBuilder_ == null) {
          if (((bitField0_ & 0x00000040) == 0x00000040)
              && updateStrategy_ != null
              && updateStrategy_
                  != io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy
                      .getDefaultInstance()) {
            updateStrategy_ =
                io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.newBuilder(
                        updateStrategy_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            updateStrategy_ = value;
          }
          onChanged();
        } else {
          updateStrategyBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        return this;
      }
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      public Builder clearUpdateStrategy() {
        if (updateStrategyBuilder_ == null) {
          updateStrategy_ = null;
          onChanged();
        } else {
          updateStrategyBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.Builder
          getUpdateStrategyBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getUpdateStrategyFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      public io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategyOrBuilder
          getUpdateStrategyOrBuilder() {
        if (updateStrategyBuilder_ != null) {
          return updateStrategyBuilder_.getMessageOrBuilder();
        } else {
          return updateStrategy_ == null
              ? io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy
                  .getDefaultInstance()
              : updateStrategy_;
        }
      }
      /**
       *
       *
       * <pre>
       * updateStrategy indicates the StatefulSetUpdateStrategy that will be
       * employed to update Pods in the StatefulSet when a revision is made to
       * Template.
       * </pre>
       *
       * <code>optional .k8s.io.api.apps.v1beta1.StatefulSetUpdateStrategy updateStrategy = 7;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.Builder,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategyOrBuilder>
          getUpdateStrategyFieldBuilder() {
        if (updateStrategyBuilder_ == null) {
          updateStrategyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy,
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategy.Builder,
                  io.kubernetes.client.proto.V1beta1Apps.StatefulSetUpdateStrategyOrBuilder>(
                  getUpdateStrategy(), getParentForChildren(), isClean());
          updateStrategy_ = null;
        }
        return updateStrategyBuilder_;
      }

      private int revisionHistoryLimit_;
      /**
       *
       *
       * <pre>
       * revisionHistoryLimit is the maximum number of revisions that will
       * be maintained in the StatefulSet's revision history. The revision history
       * consists of all revisions not represented by a currently applied
       * StatefulSetSpec version. The default value is 10.
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 8;</code>
       */
      public boolean hasRevisionHistoryLimit() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       *
       *
       * <pre>
       * revisionHistoryLimit is the maximum number of revisions that will
       * be maintained in the StatefulSet's revision history. The revision history
       * consists of all revisions not represented by a currently applied
       * StatefulSetSpec version. The default value is 10.
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 8;</code>
       */
      public int getRevisionHistoryLimit() {
        return revisionHistoryLimit_;
      }
      /**
       *
       *
       * <pre>
       * revisionHistoryLimit is the maximum number of revisions that will
       * be maintained in the StatefulSet's revision history. The revision history
       * consists of all revisions not represented by a currently applied
       * StatefulSetSpec version. The default value is 10.
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 8;</code>
       */
      public Builder setRevisionHistoryLimit(int value) {
        bitField0_ |= 0x00000080;
        revisionHistoryLimit_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * revisionHistoryLimit is the maximum number of revisions that will
       * be maintained in the StatefulSet's revision history. The revision history
       * consists of all revisions not represented by a currently applied
       * StatefulSetSpec version. The default value is 10.
       * </pre>
       *
       * <code>optional int32 revisionHistoryLimit = 8;</code>
       */
      public Builder clearRevisionHistoryLimit() {
        bitField0_ = (bitField0_ & ~0x00000080);
        revisionHistoryLimit_ = 0;
        onChanged();
        return this;
      }

      private int minReadySeconds_;
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 9;</code>
       */
      public boolean hasMinReadySeconds() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 9;</code>
       */
      public int getMinReadySeconds() {
        return minReadySeconds_;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 9;</code>
       */
      public Builder setMinReadySeconds(int value) {
        bitField0_ |= 0x00000100;
        minReadySeconds_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of seconds for which a newly created pod should be ready
       * without any of its container crashing for it to be considered available.
       * Defaults to 0 (pod will be considered available as soon as it is ready)
       * This is an alpha field and requires enabling StatefulSetMinReadySeconds feature gate.
       * +optional
       * </pre>
       *
       * <code>optional int32 minReadySeconds = 9;</code>
       */
      public Builder clearMinReadySeconds() {
        bitField0_ = (bitField0_ & ~0x00000100);
        minReadySeconds_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.apps.v1beta1.StatefulSetSpec)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.apps.v1beta1.StatefulSetSpec)
    private static final io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec();
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<StatefulSetSpec> PARSER =
        new com.google.protobuf.AbstractParser<StatefulSetSpec>() {
          @java.lang.Override
          public StatefulSetSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new StatefulSetSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<StatefulSetSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StatefulSetSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StatefulSetStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.apps.v1beta1.StatefulSetStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the
     * StatefulSet's generation, which is updated on mutation by the API Server.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    boolean hasObservedGeneration();
    /**
     *
     *
     * <pre>
     * observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the
     * StatefulSet's generation, which is updated on mutation by the API Server.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    long getObservedGeneration();

    /**
     *
     *
     * <pre>
     * replicas is the number of Pods created by the StatefulSet controller.
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    boolean hasReplicas();
    /**
     *
     *
     * <pre>
     * replicas is the number of Pods created by the StatefulSet controller.
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    int getReplicas();

    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods created by this StatefulSet controller with a Ready Condition.
     * </pre>
     *
     * <code>optional int32 readyReplicas = 3;</code>
     */
    boolean hasReadyReplicas();
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods created by this StatefulSet controller with a Ready Condition.
     * </pre>
     *
     * <code>optional int32 readyReplicas = 3;</code>
     */
    int getReadyReplicas();

    /**
     *
     *
     * <pre>
     * currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version
     * indicated by currentRevision.
     * </pre>
     *
     * <code>optional int32 currentReplicas = 4;</code>
     */
    boolean hasCurrentReplicas();
    /**
     *
     *
     * <pre>
     * currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version
     * indicated by currentRevision.
     * </pre>
     *
     * <code>optional int32 currentReplicas = 4;</code>
     */
    int getCurrentReplicas();

    /**
     *
     *
     * <pre>
     * updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version
     * indicated by updateRevision.
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 5;</code>
     */
    boolean hasUpdatedReplicas();
    /**
     *
     *
     * <pre>
     * updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version
     * indicated by updateRevision.
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 5;</code>
     */
    int getUpdatedReplicas();

    /**
     *
     *
     * <pre>
     * currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the
     * sequence [0,currentReplicas).
     * </pre>
     *
     * <code>optional string currentRevision = 6;</code>
     */
    boolean hasCurrentRevision();
    /**
     *
     *
     * <pre>
     * currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the
     * sequence [0,currentReplicas).
     * </pre>
     *
     * <code>optional string currentRevision = 6;</code>
     */
    java.lang.String getCurrentRevision();
    /**
     *
     *
     * <pre>
     * currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the
     * sequence [0,currentReplicas).
     * </pre>
     *
     * <code>optional string currentRevision = 6;</code>
     */
    com.google.protobuf.ByteString getCurrentRevisionBytes();

    /**
     *
     *
     * <pre>
     * updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence
     * [replicas-updatedReplicas,replicas)
     * </pre>
     *
     * <code>optional string updateRevision = 7;</code>
     */
    boolean hasUpdateRevision();
    /**
     *
     *
     * <pre>
     * updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence
     * [replicas-updatedReplicas,replicas)
     * </pre>
     *
     * <code>optional string updateRevision = 7;</code>
     */
    java.lang.String getUpdateRevision();
    /**
     *
     *
     * <pre>
     * updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence
     * [replicas-updatedReplicas,replicas)
     * </pre>
     *
     * <code>optional string updateRevision = 7;</code>
     */
    com.google.protobuf.ByteString getUpdateRevisionBytes();

    /**
     *
     *
     * <pre>
     * collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller
     * uses this field as a collision avoidance mechanism when it needs to create the name for the
     * newest ControllerRevision.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 9;</code>
     */
    boolean hasCollisionCount();
    /**
     *
     *
     * <pre>
     * collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller
     * uses this field as a collision avoidance mechanism when it needs to create the name for the
     * newest ControllerRevision.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 9;</code>
     */
    int getCollisionCount();

    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition> getConditionsList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition getConditions(int index);
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    int getConditionsCount();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1beta1Apps.StatefulSetConditionOrBuilder>
        getConditionsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    io.kubernetes.client.proto.V1beta1Apps.StatefulSetConditionOrBuilder getConditionsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this StatefulSet.
     * This is a beta field and enabled/disabled by StatefulSetMinReadySeconds feature gate.
     * </pre>
     *
     * <code>optional int32 availableReplicas = 11;</code>
     */
    boolean hasAvailableReplicas();
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this StatefulSet.
     * This is a beta field and enabled/disabled by StatefulSetMinReadySeconds feature gate.
     * </pre>
     *
     * <code>optional int32 availableReplicas = 11;</code>
     */
    int getAvailableReplicas();
  }
  /**
   *
   *
   * <pre>
   * StatefulSetStatus represents the current state of a StatefulSet.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.apps.v1beta1.StatefulSetStatus}
   */
  public static final class StatefulSetStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.apps.v1beta1.StatefulSetStatus)
      StatefulSetStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StatefulSetStatus.newBuilder() to construct.
    private StatefulSetStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StatefulSetStatus() {
      observedGeneration_ = 0L;
      replicas_ = 0;
      readyReplicas_ = 0;
      currentReplicas_ = 0;
      updatedReplicas_ = 0;
      currentRevision_ = "";
      updateRevision_ = "";
      collisionCount_ = 0;
      conditions_ = java.util.Collections.emptyList();
      availableReplicas_ = 0;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private StatefulSetStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                bitField0_ |= 0x00000001;
                observedGeneration_ = input.readInt64();
                break;
              }
            case 16:
              {
                bitField0_ |= 0x00000002;
                replicas_ = input.readInt32();
                break;
              }
            case 24:
              {
                bitField0_ |= 0x00000004;
                readyReplicas_ = input.readInt32();
                break;
              }
            case 32:
              {
                bitField0_ |= 0x00000008;
                currentReplicas_ = input.readInt32();
                break;
              }
            case 40:
              {
                bitField0_ |= 0x00000010;
                updatedReplicas_ = input.readInt32();
                break;
              }
            case 50:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000020;
                currentRevision_ = bs;
                break;
              }
            case 58:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000040;
                updateRevision_ = bs;
                break;
              }
            case 72:
              {
                bitField0_ |= 0x00000080;
                collisionCount_ = input.readInt32();
                break;
              }
            case 82:
              {
                if (!((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
                  conditions_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition>();
                  mutable_bitField0_ |= 0x00000100;
                }
                conditions_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition.PARSER,
                        extensionRegistry));
                break;
              }
            case 88:
              {
                bitField0_ |= 0x00000100;
                availableReplicas_ = input.readInt32();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000100) == 0x00000100)) {
          conditions_ = java.util.Collections.unmodifiableList(conditions_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSetStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1beta1Apps
          .internal_static_k8s_io_api_apps_v1beta1_StatefulSetStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.class,
              io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus.Builder.class);
    }

    private int bitField0_;
    public static final int OBSERVEDGENERATION_FIELD_NUMBER = 1;
    private long observedGeneration_;
    /**
     *
     *
     * <pre>
     * observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the
     * StatefulSet's generation, which is updated on mutation by the API Server.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    public boolean hasObservedGeneration() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the
     * StatefulSet's generation, which is updated on mutation by the API Server.
     * +optional
     * </pre>
     *
     * <code>optional int64 observedGeneration = 1;</code>
     */
    public long getObservedGeneration() {
      return observedGeneration_;
    }

    public static final int REPLICAS_FIELD_NUMBER = 2;
    private int replicas_;
    /**
     *
     *
     * <pre>
     * replicas is the number of Pods created by the StatefulSet controller.
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    public boolean hasReplicas() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * replicas is the number of Pods created by the StatefulSet controller.
     * </pre>
     *
     * <code>optional int32 replicas = 2;</code>
     */
    public int getReplicas() {
      return replicas_;
    }

    public static final int READYREPLICAS_FIELD_NUMBER = 3;
    private int readyReplicas_;
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods created by this StatefulSet controller with a Ready Condition.
     * </pre>
     *
     * <code>optional int32 readyReplicas = 3;</code>
     */
    public boolean hasReadyReplicas() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * readyReplicas is the number of pods created by this StatefulSet controller with a Ready Condition.
     * </pre>
     *
     * <code>optional int32 readyReplicas = 3;</code>
     */
    public int getReadyReplicas() {
      return readyReplicas_;
    }

    public static final int CURRENTREPLICAS_FIELD_NUMBER = 4;
    private int currentReplicas_;
    /**
     *
     *
     * <pre>
     * currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version
     * indicated by currentRevision.
     * </pre>
     *
     * <code>optional int32 currentReplicas = 4;</code>
     */
    public boolean hasCurrentReplicas() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version
     * indicated by currentRevision.
     * </pre>
     *
     * <code>optional int32 currentReplicas = 4;</code>
     */
    public int getCurrentReplicas() {
      return currentReplicas_;
    }

    public static final int UPDATEDREPLICAS_FIELD_NUMBER = 5;
    private int updatedReplicas_;
    /**
     *
     *
     * <pre>
     * updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version
     * indicated by updateRevision.
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 5;</code>
     */
    public boolean hasUpdatedReplicas() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version
     * indicated by updateRevision.
     * </pre>
     *
     * <code>optional int32 updatedReplicas = 5;</code>
     */
    public int getUpdatedReplicas() {
      return updatedReplicas_;
    }

    public static final int CURRENTREVISION_FIELD_NUMBER = 6;
    private volatile java.lang.Object currentRevision_;
    /**
     *
     *
     * <pre>
     * currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the
     * sequence [0,currentReplicas).
     * </pre>
     *
     * <code>optional string currentRevision = 6;</code>
     */
    public boolean hasCurrentRevision() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     *
     *
     * <pre>
     * currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the
     * sequence [0,currentReplicas).
     * </pre>
     *
     * <code>optional string currentRevision = 6;</code>
     */
    public java.lang.String getCurrentRevision() {
      java.lang.Object ref = currentRevision_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          currentRevision_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the
     * sequence [0,currentReplicas).
     * </pre>
     *
     * <code>optional string currentRevision = 6;</code>
     */
    public com.google.protobuf.ByteString getCurrentRevisionBytes() {
      java.lang.Object ref = currentRevision_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        currentRevision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int UPDATEREVISION_FIELD_NUMBER = 7;
    private volatile java.lang.Object updateRevision_;
    /**
     *
     *
     * <pre>
     * updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence
     * [replicas-updatedReplicas,replicas)
     * </pre>
     *
     * <code>optional string updateRevision = 7;</code>
     */
    public boolean hasUpdateRevision() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     *
     *
     * <pre>
     * updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence
     * [replicas-updatedReplicas,replicas)
     * </pre>
     *
     * <code>optional string updateRevision = 7;</code>
     */
    public java.lang.String getUpdateRevision() {
      java.lang.Object ref = updateRevision_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          updateRevision_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence
     * [replicas-updatedReplicas,replicas)
     * </pre>
     *
     * <code>optional string updateRevision = 7;</code>
     */
    public com.google.protobuf.ByteString getUpdateRevisionBytes() {
      java.lang.Object ref = updateRevision_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        updateRevision_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLLISIONCOUNT_FIELD_NUMBER = 9;
    private int collisionCount_;
    /**
     *
     *
     * <pre>
     * collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller
     * uses this field as a collision avoidance mechanism when it needs to create the name for the
     * newest ControllerRevision.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 9;</code>
     */
    public boolean hasCollisionCount() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     *
     *
     * <pre>
     * collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller
     * uses this field as a collision avoidance mechanism when it needs to create the name for the
     * newest ControllerRevision.
     * +optional
     * </pre>
     *
     * <code>optional int32 collisionCount = 9;</code>
     */
    public int getCollisionCount() {
      return collisionCount_;
    }

    public static final int CONDITIONS_FIELD_NUMBER = 10;
    private java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition> conditions_;
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition>
        getConditionsList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    public java.util.List<
            ? extends io.kubernetes.client.proto.V1beta1Apps.StatefulSetConditionOrBuilder>
        getConditionsOrBuilderList() {
      return conditions_;
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    public int getConditionsCount() {
      return conditions_.size();
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetCondition getConditions(int index) {
      return conditions_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Represents the latest available observations of a statefulset's current state.
     * +optional
     * +patchMergeKey=type
     * +patchStrategy=merge
     * </pre>
     *
     * <code>repeated .k8s.io.api.apps.v1beta1.StatefulSetCondition conditions = 10;</code>
     */
    public io.kubernetes.client.proto.V1beta1Apps.StatefulSetConditionOrBuilder
        getConditionsOrBuilder(int index) {
      return conditions_.get(index);
    }

    public static final int AVAILABLEREPLICAS_FIELD_NUMBER = 11;
    private int availableReplicas_;
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this StatefulSet.
     * This is a beta field and enabled/disabled by StatefulSetMinReadySeconds feature gate.
     * </pre>
     *
     * <code>optional int32 availableReplicas = 11;</code>
     */
    public boolean hasAvailableReplicas() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     *
     *
     * <pre>
     * Total number of available pods (ready for at least minReadySeconds) targeted by this StatefulSet.
     * This is a beta field and enabled/disabled by StatefulSetMinReadySeconds feature gate.
     * </pre>
     *
     * <code>optional int32 availableReplicas = 11;</code>
     */
    public int getAvailableReplicas() {
      return availableReplicas_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeInt64(1, observedGeneration_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeInt32(2, replicas_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeInt32(3, readyReplicas_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeInt32(4, currentReplicas_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeInt32(5, updatedReplicas_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 6, currentRevision_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 7, updateRevision_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeInt32(9, collisionCount_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        output.writeMessage(10, conditions_.get(i));
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeInt32(11, availableReplicas_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, observedGeneration_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, replicas_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, readyReplicas_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(4, currentReplicas_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, updatedReplicas_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, currentRevision_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, updateRevision_);
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(9, collisionCount_);
      }
      for (int i = 0; i < conditions_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, conditions_.get(i));
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(11, availableReplicas_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus other =
          (io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus) obj;

      boolean result = true;
      result = result && (hasObservedGeneration() == other.hasObservedGeneration());
      if (hasObservedGeneration()) {
        result = result && (getObservedGeneration() == other.getObservedGeneration());
      }
      result = result && (hasReplicas() == other.hasReplicas());
      if (hasReplicas()) {
        result = result && (getReplicas() == other.getReplicas());
      }
      result = result && (hasReadyReplicas() == other.hasReadyReplicas());
      if (hasReadyReplicas()) {
        result = result && (getReadyReplicas() == other.getReadyReplicas());
      }
      result = result && (hasCurrentReplicas() == other.hasCurrentReplicas());
      if (hasCurrentReplicas()) {
        result = result && (getCurrentReplicas() == other.getCurrentReplicas());
      }
      result = result && (hasUpdatedReplicas() == other.hasUpdatedReplicas());
      if (hasUpdatedReplicas()) {
        result = result && (getUpdatedReplicas() == other.getUpdatedReplicas());
      }
      result = result && (hasCurrentRevision() == other.hasCurrentRevision());
      if (hasCurrentRevision()) {
        result = result && getCurrentRevision().equals(other.getCurrentRevision());
      }
      result = result && (hasUpdateRevision() == other.hasUpdateRevision());
      if (hasUpdateRevision()) {
        result = result && getUpdateRevision().equals(other.getUpdateRevision());
      }
      result = result && (hasCollisionCount() == other.hasCollisionCount());
      if (hasCollisionCount()) {
        result = result && (getCollisionCount() == other.getCollisionCount());
      }
      result = result && getConditionsList().equals(other.getConditionsList());
      result = result && (hasAvailableReplicas() == other.hasAvailableReplicas());
      if (hasAvailableReplicas()) {
        result = result && (getAvailableReplicas() == other.getAvailableReplicas());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasObservedGeneration()) {
        hash = (37 * hash) + OBSERVEDGENERATION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getObservedGeneration());
      }
      if (hasReplicas()) {
        hash = (37 * hash) + REPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReplicas();
      }
      if (hasReadyReplicas()) {
        hash = (37 * hash) + READYREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getReadyReplicas();
      }
      if (hasCurrentReplicas()) {
        hash = (37 * hash) + CURRENTREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getCurrentReplicas();
      }
      if (hasUpdatedReplicas()) {
        hash = (37 * hash) + UPDATEDREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getUpdatedReplicas();
      }
      if (hasCurrentRevision()) {
        hash = (37 * hash) + CURRENTREVISION_FIELD_NUMBER;
        hash = (53 * hash) + getCurrentRevision().hashCode();
      }
      if (hasUpdateRevision()) {
        hash = (37 * hash) + UPDATEREVISION_FIELD_NUMBER;
        hash = (53 * hash) + getUpdateRevision().hashCode();
      }
      if (hasCollisionCount()) {
        hash = (37 * hash) + COLLISIONCOUNT_FIELD_NUMBER;
        hash = (53 * hash) + getCollisionCount();
      }
      if (getConditionsCount() > 0) {
        hash = (37 * hash) + CONDITIONS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionsList().hashCode();
      }
      if (hasAvailableReplicas()) {
        hash = (37 * hash) + AVAILABLEREPLICAS_FIELD_NUMBER;
        hash = (53 * hash) + getAvailableReplicas();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1beta1Apps.StatefulSetStatus parseFrom(
        com.google.protobuf.Cod