/*
Copyright 2021 The Kubernetes Authors.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
package io.kubernetes.client.proto;

public final class V1Networking {
  private V1Networking() {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistryLite registry) {}

  public static void registerAllExtensions(com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions((com.google.protobuf.ExtensionRegistryLite) registry);
  }

  public interface HTTPIngressPathOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.HTTPIngressPath)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Path is matched against the path of an incoming request. Currently it can
     * contain characters disallowed from the conventional "path" part of a URL
     * as defined by RFC 3986. Paths must begin with a '/' and must be present
     * when using PathType with value "Exact" or "Prefix".
     * +optional
     * </pre>
     *
     * <code>optional string path = 1;</code>
     */
    boolean hasPath();
    /**
     *
     *
     * <pre>
     * Path is matched against the path of an incoming request. Currently it can
     * contain characters disallowed from the conventional "path" part of a URL
     * as defined by RFC 3986. Paths must begin with a '/' and must be present
     * when using PathType with value "Exact" or "Prefix".
     * +optional
     * </pre>
     *
     * <code>optional string path = 1;</code>
     */
    java.lang.String getPath();
    /**
     *
     *
     * <pre>
     * Path is matched against the path of an incoming request. Currently it can
     * contain characters disallowed from the conventional "path" part of a URL
     * as defined by RFC 3986. Paths must begin with a '/' and must be present
     * when using PathType with value "Exact" or "Prefix".
     * +optional
     * </pre>
     *
     * <code>optional string path = 1;</code>
     */
    com.google.protobuf.ByteString getPathBytes();

    /**
     *
     *
     * <pre>
     * PathType determines the interpretation of the Path matching. PathType can
     * be one of the following values:
     * * Exact: Matches the URL path exactly.
     * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
     *   done on a path element by element basis. A path element refers is the
     *   list of labels in the path split by the '/' separator. A request is a
     *   match for path p if every p is an element-wise prefix of p of the
     *   request path. Note that if the last element of the path is a substring
     *   of the last element in request path, it is not a match (e.g. /foo/bar
     *   matches /foo/bar/baz, but does not match /foo/barbaz).
     * * ImplementationSpecific: Interpretation of the Path matching is up to
     *   the IngressClass. Implementations can treat this as a separate PathType
     *   or treat it identically to Prefix or Exact path types.
     * Implementations are required to support all path types.
     * </pre>
     *
     * <code>optional string pathType = 3;</code>
     */
    boolean hasPathType();
    /**
     *
     *
     * <pre>
     * PathType determines the interpretation of the Path matching. PathType can
     * be one of the following values:
     * * Exact: Matches the URL path exactly.
     * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
     *   done on a path element by element basis. A path element refers is the
     *   list of labels in the path split by the '/' separator. A request is a
     *   match for path p if every p is an element-wise prefix of p of the
     *   request path. Note that if the last element of the path is a substring
     *   of the last element in request path, it is not a match (e.g. /foo/bar
     *   matches /foo/bar/baz, but does not match /foo/barbaz).
     * * ImplementationSpecific: Interpretation of the Path matching is up to
     *   the IngressClass. Implementations can treat this as a separate PathType
     *   or treat it identically to Prefix or Exact path types.
     * Implementations are required to support all path types.
     * </pre>
     *
     * <code>optional string pathType = 3;</code>
     */
    java.lang.String getPathType();
    /**
     *
     *
     * <pre>
     * PathType determines the interpretation of the Path matching. PathType can
     * be one of the following values:
     * * Exact: Matches the URL path exactly.
     * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
     *   done on a path element by element basis. A path element refers is the
     *   list of labels in the path split by the '/' separator. A request is a
     *   match for path p if every p is an element-wise prefix of p of the
     *   request path. Note that if the last element of the path is a substring
     *   of the last element in request path, it is not a match (e.g. /foo/bar
     *   matches /foo/bar/baz, but does not match /foo/barbaz).
     * * ImplementationSpecific: Interpretation of the Path matching is up to
     *   the IngressClass. Implementations can treat this as a separate PathType
     *   or treat it identically to Prefix or Exact path types.
     * Implementations are required to support all path types.
     * </pre>
     *
     * <code>optional string pathType = 3;</code>
     */
    com.google.protobuf.ByteString getPathTypeBytes();

    /**
     *
     *
     * <pre>
     * Backend defines the referenced service endpoint to which the traffic
     * will be forwarded to.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
     */
    boolean hasBackend();
    /**
     *
     *
     * <pre>
     * Backend defines the referenced service endpoint to which the traffic
     * will be forwarded to.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressBackend getBackend();
    /**
     *
     *
     * <pre>
     * Backend defines the referenced service endpoint to which the traffic
     * will be forwarded to.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder getBackendOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * HTTPIngressPath associates a path with a backend. Incoming urls matching the
   * path are forwarded to the backend.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.HTTPIngressPath}
   */
  public static final class HTTPIngressPath extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.HTTPIngressPath)
      HTTPIngressPathOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HTTPIngressPath.newBuilder() to construct.
    private HTTPIngressPath(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HTTPIngressPath() {
      path_ = "";
      pathType_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private HTTPIngressPath(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                path_ = bs;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Networking.IngressBackend.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = backend_.toBuilder();
                }
                backend_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressBackend.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(backend_);
                  backend_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            case 26:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                pathType_ = bs;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_HTTPIngressPath_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_HTTPIngressPath_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.HTTPIngressPath.class,
              io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder.class);
    }

    private int bitField0_;
    public static final int PATH_FIELD_NUMBER = 1;
    private volatile java.lang.Object path_;
    /**
     *
     *
     * <pre>
     * Path is matched against the path of an incoming request. Currently it can
     * contain characters disallowed from the conventional "path" part of a URL
     * as defined by RFC 3986. Paths must begin with a '/' and must be present
     * when using PathType with value "Exact" or "Prefix".
     * +optional
     * </pre>
     *
     * <code>optional string path = 1;</code>
     */
    public boolean hasPath() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Path is matched against the path of an incoming request. Currently it can
     * contain characters disallowed from the conventional "path" part of a URL
     * as defined by RFC 3986. Paths must begin with a '/' and must be present
     * when using PathType with value "Exact" or "Prefix".
     * +optional
     * </pre>
     *
     * <code>optional string path = 1;</code>
     */
    public java.lang.String getPath() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          path_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Path is matched against the path of an incoming request. Currently it can
     * contain characters disallowed from the conventional "path" part of a URL
     * as defined by RFC 3986. Paths must begin with a '/' and must be present
     * when using PathType with value "Exact" or "Prefix".
     * +optional
     * </pre>
     *
     * <code>optional string path = 1;</code>
     */
    public com.google.protobuf.ByteString getPathBytes() {
      java.lang.Object ref = path_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        path_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PATHTYPE_FIELD_NUMBER = 3;
    private volatile java.lang.Object pathType_;
    /**
     *
     *
     * <pre>
     * PathType determines the interpretation of the Path matching. PathType can
     * be one of the following values:
     * * Exact: Matches the URL path exactly.
     * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
     *   done on a path element by element basis. A path element refers is the
     *   list of labels in the path split by the '/' separator. A request is a
     *   match for path p if every p is an element-wise prefix of p of the
     *   request path. Note that if the last element of the path is a substring
     *   of the last element in request path, it is not a match (e.g. /foo/bar
     *   matches /foo/bar/baz, but does not match /foo/barbaz).
     * * ImplementationSpecific: Interpretation of the Path matching is up to
     *   the IngressClass. Implementations can treat this as a separate PathType
     *   or treat it identically to Prefix or Exact path types.
     * Implementations are required to support all path types.
     * </pre>
     *
     * <code>optional string pathType = 3;</code>
     */
    public boolean hasPathType() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * PathType determines the interpretation of the Path matching. PathType can
     * be one of the following values:
     * * Exact: Matches the URL path exactly.
     * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
     *   done on a path element by element basis. A path element refers is the
     *   list of labels in the path split by the '/' separator. A request is a
     *   match for path p if every p is an element-wise prefix of p of the
     *   request path. Note that if the last element of the path is a substring
     *   of the last element in request path, it is not a match (e.g. /foo/bar
     *   matches /foo/bar/baz, but does not match /foo/barbaz).
     * * ImplementationSpecific: Interpretation of the Path matching is up to
     *   the IngressClass. Implementations can treat this as a separate PathType
     *   or treat it identically to Prefix or Exact path types.
     * Implementations are required to support all path types.
     * </pre>
     *
     * <code>optional string pathType = 3;</code>
     */
    public java.lang.String getPathType() {
      java.lang.Object ref = pathType_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          pathType_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * PathType determines the interpretation of the Path matching. PathType can
     * be one of the following values:
     * * Exact: Matches the URL path exactly.
     * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
     *   done on a path element by element basis. A path element refers is the
     *   list of labels in the path split by the '/' separator. A request is a
     *   match for path p if every p is an element-wise prefix of p of the
     *   request path. Note that if the last element of the path is a substring
     *   of the last element in request path, it is not a match (e.g. /foo/bar
     *   matches /foo/bar/baz, but does not match /foo/barbaz).
     * * ImplementationSpecific: Interpretation of the Path matching is up to
     *   the IngressClass. Implementations can treat this as a separate PathType
     *   or treat it identically to Prefix or Exact path types.
     * Implementations are required to support all path types.
     * </pre>
     *
     * <code>optional string pathType = 3;</code>
     */
    public com.google.protobuf.ByteString getPathTypeBytes() {
      java.lang.Object ref = pathType_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pathType_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int BACKEND_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Networking.IngressBackend backend_;
    /**
     *
     *
     * <pre>
     * Backend defines the referenced service endpoint to which the traffic
     * will be forwarded to.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
     */
    public boolean hasBackend() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Backend defines the referenced service endpoint to which the traffic
     * will be forwarded to.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressBackend getBackend() {
      return backend_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()
          : backend_;
    }
    /**
     *
     *
     * <pre>
     * Backend defines the referenced service endpoint to which the traffic
     * will be forwarded to.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder getBackendOrBuilder() {
      return backend_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()
          : backend_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, path_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(2, getBackend());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, pathType_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, path_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getBackend());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, pathType_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.HTTPIngressPath)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.HTTPIngressPath other =
          (io.kubernetes.client.proto.V1Networking.HTTPIngressPath) obj;

      boolean result = true;
      result = result && (hasPath() == other.hasPath());
      if (hasPath()) {
        result = result && getPath().equals(other.getPath());
      }
      result = result && (hasPathType() == other.hasPathType());
      if (hasPathType()) {
        result = result && getPathType().equals(other.getPathType());
      }
      result = result && (hasBackend() == other.hasBackend());
      if (hasBackend()) {
        result = result && getBackend().equals(other.getBackend());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPath()) {
        hash = (37 * hash) + PATH_FIELD_NUMBER;
        hash = (53 * hash) + getPath().hashCode();
      }
      if (hasPathType()) {
        hash = (37 * hash) + PATHTYPE_FIELD_NUMBER;
        hash = (53 * hash) + getPathType().hashCode();
      }
      if (hasBackend()) {
        hash = (37 * hash) + BACKEND_FIELD_NUMBER;
        hash = (53 * hash) + getBackend().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.HTTPIngressPath prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * HTTPIngressPath associates a path with a backend. Incoming urls matching the
     * path are forwarded to the backend.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.HTTPIngressPath}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.HTTPIngressPath)
        io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_HTTPIngressPath_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_HTTPIngressPath_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.HTTPIngressPath.class,
                io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.HTTPIngressPath.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getBackendFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        path_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        pathType_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        if (backendBuilder_ == null) {
          backend_ = null;
        } else {
          backendBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_HTTPIngressPath_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.HTTPIngressPath getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.HTTPIngressPath.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.HTTPIngressPath build() {
        io.kubernetes.client.proto.V1Networking.HTTPIngressPath result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.HTTPIngressPath buildPartial() {
        io.kubernetes.client.proto.V1Networking.HTTPIngressPath result =
            new io.kubernetes.client.proto.V1Networking.HTTPIngressPath(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.path_ = path_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.pathType_ = pathType_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (backendBuilder_ == null) {
          result.backend_ = backend_;
        } else {
          result.backend_ = backendBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.HTTPIngressPath) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.HTTPIngressPath) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.HTTPIngressPath other) {
        if (other == io.kubernetes.client.proto.V1Networking.HTTPIngressPath.getDefaultInstance())
          return this;
        if (other.hasPath()) {
          bitField0_ |= 0x00000001;
          path_ = other.path_;
          onChanged();
        }
        if (other.hasPathType()) {
          bitField0_ |= 0x00000002;
          pathType_ = other.pathType_;
          onChanged();
        }
        if (other.hasBackend()) {
          mergeBackend(other.getBackend());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.HTTPIngressPath parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.HTTPIngressPath) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object path_ = "";
      /**
       *
       *
       * <pre>
       * Path is matched against the path of an incoming request. Currently it can
       * contain characters disallowed from the conventional "path" part of a URL
       * as defined by RFC 3986. Paths must begin with a '/' and must be present
       * when using PathType with value "Exact" or "Prefix".
       * +optional
       * </pre>
       *
       * <code>optional string path = 1;</code>
       */
      public boolean hasPath() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Path is matched against the path of an incoming request. Currently it can
       * contain characters disallowed from the conventional "path" part of a URL
       * as defined by RFC 3986. Paths must begin with a '/' and must be present
       * when using PathType with value "Exact" or "Prefix".
       * +optional
       * </pre>
       *
       * <code>optional string path = 1;</code>
       */
      public java.lang.String getPath() {
        java.lang.Object ref = path_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            path_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Path is matched against the path of an incoming request. Currently it can
       * contain characters disallowed from the conventional "path" part of a URL
       * as defined by RFC 3986. Paths must begin with a '/' and must be present
       * when using PathType with value "Exact" or "Prefix".
       * +optional
       * </pre>
       *
       * <code>optional string path = 1;</code>
       */
      public com.google.protobuf.ByteString getPathBytes() {
        java.lang.Object ref = path_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          path_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Path is matched against the path of an incoming request. Currently it can
       * contain characters disallowed from the conventional "path" part of a URL
       * as defined by RFC 3986. Paths must begin with a '/' and must be present
       * when using PathType with value "Exact" or "Prefix".
       * +optional
       * </pre>
       *
       * <code>optional string path = 1;</code>
       */
      public Builder setPath(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        path_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path is matched against the path of an incoming request. Currently it can
       * contain characters disallowed from the conventional "path" part of a URL
       * as defined by RFC 3986. Paths must begin with a '/' and must be present
       * when using PathType with value "Exact" or "Prefix".
       * +optional
       * </pre>
       *
       * <code>optional string path = 1;</code>
       */
      public Builder clearPath() {
        bitField0_ = (bitField0_ & ~0x00000001);
        path_ = getDefaultInstance().getPath();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Path is matched against the path of an incoming request. Currently it can
       * contain characters disallowed from the conventional "path" part of a URL
       * as defined by RFC 3986. Paths must begin with a '/' and must be present
       * when using PathType with value "Exact" or "Prefix".
       * +optional
       * </pre>
       *
       * <code>optional string path = 1;</code>
       */
      public Builder setPathBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        path_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object pathType_ = "";
      /**
       *
       *
       * <pre>
       * PathType determines the interpretation of the Path matching. PathType can
       * be one of the following values:
       * * Exact: Matches the URL path exactly.
       * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
       *   done on a path element by element basis. A path element refers is the
       *   list of labels in the path split by the '/' separator. A request is a
       *   match for path p if every p is an element-wise prefix of p of the
       *   request path. Note that if the last element of the path is a substring
       *   of the last element in request path, it is not a match (e.g. /foo/bar
       *   matches /foo/bar/baz, but does not match /foo/barbaz).
       * * ImplementationSpecific: Interpretation of the Path matching is up to
       *   the IngressClass. Implementations can treat this as a separate PathType
       *   or treat it identically to Prefix or Exact path types.
       * Implementations are required to support all path types.
       * </pre>
       *
       * <code>optional string pathType = 3;</code>
       */
      public boolean hasPathType() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * PathType determines the interpretation of the Path matching. PathType can
       * be one of the following values:
       * * Exact: Matches the URL path exactly.
       * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
       *   done on a path element by element basis. A path element refers is the
       *   list of labels in the path split by the '/' separator. A request is a
       *   match for path p if every p is an element-wise prefix of p of the
       *   request path. Note that if the last element of the path is a substring
       *   of the last element in request path, it is not a match (e.g. /foo/bar
       *   matches /foo/bar/baz, but does not match /foo/barbaz).
       * * ImplementationSpecific: Interpretation of the Path matching is up to
       *   the IngressClass. Implementations can treat this as a separate PathType
       *   or treat it identically to Prefix or Exact path types.
       * Implementations are required to support all path types.
       * </pre>
       *
       * <code>optional string pathType = 3;</code>
       */
      public java.lang.String getPathType() {
        java.lang.Object ref = pathType_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            pathType_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * PathType determines the interpretation of the Path matching. PathType can
       * be one of the following values:
       * * Exact: Matches the URL path exactly.
       * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
       *   done on a path element by element basis. A path element refers is the
       *   list of labels in the path split by the '/' separator. A request is a
       *   match for path p if every p is an element-wise prefix of p of the
       *   request path. Note that if the last element of the path is a substring
       *   of the last element in request path, it is not a match (e.g. /foo/bar
       *   matches /foo/bar/baz, but does not match /foo/barbaz).
       * * ImplementationSpecific: Interpretation of the Path matching is up to
       *   the IngressClass. Implementations can treat this as a separate PathType
       *   or treat it identically to Prefix or Exact path types.
       * Implementations are required to support all path types.
       * </pre>
       *
       * <code>optional string pathType = 3;</code>
       */
      public com.google.protobuf.ByteString getPathTypeBytes() {
        java.lang.Object ref = pathType_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pathType_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * PathType determines the interpretation of the Path matching. PathType can
       * be one of the following values:
       * * Exact: Matches the URL path exactly.
       * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
       *   done on a path element by element basis. A path element refers is the
       *   list of labels in the path split by the '/' separator. A request is a
       *   match for path p if every p is an element-wise prefix of p of the
       *   request path. Note that if the last element of the path is a substring
       *   of the last element in request path, it is not a match (e.g. /foo/bar
       *   matches /foo/bar/baz, but does not match /foo/barbaz).
       * * ImplementationSpecific: Interpretation of the Path matching is up to
       *   the IngressClass. Implementations can treat this as a separate PathType
       *   or treat it identically to Prefix or Exact path types.
       * Implementations are required to support all path types.
       * </pre>
       *
       * <code>optional string pathType = 3;</code>
       */
      public Builder setPathType(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        pathType_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * PathType determines the interpretation of the Path matching. PathType can
       * be one of the following values:
       * * Exact: Matches the URL path exactly.
       * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
       *   done on a path element by element basis. A path element refers is the
       *   list of labels in the path split by the '/' separator. A request is a
       *   match for path p if every p is an element-wise prefix of p of the
       *   request path. Note that if the last element of the path is a substring
       *   of the last element in request path, it is not a match (e.g. /foo/bar
       *   matches /foo/bar/baz, but does not match /foo/barbaz).
       * * ImplementationSpecific: Interpretation of the Path matching is up to
       *   the IngressClass. Implementations can treat this as a separate PathType
       *   or treat it identically to Prefix or Exact path types.
       * Implementations are required to support all path types.
       * </pre>
       *
       * <code>optional string pathType = 3;</code>
       */
      public Builder clearPathType() {
        bitField0_ = (bitField0_ & ~0x00000002);
        pathType_ = getDefaultInstance().getPathType();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * PathType determines the interpretation of the Path matching. PathType can
       * be one of the following values:
       * * Exact: Matches the URL path exactly.
       * * Prefix: Matches based on a URL path prefix split by '/'. Matching is
       *   done on a path element by element basis. A path element refers is the
       *   list of labels in the path split by the '/' separator. A request is a
       *   match for path p if every p is an element-wise prefix of p of the
       *   request path. Note that if the last element of the path is a substring
       *   of the last element in request path, it is not a match (e.g. /foo/bar
       *   matches /foo/bar/baz, but does not match /foo/barbaz).
       * * ImplementationSpecific: Interpretation of the Path matching is up to
       *   the IngressClass. Implementations can treat this as a separate PathType
       *   or treat it identically to Prefix or Exact path types.
       * Implementations are required to support all path types.
       * </pre>
       *
       * <code>optional string pathType = 3;</code>
       */
      public Builder setPathTypeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        pathType_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1Networking.IngressBackend backend_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressBackend,
              io.kubernetes.client.proto.V1Networking.IngressBackend.Builder,
              io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder>
          backendBuilder_;
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      public boolean hasBackend() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressBackend getBackend() {
        if (backendBuilder_ == null) {
          return backend_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()
              : backend_;
        } else {
          return backendBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      public Builder setBackend(io.kubernetes.client.proto.V1Networking.IngressBackend value) {
        if (backendBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          backend_ = value;
          onChanged();
        } else {
          backendBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      public Builder setBackend(
          io.kubernetes.client.proto.V1Networking.IngressBackend.Builder builderForValue) {
        if (backendBuilder_ == null) {
          backend_ = builderForValue.build();
          onChanged();
        } else {
          backendBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      public Builder mergeBackend(io.kubernetes.client.proto.V1Networking.IngressBackend value) {
        if (backendBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && backend_ != null
              && backend_
                  != io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()) {
            backend_ =
                io.kubernetes.client.proto.V1Networking.IngressBackend.newBuilder(backend_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            backend_ = value;
          }
          onChanged();
        } else {
          backendBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      public Builder clearBackend() {
        if (backendBuilder_ == null) {
          backend_ = null;
          onChanged();
        } else {
          backendBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressBackend.Builder getBackendBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getBackendFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder getBackendOrBuilder() {
        if (backendBuilder_ != null) {
          return backendBuilder_.getMessageOrBuilder();
        } else {
          return backend_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()
              : backend_;
        }
      }
      /**
       *
       *
       * <pre>
       * Backend defines the referenced service endpoint to which the traffic
       * will be forwarded to.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend backend = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressBackend,
              io.kubernetes.client.proto.V1Networking.IngressBackend.Builder,
              io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder>
          getBackendFieldBuilder() {
        if (backendBuilder_ == null) {
          backendBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressBackend,
                  io.kubernetes.client.proto.V1Networking.IngressBackend.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder>(
                  getBackend(), getParentForChildren(), isClean());
          backend_ = null;
        }
        return backendBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.HTTPIngressPath)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.HTTPIngressPath)
    private static final io.kubernetes.client.proto.V1Networking.HTTPIngressPath DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.HTTPIngressPath();
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressPath getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<HTTPIngressPath> PARSER =
        new com.google.protobuf.AbstractParser<HTTPIngressPath>() {
          @java.lang.Override
          public HTTPIngressPath parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new HTTPIngressPath(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<HTTPIngressPath> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HTTPIngressPath> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.HTTPIngressPath getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HTTPIngressRuleValueOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.HTTPIngressRuleValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.HTTPIngressPath> getPathsList();
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.HTTPIngressPath getPaths(int index);
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    int getPathsCount();
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder>
        getPathsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder getPathsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * HTTPIngressRuleValue is a list of http selectors pointing to backends.
   * In the example: http://&lt;host&gt;/&lt;path&gt;?&lt;searchpart&gt; -&gt; backend where
   * where parts of the url correspond to RFC 3986, this resource will be used
   * to match against everything after the last '/' and before the first '?'
   * or '#'.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.HTTPIngressRuleValue}
   */
  public static final class HTTPIngressRuleValue extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.HTTPIngressRuleValue)
      HTTPIngressRuleValueOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use HTTPIngressRuleValue.newBuilder() to construct.
    private HTTPIngressRuleValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HTTPIngressRuleValue() {
      paths_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private HTTPIngressRuleValue(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                  paths_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Networking.HTTPIngressPath>();
                  mutable_bitField0_ |= 0x00000001;
                }
                paths_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.HTTPIngressPath.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          paths_ = java.util.Collections.unmodifiableList(paths_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_HTTPIngressRuleValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_HTTPIngressRuleValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.class,
              io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.Builder.class);
    }

    public static final int PATHS_FIELD_NUMBER = 1;
    private java.util.List<io.kubernetes.client.proto.V1Networking.HTTPIngressPath> paths_;
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.HTTPIngressPath> getPathsList() {
      return paths_;
    }
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    public java.util.List<
            ? extends io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder>
        getPathsOrBuilderList() {
      return paths_;
    }
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    public int getPathsCount() {
      return paths_.size();
    }
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.HTTPIngressPath getPaths(int index) {
      return paths_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of paths that map requests to backends.
     * +listType=atomic
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder getPathsOrBuilder(
        int index) {
      return paths_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < paths_.size(); i++) {
        output.writeMessage(1, paths_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < paths_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, paths_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue other =
          (io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue) obj;

      boolean result = true;
      result = result && getPathsList().equals(other.getPathsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPathsCount() > 0) {
        hash = (37 * hash) + PATHS_FIELD_NUMBER;
        hash = (53 * hash) + getPathsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * HTTPIngressRuleValue is a list of http selectors pointing to backends.
     * In the example: http://&lt;host&gt;/&lt;path&gt;?&lt;searchpart&gt; -&gt; backend where
     * where parts of the url correspond to RFC 3986, this resource will be used
     * to match against everything after the last '/' and before the first '?'
     * or '#'.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.HTTPIngressRuleValue}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.HTTPIngressRuleValue)
        io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_HTTPIngressRuleValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_HTTPIngressRuleValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.class,
                io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPathsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (pathsBuilder_ == null) {
          paths_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          pathsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_HTTPIngressRuleValue_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue build() {
        io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue buildPartial() {
        io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue result =
            new io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue(this);
        int from_bitField0_ = bitField0_;
        if (pathsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            paths_ = java.util.Collections.unmodifiableList(paths_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.paths_ = paths_;
        } else {
          result.paths_ = pathsBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue other) {
        if (other
            == io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.getDefaultInstance())
          return this;
        if (pathsBuilder_ == null) {
          if (!other.paths_.isEmpty()) {
            if (paths_.isEmpty()) {
              paths_ = other.paths_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePathsIsMutable();
              paths_.addAll(other.paths_);
            }
            onChanged();
          }
        } else {
          if (!other.paths_.isEmpty()) {
            if (pathsBuilder_.isEmpty()) {
              pathsBuilder_.dispose();
              pathsBuilder_ = null;
              paths_ = other.paths_;
              bitField0_ = (bitField0_ & ~0x00000001);
              pathsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPathsFieldBuilder()
                      : null;
            } else {
              pathsBuilder_.addAllMessages(other.paths_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<io.kubernetes.client.proto.V1Networking.HTTPIngressPath> paths_ =
          java.util.Collections.emptyList();

      private void ensurePathsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          paths_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.HTTPIngressPath>(
                  paths_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.HTTPIngressPath,
              io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder,
              io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder>
          pathsBuilder_;

      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.HTTPIngressPath>
          getPathsList() {
        if (pathsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(paths_);
        } else {
          return pathsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public int getPathsCount() {
        if (pathsBuilder_ == null) {
          return paths_.size();
        } else {
          return pathsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.HTTPIngressPath getPaths(int index) {
        if (pathsBuilder_ == null) {
          return paths_.get(index);
        } else {
          return pathsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder setPaths(
          int index, io.kubernetes.client.proto.V1Networking.HTTPIngressPath value) {
        if (pathsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePathsIsMutable();
          paths_.set(index, value);
          onChanged();
        } else {
          pathsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder setPaths(
          int index,
          io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder builderForValue) {
        if (pathsBuilder_ == null) {
          ensurePathsIsMutable();
          paths_.set(index, builderForValue.build());
          onChanged();
        } else {
          pathsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder addPaths(io.kubernetes.client.proto.V1Networking.HTTPIngressPath value) {
        if (pathsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePathsIsMutable();
          paths_.add(value);
          onChanged();
        } else {
          pathsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder addPaths(
          int index, io.kubernetes.client.proto.V1Networking.HTTPIngressPath value) {
        if (pathsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePathsIsMutable();
          paths_.add(index, value);
          onChanged();
        } else {
          pathsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder addPaths(
          io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder builderForValue) {
        if (pathsBuilder_ == null) {
          ensurePathsIsMutable();
          paths_.add(builderForValue.build());
          onChanged();
        } else {
          pathsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder addPaths(
          int index,
          io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder builderForValue) {
        if (pathsBuilder_ == null) {
          ensurePathsIsMutable();
          paths_.add(index, builderForValue.build());
          onChanged();
        } else {
          pathsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder addAllPaths(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.HTTPIngressPath>
              values) {
        if (pathsBuilder_ == null) {
          ensurePathsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, paths_);
          onChanged();
        } else {
          pathsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder clearPaths() {
        if (pathsBuilder_ == null) {
          paths_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          pathsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public Builder removePaths(int index) {
        if (pathsBuilder_ == null) {
          ensurePathsIsMutable();
          paths_.remove(index);
          onChanged();
        } else {
          pathsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder getPathsBuilder(
          int index) {
        return getPathsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder getPathsOrBuilder(
          int index) {
        if (pathsBuilder_ == null) {
          return paths_.get(index);
        } else {
          return pathsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder>
          getPathsOrBuilderList() {
        if (pathsBuilder_ != null) {
          return pathsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(paths_);
        }
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder addPathsBuilder() {
        return getPathsFieldBuilder()
            .addBuilder(
                io.kubernetes.client.proto.V1Networking.HTTPIngressPath.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder addPathsBuilder(
          int index) {
        return getPathsFieldBuilder()
            .addBuilder(
                index,
                io.kubernetes.client.proto.V1Networking.HTTPIngressPath.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A collection of paths that map requests to backends.
       * +listType=atomic
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.HTTPIngressPath paths = 1;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder>
          getPathsBuilderList() {
        return getPathsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.HTTPIngressPath,
              io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder,
              io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder>
          getPathsFieldBuilder() {
        if (pathsBuilder_ == null) {
          pathsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.HTTPIngressPath,
                  io.kubernetes.client.proto.V1Networking.HTTPIngressPath.Builder,
                  io.kubernetes.client.proto.V1Networking.HTTPIngressPathOrBuilder>(
                  paths_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          paths_ = null;
        }
        return pathsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.HTTPIngressRuleValue)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.HTTPIngressRuleValue)
    private static final io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue();
    }

    public static io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<HTTPIngressRuleValue> PARSER =
        new com.google.protobuf.AbstractParser<HTTPIngressRuleValue>() {
          @java.lang.Override
          public HTTPIngressRuleValue parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new HTTPIngressRuleValue(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<HTTPIngressRuleValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HTTPIngressRuleValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IPBlockOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IPBlock)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * CIDR is a string representing the IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * </pre>
     *
     * <code>optional string cidr = 1;</code>
     */
    boolean hasCidr();
    /**
     *
     *
     * <pre>
     * CIDR is a string representing the IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * </pre>
     *
     * <code>optional string cidr = 1;</code>
     */
    java.lang.String getCidr();
    /**
     *
     *
     * <pre>
     * CIDR is a string representing the IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * </pre>
     *
     * <code>optional string cidr = 1;</code>
     */
    com.google.protobuf.ByteString getCidrBytes();

    /**
     *
     *
     * <pre>
     * Except is a slice of CIDRs that should not be included within an IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * Except values will be rejected if they are outside the CIDR range
     * +optional
     * </pre>
     *
     * <code>repeated string except = 2;</code>
     */
    java.util.List<java.lang.String> getExceptList();
    /**
     *
     *
     * <pre>
     * Except is a slice of CIDRs that should not be included within an IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * Except values will be rejected if they are outside the CIDR range
     * +optional
     * </pre>
     *
     * <code>repeated string except = 2;</code>
     */
    int getExceptCount();
    /**
     *
     *
     * <pre>
     * Except is a slice of CIDRs that should not be included within an IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * Except values will be rejected if they are outside the CIDR range
     * +optional
     * </pre>
     *
     * <code>repeated string except = 2;</code>
     */
    java.lang.String getExcept(int index);
    /**
     *
     *
     * <pre>
     * Except is a slice of CIDRs that should not be included within an IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * Except values will be rejected if they are outside the CIDR range
     * +optional
     * </pre>
     *
     * <code>repeated string except = 2;</code>
     */
    com.google.protobuf.ByteString getExceptBytes(int index);
  }
  /**
   *
   *
   * <pre>
   * IPBlock describes a particular CIDR (Ex. "192.168.1.1/24","2001:db9::/64") that is allowed
   * to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs
   * that should not be included within this rule.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IPBlock}
   */
  public static final class IPBlock extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IPBlock)
      IPBlockOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IPBlock.newBuilder() to construct.
    private IPBlock(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IPBlock() {
      cidr_ = "";
      except_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IPBlock(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                cidr_ = bs;
                break;
              }
            case 18:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  except_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000002;
                }
                except_.add(bs);
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          except_ = except_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IPBlock_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IPBlock_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IPBlock.class,
              io.kubernetes.client.proto.V1Networking.IPBlock.Builder.class);
    }

    private int bitField0_;
    public static final int CIDR_FIELD_NUMBER = 1;
    private volatile java.lang.Object cidr_;
    /**
     *
     *
     * <pre>
     * CIDR is a string representing the IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * </pre>
     *
     * <code>optional string cidr = 1;</code>
     */
    public boolean hasCidr() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * CIDR is a string representing the IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * </pre>
     *
     * <code>optional string cidr = 1;</code>
     */
    public java.lang.String getCidr() {
      java.lang.Object ref = cidr_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          cidr_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * CIDR is a string representing the IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * </pre>
     *
     * <code>optional string cidr = 1;</code>
     */
    public com.google.protobuf.ByteString getCidrBytes() {
      java.lang.Object ref = cidr_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        cidr_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int EXCEPT_FIELD_NUMBER = 2;
    private com.google.protobuf.LazyStringList except_;
    /**
     *
     *
     * <pre>
     * Except is a slice of CIDRs that should not be included within an IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * Except values will be rejected if they are outside the CIDR range
     * +optional
     * </pre>
     *
     * <code>repeated string except = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList getExceptList() {
      return except_;
    }
    /**
     *
     *
     * <pre>
     * Except is a slice of CIDRs that should not be included within an IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * Except values will be rejected if they are outside the CIDR range
     * +optional
     * </pre>
     *
     * <code>repeated string except = 2;</code>
     */
    public int getExceptCount() {
      return except_.size();
    }
    /**
     *
     *
     * <pre>
     * Except is a slice of CIDRs that should not be included within an IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * Except values will be rejected if they are outside the CIDR range
     * +optional
     * </pre>
     *
     * <code>repeated string except = 2;</code>
     */
    public java.lang.String getExcept(int index) {
      return except_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Except is a slice of CIDRs that should not be included within an IP Block
     * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
     * Except values will be rejected if they are outside the CIDR range
     * +optional
     * </pre>
     *
     * <code>repeated string except = 2;</code>
     */
    public com.google.protobuf.ByteString getExceptBytes(int index) {
      return except_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, cidr_);
      }
      for (int i = 0; i < except_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, except_.getRaw(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, cidr_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < except_.size(); i++) {
          dataSize += computeStringSizeNoTag(except_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getExceptList().size();
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IPBlock)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IPBlock other =
          (io.kubernetes.client.proto.V1Networking.IPBlock) obj;

      boolean result = true;
      result = result && (hasCidr() == other.hasCidr());
      if (hasCidr()) {
        result = result && getCidr().equals(other.getCidr());
      }
      result = result && getExceptList().equals(other.getExceptList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCidr()) {
        hash = (37 * hash) + CIDR_FIELD_NUMBER;
        hash = (53 * hash) + getCidr().hashCode();
      }
      if (getExceptCount() > 0) {
        hash = (37 * hash) + EXCEPT_FIELD_NUMBER;
        hash = (53 * hash) + getExceptList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Networking.IPBlock prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IPBlock describes a particular CIDR (Ex. "192.168.1.1/24","2001:db9::/64") that is allowed
     * to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs
     * that should not be included within this rule.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IPBlock}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IPBlock)
        io.kubernetes.client.proto.V1Networking.IPBlockOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IPBlock_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IPBlock_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IPBlock.class,
                io.kubernetes.client.proto.V1Networking.IPBlock.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IPBlock.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        cidr_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        except_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IPBlock_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IPBlock getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IPBlock.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IPBlock build() {
        io.kubernetes.client.proto.V1Networking.IPBlock result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IPBlock buildPartial() {
        io.kubernetes.client.proto.V1Networking.IPBlock result =
            new io.kubernetes.client.proto.V1Networking.IPBlock(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.cidr_ = cidr_;
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          except_ = except_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.except_ = except_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IPBlock) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IPBlock) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IPBlock other) {
        if (other == io.kubernetes.client.proto.V1Networking.IPBlock.getDefaultInstance())
          return this;
        if (other.hasCidr()) {
          bitField0_ |= 0x00000001;
          cidr_ = other.cidr_;
          onChanged();
        }
        if (!other.except_.isEmpty()) {
          if (except_.isEmpty()) {
            except_ = other.except_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureExceptIsMutable();
            except_.addAll(other.except_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IPBlock parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IPBlock) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object cidr_ = "";
      /**
       *
       *
       * <pre>
       * CIDR is a string representing the IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * </pre>
       *
       * <code>optional string cidr = 1;</code>
       */
      public boolean hasCidr() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * CIDR is a string representing the IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * </pre>
       *
       * <code>optional string cidr = 1;</code>
       */
      public java.lang.String getCidr() {
        java.lang.Object ref = cidr_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            cidr_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * CIDR is a string representing the IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * </pre>
       *
       * <code>optional string cidr = 1;</code>
       */
      public com.google.protobuf.ByteString getCidrBytes() {
        java.lang.Object ref = cidr_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          cidr_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * CIDR is a string representing the IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * </pre>
       *
       * <code>optional string cidr = 1;</code>
       */
      public Builder setCidr(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        cidr_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CIDR is a string representing the IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * </pre>
       *
       * <code>optional string cidr = 1;</code>
       */
      public Builder clearCidr() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cidr_ = getDefaultInstance().getCidr();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * CIDR is a string representing the IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * </pre>
       *
       * <code>optional string cidr = 1;</code>
       */
      public Builder setCidrBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        cidr_ = value;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList except_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureExceptIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          except_ = new com.google.protobuf.LazyStringArrayList(except_);
          bitField0_ |= 0x00000002;
        }
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public com.google.protobuf.ProtocolStringList getExceptList() {
        return except_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public int getExceptCount() {
        return except_.size();
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public java.lang.String getExcept(int index) {
        return except_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public com.google.protobuf.ByteString getExceptBytes(int index) {
        return except_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public Builder setExcept(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExceptIsMutable();
        except_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public Builder addExcept(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExceptIsMutable();
        except_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public Builder addAllExcept(java.lang.Iterable<java.lang.String> values) {
        ensureExceptIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, except_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public Builder clearExcept() {
        except_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Except is a slice of CIDRs that should not be included within an IP Block
       * Valid examples are "192.168.1.1/24" or "2001:db9::/64"
       * Except values will be rejected if they are outside the CIDR range
       * +optional
       * </pre>
       *
       * <code>repeated string except = 2;</code>
       */
      public Builder addExceptBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureExceptIsMutable();
        except_.add(value);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IPBlock)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IPBlock)
    private static final io.kubernetes.client.proto.V1Networking.IPBlock DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IPBlock();
    }

    public static io.kubernetes.client.proto.V1Networking.IPBlock getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IPBlock> PARSER =
        new com.google.protobuf.AbstractParser<IPBlock>() {
          @java.lang.Override
          public IPBlock parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IPBlock(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IPBlock> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IPBlock> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IPBlock getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.Ingress)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Spec is the desired state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressSpec getSpec();
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressSpecOrBuilder getSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Status is the current state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
     */
    boolean hasStatus();
    /**
     *
     *
     * <pre>
     * Status is the current state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressStatus getStatus();
    /**
     *
     *
     * <pre>
     * Status is the current state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressStatusOrBuilder getStatusOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Ingress is a collection of rules that allow inbound connections to reach the
   * endpoints defined by a backend. An Ingress can be configured to give services
   * externally-reachable urls, load balance traffic, terminate SSL, offer name
   * based virtual hosting etc.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.Ingress}
   */
  public static final class Ingress extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.Ingress)
      IngressOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use Ingress.newBuilder() to construct.
    private Ingress(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Ingress() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private Ingress(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Networking.IngressSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressSpec.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1Networking.IngressStatus.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = status_.toBuilder();
                }
                status_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressStatus.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(status_);
                  status_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_Ingress_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_Ingress_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.Ingress.class,
              io.kubernetes.client.proto.V1Networking.Ingress.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Networking.IngressSpec spec_;
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressSpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressSpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressSpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressSpec.getDefaultInstance()
          : spec_;
    }

    public static final int STATUS_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1Networking.IngressStatus status_;
    /**
     *
     *
     * <pre>
     * Status is the current state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Status is the current state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressStatus getStatus() {
      return status_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressStatus.getDefaultInstance()
          : status_;
    }
    /**
     *
     *
     * <pre>
     * Status is the current state of the Ingress.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressStatusOrBuilder getStatusOrBuilder() {
      return status_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressStatus.getDefaultInstance()
          : status_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getStatus());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStatus());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.Ingress)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.Ingress other =
          (io.kubernetes.client.proto.V1Networking.Ingress) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && (hasStatus() == other.hasStatus());
      if (hasStatus()) {
        result = result && getStatus().equals(other.getStatus());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      if (hasStatus()) {
        hash = (37 * hash) + STATUS_FIELD_NUMBER;
        hash = (53 * hash) + getStatus().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Networking.Ingress prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Ingress is a collection of rules that allow inbound connections to reach the
     * endpoints defined by a backend. An Ingress can be configured to give services
     * externally-reachable urls, load balance traffic, terminate SSL, offer name
     * based virtual hosting etc.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.Ingress}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.Ingress)
        io.kubernetes.client.proto.V1Networking.IngressOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_Ingress_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_Ingress_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.Ingress.class,
                io.kubernetes.client.proto.V1Networking.Ingress.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.Ingress.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
          getStatusFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (statusBuilder_ == null) {
          status_ = null;
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_Ingress_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.Ingress getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.Ingress.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.Ingress build() {
        io.kubernetes.client.proto.V1Networking.Ingress result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.Ingress buildPartial() {
        io.kubernetes.client.proto.V1Networking.Ingress result =
            new io.kubernetes.client.proto.V1Networking.Ingress(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (statusBuilder_ == null) {
          result.status_ = status_;
        } else {
          result.status_ = statusBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.Ingress) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.Ingress) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.Ingress other) {
        if (other == io.kubernetes.client.proto.V1Networking.Ingress.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        if (other.hasStatus()) {
          mergeStatus(other.getStatus());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.Ingress parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.Ingress) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1Networking.IngressSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressSpec,
              io.kubernetes.client.proto.V1Networking.IngressSpec.Builder,
              io.kubernetes.client.proto.V1Networking.IngressSpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1Networking.IngressSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1Networking.IngressSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1Networking.IngressSpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_
                  != io.kubernetes.client.proto.V1Networking.IngressSpec.getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1Networking.IngressSpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressSpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressSpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressSpec,
              io.kubernetes.client.proto.V1Networking.IngressSpec.Builder,
              io.kubernetes.client.proto.V1Networking.IngressSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressSpec,
                  io.kubernetes.client.proto.V1Networking.IngressSpec.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      private io.kubernetes.client.proto.V1Networking.IngressStatus status_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressStatus,
              io.kubernetes.client.proto.V1Networking.IngressStatus.Builder,
              io.kubernetes.client.proto.V1Networking.IngressStatusOrBuilder>
          statusBuilder_;
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      public boolean hasStatus() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressStatus getStatus() {
        if (statusBuilder_ == null) {
          return status_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressStatus.getDefaultInstance()
              : status_;
        } else {
          return statusBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      public Builder setStatus(io.kubernetes.client.proto.V1Networking.IngressStatus value) {
        if (statusBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          status_ = value;
          onChanged();
        } else {
          statusBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      public Builder setStatus(
          io.kubernetes.client.proto.V1Networking.IngressStatus.Builder builderForValue) {
        if (statusBuilder_ == null) {
          status_ = builderForValue.build();
          onChanged();
        } else {
          statusBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      public Builder mergeStatus(io.kubernetes.client.proto.V1Networking.IngressStatus value) {
        if (statusBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)
              && status_ != null
              && status_
                  != io.kubernetes.client.proto.V1Networking.IngressStatus.getDefaultInstance()) {
            status_ =
                io.kubernetes.client.proto.V1Networking.IngressStatus.newBuilder(status_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            status_ = value;
          }
          onChanged();
        } else {
          statusBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      public Builder clearStatus() {
        if (statusBuilder_ == null) {
          status_ = null;
          onChanged();
        } else {
          statusBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressStatus.Builder getStatusBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getStatusFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressStatusOrBuilder getStatusOrBuilder() {
        if (statusBuilder_ != null) {
          return statusBuilder_.getMessageOrBuilder();
        } else {
          return status_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressStatus.getDefaultInstance()
              : status_;
        }
      }
      /**
       *
       *
       * <pre>
       * Status is the current state of the Ingress.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressStatus status = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressStatus,
              io.kubernetes.client.proto.V1Networking.IngressStatus.Builder,
              io.kubernetes.client.proto.V1Networking.IngressStatusOrBuilder>
          getStatusFieldBuilder() {
        if (statusBuilder_ == null) {
          statusBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressStatus,
                  io.kubernetes.client.proto.V1Networking.IngressStatus.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressStatusOrBuilder>(
                  getStatus(), getParentForChildren(), isClean());
          status_ = null;
        }
        return statusBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.Ingress)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.Ingress)
    private static final io.kubernetes.client.proto.V1Networking.Ingress DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.Ingress();
    }

    public static io.kubernetes.client.proto.V1Networking.Ingress getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<Ingress> PARSER =
        new com.google.protobuf.AbstractParser<Ingress>() {
          @java.lang.Override
          public Ingress parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new Ingress(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<Ingress> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Ingress> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.Ingress getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressBackendOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressBackend)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Service references a Service as a Backend.
     * This is a mutually exclusive setting with "Resource".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
     */
    boolean hasService();
    /**
     *
     *
     * <pre>
     * Service references a Service as a Backend.
     * This is a mutually exclusive setting with "Resource".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressServiceBackend getService();
    /**
     *
     *
     * <pre>
     * Service references a Service as a Backend.
     * This is a mutually exclusive setting with "Resource".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressServiceBackendOrBuilder getServiceOrBuilder();

    /**
     *
     *
     * <pre>
     * Resource is an ObjectRef to another Kubernetes resource in the namespace
     * of the Ingress object. If resource is specified, a service.Name and
     * service.Port must not be specified.
     * This is a mutually exclusive setting with "Service".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
     */
    boolean hasResource();
    /**
     *
     *
     * <pre>
     * Resource is an ObjectRef to another Kubernetes resource in the namespace
     * of the Ingress object. If resource is specified, a service.Name and
     * service.Port must not be specified.
     * This is a mutually exclusive setting with "Service".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
     */
    io.kubernetes.client.proto.V1.TypedLocalObjectReference getResource();
    /**
     *
     *
     * <pre>
     * Resource is an ObjectRef to another Kubernetes resource in the namespace
     * of the Ingress object. If resource is specified, a service.Name and
     * service.Port must not be specified.
     * This is a mutually exclusive setting with "Service".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
     */
    io.kubernetes.client.proto.V1.TypedLocalObjectReferenceOrBuilder getResourceOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * IngressBackend describes all endpoints for a given service and port.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressBackend}
   */
  public static final class IngressBackend extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressBackend)
      IngressBackendOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressBackend.newBuilder() to construct.
    private IngressBackend(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressBackend() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressBackend(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26:
              {
                io.kubernetes.client.proto.V1.TypedLocalObjectReference.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = resource_.toBuilder();
                }
                resource_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1.TypedLocalObjectReference.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(resource_);
                  resource_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 34:
              {
                io.kubernetes.client.proto.V1Networking.IngressServiceBackend.Builder subBuilder =
                    null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = service_.toBuilder();
                }
                service_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressServiceBackend.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(service_);
                  service_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressBackend_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressBackend_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressBackend.class,
              io.kubernetes.client.proto.V1Networking.IngressBackend.Builder.class);
    }

    private int bitField0_;
    public static final int SERVICE_FIELD_NUMBER = 4;
    private io.kubernetes.client.proto.V1Networking.IngressServiceBackend service_;
    /**
     *
     *
     * <pre>
     * Service references a Service as a Backend.
     * This is a mutually exclusive setting with "Resource".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
     */
    public boolean hasService() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Service references a Service as a Backend.
     * This is a mutually exclusive setting with "Resource".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressServiceBackend getService() {
      return service_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressServiceBackend.getDefaultInstance()
          : service_;
    }
    /**
     *
     *
     * <pre>
     * Service references a Service as a Backend.
     * This is a mutually exclusive setting with "Resource".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressServiceBackendOrBuilder
        getServiceOrBuilder() {
      return service_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressServiceBackend.getDefaultInstance()
          : service_;
    }

    public static final int RESOURCE_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1.TypedLocalObjectReference resource_;
    /**
     *
     *
     * <pre>
     * Resource is an ObjectRef to another Kubernetes resource in the namespace
     * of the Ingress object. If resource is specified, a service.Name and
     * service.Port must not be specified.
     * This is a mutually exclusive setting with "Service".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
     */
    public boolean hasResource() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Resource is an ObjectRef to another Kubernetes resource in the namespace
     * of the Ingress object. If resource is specified, a service.Name and
     * service.Port must not be specified.
     * This is a mutually exclusive setting with "Service".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
     */
    public io.kubernetes.client.proto.V1.TypedLocalObjectReference getResource() {
      return resource_ == null
          ? io.kubernetes.client.proto.V1.TypedLocalObjectReference.getDefaultInstance()
          : resource_;
    }
    /**
     *
     *
     * <pre>
     * Resource is an ObjectRef to another Kubernetes resource in the namespace
     * of the Ingress object. If resource is specified, a service.Name and
     * service.Port must not be specified.
     * This is a mutually exclusive setting with "Service".
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
     */
    public io.kubernetes.client.proto.V1.TypedLocalObjectReferenceOrBuilder getResourceOrBuilder() {
      return resource_ == null
          ? io.kubernetes.client.proto.V1.TypedLocalObjectReference.getDefaultInstance()
          : resource_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(3, getResource());
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(4, getService());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getResource());
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getService());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressBackend)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressBackend other =
          (io.kubernetes.client.proto.V1Networking.IngressBackend) obj;

      boolean result = true;
      result = result && (hasService() == other.hasService());
      if (hasService()) {
        result = result && getService().equals(other.getService());
      }
      result = result && (hasResource() == other.hasResource());
      if (hasResource()) {
        result = result && getResource().equals(other.getResource());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasService()) {
        hash = (37 * hash) + SERVICE_FIELD_NUMBER;
        hash = (53 * hash) + getService().hashCode();
      }
      if (hasResource()) {
        hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
        hash = (53 * hash) + getResource().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressBackend prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressBackend describes all endpoints for a given service and port.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressBackend}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressBackend)
        io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressBackend_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressBackend_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressBackend.class,
                io.kubernetes.client.proto.V1Networking.IngressBackend.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressBackend.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getServiceFieldBuilder();
          getResourceFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (serviceBuilder_ == null) {
          service_ = null;
        } else {
          serviceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (resourceBuilder_ == null) {
          resource_ = null;
        } else {
          resourceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressBackend_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressBackend getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressBackend build() {
        io.kubernetes.client.proto.V1Networking.IngressBackend result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressBackend buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressBackend result =
            new io.kubernetes.client.proto.V1Networking.IngressBackend(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (serviceBuilder_ == null) {
          result.service_ = service_;
        } else {
          result.service_ = serviceBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (resourceBuilder_ == null) {
          result.resource_ = resource_;
        } else {
          result.resource_ = resourceBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressBackend) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressBackend) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressBackend other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance())
          return this;
        if (other.hasService()) {
          mergeService(other.getService());
        }
        if (other.hasResource()) {
          mergeResource(other.getResource());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressBackend parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressBackend) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.V1Networking.IngressServiceBackend service_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressServiceBackend,
              io.kubernetes.client.proto.V1Networking.IngressServiceBackend.Builder,
              io.kubernetes.client.proto.V1Networking.IngressServiceBackendOrBuilder>
          serviceBuilder_;
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      public boolean hasService() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressServiceBackend getService() {
        if (serviceBuilder_ == null) {
          return service_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressServiceBackend.getDefaultInstance()
              : service_;
        } else {
          return serviceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      public Builder setService(
          io.kubernetes.client.proto.V1Networking.IngressServiceBackend value) {
        if (serviceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          service_ = value;
          onChanged();
        } else {
          serviceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      public Builder setService(
          io.kubernetes.client.proto.V1Networking.IngressServiceBackend.Builder builderForValue) {
        if (serviceBuilder_ == null) {
          service_ = builderForValue.build();
          onChanged();
        } else {
          serviceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      public Builder mergeService(
          io.kubernetes.client.proto.V1Networking.IngressServiceBackend value) {
        if (serviceBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && service_ != null
              && service_
                  != io.kubernetes.client.proto.V1Networking.IngressServiceBackend
                      .getDefaultInstance()) {
            service_ =
                io.kubernetes.client.proto.V1Networking.IngressServiceBackend.newBuilder(service_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            service_ = value;
          }
          onChanged();
        } else {
          serviceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      public Builder clearService() {
        if (serviceBuilder_ == null) {
          service_ = null;
          onChanged();
        } else {
          serviceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressServiceBackend.Builder
          getServiceBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getServiceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressServiceBackendOrBuilder
          getServiceOrBuilder() {
        if (serviceBuilder_ != null) {
          return serviceBuilder_.getMessageOrBuilder();
        } else {
          return service_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressServiceBackend.getDefaultInstance()
              : service_;
        }
      }
      /**
       *
       *
       * <pre>
       * Service references a Service as a Backend.
       * This is a mutually exclusive setting with "Resource".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressServiceBackend service = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressServiceBackend,
              io.kubernetes.client.proto.V1Networking.IngressServiceBackend.Builder,
              io.kubernetes.client.proto.V1Networking.IngressServiceBackendOrBuilder>
          getServiceFieldBuilder() {
        if (serviceBuilder_ == null) {
          serviceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressServiceBackend,
                  io.kubernetes.client.proto.V1Networking.IngressServiceBackend.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressServiceBackendOrBuilder>(
                  getService(), getParentForChildren(), isClean());
          service_ = null;
        }
        return serviceBuilder_;
      }

      private io.kubernetes.client.proto.V1.TypedLocalObjectReference resource_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.TypedLocalObjectReference,
              io.kubernetes.client.proto.V1.TypedLocalObjectReference.Builder,
              io.kubernetes.client.proto.V1.TypedLocalObjectReferenceOrBuilder>
          resourceBuilder_;
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      public boolean hasResource() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      public io.kubernetes.client.proto.V1.TypedLocalObjectReference getResource() {
        if (resourceBuilder_ == null) {
          return resource_ == null
              ? io.kubernetes.client.proto.V1.TypedLocalObjectReference.getDefaultInstance()
              : resource_;
        } else {
          return resourceBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      public Builder setResource(io.kubernetes.client.proto.V1.TypedLocalObjectReference value) {
        if (resourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          resource_ = value;
          onChanged();
        } else {
          resourceBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      public Builder setResource(
          io.kubernetes.client.proto.V1.TypedLocalObjectReference.Builder builderForValue) {
        if (resourceBuilder_ == null) {
          resource_ = builderForValue.build();
          onChanged();
        } else {
          resourceBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      public Builder mergeResource(io.kubernetes.client.proto.V1.TypedLocalObjectReference value) {
        if (resourceBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && resource_ != null
              && resource_
                  != io.kubernetes.client.proto.V1.TypedLocalObjectReference.getDefaultInstance()) {
            resource_ =
                io.kubernetes.client.proto.V1.TypedLocalObjectReference.newBuilder(resource_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            resource_ = value;
          }
          onChanged();
        } else {
          resourceBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      public Builder clearResource() {
        if (resourceBuilder_ == null) {
          resource_ = null;
          onChanged();
        } else {
          resourceBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      public io.kubernetes.client.proto.V1.TypedLocalObjectReference.Builder getResourceBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getResourceFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      public io.kubernetes.client.proto.V1.TypedLocalObjectReferenceOrBuilder
          getResourceOrBuilder() {
        if (resourceBuilder_ != null) {
          return resourceBuilder_.getMessageOrBuilder();
        } else {
          return resource_ == null
              ? io.kubernetes.client.proto.V1.TypedLocalObjectReference.getDefaultInstance()
              : resource_;
        }
      }
      /**
       *
       *
       * <pre>
       * Resource is an ObjectRef to another Kubernetes resource in the namespace
       * of the Ingress object. If resource is specified, a service.Name and
       * service.Port must not be specified.
       * This is a mutually exclusive setting with "Service".
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.TypedLocalObjectReference resource = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.TypedLocalObjectReference,
              io.kubernetes.client.proto.V1.TypedLocalObjectReference.Builder,
              io.kubernetes.client.proto.V1.TypedLocalObjectReferenceOrBuilder>
          getResourceFieldBuilder() {
        if (resourceBuilder_ == null) {
          resourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1.TypedLocalObjectReference,
                  io.kubernetes.client.proto.V1.TypedLocalObjectReference.Builder,
                  io.kubernetes.client.proto.V1.TypedLocalObjectReferenceOrBuilder>(
                  getResource(), getParentForChildren(), isClean());
          resource_ = null;
        }
        return resourceBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressBackend)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressBackend)
    private static final io.kubernetes.client.proto.V1Networking.IngressBackend DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressBackend();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressBackend getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressBackend> PARSER =
        new com.google.protobuf.AbstractParser<IngressBackend>() {
          @java.lang.Override
          public IngressBackend parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressBackend(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressBackend> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressBackend> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressBackend getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressClassOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressClass)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Spec is the desired state of the IngressClass.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the IngressClass.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressClassSpec getSpec();
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the IngressClass.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressClassSpecOrBuilder getSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * IngressClass represents the class of the Ingress, referenced by the Ingress
   * Spec. The `ingressclass.kubernetes.io/is-default-class` annotation can be
   * used to indicate that an IngressClass should be considered default. When a
   * single IngressClass resource has this annotation set to true, new Ingress
   * resources without a class specified will be assigned this default class.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressClass}
   */
  public static final class IngressClass extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressClass)
      IngressClassOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressClass.newBuilder() to construct.
    private IngressClass(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressClass() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressClass(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Networking.IngressClassSpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressClassSpec.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressClass_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressClass_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressClass.class,
              io.kubernetes.client.proto.V1Networking.IngressClass.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Networking.IngressClassSpec spec_;
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the IngressClass.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the IngressClass.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressClassSpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressClassSpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * Spec is the desired state of the IngressClass.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressClassSpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressClassSpec.getDefaultInstance()
          : spec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressClass)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressClass other =
          (io.kubernetes.client.proto.V1Networking.IngressClass) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressClass prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressClass represents the class of the Ingress, referenced by the Ingress
     * Spec. The `ingressclass.kubernetes.io/is-default-class` annotation can be
     * used to indicate that an IngressClass should be considered default. When a
     * single IngressClass resource has this annotation set to true, new Ingress
     * resources without a class specified will be assigned this default class.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressClass}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressClass)
        io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClass_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClass_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressClass.class,
                io.kubernetes.client.proto.V1Networking.IngressClass.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressClass.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClass_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClass getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressClass.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClass build() {
        io.kubernetes.client.proto.V1Networking.IngressClass result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClass buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressClass result =
            new io.kubernetes.client.proto.V1Networking.IngressClass(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressClass) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressClass) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressClass other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressClass.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressClass parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressClass) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1Networking.IngressClassSpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressClassSpec,
              io.kubernetes.client.proto.V1Networking.IngressClassSpec.Builder,
              io.kubernetes.client.proto.V1Networking.IngressClassSpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClassSpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressClassSpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1Networking.IngressClassSpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1Networking.IngressClassSpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1Networking.IngressClassSpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_
                  != io.kubernetes.client.proto.V1Networking.IngressClassSpec
                      .getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1Networking.IngressClassSpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClassSpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClassSpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressClassSpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Spec is the desired state of the IngressClass.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassSpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressClassSpec,
              io.kubernetes.client.proto.V1Networking.IngressClassSpec.Builder,
              io.kubernetes.client.proto.V1Networking.IngressClassSpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressClassSpec,
                  io.kubernetes.client.proto.V1Networking.IngressClassSpec.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressClassSpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressClass)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressClass)
    private static final io.kubernetes.client.proto.V1Networking.IngressClass DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressClass();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClass getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressClass> PARSER =
        new com.google.protobuf.AbstractParser<IngressClass>() {
          @java.lang.Override
          public IngressClass parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressClass(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressClass> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressClass> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressClass getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressClassListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressClassList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.IngressClass> getItemsList();
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressClass getItems(int index);
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * IngressClassList is a collection of IngressClasses.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressClassList}
   */
  public static final class IngressClassList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressClassList)
      IngressClassListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressClassList.newBuilder() to construct.
    private IngressClassList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressClassList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressClassList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Networking.IngressClass>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressClass.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressClassList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressClassList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressClassList.class,
              io.kubernetes.client.proto.V1Networking.IngressClassList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Networking.IngressClass> items_;
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.IngressClass> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressClass getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Items is the list of IngressClasses.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder getItemsOrBuilder(
        int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressClassList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressClassList other =
          (io.kubernetes.client.proto.V1Networking.IngressClassList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressClassList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressClassList is a collection of IngressClasses.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressClassList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressClassList)
        io.kubernetes.client.proto.V1Networking.IngressClassListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressClassList.class,
                io.kubernetes.client.proto.V1Networking.IngressClassList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressClassList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressClassList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassList build() {
        io.kubernetes.client.proto.V1Networking.IngressClassList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassList buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressClassList result =
            new io.kubernetes.client.proto.V1Networking.IngressClassList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressClassList) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressClassList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressClassList other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressClassList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressClassList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressClassList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Networking.IngressClass> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.IngressClass>(items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressClass,
              io.kubernetes.client.proto.V1Networking.IngressClass.Builder,
              io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.IngressClass> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClass getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Networking.IngressClass value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Networking.IngressClass.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1Networking.IngressClass value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Networking.IngressClass value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder addItems(
          io.kubernetes.client.proto.V1Networking.IngressClass.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Networking.IngressClass.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.IngressClass>
              values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClass.Builder getItemsBuilder(
          int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder getItemsOrBuilder(
          int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClass.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Networking.IngressClass.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClass.Builder addItemsBuilder(
          int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1Networking.IngressClass.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of IngressClasses.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressClass items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.IngressClass.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressClass,
              io.kubernetes.client.proto.V1Networking.IngressClass.Builder,
              io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressClass,
                  io.kubernetes.client.proto.V1Networking.IngressClass.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressClassOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressClassList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressClassList)
    private static final io.kubernetes.client.proto.V1Networking.IngressClassList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressClassList();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressClassList> PARSER =
        new com.google.protobuf.AbstractParser<IngressClassList>() {
          @java.lang.Override
          public IngressClassList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressClassList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressClassList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressClassList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressClassList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressClassParametersReferenceOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressClassParametersReference)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * APIGroup is the group for the resource being referenced. If APIGroup is
     * not specified, the specified Kind must be in the core API group. For any
     * other third-party types, APIGroup is required.
     * +optional
     * </pre>
     *
     * <code>optional string aPIGroup = 1;</code>
     */
    boolean hasAPIGroup();
    /**
     *
     *
     * <pre>
     * APIGroup is the group for the resource being referenced. If APIGroup is
     * not specified, the specified Kind must be in the core API group. For any
     * other third-party types, APIGroup is required.
     * +optional
     * </pre>
     *
     * <code>optional string aPIGroup = 1;</code>
     */
    java.lang.String getAPIGroup();
    /**
     *
     *
     * <pre>
     * APIGroup is the group for the resource being referenced. If APIGroup is
     * not specified, the specified Kind must be in the core API group. For any
     * other third-party types, APIGroup is required.
     * +optional
     * </pre>
     *
     * <code>optional string aPIGroup = 1;</code>
     */
    com.google.protobuf.ByteString getAPIGroupBytes();

    /**
     *
     *
     * <pre>
     * Kind is the type of resource being referenced.
     * </pre>
     *
     * <code>optional string kind = 2;</code>
     */
    boolean hasKind();
    /**
     *
     *
     * <pre>
     * Kind is the type of resource being referenced.
     * </pre>
     *
     * <code>optional string kind = 2;</code>
     */
    java.lang.String getKind();
    /**
     *
     *
     * <pre>
     * Kind is the type of resource being referenced.
     * </pre>
     *
     * <code>optional string kind = 2;</code>
     */
    com.google.protobuf.ByteString getKindBytes();

    /**
     *
     *
     * <pre>
     * Name is the name of resource being referenced.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    boolean hasName();
    /**
     *
     *
     * <pre>
     * Name is the name of resource being referenced.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Name is the name of resource being referenced.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Scope represents if this refers to a cluster or namespace scoped resource.
     * This may be set to "Cluster" (default) or "Namespace".
     * Field can be enabled with IngressClassNamespacedParams feature gate.
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string scope = 4;</code>
     */
    boolean hasScope();
    /**
     *
     *
     * <pre>
     * Scope represents if this refers to a cluster or namespace scoped resource.
     * This may be set to "Cluster" (default) or "Namespace".
     * Field can be enabled with IngressClassNamespacedParams feature gate.
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string scope = 4;</code>
     */
    java.lang.String getScope();
    /**
     *
     *
     * <pre>
     * Scope represents if this refers to a cluster or namespace scoped resource.
     * This may be set to "Cluster" (default) or "Namespace".
     * Field can be enabled with IngressClassNamespacedParams feature gate.
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string scope = 4;</code>
     */
    com.google.protobuf.ByteString getScopeBytes();

    /**
     *
     *
     * <pre>
     * Namespace is the namespace of the resource being referenced. This field is
     * required when scope is set to "Namespace" and must be unset when scope is set to
     * "Cluster".
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string namespace = 5;</code>
     */
    boolean hasNamespace();
    /**
     *
     *
     * <pre>
     * Namespace is the namespace of the resource being referenced. This field is
     * required when scope is set to "Namespace" and must be unset when scope is set to
     * "Cluster".
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string namespace = 5;</code>
     */
    java.lang.String getNamespace();
    /**
     *
     *
     * <pre>
     * Namespace is the namespace of the resource being referenced. This field is
     * required when scope is set to "Namespace" and must be unset when scope is set to
     * "Cluster".
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string namespace = 5;</code>
     */
    com.google.protobuf.ByteString getNamespaceBytes();
  }
  /**
   *
   *
   * <pre>
   * IngressClassParametersReference identifies an API object. This can be used
   * to specify a cluster or namespace-scoped resource.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressClassParametersReference}
   */
  public static final class IngressClassParametersReference
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressClassParametersReference)
      IngressClassParametersReferenceOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressClassParametersReference.newBuilder() to construct.
    private IngressClassParametersReference(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressClassParametersReference() {
      aPIGroup_ = "";
      kind_ = "";
      name_ = "";
      scope_ = "";
      namespace_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressClassParametersReference(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                aPIGroup_ = bs;
                break;
              }
            case 18:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000002;
                kind_ = bs;
                break;
              }
            case 26:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000004;
                name_ = bs;
                break;
              }
            case 34:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000008;
                scope_ = bs;
                break;
              }
            case 42:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000010;
                namespace_ = bs;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressClassParametersReference_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressClassParametersReference_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.class,
              io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.Builder
                  .class);
    }

    private int bitField0_;
    public static final int APIGROUP_FIELD_NUMBER = 1;
    private volatile java.lang.Object aPIGroup_;
    /**
     *
     *
     * <pre>
     * APIGroup is the group for the resource being referenced. If APIGroup is
     * not specified, the specified Kind must be in the core API group. For any
     * other third-party types, APIGroup is required.
     * +optional
     * </pre>
     *
     * <code>optional string aPIGroup = 1;</code>
     */
    public boolean hasAPIGroup() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * APIGroup is the group for the resource being referenced. If APIGroup is
     * not specified, the specified Kind must be in the core API group. For any
     * other third-party types, APIGroup is required.
     * +optional
     * </pre>
     *
     * <code>optional string aPIGroup = 1;</code>
     */
    public java.lang.String getAPIGroup() {
      java.lang.Object ref = aPIGroup_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          aPIGroup_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * APIGroup is the group for the resource being referenced. If APIGroup is
     * not specified, the specified Kind must be in the core API group. For any
     * other third-party types, APIGroup is required.
     * +optional
     * </pre>
     *
     * <code>optional string aPIGroup = 1;</code>
     */
    public com.google.protobuf.ByteString getAPIGroupBytes() {
      java.lang.Object ref = aPIGroup_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        aPIGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int KIND_FIELD_NUMBER = 2;
    private volatile java.lang.Object kind_;
    /**
     *
     *
     * <pre>
     * Kind is the type of resource being referenced.
     * </pre>
     *
     * <code>optional string kind = 2;</code>
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Kind is the type of resource being referenced.
     * </pre>
     *
     * <code>optional string kind = 2;</code>
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          kind_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Kind is the type of resource being referenced.
     * </pre>
     *
     * <code>optional string kind = 2;</code>
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAME_FIELD_NUMBER = 3;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Name is the name of resource being referenced.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * Name is the name of resource being referenced.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name is the name of resource being referenced.
     * </pre>
     *
     * <code>optional string name = 3;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCOPE_FIELD_NUMBER = 4;
    private volatile java.lang.Object scope_;
    /**
     *
     *
     * <pre>
     * Scope represents if this refers to a cluster or namespace scoped resource.
     * This may be set to "Cluster" (default) or "Namespace".
     * Field can be enabled with IngressClassNamespacedParams feature gate.
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string scope = 4;</code>
     */
    public boolean hasScope() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     *
     *
     * <pre>
     * Scope represents if this refers to a cluster or namespace scoped resource.
     * This may be set to "Cluster" (default) or "Namespace".
     * Field can be enabled with IngressClassNamespacedParams feature gate.
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string scope = 4;</code>
     */
    public java.lang.String getScope() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          scope_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Scope represents if this refers to a cluster or namespace scoped resource.
     * This may be set to "Cluster" (default) or "Namespace".
     * Field can be enabled with IngressClassNamespacedParams feature gate.
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string scope = 4;</code>
     */
    public com.google.protobuf.ByteString getScopeBytes() {
      java.lang.Object ref = scope_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        scope_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int NAMESPACE_FIELD_NUMBER = 5;
    private volatile java.lang.Object namespace_;
    /**
     *
     *
     * <pre>
     * Namespace is the namespace of the resource being referenced. This field is
     * required when scope is set to "Namespace" and must be unset when scope is set to
     * "Cluster".
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string namespace = 5;</code>
     */
    public boolean hasNamespace() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     *
     *
     * <pre>
     * Namespace is the namespace of the resource being referenced. This field is
     * required when scope is set to "Namespace" and must be unset when scope is set to
     * "Cluster".
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string namespace = 5;</code>
     */
    public java.lang.String getNamespace() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          namespace_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Namespace is the namespace of the resource being referenced. This field is
     * required when scope is set to "Namespace" and must be unset when scope is set to
     * "Cluster".
     * +optional
     * +featureGate=IngressClassNamespacedParams
     * </pre>
     *
     * <code>optional string namespace = 5;</code>
     */
    public com.google.protobuf.ByteString getNamespaceBytes() {
      java.lang.Object ref = namespace_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        namespace_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, aPIGroup_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, kind_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, name_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, scope_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, namespace_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, aPIGroup_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, kind_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, name_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, scope_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, namespace_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof io.kubernetes.client.proto.V1Networking.IngressClassParametersReference)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressClassParametersReference other =
          (io.kubernetes.client.proto.V1Networking.IngressClassParametersReference) obj;

      boolean result = true;
      result = result && (hasAPIGroup() == other.hasAPIGroup());
      if (hasAPIGroup()) {
        result = result && getAPIGroup().equals(other.getAPIGroup());
      }
      result = result && (hasKind() == other.hasKind());
      if (hasKind()) {
        result = result && getKind().equals(other.getKind());
      }
      result = result && (hasName() == other.hasName());
      if (hasName()) {
        result = result && getName().equals(other.getName());
      }
      result = result && (hasScope() == other.hasScope());
      if (hasScope()) {
        result = result && getScope().equals(other.getScope());
      }
      result = result && (hasNamespace() == other.hasNamespace());
      if (hasNamespace()) {
        result = result && getNamespace().equals(other.getNamespace());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasAPIGroup()) {
        hash = (37 * hash) + APIGROUP_FIELD_NUMBER;
        hash = (53 * hash) + getAPIGroup().hashCode();
      }
      if (hasKind()) {
        hash = (37 * hash) + KIND_FIELD_NUMBER;
        hash = (53 * hash) + getKind().hashCode();
      }
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (hasScope()) {
        hash = (37 * hash) + SCOPE_FIELD_NUMBER;
        hash = (53 * hash) + getScope().hashCode();
      }
      if (hasNamespace()) {
        hash = (37 * hash) + NAMESPACE_FIELD_NUMBER;
        hash = (53 * hash) + getNamespace().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressClassParametersReference prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressClassParametersReference identifies an API object. This can be used
     * to specify a cluster or namespace-scoped resource.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressClassParametersReference}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressClassParametersReference)
        io.kubernetes.client.proto.V1Networking.IngressClassParametersReferenceOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassParametersReference_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassParametersReference_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.class,
                io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.Builder
                    .class);
      }

      // Construct using
      // io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        aPIGroup_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        kind_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000004);
        scope_ = "";
        bitField0_ = (bitField0_ & ~0x00000008);
        namespace_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassParametersReference_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
            .getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassParametersReference build() {
        io.kubernetes.client.proto.V1Networking.IngressClassParametersReference result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
          buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressClassParametersReference result =
            new io.kubernetes.client.proto.V1Networking.IngressClassParametersReference(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.aPIGroup_ = aPIGroup_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.kind_ = kind_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.scope_ = scope_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.namespace_ = namespace_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof io.kubernetes.client.proto.V1Networking.IngressClassParametersReference) {
          return mergeFrom(
              (io.kubernetes.client.proto.V1Networking.IngressClassParametersReference) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          io.kubernetes.client.proto.V1Networking.IngressClassParametersReference other) {
        if (other
            == io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
                .getDefaultInstance()) return this;
        if (other.hasAPIGroup()) {
          bitField0_ |= 0x00000001;
          aPIGroup_ = other.aPIGroup_;
          onChanged();
        }
        if (other.hasKind()) {
          bitField0_ |= 0x00000002;
          kind_ = other.kind_;
          onChanged();
        }
        if (other.hasName()) {
          bitField0_ |= 0x00000004;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasScope()) {
          bitField0_ |= 0x00000008;
          scope_ = other.scope_;
          onChanged();
        }
        if (other.hasNamespace()) {
          bitField0_ |= 0x00000010;
          namespace_ = other.namespace_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parsedMessage =
            null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressClassParametersReference)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object aPIGroup_ = "";
      /**
       *
       *
       * <pre>
       * APIGroup is the group for the resource being referenced. If APIGroup is
       * not specified, the specified Kind must be in the core API group. For any
       * other third-party types, APIGroup is required.
       * +optional
       * </pre>
       *
       * <code>optional string aPIGroup = 1;</code>
       */
      public boolean hasAPIGroup() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * APIGroup is the group for the resource being referenced. If APIGroup is
       * not specified, the specified Kind must be in the core API group. For any
       * other third-party types, APIGroup is required.
       * +optional
       * </pre>
       *
       * <code>optional string aPIGroup = 1;</code>
       */
      public java.lang.String getAPIGroup() {
        java.lang.Object ref = aPIGroup_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            aPIGroup_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * APIGroup is the group for the resource being referenced. If APIGroup is
       * not specified, the specified Kind must be in the core API group. For any
       * other third-party types, APIGroup is required.
       * +optional
       * </pre>
       *
       * <code>optional string aPIGroup = 1;</code>
       */
      public com.google.protobuf.ByteString getAPIGroupBytes() {
        java.lang.Object ref = aPIGroup_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          aPIGroup_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * APIGroup is the group for the resource being referenced. If APIGroup is
       * not specified, the specified Kind must be in the core API group. For any
       * other third-party types, APIGroup is required.
       * +optional
       * </pre>
       *
       * <code>optional string aPIGroup = 1;</code>
       */
      public Builder setAPIGroup(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        aPIGroup_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * APIGroup is the group for the resource being referenced. If APIGroup is
       * not specified, the specified Kind must be in the core API group. For any
       * other third-party types, APIGroup is required.
       * +optional
       * </pre>
       *
       * <code>optional string aPIGroup = 1;</code>
       */
      public Builder clearAPIGroup() {
        bitField0_ = (bitField0_ & ~0x00000001);
        aPIGroup_ = getDefaultInstance().getAPIGroup();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * APIGroup is the group for the resource being referenced. If APIGroup is
       * not specified, the specified Kind must be in the core API group. For any
       * other third-party types, APIGroup is required.
       * +optional
       * </pre>
       *
       * <code>optional string aPIGroup = 1;</code>
       */
      public Builder setAPIGroupBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        aPIGroup_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object kind_ = "";
      /**
       *
       *
       * <pre>
       * Kind is the type of resource being referenced.
       * </pre>
       *
       * <code>optional string kind = 2;</code>
       */
      public boolean hasKind() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Kind is the type of resource being referenced.
       * </pre>
       *
       * <code>optional string kind = 2;</code>
       */
      public java.lang.String getKind() {
        java.lang.Object ref = kind_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            kind_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kind is the type of resource being referenced.
       * </pre>
       *
       * <code>optional string kind = 2;</code>
       */
      public com.google.protobuf.ByteString getKindBytes() {
        java.lang.Object ref = kind_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          kind_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Kind is the type of resource being referenced.
       * </pre>
       *
       * <code>optional string kind = 2;</code>
       */
      public Builder setKind(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        kind_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kind is the type of resource being referenced.
       * </pre>
       *
       * <code>optional string kind = 2;</code>
       */
      public Builder clearKind() {
        bitField0_ = (bitField0_ & ~0x00000002);
        kind_ = getDefaultInstance().getKind();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Kind is the type of resource being referenced.
       * </pre>
       *
       * <code>optional string kind = 2;</code>
       */
      public Builder setKindBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        kind_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name is the name of resource being referenced.
       * </pre>
       *
       * <code>optional string name = 3;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       *
       *
       * <pre>
       * Name is the name of resource being referenced.
       * </pre>
       *
       * <code>optional string name = 3;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name is the name of resource being referenced.
       * </pre>
       *
       * <code>optional string name = 3;</code>
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name is the name of resource being referenced.
       * </pre>
       *
       * <code>optional string name = 3;</code>
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name is the name of resource being referenced.
       * </pre>
       *
       * <code>optional string name = 3;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000004);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name is the name of resource being referenced.
       * </pre>
       *
       * <code>optional string name = 3;</code>
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000004;
        name_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object scope_ = "";
      /**
       *
       *
       * <pre>
       * Scope represents if this refers to a cluster or namespace scoped resource.
       * This may be set to "Cluster" (default) or "Namespace".
       * Field can be enabled with IngressClassNamespacedParams feature gate.
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string scope = 4;</code>
       */
      public boolean hasScope() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       *
       *
       * <pre>
       * Scope represents if this refers to a cluster or namespace scoped resource.
       * This may be set to "Cluster" (default) or "Namespace".
       * Field can be enabled with IngressClassNamespacedParams feature gate.
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string scope = 4;</code>
       */
      public java.lang.String getScope() {
        java.lang.Object ref = scope_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            scope_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Scope represents if this refers to a cluster or namespace scoped resource.
       * This may be set to "Cluster" (default) or "Namespace".
       * Field can be enabled with IngressClassNamespacedParams feature gate.
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string scope = 4;</code>
       */
      public com.google.protobuf.ByteString getScopeBytes() {
        java.lang.Object ref = scope_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          scope_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Scope represents if this refers to a cluster or namespace scoped resource.
       * This may be set to "Cluster" (default) or "Namespace".
       * Field can be enabled with IngressClassNamespacedParams feature gate.
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string scope = 4;</code>
       */
      public Builder setScope(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        scope_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Scope represents if this refers to a cluster or namespace scoped resource.
       * This may be set to "Cluster" (default) or "Namespace".
       * Field can be enabled with IngressClassNamespacedParams feature gate.
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string scope = 4;</code>
       */
      public Builder clearScope() {
        bitField0_ = (bitField0_ & ~0x00000008);
        scope_ = getDefaultInstance().getScope();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Scope represents if this refers to a cluster or namespace scoped resource.
       * This may be set to "Cluster" (default) or "Namespace".
       * Field can be enabled with IngressClassNamespacedParams feature gate.
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string scope = 4;</code>
       */
      public Builder setScopeBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        scope_ = value;
        onChanged();
        return this;
      }

      private java.lang.Object namespace_ = "";
      /**
       *
       *
       * <pre>
       * Namespace is the namespace of the resource being referenced. This field is
       * required when scope is set to "Namespace" and must be unset when scope is set to
       * "Cluster".
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string namespace = 5;</code>
       */
      public boolean hasNamespace() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       *
       *
       * <pre>
       * Namespace is the namespace of the resource being referenced. This field is
       * required when scope is set to "Namespace" and must be unset when scope is set to
       * "Cluster".
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string namespace = 5;</code>
       */
      public java.lang.String getNamespace() {
        java.lang.Object ref = namespace_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            namespace_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Namespace is the namespace of the resource being referenced. This field is
       * required when scope is set to "Namespace" and must be unset when scope is set to
       * "Cluster".
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string namespace = 5;</code>
       */
      public com.google.protobuf.ByteString getNamespaceBytes() {
        java.lang.Object ref = namespace_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          namespace_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Namespace is the namespace of the resource being referenced. This field is
       * required when scope is set to "Namespace" and must be unset when scope is set to
       * "Cluster".
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string namespace = 5;</code>
       */
      public Builder setNamespace(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        namespace_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Namespace is the namespace of the resource being referenced. This field is
       * required when scope is set to "Namespace" and must be unset when scope is set to
       * "Cluster".
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string namespace = 5;</code>
       */
      public Builder clearNamespace() {
        bitField0_ = (bitField0_ & ~0x00000010);
        namespace_ = getDefaultInstance().getNamespace();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Namespace is the namespace of the resource being referenced. This field is
       * required when scope is set to "Namespace" and must be unset when scope is set to
       * "Cluster".
       * +optional
       * +featureGate=IngressClassNamespacedParams
       * </pre>
       *
       * <code>optional string namespace = 5;</code>
       */
      public Builder setNamespaceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        namespace_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressClassParametersReference)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressClassParametersReference)
    private static final io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new io.kubernetes.client.proto.V1Networking.IngressClassParametersReference();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressClassParametersReference> PARSER =
        new com.google.protobuf.AbstractParser<IngressClassParametersReference>() {
          @java.lang.Override
          public IngressClassParametersReference parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressClassParametersReference(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressClassParametersReference> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressClassParametersReference> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressClassSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressClassSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Controller refers to the name of the controller that should handle this
     * class. This allows for different "flavors" that are controlled by the
     * same controller. For example, you may have different Parameters for the
     * same implementing controller. This should be specified as a
     * domain-prefixed path no more than 250 characters in length, e.g.
     * "acme.io/ingress-controller". This field is immutable.
     * </pre>
     *
     * <code>optional string controller = 1;</code>
     */
    boolean hasController();
    /**
     *
     *
     * <pre>
     * Controller refers to the name of the controller that should handle this
     * class. This allows for different "flavors" that are controlled by the
     * same controller. For example, you may have different Parameters for the
     * same implementing controller. This should be specified as a
     * domain-prefixed path no more than 250 characters in length, e.g.
     * "acme.io/ingress-controller". This field is immutable.
     * </pre>
     *
     * <code>optional string controller = 1;</code>
     */
    java.lang.String getController();
    /**
     *
     *
     * <pre>
     * Controller refers to the name of the controller that should handle this
     * class. This allows for different "flavors" that are controlled by the
     * same controller. For example, you may have different Parameters for the
     * same implementing controller. This should be specified as a
     * domain-prefixed path no more than 250 characters in length, e.g.
     * "acme.io/ingress-controller". This field is immutable.
     * </pre>
     *
     * <code>optional string controller = 1;</code>
     */
    com.google.protobuf.ByteString getControllerBytes();

    /**
     *
     *
     * <pre>
     * Parameters is a link to a custom resource containing additional
     * configuration for the controller. This is optional if the controller does
     * not require extra parameters.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
     * </code>
     */
    boolean hasParameters();
    /**
     *
     *
     * <pre>
     * Parameters is a link to a custom resource containing additional
     * configuration for the controller. This is optional if the controller does
     * not require extra parameters.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
     * </code>
     */
    io.kubernetes.client.proto.V1Networking.IngressClassParametersReference getParameters();
    /**
     *
     *
     * <pre>
     * Parameters is a link to a custom resource containing additional
     * configuration for the controller. This is optional if the controller does
     * not require extra parameters.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
     * </code>
     */
    io.kubernetes.client.proto.V1Networking.IngressClassParametersReferenceOrBuilder
        getParametersOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * IngressClassSpec provides information about the class of an Ingress.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressClassSpec}
   */
  public static final class IngressClassSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressClassSpec)
      IngressClassSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressClassSpec.newBuilder() to construct.
    private IngressClassSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressClassSpec() {
      controller_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressClassSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                controller_ = bs;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.Builder
                    subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = parameters_.toBuilder();
                }
                parameters_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
                            .PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(parameters_);
                  parameters_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressClassSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressClassSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressClassSpec.class,
              io.kubernetes.client.proto.V1Networking.IngressClassSpec.Builder.class);
    }

    private int bitField0_;
    public static final int CONTROLLER_FIELD_NUMBER = 1;
    private volatile java.lang.Object controller_;
    /**
     *
     *
     * <pre>
     * Controller refers to the name of the controller that should handle this
     * class. This allows for different "flavors" that are controlled by the
     * same controller. For example, you may have different Parameters for the
     * same implementing controller. This should be specified as a
     * domain-prefixed path no more than 250 characters in length, e.g.
     * "acme.io/ingress-controller". This field is immutable.
     * </pre>
     *
     * <code>optional string controller = 1;</code>
     */
    public boolean hasController() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Controller refers to the name of the controller that should handle this
     * class. This allows for different "flavors" that are controlled by the
     * same controller. For example, you may have different Parameters for the
     * same implementing controller. This should be specified as a
     * domain-prefixed path no more than 250 characters in length, e.g.
     * "acme.io/ingress-controller". This field is immutable.
     * </pre>
     *
     * <code>optional string controller = 1;</code>
     */
    public java.lang.String getController() {
      java.lang.Object ref = controller_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          controller_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Controller refers to the name of the controller that should handle this
     * class. This allows for different "flavors" that are controlled by the
     * same controller. For example, you may have different Parameters for the
     * same implementing controller. This should be specified as a
     * domain-prefixed path no more than 250 characters in length, e.g.
     * "acme.io/ingress-controller". This field is immutable.
     * </pre>
     *
     * <code>optional string controller = 1;</code>
     */
    public com.google.protobuf.ByteString getControllerBytes() {
      java.lang.Object ref = controller_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        controller_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARAMETERS_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parameters_;
    /**
     *
     *
     * <pre>
     * Parameters is a link to a custom resource containing additional
     * configuration for the controller. This is optional if the controller does
     * not require extra parameters.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
     * </code>
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Parameters is a link to a custom resource containing additional
     * configuration for the controller. This is optional if the controller does
     * not require extra parameters.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
     * </code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressClassParametersReference getParameters() {
      return parameters_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
              .getDefaultInstance()
          : parameters_;
    }
    /**
     *
     *
     * <pre>
     * Parameters is a link to a custom resource containing additional
     * configuration for the controller. This is optional if the controller does
     * not require extra parameters.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
     * </code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressClassParametersReferenceOrBuilder
        getParametersOrBuilder() {
      return parameters_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
              .getDefaultInstance()
          : parameters_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, controller_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getParameters());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, controller_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getParameters());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressClassSpec)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressClassSpec other =
          (io.kubernetes.client.proto.V1Networking.IngressClassSpec) obj;

      boolean result = true;
      result = result && (hasController() == other.hasController());
      if (hasController()) {
        result = result && getController().equals(other.getController());
      }
      result = result && (hasParameters() == other.hasParameters());
      if (hasParameters()) {
        result = result && getParameters().equals(other.getParameters());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasController()) {
        hash = (37 * hash) + CONTROLLER_FIELD_NUMBER;
        hash = (53 * hash) + getController().hashCode();
      }
      if (hasParameters()) {
        hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
        hash = (53 * hash) + getParameters().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressClassSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressClassSpec provides information about the class of an Ingress.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressClassSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressClassSpec)
        io.kubernetes.client.proto.V1Networking.IngressClassSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressClassSpec.class,
                io.kubernetes.client.proto.V1Networking.IngressClassSpec.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressClassSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getParametersFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        controller_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (parametersBuilder_ == null) {
          parameters_ = null;
        } else {
          parametersBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressClassSpec_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassSpec getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressClassSpec.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassSpec build() {
        io.kubernetes.client.proto.V1Networking.IngressClassSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressClassSpec buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressClassSpec result =
            new io.kubernetes.client.proto.V1Networking.IngressClassSpec(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.controller_ = controller_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (parametersBuilder_ == null) {
          result.parameters_ = parameters_;
        } else {
          result.parameters_ = parametersBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressClassSpec) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressClassSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressClassSpec other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressClassSpec.getDefaultInstance())
          return this;
        if (other.hasController()) {
          bitField0_ |= 0x00000001;
          controller_ = other.controller_;
          onChanged();
        }
        if (other.hasParameters()) {
          mergeParameters(other.getParameters());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressClassSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressClassSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object controller_ = "";
      /**
       *
       *
       * <pre>
       * Controller refers to the name of the controller that should handle this
       * class. This allows for different "flavors" that are controlled by the
       * same controller. For example, you may have different Parameters for the
       * same implementing controller. This should be specified as a
       * domain-prefixed path no more than 250 characters in length, e.g.
       * "acme.io/ingress-controller". This field is immutable.
       * </pre>
       *
       * <code>optional string controller = 1;</code>
       */
      public boolean hasController() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Controller refers to the name of the controller that should handle this
       * class. This allows for different "flavors" that are controlled by the
       * same controller. For example, you may have different Parameters for the
       * same implementing controller. This should be specified as a
       * domain-prefixed path no more than 250 characters in length, e.g.
       * "acme.io/ingress-controller". This field is immutable.
       * </pre>
       *
       * <code>optional string controller = 1;</code>
       */
      public java.lang.String getController() {
        java.lang.Object ref = controller_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            controller_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Controller refers to the name of the controller that should handle this
       * class. This allows for different "flavors" that are controlled by the
       * same controller. For example, you may have different Parameters for the
       * same implementing controller. This should be specified as a
       * domain-prefixed path no more than 250 characters in length, e.g.
       * "acme.io/ingress-controller". This field is immutable.
       * </pre>
       *
       * <code>optional string controller = 1;</code>
       */
      public com.google.protobuf.ByteString getControllerBytes() {
        java.lang.Object ref = controller_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          controller_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Controller refers to the name of the controller that should handle this
       * class. This allows for different "flavors" that are controlled by the
       * same controller. For example, you may have different Parameters for the
       * same implementing controller. This should be specified as a
       * domain-prefixed path no more than 250 characters in length, e.g.
       * "acme.io/ingress-controller". This field is immutable.
       * </pre>
       *
       * <code>optional string controller = 1;</code>
       */
      public Builder setController(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        controller_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Controller refers to the name of the controller that should handle this
       * class. This allows for different "flavors" that are controlled by the
       * same controller. For example, you may have different Parameters for the
       * same implementing controller. This should be specified as a
       * domain-prefixed path no more than 250 characters in length, e.g.
       * "acme.io/ingress-controller". This field is immutable.
       * </pre>
       *
       * <code>optional string controller = 1;</code>
       */
      public Builder clearController() {
        bitField0_ = (bitField0_ & ~0x00000001);
        controller_ = getDefaultInstance().getController();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Controller refers to the name of the controller that should handle this
       * class. This allows for different "flavors" that are controlled by the
       * same controller. For example, you may have different Parameters for the
       * same implementing controller. This should be specified as a
       * domain-prefixed path no more than 250 characters in length, e.g.
       * "acme.io/ingress-controller". This field is immutable.
       * </pre>
       *
       * <code>optional string controller = 1;</code>
       */
      public Builder setControllerBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        controller_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1Networking.IngressClassParametersReference parameters_ =
          null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressClassParametersReference,
              io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.Builder,
              io.kubernetes.client.proto.V1Networking.IngressClassParametersReferenceOrBuilder>
          parametersBuilder_;
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      public boolean hasParameters() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
          getParameters() {
        if (parametersBuilder_ == null) {
          return parameters_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
                  .getDefaultInstance()
              : parameters_;
        } else {
          return parametersBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      public Builder setParameters(
          io.kubernetes.client.proto.V1Networking.IngressClassParametersReference value) {
        if (parametersBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameters_ = value;
          onChanged();
        } else {
          parametersBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      public Builder setParameters(
          io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.Builder
              builderForValue) {
        if (parametersBuilder_ == null) {
          parameters_ = builderForValue.build();
          onChanged();
        } else {
          parametersBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      public Builder mergeParameters(
          io.kubernetes.client.proto.V1Networking.IngressClassParametersReference value) {
        if (parametersBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && parameters_ != null
              && parameters_
                  != io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
                      .getDefaultInstance()) {
            parameters_ =
                io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.newBuilder(
                        parameters_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameters_ = value;
          }
          onChanged();
        } else {
          parametersBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      public Builder clearParameters() {
        if (parametersBuilder_ == null) {
          parameters_ = null;
          onChanged();
        } else {
          parametersBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.Builder
          getParametersBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getParametersFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressClassParametersReferenceOrBuilder
          getParametersOrBuilder() {
        if (parametersBuilder_ != null) {
          return parametersBuilder_.getMessageOrBuilder();
        } else {
          return parameters_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressClassParametersReference
                  .getDefaultInstance()
              : parameters_;
        }
      }
      /**
       *
       *
       * <pre>
       * Parameters is a link to a custom resource containing additional
       * configuration for the controller. This is optional if the controller does
       * not require extra parameters.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressClassParametersReference parameters = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressClassParametersReference,
              io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.Builder,
              io.kubernetes.client.proto.V1Networking.IngressClassParametersReferenceOrBuilder>
          getParametersFieldBuilder() {
        if (parametersBuilder_ == null) {
          parametersBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressClassParametersReference,
                  io.kubernetes.client.proto.V1Networking.IngressClassParametersReference.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressClassParametersReferenceOrBuilder>(
                  getParameters(), getParentForChildren(), isClean());
          parameters_ = null;
        }
        return parametersBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressClassSpec)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressClassSpec)
    private static final io.kubernetes.client.proto.V1Networking.IngressClassSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressClassSpec();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressClassSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressClassSpec> PARSER =
        new com.google.protobuf.AbstractParser<IngressClassSpec>() {
          @java.lang.Override
          public IngressClassSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressClassSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressClassSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressClassSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressClassSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.Ingress> getItemsList();
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.Ingress getItems(int index);
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * IngressList is a collection of Ingress.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressList}
   */
  public static final class IngressList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressList)
      IngressListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressList.newBuilder() to construct.
    private IngressList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ =
                      new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.Ingress>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.Ingress.PARSER, extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressList.class,
              io.kubernetes.client.proto.V1Networking.IngressList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Networking.Ingress> items_;
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.Ingress> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.Ingress getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Items is the list of Ingress.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressOrBuilder getItemsOrBuilder(int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressList other =
          (io.kubernetes.client.proto.V1Networking.IngressList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressList is a collection of Ingress.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressList)
        io.kubernetes.client.proto.V1Networking.IngressListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressList.class,
                io.kubernetes.client.proto.V1Networking.IngressList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressList build() {
        io.kubernetes.client.proto.V1Networking.IngressList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressList buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressList result =
            new io.kubernetes.client.proto.V1Networking.IngressList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressList) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressList other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Networking.Ingress> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.Ingress>(items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.Ingress,
              io.kubernetes.client.proto.V1Networking.Ingress.Builder,
              io.kubernetes.client.proto.V1Networking.IngressOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.Ingress> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.Ingress getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder setItems(int index, io.kubernetes.client.proto.V1Networking.Ingress value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Networking.Ingress.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1Networking.Ingress value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder addItems(int index, io.kubernetes.client.proto.V1Networking.Ingress value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder addItems(
          io.kubernetes.client.proto.V1Networking.Ingress.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Networking.Ingress.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.Ingress> values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.Ingress.Builder getItemsBuilder(int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressOrBuilder getItemsOrBuilder(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.Ingress.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Networking.Ingress.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.Ingress.Builder addItemsBuilder(int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1Networking.Ingress.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is the list of Ingress.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.Ingress items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.Ingress.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.Ingress,
              io.kubernetes.client.proto.V1Networking.Ingress.Builder,
              io.kubernetes.client.proto.V1Networking.IngressOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.Ingress,
                  io.kubernetes.client.proto.V1Networking.Ingress.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressList)
    private static final io.kubernetes.client.proto.V1Networking.IngressList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressList();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressList> PARSER =
        new com.google.protobuf.AbstractParser<IngressList>() {
          @java.lang.Override
          public IngressList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     * Note the following deviations from the "host" part of the
     * URI as defined in RFC 3986:
     * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     *    the IP in the Spec of the parent Ingress.
     * 2. The `:` delimiter is not respected because ports are not allowed.
     * 	  Currently the port of an Ingress is implicitly :80 for http and
     * 	  :443 for https.
     * Both these may change in the future.
     * Incoming requests are matched against the host before the
     * IngressRuleValue. If the host is unspecified, the Ingress routes all
     * traffic based on the specified IngressRuleValue.
     * Host can be "precise" which is a domain name without the terminating dot of
     * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
     * prefixed with a single wildcard label (e.g. "*.foo.com").
     * The wildcard character '*' must appear by itself as the first DNS label and
     * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
     * Requests will be matched against the Host field in the following way:
     * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
     * 2. If Host is a wildcard, then the request matches this rule if the http host header
     * is to equal to the suffix (removing the first label) of the wildcard rule.
     * +optional
     * </pre>
     *
     * <code>optional string host = 1;</code>
     */
    boolean hasHost();
    /**
     *
     *
     * <pre>
     * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     * Note the following deviations from the "host" part of the
     * URI as defined in RFC 3986:
     * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     *    the IP in the Spec of the parent Ingress.
     * 2. The `:` delimiter is not respected because ports are not allowed.
     * 	  Currently the port of an Ingress is implicitly :80 for http and
     * 	  :443 for https.
     * Both these may change in the future.
     * Incoming requests are matched against the host before the
     * IngressRuleValue. If the host is unspecified, the Ingress routes all
     * traffic based on the specified IngressRuleValue.
     * Host can be "precise" which is a domain name without the terminating dot of
     * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
     * prefixed with a single wildcard label (e.g. "*.foo.com").
     * The wildcard character '*' must appear by itself as the first DNS label and
     * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
     * Requests will be matched against the Host field in the following way:
     * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
     * 2. If Host is a wildcard, then the request matches this rule if the http host header
     * is to equal to the suffix (removing the first label) of the wildcard rule.
     * +optional
     * </pre>
     *
     * <code>optional string host = 1;</code>
     */
    java.lang.String getHost();
    /**
     *
     *
     * <pre>
     * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     * Note the following deviations from the "host" part of the
     * URI as defined in RFC 3986:
     * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     *    the IP in the Spec of the parent Ingress.
     * 2. The `:` delimiter is not respected because ports are not allowed.
     * 	  Currently the port of an Ingress is implicitly :80 for http and
     * 	  :443 for https.
     * Both these may change in the future.
     * Incoming requests are matched against the host before the
     * IngressRuleValue. If the host is unspecified, the Ingress routes all
     * traffic based on the specified IngressRuleValue.
     * Host can be "precise" which is a domain name without the terminating dot of
     * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
     * prefixed with a single wildcard label (e.g. "*.foo.com").
     * The wildcard character '*' must appear by itself as the first DNS label and
     * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
     * Requests will be matched against the Host field in the following way:
     * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
     * 2. If Host is a wildcard, then the request matches this rule if the http host header
     * is to equal to the suffix (removing the first label) of the wildcard rule.
     * +optional
     * </pre>
     *
     * <code>optional string host = 1;</code>
     */
    com.google.protobuf.ByteString getHostBytes();

    /**
     *
     *
     * <pre>
     * IngressRuleValue represents a rule to route requests for this IngressRule.
     * If unspecified, the rule defaults to a http catch-all. Whether that sends
     * just traffic matching the host to the default backend or all traffic to the
     * default backend, is left to the controller fulfilling the Ingress. Http is
     * currently the only supported IngressRuleValue.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
     */
    boolean hasIngressRuleValue();
    /**
     *
     *
     * <pre>
     * IngressRuleValue represents a rule to route requests for this IngressRule.
     * If unspecified, the rule defaults to a http catch-all. Whether that sends
     * just traffic matching the host to the default backend or all traffic to the
     * default backend, is left to the controller fulfilling the Ingress. Http is
     * currently the only supported IngressRuleValue.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressRuleValue getIngressRuleValue();
    /**
     *
     *
     * <pre>
     * IngressRuleValue represents a rule to route requests for this IngressRule.
     * If unspecified, the rule defaults to a http catch-all. Whether that sends
     * just traffic matching the host to the default backend or all traffic to the
     * default backend, is left to the controller fulfilling the Ingress. Http is
     * currently the only supported IngressRuleValue.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressRuleValueOrBuilder
        getIngressRuleValueOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * IngressRule represents the rules mapping the paths under a specified host to
   * the related backend services. Incoming requests are first evaluated for a host
   * match, then routed to the backend associated with the matching IngressRuleValue.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressRule}
   */
  public static final class IngressRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressRule)
      IngressRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressRule.newBuilder() to construct.
    private IngressRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressRule() {
      host_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressRule(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                host_ = bs;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Networking.IngressRuleValue.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = ingressRuleValue_.toBuilder();
                }
                ingressRuleValue_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressRuleValue.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(ingressRuleValue_);
                  ingressRuleValue_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressRule.class,
              io.kubernetes.client.proto.V1Networking.IngressRule.Builder.class);
    }

    private int bitField0_;
    public static final int HOST_FIELD_NUMBER = 1;
    private volatile java.lang.Object host_;
    /**
     *
     *
     * <pre>
     * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     * Note the following deviations from the "host" part of the
     * URI as defined in RFC 3986:
     * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     *    the IP in the Spec of the parent Ingress.
     * 2. The `:` delimiter is not respected because ports are not allowed.
     * 	  Currently the port of an Ingress is implicitly :80 for http and
     * 	  :443 for https.
     * Both these may change in the future.
     * Incoming requests are matched against the host before the
     * IngressRuleValue. If the host is unspecified, the Ingress routes all
     * traffic based on the specified IngressRuleValue.
     * Host can be "precise" which is a domain name without the terminating dot of
     * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
     * prefixed with a single wildcard label (e.g. "*.foo.com").
     * The wildcard character '*' must appear by itself as the first DNS label and
     * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
     * Requests will be matched against the Host field in the following way:
     * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
     * 2. If Host is a wildcard, then the request matches this rule if the http host header
     * is to equal to the suffix (removing the first label) of the wildcard rule.
     * +optional
     * </pre>
     *
     * <code>optional string host = 1;</code>
     */
    public boolean hasHost() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     * Note the following deviations from the "host" part of the
     * URI as defined in RFC 3986:
     * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     *    the IP in the Spec of the parent Ingress.
     * 2. The `:` delimiter is not respected because ports are not allowed.
     * 	  Currently the port of an Ingress is implicitly :80 for http and
     * 	  :443 for https.
     * Both these may change in the future.
     * Incoming requests are matched against the host before the
     * IngressRuleValue. If the host is unspecified, the Ingress routes all
     * traffic based on the specified IngressRuleValue.
     * Host can be "precise" which is a domain name without the terminating dot of
     * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
     * prefixed with a single wildcard label (e.g. "*.foo.com").
     * The wildcard character '*' must appear by itself as the first DNS label and
     * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
     * Requests will be matched against the Host field in the following way:
     * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
     * 2. If Host is a wildcard, then the request matches this rule if the http host header
     * is to equal to the suffix (removing the first label) of the wildcard rule.
     * +optional
     * </pre>
     *
     * <code>optional string host = 1;</code>
     */
    public java.lang.String getHost() {
      java.lang.Object ref = host_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          host_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
     * Note the following deviations from the "host" part of the
     * URI as defined in RFC 3986:
     * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
     *    the IP in the Spec of the parent Ingress.
     * 2. The `:` delimiter is not respected because ports are not allowed.
     * 	  Currently the port of an Ingress is implicitly :80 for http and
     * 	  :443 for https.
     * Both these may change in the future.
     * Incoming requests are matched against the host before the
     * IngressRuleValue. If the host is unspecified, the Ingress routes all
     * traffic based on the specified IngressRuleValue.
     * Host can be "precise" which is a domain name without the terminating dot of
     * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
     * prefixed with a single wildcard label (e.g. "*.foo.com").
     * The wildcard character '*' must appear by itself as the first DNS label and
     * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
     * Requests will be matched against the Host field in the following way:
     * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
     * 2. If Host is a wildcard, then the request matches this rule if the http host header
     * is to equal to the suffix (removing the first label) of the wildcard rule.
     * +optional
     * </pre>
     *
     * <code>optional string host = 1;</code>
     */
    public com.google.protobuf.ByteString getHostBytes() {
      java.lang.Object ref = host_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        host_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int INGRESSRULEVALUE_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Networking.IngressRuleValue ingressRuleValue_;
    /**
     *
     *
     * <pre>
     * IngressRuleValue represents a rule to route requests for this IngressRule.
     * If unspecified, the rule defaults to a http catch-all. Whether that sends
     * just traffic matching the host to the default backend or all traffic to the
     * default backend, is left to the controller fulfilling the Ingress. Http is
     * currently the only supported IngressRuleValue.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
     */
    public boolean hasIngressRuleValue() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * IngressRuleValue represents a rule to route requests for this IngressRule.
     * If unspecified, the rule defaults to a http catch-all. Whether that sends
     * just traffic matching the host to the default backend or all traffic to the
     * default backend, is left to the controller fulfilling the Ingress. Http is
     * currently the only supported IngressRuleValue.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressRuleValue getIngressRuleValue() {
      return ingressRuleValue_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressRuleValue.getDefaultInstance()
          : ingressRuleValue_;
    }
    /**
     *
     *
     * <pre>
     * IngressRuleValue represents a rule to route requests for this IngressRule.
     * If unspecified, the rule defaults to a http catch-all. Whether that sends
     * just traffic matching the host to the default backend or all traffic to the
     * default backend, is left to the controller fulfilling the Ingress. Http is
     * currently the only supported IngressRuleValue.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressRuleValueOrBuilder
        getIngressRuleValueOrBuilder() {
      return ingressRuleValue_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressRuleValue.getDefaultInstance()
          : ingressRuleValue_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, host_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getIngressRuleValue());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, host_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getIngressRuleValue());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressRule)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressRule other =
          (io.kubernetes.client.proto.V1Networking.IngressRule) obj;

      boolean result = true;
      result = result && (hasHost() == other.hasHost());
      if (hasHost()) {
        result = result && getHost().equals(other.getHost());
      }
      result = result && (hasIngressRuleValue() == other.hasIngressRuleValue());
      if (hasIngressRuleValue()) {
        result = result && getIngressRuleValue().equals(other.getIngressRuleValue());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasHost()) {
        hash = (37 * hash) + HOST_FIELD_NUMBER;
        hash = (53 * hash) + getHost().hashCode();
      }
      if (hasIngressRuleValue()) {
        hash = (37 * hash) + INGRESSRULEVALUE_FIELD_NUMBER;
        hash = (53 * hash) + getIngressRuleValue().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressRule represents the rules mapping the paths under a specified host to
     * the related backend services. Incoming requests are first evaluated for a host
     * match, then routed to the backend associated with the matching IngressRuleValue.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressRule)
        io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressRule.class,
                io.kubernetes.client.proto.V1Networking.IngressRule.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressRule.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getIngressRuleValueFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        host_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (ingressRuleValueBuilder_ == null) {
          ingressRuleValue_ = null;
        } else {
          ingressRuleValueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressRule_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressRule getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressRule.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressRule build() {
        io.kubernetes.client.proto.V1Networking.IngressRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressRule buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressRule result =
            new io.kubernetes.client.proto.V1Networking.IngressRule(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.host_ = host_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (ingressRuleValueBuilder_ == null) {
          result.ingressRuleValue_ = ingressRuleValue_;
        } else {
          result.ingressRuleValue_ = ingressRuleValueBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressRule) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressRule other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressRule.getDefaultInstance())
          return this;
        if (other.hasHost()) {
          bitField0_ |= 0x00000001;
          host_ = other.host_;
          onChanged();
        }
        if (other.hasIngressRuleValue()) {
          mergeIngressRuleValue(other.getIngressRuleValue());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressRule parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressRule) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object host_ = "";
      /**
       *
       *
       * <pre>
       * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
       * Note the following deviations from the "host" part of the
       * URI as defined in RFC 3986:
       * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
       *    the IP in the Spec of the parent Ingress.
       * 2. The `:` delimiter is not respected because ports are not allowed.
       * 	  Currently the port of an Ingress is implicitly :80 for http and
       * 	  :443 for https.
       * Both these may change in the future.
       * Incoming requests are matched against the host before the
       * IngressRuleValue. If the host is unspecified, the Ingress routes all
       * traffic based on the specified IngressRuleValue.
       * Host can be "precise" which is a domain name without the terminating dot of
       * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
       * prefixed with a single wildcard label (e.g. "*.foo.com").
       * The wildcard character '*' must appear by itself as the first DNS label and
       * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
       * Requests will be matched against the Host field in the following way:
       * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
       * 2. If Host is a wildcard, then the request matches this rule if the http host header
       * is to equal to the suffix (removing the first label) of the wildcard rule.
       * +optional
       * </pre>
       *
       * <code>optional string host = 1;</code>
       */
      public boolean hasHost() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
       * Note the following deviations from the "host" part of the
       * URI as defined in RFC 3986:
       * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
       *    the IP in the Spec of the parent Ingress.
       * 2. The `:` delimiter is not respected because ports are not allowed.
       * 	  Currently the port of an Ingress is implicitly :80 for http and
       * 	  :443 for https.
       * Both these may change in the future.
       * Incoming requests are matched against the host before the
       * IngressRuleValue. If the host is unspecified, the Ingress routes all
       * traffic based on the specified IngressRuleValue.
       * Host can be "precise" which is a domain name without the terminating dot of
       * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
       * prefixed with a single wildcard label (e.g. "*.foo.com").
       * The wildcard character '*' must appear by itself as the first DNS label and
       * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
       * Requests will be matched against the Host field in the following way:
       * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
       * 2. If Host is a wildcard, then the request matches this rule if the http host header
       * is to equal to the suffix (removing the first label) of the wildcard rule.
       * +optional
       * </pre>
       *
       * <code>optional string host = 1;</code>
       */
      public java.lang.String getHost() {
        java.lang.Object ref = host_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            host_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
       * Note the following deviations from the "host" part of the
       * URI as defined in RFC 3986:
       * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
       *    the IP in the Spec of the parent Ingress.
       * 2. The `:` delimiter is not respected because ports are not allowed.
       * 	  Currently the port of an Ingress is implicitly :80 for http and
       * 	  :443 for https.
       * Both these may change in the future.
       * Incoming requests are matched against the host before the
       * IngressRuleValue. If the host is unspecified, the Ingress routes all
       * traffic based on the specified IngressRuleValue.
       * Host can be "precise" which is a domain name without the terminating dot of
       * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
       * prefixed with a single wildcard label (e.g. "*.foo.com").
       * The wildcard character '*' must appear by itself as the first DNS label and
       * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
       * Requests will be matched against the Host field in the following way:
       * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
       * 2. If Host is a wildcard, then the request matches this rule if the http host header
       * is to equal to the suffix (removing the first label) of the wildcard rule.
       * +optional
       * </pre>
       *
       * <code>optional string host = 1;</code>
       */
      public com.google.protobuf.ByteString getHostBytes() {
        java.lang.Object ref = host_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          host_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
       * Note the following deviations from the "host" part of the
       * URI as defined in RFC 3986:
       * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
       *    the IP in the Spec of the parent Ingress.
       * 2. The `:` delimiter is not respected because ports are not allowed.
       * 	  Currently the port of an Ingress is implicitly :80 for http and
       * 	  :443 for https.
       * Both these may change in the future.
       * Incoming requests are matched against the host before the
       * IngressRuleValue. If the host is unspecified, the Ingress routes all
       * traffic based on the specified IngressRuleValue.
       * Host can be "precise" which is a domain name without the terminating dot of
       * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
       * prefixed with a single wildcard label (e.g. "*.foo.com").
       * The wildcard character '*' must appear by itself as the first DNS label and
       * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
       * Requests will be matched against the Host field in the following way:
       * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
       * 2. If Host is a wildcard, then the request matches this rule if the http host header
       * is to equal to the suffix (removing the first label) of the wildcard rule.
       * +optional
       * </pre>
       *
       * <code>optional string host = 1;</code>
       */
      public Builder setHost(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        host_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
       * Note the following deviations from the "host" part of the
       * URI as defined in RFC 3986:
       * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
       *    the IP in the Spec of the parent Ingress.
       * 2. The `:` delimiter is not respected because ports are not allowed.
       * 	  Currently the port of an Ingress is implicitly :80 for http and
       * 	  :443 for https.
       * Both these may change in the future.
       * Incoming requests are matched against the host before the
       * IngressRuleValue. If the host is unspecified, the Ingress routes all
       * traffic based on the specified IngressRuleValue.
       * Host can be "precise" which is a domain name without the terminating dot of
       * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
       * prefixed with a single wildcard label (e.g. "*.foo.com").
       * The wildcard character '*' must appear by itself as the first DNS label and
       * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
       * Requests will be matched against the Host field in the following way:
       * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
       * 2. If Host is a wildcard, then the request matches this rule if the http host header
       * is to equal to the suffix (removing the first label) of the wildcard rule.
       * +optional
       * </pre>
       *
       * <code>optional string host = 1;</code>
       */
      public Builder clearHost() {
        bitField0_ = (bitField0_ & ~0x00000001);
        host_ = getDefaultInstance().getHost();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Host is the fully qualified domain name of a network host, as defined by RFC 3986.
       * Note the following deviations from the "host" part of the
       * URI as defined in RFC 3986:
       * 1. IPs are not allowed. Currently an IngressRuleValue can only apply to
       *    the IP in the Spec of the parent Ingress.
       * 2. The `:` delimiter is not respected because ports are not allowed.
       * 	  Currently the port of an Ingress is implicitly :80 for http and
       * 	  :443 for https.
       * Both these may change in the future.
       * Incoming requests are matched against the host before the
       * IngressRuleValue. If the host is unspecified, the Ingress routes all
       * traffic based on the specified IngressRuleValue.
       * Host can be "precise" which is a domain name without the terminating dot of
       * a network host (e.g. "foo.bar.com") or "wildcard", which is a domain name
       * prefixed with a single wildcard label (e.g. "*.foo.com").
       * The wildcard character '*' must appear by itself as the first DNS label and
       * matches only a single label. You cannot have a wildcard label by itself (e.g. Host == "*").
       * Requests will be matched against the Host field in the following way:
       * 1. If Host is precise, the request matches this rule if the http host header is equal to Host.
       * 2. If Host is a wildcard, then the request matches this rule if the http host header
       * is to equal to the suffix (removing the first label) of the wildcard rule.
       * +optional
       * </pre>
       *
       * <code>optional string host = 1;</code>
       */
      public Builder setHostBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        host_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1Networking.IngressRuleValue ingressRuleValue_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressRuleValue,
              io.kubernetes.client.proto.V1Networking.IngressRuleValue.Builder,
              io.kubernetes.client.proto.V1Networking.IngressRuleValueOrBuilder>
          ingressRuleValueBuilder_;
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      public boolean hasIngressRuleValue() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressRuleValue getIngressRuleValue() {
        if (ingressRuleValueBuilder_ == null) {
          return ingressRuleValue_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressRuleValue.getDefaultInstance()
              : ingressRuleValue_;
        } else {
          return ingressRuleValueBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      public Builder setIngressRuleValue(
          io.kubernetes.client.proto.V1Networking.IngressRuleValue value) {
        if (ingressRuleValueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ingressRuleValue_ = value;
          onChanged();
        } else {
          ingressRuleValueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      public Builder setIngressRuleValue(
          io.kubernetes.client.proto.V1Networking.IngressRuleValue.Builder builderForValue) {
        if (ingressRuleValueBuilder_ == null) {
          ingressRuleValue_ = builderForValue.build();
          onChanged();
        } else {
          ingressRuleValueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      public Builder mergeIngressRuleValue(
          io.kubernetes.client.proto.V1Networking.IngressRuleValue value) {
        if (ingressRuleValueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && ingressRuleValue_ != null
              && ingressRuleValue_
                  != io.kubernetes.client.proto.V1Networking.IngressRuleValue
                      .getDefaultInstance()) {
            ingressRuleValue_ =
                io.kubernetes.client.proto.V1Networking.IngressRuleValue.newBuilder(
                        ingressRuleValue_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            ingressRuleValue_ = value;
          }
          onChanged();
        } else {
          ingressRuleValueBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      public Builder clearIngressRuleValue() {
        if (ingressRuleValueBuilder_ == null) {
          ingressRuleValue_ = null;
          onChanged();
        } else {
          ingressRuleValueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressRuleValue.Builder
          getIngressRuleValueBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getIngressRuleValueFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressRuleValueOrBuilder
          getIngressRuleValueOrBuilder() {
        if (ingressRuleValueBuilder_ != null) {
          return ingressRuleValueBuilder_.getMessageOrBuilder();
        } else {
          return ingressRuleValue_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressRuleValue.getDefaultInstance()
              : ingressRuleValue_;
        }
      }
      /**
       *
       *
       * <pre>
       * IngressRuleValue represents a rule to route requests for this IngressRule.
       * If unspecified, the rule defaults to a http catch-all. Whether that sends
       * just traffic matching the host to the default backend or all traffic to the
       * default backend, is left to the controller fulfilling the Ingress. Http is
       * currently the only supported IngressRuleValue.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressRuleValue ingressRuleValue = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressRuleValue,
              io.kubernetes.client.proto.V1Networking.IngressRuleValue.Builder,
              io.kubernetes.client.proto.V1Networking.IngressRuleValueOrBuilder>
          getIngressRuleValueFieldBuilder() {
        if (ingressRuleValueBuilder_ == null) {
          ingressRuleValueBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressRuleValue,
                  io.kubernetes.client.proto.V1Networking.IngressRuleValue.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressRuleValueOrBuilder>(
                  getIngressRuleValue(), getParentForChildren(), isClean());
          ingressRuleValue_ = null;
        }
        return ingressRuleValueBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressRule)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressRule)
    private static final io.kubernetes.client.proto.V1Networking.IngressRule DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressRule();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRule getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressRule> PARSER =
        new com.google.protobuf.AbstractParser<IngressRule>() {
          @java.lang.Override
          public IngressRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressRule(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressRule getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressRuleValueOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressRuleValue)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
     */
    boolean hasHttp();
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue getHttp();
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValueOrBuilder getHttpOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * IngressRuleValue represents a rule to apply against incoming requests. If the
   * rule is satisfied, the request is routed to the specified backend. Currently
   * mixing different types of rules in a single Ingress is disallowed, so exactly
   * one of the following must be set.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressRuleValue}
   */
  public static final class IngressRuleValue extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressRuleValue)
      IngressRuleValueOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressRuleValue.newBuilder() to construct.
    private IngressRuleValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressRuleValue() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressRuleValue(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.Builder subBuilder =
                    null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = http_.toBuilder();
                }
                http_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(http_);
                  http_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressRuleValue_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressRuleValue_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressRuleValue.class,
              io.kubernetes.client.proto.V1Networking.IngressRuleValue.Builder.class);
    }

    private int bitField0_;
    public static final int HTTP_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue http_;
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
     */
    public boolean hasHttp() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue getHttp() {
      return http_ == null
          ? io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.getDefaultInstance()
          : http_;
    }
    /**
     *
     *
     * <pre>
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValueOrBuilder
        getHttpOrBuilder() {
      return http_ == null
          ? io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.getDefaultInstance()
          : http_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getHttp());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getHttp());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressRuleValue)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressRuleValue other =
          (io.kubernetes.client.proto.V1Networking.IngressRuleValue) obj;

      boolean result = true;
      result = result && (hasHttp() == other.hasHttp());
      if (hasHttp()) {
        result = result && getHttp().equals(other.getHttp());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasHttp()) {
        hash = (37 * hash) + HTTP_FIELD_NUMBER;
        hash = (53 * hash) + getHttp().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressRuleValue prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressRuleValue represents a rule to apply against incoming requests. If the
     * rule is satisfied, the request is routed to the specified backend. Currently
     * mixing different types of rules in a single Ingress is disallowed, so exactly
     * one of the following must be set.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressRuleValue}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressRuleValue)
        io.kubernetes.client.proto.V1Networking.IngressRuleValueOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressRuleValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressRuleValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressRuleValue.class,
                io.kubernetes.client.proto.V1Networking.IngressRuleValue.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressRuleValue.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getHttpFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (httpBuilder_ == null) {
          http_ = null;
        } else {
          httpBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressRuleValue_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressRuleValue getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressRuleValue.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressRuleValue build() {
        io.kubernetes.client.proto.V1Networking.IngressRuleValue result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressRuleValue buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressRuleValue result =
            new io.kubernetes.client.proto.V1Networking.IngressRuleValue(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (httpBuilder_ == null) {
          result.http_ = http_;
        } else {
          result.http_ = httpBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressRuleValue) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressRuleValue) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressRuleValue other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressRuleValue.getDefaultInstance())
          return this;
        if (other.hasHttp()) {
          mergeHttp(other.getHttp());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressRuleValue parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressRuleValue) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue http_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue,
              io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.Builder,
              io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValueOrBuilder>
          httpBuilder_;
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      public boolean hasHttp() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue getHttp() {
        if (httpBuilder_ == null) {
          return http_ == null
              ? io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.getDefaultInstance()
              : http_;
        } else {
          return httpBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      public Builder setHttp(io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue value) {
        if (httpBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          http_ = value;
          onChanged();
        } else {
          httpBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      public Builder setHttp(
          io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.Builder builderForValue) {
        if (httpBuilder_ == null) {
          http_ = builderForValue.build();
          onChanged();
        } else {
          httpBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      public Builder mergeHttp(io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue value) {
        if (httpBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && http_ != null
              && http_
                  != io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue
                      .getDefaultInstance()) {
            http_ =
                io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.newBuilder(http_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            http_ = value;
          }
          onChanged();
        } else {
          httpBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      public Builder clearHttp() {
        if (httpBuilder_ == null) {
          http_ = null;
          onChanged();
        } else {
          httpBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.Builder getHttpBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getHttpFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValueOrBuilder
          getHttpOrBuilder() {
        if (httpBuilder_ != null) {
          return httpBuilder_.getMessageOrBuilder();
        } else {
          return http_ == null
              ? io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.getDefaultInstance()
              : http_;
        }
      }
      /**
       *
       *
       * <pre>
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.HTTPIngressRuleValue http = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue,
              io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.Builder,
              io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValueOrBuilder>
          getHttpFieldBuilder() {
        if (httpBuilder_ == null) {
          httpBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue,
                  io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValue.Builder,
                  io.kubernetes.client.proto.V1Networking.HTTPIngressRuleValueOrBuilder>(
                  getHttp(), getParentForChildren(), isClean());
          http_ = null;
        }
        return httpBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressRuleValue)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressRuleValue)
    private static final io.kubernetes.client.proto.V1Networking.IngressRuleValue DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressRuleValue();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressRuleValue getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressRuleValue> PARSER =
        new com.google.protobuf.AbstractParser<IngressRuleValue>() {
          @java.lang.Override
          public IngressRuleValue parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressRuleValue(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressRuleValue> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressRuleValue> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressRuleValue getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressServiceBackendOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressServiceBackend)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Name is the referenced service. The service must exist in
     * the same namespace as the Ingress object.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    boolean hasName();
    /**
     *
     *
     * <pre>
     * Name is the referenced service. The service must exist in
     * the same namespace as the Ingress object.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    java.lang.String getName();
    /**
     *
     *
     * <pre>
     * Name is the referenced service. The service must exist in
     * the same namespace as the Ingress object.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Port of the referenced service. A port name or port number
     * is required for a IngressServiceBackend.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
     */
    boolean hasPort();
    /**
     *
     *
     * <pre>
     * Port of the referenced service. A port name or port number
     * is required for a IngressServiceBackend.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.ServiceBackendPort getPort();
    /**
     *
     *
     * <pre>
     * Port of the referenced service. A port name or port number
     * is required for a IngressServiceBackend.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.ServiceBackendPortOrBuilder getPortOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * IngressServiceBackend references a Kubernetes Service as a Backend.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressServiceBackend}
   */
  public static final class IngressServiceBackend extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressServiceBackend)
      IngressServiceBackendOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressServiceBackend.newBuilder() to construct.
    private IngressServiceBackend(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressServiceBackend() {
      name_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressServiceBackend(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                name_ = bs;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Networking.ServiceBackendPort.Builder subBuilder =
                    null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = port_.toBuilder();
                }
                port_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.ServiceBackendPort.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(port_);
                  port_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressServiceBackend_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressServiceBackend_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressServiceBackend.class,
              io.kubernetes.client.proto.V1Networking.IngressServiceBackend.Builder.class);
    }

    private int bitField0_;
    public static final int NAME_FIELD_NUMBER = 1;
    private volatile java.lang.Object name_;
    /**
     *
     *
     * <pre>
     * Name is the referenced service. The service must exist in
     * the same namespace as the Ingress object.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Name is the referenced service. The service must exist in
     * the same namespace as the Ingress object.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Name is the referenced service. The service must exist in
     * the same namespace as the Ingress object.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PORT_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Networking.ServiceBackendPort port_;
    /**
     *
     *
     * <pre>
     * Port of the referenced service. A port name or port number
     * is required for a IngressServiceBackend.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
     */
    public boolean hasPort() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Port of the referenced service. A port name or port number
     * is required for a IngressServiceBackend.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.ServiceBackendPort getPort() {
      return port_ == null
          ? io.kubernetes.client.proto.V1Networking.ServiceBackendPort.getDefaultInstance()
          : port_;
    }
    /**
     *
     *
     * <pre>
     * Port of the referenced service. A port name or port number
     * is required for a IngressServiceBackend.
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.ServiceBackendPortOrBuilder getPortOrBuilder() {
      return port_ == null
          ? io.kubernetes.client.proto.V1Networking.ServiceBackendPort.getDefaultInstance()
          : port_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getPort());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPort());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressServiceBackend)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressServiceBackend other =
          (io.kubernetes.client.proto.V1Networking.IngressServiceBackend) obj;

      boolean result = true;
      result = result && (hasName() == other.hasName());
      if (hasName()) {
        result = result && getName().equals(other.getName());
      }
      result = result && (hasPort() == other.hasPort());
      if (hasPort()) {
        result = result && getPort().equals(other.getPort());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasName()) {
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
      }
      if (hasPort()) {
        hash = (37 * hash) + PORT_FIELD_NUMBER;
        hash = (53 * hash) + getPort().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressServiceBackend prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressServiceBackend references a Kubernetes Service as a Backend.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressServiceBackend}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressServiceBackend)
        io.kubernetes.client.proto.V1Networking.IngressServiceBackendOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressServiceBackend_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressServiceBackend_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressServiceBackend.class,
                io.kubernetes.client.proto.V1Networking.IngressServiceBackend.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressServiceBackend.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPortFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (portBuilder_ == null) {
          port_ = null;
        } else {
          portBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressServiceBackend_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressServiceBackend
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressServiceBackend.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressServiceBackend build() {
        io.kubernetes.client.proto.V1Networking.IngressServiceBackend result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressServiceBackend buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressServiceBackend result =
            new io.kubernetes.client.proto.V1Networking.IngressServiceBackend(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.name_ = name_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (portBuilder_ == null) {
          result.port_ = port_;
        } else {
          result.port_ = portBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressServiceBackend) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressServiceBackend) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          io.kubernetes.client.proto.V1Networking.IngressServiceBackend other) {
        if (other
            == io.kubernetes.client.proto.V1Networking.IngressServiceBackend.getDefaultInstance())
          return this;
        if (other.hasName()) {
          bitField0_ |= 0x00000001;
          name_ = other.name_;
          onChanged();
        }
        if (other.hasPort()) {
          mergePort(other.getPort());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressServiceBackend parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressServiceBackend)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";
      /**
       *
       *
       * <pre>
       * Name is the referenced service. The service must exist in
       * the same namespace as the Ingress object.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Name is the referenced service. The service must exist in
       * the same namespace as the Ingress object.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            name_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name is the referenced service. The service must exist in
       * the same namespace as the Ingress object.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Name is the referenced service. The service must exist in
       * the same namespace as the Ingress object.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name is the referenced service. The service must exist in
       * the same namespace as the Ingress object.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Name is the referenced service. The service must exist in
       * the same namespace as the Ingress object.
       * </pre>
       *
       * <code>optional string name = 1;</code>
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        name_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1Networking.ServiceBackendPort port_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.ServiceBackendPort,
              io.kubernetes.client.proto.V1Networking.ServiceBackendPort.Builder,
              io.kubernetes.client.proto.V1Networking.ServiceBackendPortOrBuilder>
          portBuilder_;
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      public boolean hasPort() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.ServiceBackendPort getPort() {
        if (portBuilder_ == null) {
          return port_ == null
              ? io.kubernetes.client.proto.V1Networking.ServiceBackendPort.getDefaultInstance()
              : port_;
        } else {
          return portBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      public Builder setPort(io.kubernetes.client.proto.V1Networking.ServiceBackendPort value) {
        if (portBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          port_ = value;
          onChanged();
        } else {
          portBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      public Builder setPort(
          io.kubernetes.client.proto.V1Networking.ServiceBackendPort.Builder builderForValue) {
        if (portBuilder_ == null) {
          port_ = builderForValue.build();
          onChanged();
        } else {
          portBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      public Builder mergePort(io.kubernetes.client.proto.V1Networking.ServiceBackendPort value) {
        if (portBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && port_ != null
              && port_
                  != io.kubernetes.client.proto.V1Networking.ServiceBackendPort
                      .getDefaultInstance()) {
            port_ =
                io.kubernetes.client.proto.V1Networking.ServiceBackendPort.newBuilder(port_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            port_ = value;
          }
          onChanged();
        } else {
          portBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      public Builder clearPort() {
        if (portBuilder_ == null) {
          port_ = null;
          onChanged();
        } else {
          portBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.ServiceBackendPort.Builder getPortBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getPortFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.ServiceBackendPortOrBuilder
          getPortOrBuilder() {
        if (portBuilder_ != null) {
          return portBuilder_.getMessageOrBuilder();
        } else {
          return port_ == null
              ? io.kubernetes.client.proto.V1Networking.ServiceBackendPort.getDefaultInstance()
              : port_;
        }
      }
      /**
       *
       *
       * <pre>
       * Port of the referenced service. A port name or port number
       * is required for a IngressServiceBackend.
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.ServiceBackendPort port = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.ServiceBackendPort,
              io.kubernetes.client.proto.V1Networking.ServiceBackendPort.Builder,
              io.kubernetes.client.proto.V1Networking.ServiceBackendPortOrBuilder>
          getPortFieldBuilder() {
        if (portBuilder_ == null) {
          portBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.ServiceBackendPort,
                  io.kubernetes.client.proto.V1Networking.ServiceBackendPort.Builder,
                  io.kubernetes.client.proto.V1Networking.ServiceBackendPortOrBuilder>(
                  getPort(), getParentForChildren(), isClean());
          port_ = null;
        }
        return portBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressServiceBackend)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressServiceBackend)
    private static final io.kubernetes.client.proto.V1Networking.IngressServiceBackend
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressServiceBackend();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressServiceBackend
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressServiceBackend> PARSER =
        new com.google.protobuf.AbstractParser<IngressServiceBackend>() {
          @java.lang.Override
          public IngressServiceBackend parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressServiceBackend(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressServiceBackend> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressServiceBackend> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressServiceBackend
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * IngressClassName is the name of the IngressClass cluster resource. The
     * associated IngressClass defines which controller will implement the
     * resource. This replaces the deprecated `kubernetes.io/ingress.class`
     * annotation. For backwards compatibility, when that annotation is set, it
     * must be given precedence over this field. The controller may emit a
     * warning if the field and annotation have different values.
     * Implementations of this API should ignore Ingresses without a class
     * specified. An IngressClass resource may be marked as default, which can
     * be used to set a default value for this field. For more information,
     * refer to the IngressClass documentation.
     * +optional
     * </pre>
     *
     * <code>optional string ingressClassName = 4;</code>
     */
    boolean hasIngressClassName();
    /**
     *
     *
     * <pre>
     * IngressClassName is the name of the IngressClass cluster resource. The
     * associated IngressClass defines which controller will implement the
     * resource. This replaces the deprecated `kubernetes.io/ingress.class`
     * annotation. For backwards compatibility, when that annotation is set, it
     * must be given precedence over this field. The controller may emit a
     * warning if the field and annotation have different values.
     * Implementations of this API should ignore Ingresses without a class
     * specified. An IngressClass resource may be marked as default, which can
     * be used to set a default value for this field. For more information,
     * refer to the IngressClass documentation.
     * +optional
     * </pre>
     *
     * <code>optional string ingressClassName = 4;</code>
     */
    java.lang.String getIngressClassName();
    /**
     *
     *
     * <pre>
     * IngressClassName is the name of the IngressClass cluster resource. The
     * associated IngressClass defines which controller will implement the
     * resource. This replaces the deprecated `kubernetes.io/ingress.class`
     * annotation. For backwards compatibility, when that annotation is set, it
     * must be given precedence over this field. The controller may emit a
     * warning if the field and annotation have different values.
     * Implementations of this API should ignore Ingresses without a class
     * specified. An IngressClass resource may be marked as default, which can
     * be used to set a default value for this field. For more information,
     * refer to the IngressClass documentation.
     * +optional
     * </pre>
     *
     * <code>optional string ingressClassName = 4;</code>
     */
    com.google.protobuf.ByteString getIngressClassNameBytes();

    /**
     *
     *
     * <pre>
     * DefaultBackend is the backend that should handle requests that don't
     * match any rule. If Rules are not specified, DefaultBackend must be specified.
     * If DefaultBackend is not set, the handling of requests that do not match any
     * of the rules will be up to the Ingress controller.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
     */
    boolean hasDefaultBackend();
    /**
     *
     *
     * <pre>
     * DefaultBackend is the backend that should handle requests that don't
     * match any rule. If Rules are not specified, DefaultBackend must be specified.
     * If DefaultBackend is not set, the handling of requests that do not match any
     * of the rules will be up to the Ingress controller.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressBackend getDefaultBackend();
    /**
     *
     *
     * <pre>
     * DefaultBackend is the backend that should handle requests that don't
     * match any rule. If Rules are not specified, DefaultBackend must be specified.
     * If DefaultBackend is not set, the handling of requests that do not match any
     * of the rules will be up to the Ingress controller.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder getDefaultBackendOrBuilder();

    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.IngressTLS> getTlsList();
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressTLS getTls(int index);
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    int getTlsCount();
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder>
        getTlsOrBuilderList();
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder getTlsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.IngressRule> getRulesList();
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressRule getRules(int index);
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    int getRulesCount();
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder>
        getRulesOrBuilderList();
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder getRulesOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * IngressSpec describes the Ingress the user wishes to exist.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressSpec}
   */
  public static final class IngressSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressSpec)
      IngressSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressSpec.newBuilder() to construct.
    private IngressSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressSpec() {
      ingressClassName_ = "";
      tls_ = java.util.Collections.emptyList();
      rules_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressSpec(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.V1Networking.IngressBackend.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = defaultBackend_.toBuilder();
                }
                defaultBackend_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressBackend.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(defaultBackend_);
                  defaultBackend_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                  tls_ =
                      new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.IngressTLS>();
                  mutable_bitField0_ |= 0x00000004;
                }
                tls_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressTLS.PARSER,
                        extensionRegistry));
                break;
              }
            case 26:
              {
                if (!((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
                  rules_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Networking.IngressRule>();
                  mutable_bitField0_ |= 0x00000008;
                }
                rules_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IngressRule.PARSER,
                        extensionRegistry));
                break;
              }
            case 34:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                ingressClassName_ = bs;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          tls_ = java.util.Collections.unmodifiableList(tls_);
        }
        if (((mutable_bitField0_ & 0x00000008) == 0x00000008)) {
          rules_ = java.util.Collections.unmodifiableList(rules_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressSpec.class,
              io.kubernetes.client.proto.V1Networking.IngressSpec.Builder.class);
    }

    private int bitField0_;
    public static final int INGRESSCLASSNAME_FIELD_NUMBER = 4;
    private volatile java.lang.Object ingressClassName_;
    /**
     *
     *
     * <pre>
     * IngressClassName is the name of the IngressClass cluster resource. The
     * associated IngressClass defines which controller will implement the
     * resource. This replaces the deprecated `kubernetes.io/ingress.class`
     * annotation. For backwards compatibility, when that annotation is set, it
     * must be given precedence over this field. The controller may emit a
     * warning if the field and annotation have different values.
     * Implementations of this API should ignore Ingresses without a class
     * specified. An IngressClass resource may be marked as default, which can
     * be used to set a default value for this field. For more information,
     * refer to the IngressClass documentation.
     * +optional
     * </pre>
     *
     * <code>optional string ingressClassName = 4;</code>
     */
    public boolean hasIngressClassName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * IngressClassName is the name of the IngressClass cluster resource. The
     * associated IngressClass defines which controller will implement the
     * resource. This replaces the deprecated `kubernetes.io/ingress.class`
     * annotation. For backwards compatibility, when that annotation is set, it
     * must be given precedence over this field. The controller may emit a
     * warning if the field and annotation have different values.
     * Implementations of this API should ignore Ingresses without a class
     * specified. An IngressClass resource may be marked as default, which can
     * be used to set a default value for this field. For more information,
     * refer to the IngressClass documentation.
     * +optional
     * </pre>
     *
     * <code>optional string ingressClassName = 4;</code>
     */
    public java.lang.String getIngressClassName() {
      java.lang.Object ref = ingressClassName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          ingressClassName_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * IngressClassName is the name of the IngressClass cluster resource. The
     * associated IngressClass defines which controller will implement the
     * resource. This replaces the deprecated `kubernetes.io/ingress.class`
     * annotation. For backwards compatibility, when that annotation is set, it
     * must be given precedence over this field. The controller may emit a
     * warning if the field and annotation have different values.
     * Implementations of this API should ignore Ingresses without a class
     * specified. An IngressClass resource may be marked as default, which can
     * be used to set a default value for this field. For more information,
     * refer to the IngressClass documentation.
     * +optional
     * </pre>
     *
     * <code>optional string ingressClassName = 4;</code>
     */
    public com.google.protobuf.ByteString getIngressClassNameBytes() {
      java.lang.Object ref = ingressClassName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        ingressClassName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEFAULTBACKEND_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.V1Networking.IngressBackend defaultBackend_;
    /**
     *
     *
     * <pre>
     * DefaultBackend is the backend that should handle requests that don't
     * match any rule. If Rules are not specified, DefaultBackend must be specified.
     * If DefaultBackend is not set, the handling of requests that do not match any
     * of the rules will be up to the Ingress controller.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
     */
    public boolean hasDefaultBackend() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * DefaultBackend is the backend that should handle requests that don't
     * match any rule. If Rules are not specified, DefaultBackend must be specified.
     * If DefaultBackend is not set, the handling of requests that do not match any
     * of the rules will be up to the Ingress controller.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressBackend getDefaultBackend() {
      return defaultBackend_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()
          : defaultBackend_;
    }
    /**
     *
     *
     * <pre>
     * DefaultBackend is the backend that should handle requests that don't
     * match any rule. If Rules are not specified, DefaultBackend must be specified.
     * If DefaultBackend is not set, the handling of requests that do not match any
     * of the rules will be up to the Ingress controller.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder
        getDefaultBackendOrBuilder() {
      return defaultBackend_ == null
          ? io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()
          : defaultBackend_;
    }

    public static final int TLS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Networking.IngressTLS> tls_;
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.IngressTLS> getTlsList() {
      return tls_;
    }
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder>
        getTlsOrBuilderList() {
      return tls_;
    }
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    public int getTlsCount() {
      return tls_.size();
    }
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressTLS getTls(int index) {
      return tls_.get(index);
    }
    /**
     *
     *
     * <pre>
     * TLS configuration. Currently the Ingress only supports a single TLS
     * port, 443. If multiple members of this list specify different hosts, they
     * will be multiplexed on the same port according to the hostname specified
     * through the SNI TLS extension, if the ingress controller fulfilling the
     * ingress supports SNI.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder getTlsOrBuilder(int index) {
      return tls_.get(index);
    }

    public static final int RULES_FIELD_NUMBER = 3;
    private java.util.List<io.kubernetes.client.proto.V1Networking.IngressRule> rules_;
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.IngressRule> getRulesList() {
      return rules_;
    }
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder>
        getRulesOrBuilderList() {
      return rules_;
    }
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    public int getRulesCount() {
      return rules_.size();
    }
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressRule getRules(int index) {
      return rules_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A list of host rules used to configure the Ingress. If unspecified, or
     * no rule matches, all traffic is sent to the default backend.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder getRulesOrBuilder(
        int index) {
      return rules_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(1, getDefaultBackend());
      }
      for (int i = 0; i < tls_.size(); i++) {
        output.writeMessage(2, tls_.get(i));
      }
      for (int i = 0; i < rules_.size(); i++) {
        output.writeMessage(3, rules_.get(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, ingressClassName_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDefaultBackend());
      }
      for (int i = 0; i < tls_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, tls_.get(i));
      }
      for (int i = 0; i < rules_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, rules_.get(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, ingressClassName_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressSpec)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressSpec other =
          (io.kubernetes.client.proto.V1Networking.IngressSpec) obj;

      boolean result = true;
      result = result && (hasIngressClassName() == other.hasIngressClassName());
      if (hasIngressClassName()) {
        result = result && getIngressClassName().equals(other.getIngressClassName());
      }
      result = result && (hasDefaultBackend() == other.hasDefaultBackend());
      if (hasDefaultBackend()) {
        result = result && getDefaultBackend().equals(other.getDefaultBackend());
      }
      result = result && getTlsList().equals(other.getTlsList());
      result = result && getRulesList().equals(other.getRulesList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasIngressClassName()) {
        hash = (37 * hash) + INGRESSCLASSNAME_FIELD_NUMBER;
        hash = (53 * hash) + getIngressClassName().hashCode();
      }
      if (hasDefaultBackend()) {
        hash = (37 * hash) + DEFAULTBACKEND_FIELD_NUMBER;
        hash = (53 * hash) + getDefaultBackend().hashCode();
      }
      if (getTlsCount() > 0) {
        hash = (37 * hash) + TLS_FIELD_NUMBER;
        hash = (53 * hash) + getTlsList().hashCode();
      }
      if (getRulesCount() > 0) {
        hash = (37 * hash) + RULES_FIELD_NUMBER;
        hash = (53 * hash) + getRulesList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressSpec describes the Ingress the user wishes to exist.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressSpec)
        io.kubernetes.client.proto.V1Networking.IngressSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressSpec.class,
                io.kubernetes.client.proto.V1Networking.IngressSpec.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDefaultBackendFieldBuilder();
          getTlsFieldBuilder();
          getRulesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        ingressClassName_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (defaultBackendBuilder_ == null) {
          defaultBackend_ = null;
        } else {
          defaultBackendBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (tlsBuilder_ == null) {
          tls_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          tlsBuilder_.clear();
        }
        if (rulesBuilder_ == null) {
          rules_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
        } else {
          rulesBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressSpec_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressSpec getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressSpec.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressSpec build() {
        io.kubernetes.client.proto.V1Networking.IngressSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressSpec buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressSpec result =
            new io.kubernetes.client.proto.V1Networking.IngressSpec(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.ingressClassName_ = ingressClassName_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (defaultBackendBuilder_ == null) {
          result.defaultBackend_ = defaultBackend_;
        } else {
          result.defaultBackend_ = defaultBackendBuilder_.build();
        }
        if (tlsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            tls_ = java.util.Collections.unmodifiableList(tls_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.tls_ = tls_;
        } else {
          result.tls_ = tlsBuilder_.build();
        }
        if (rulesBuilder_ == null) {
          if (((bitField0_ & 0x00000008) == 0x00000008)) {
            rules_ = java.util.Collections.unmodifiableList(rules_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.rules_ = rules_;
        } else {
          result.rules_ = rulesBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressSpec) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressSpec other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressSpec.getDefaultInstance())
          return this;
        if (other.hasIngressClassName()) {
          bitField0_ |= 0x00000001;
          ingressClassName_ = other.ingressClassName_;
          onChanged();
        }
        if (other.hasDefaultBackend()) {
          mergeDefaultBackend(other.getDefaultBackend());
        }
        if (tlsBuilder_ == null) {
          if (!other.tls_.isEmpty()) {
            if (tls_.isEmpty()) {
              tls_ = other.tls_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureTlsIsMutable();
              tls_.addAll(other.tls_);
            }
            onChanged();
          }
        } else {
          if (!other.tls_.isEmpty()) {
            if (tlsBuilder_.isEmpty()) {
              tlsBuilder_.dispose();
              tlsBuilder_ = null;
              tls_ = other.tls_;
              bitField0_ = (bitField0_ & ~0x00000004);
              tlsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getTlsFieldBuilder()
                      : null;
            } else {
              tlsBuilder_.addAllMessages(other.tls_);
            }
          }
        }
        if (rulesBuilder_ == null) {
          if (!other.rules_.isEmpty()) {
            if (rules_.isEmpty()) {
              rules_ = other.rules_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureRulesIsMutable();
              rules_.addAll(other.rules_);
            }
            onChanged();
          }
        } else {
          if (!other.rules_.isEmpty()) {
            if (rulesBuilder_.isEmpty()) {
              rulesBuilder_.dispose();
              rulesBuilder_ = null;
              rules_ = other.rules_;
              bitField0_ = (bitField0_ & ~0x00000008);
              rulesBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getRulesFieldBuilder()
                      : null;
            } else {
              rulesBuilder_.addAllMessages(other.rules_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressSpec parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressSpec) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.lang.Object ingressClassName_ = "";
      /**
       *
       *
       * <pre>
       * IngressClassName is the name of the IngressClass cluster resource. The
       * associated IngressClass defines which controller will implement the
       * resource. This replaces the deprecated `kubernetes.io/ingress.class`
       * annotation. For backwards compatibility, when that annotation is set, it
       * must be given precedence over this field. The controller may emit a
       * warning if the field and annotation have different values.
       * Implementations of this API should ignore Ingresses without a class
       * specified. An IngressClass resource may be marked as default, which can
       * be used to set a default value for this field. For more information,
       * refer to the IngressClass documentation.
       * +optional
       * </pre>
       *
       * <code>optional string ingressClassName = 4;</code>
       */
      public boolean hasIngressClassName() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * IngressClassName is the name of the IngressClass cluster resource. The
       * associated IngressClass defines which controller will implement the
       * resource. This replaces the deprecated `kubernetes.io/ingress.class`
       * annotation. For backwards compatibility, when that annotation is set, it
       * must be given precedence over this field. The controller may emit a
       * warning if the field and annotation have different values.
       * Implementations of this API should ignore Ingresses without a class
       * specified. An IngressClass resource may be marked as default, which can
       * be used to set a default value for this field. For more information,
       * refer to the IngressClass documentation.
       * +optional
       * </pre>
       *
       * <code>optional string ingressClassName = 4;</code>
       */
      public java.lang.String getIngressClassName() {
        java.lang.Object ref = ingressClassName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            ingressClassName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * IngressClassName is the name of the IngressClass cluster resource. The
       * associated IngressClass defines which controller will implement the
       * resource. This replaces the deprecated `kubernetes.io/ingress.class`
       * annotation. For backwards compatibility, when that annotation is set, it
       * must be given precedence over this field. The controller may emit a
       * warning if the field and annotation have different values.
       * Implementations of this API should ignore Ingresses without a class
       * specified. An IngressClass resource may be marked as default, which can
       * be used to set a default value for this field. For more information,
       * refer to the IngressClass documentation.
       * +optional
       * </pre>
       *
       * <code>optional string ingressClassName = 4;</code>
       */
      public com.google.protobuf.ByteString getIngressClassNameBytes() {
        java.lang.Object ref = ingressClassName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          ingressClassName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * IngressClassName is the name of the IngressClass cluster resource. The
       * associated IngressClass defines which controller will implement the
       * resource. This replaces the deprecated `kubernetes.io/ingress.class`
       * annotation. For backwards compatibility, when that annotation is set, it
       * must be given precedence over this field. The controller may emit a
       * warning if the field and annotation have different values.
       * Implementations of this API should ignore Ingresses without a class
       * specified. An IngressClass resource may be marked as default, which can
       * be used to set a default value for this field. For more information,
       * refer to the IngressClass documentation.
       * +optional
       * </pre>
       *
       * <code>optional string ingressClassName = 4;</code>
       */
      public Builder setIngressClassName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        ingressClassName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * IngressClassName is the name of the IngressClass cluster resource. The
       * associated IngressClass defines which controller will implement the
       * resource. This replaces the deprecated `kubernetes.io/ingress.class`
       * annotation. For backwards compatibility, when that annotation is set, it
       * must be given precedence over this field. The controller may emit a
       * warning if the field and annotation have different values.
       * Implementations of this API should ignore Ingresses without a class
       * specified. An IngressClass resource may be marked as default, which can
       * be used to set a default value for this field. For more information,
       * refer to the IngressClass documentation.
       * +optional
       * </pre>
       *
       * <code>optional string ingressClassName = 4;</code>
       */
      public Builder clearIngressClassName() {
        bitField0_ = (bitField0_ & ~0x00000001);
        ingressClassName_ = getDefaultInstance().getIngressClassName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * IngressClassName is the name of the IngressClass cluster resource. The
       * associated IngressClass defines which controller will implement the
       * resource. This replaces the deprecated `kubernetes.io/ingress.class`
       * annotation. For backwards compatibility, when that annotation is set, it
       * must be given precedence over this field. The controller may emit a
       * warning if the field and annotation have different values.
       * Implementations of this API should ignore Ingresses without a class
       * specified. An IngressClass resource may be marked as default, which can
       * be used to set a default value for this field. For more information,
       * refer to the IngressClass documentation.
       * +optional
       * </pre>
       *
       * <code>optional string ingressClassName = 4;</code>
       */
      public Builder setIngressClassNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        ingressClassName_ = value;
        onChanged();
        return this;
      }

      private io.kubernetes.client.proto.V1Networking.IngressBackend defaultBackend_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressBackend,
              io.kubernetes.client.proto.V1Networking.IngressBackend.Builder,
              io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder>
          defaultBackendBuilder_;
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      public boolean hasDefaultBackend() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressBackend getDefaultBackend() {
        if (defaultBackendBuilder_ == null) {
          return defaultBackend_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()
              : defaultBackend_;
        } else {
          return defaultBackendBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      public Builder setDefaultBackend(
          io.kubernetes.client.proto.V1Networking.IngressBackend value) {
        if (defaultBackendBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultBackend_ = value;
          onChanged();
        } else {
          defaultBackendBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      public Builder setDefaultBackend(
          io.kubernetes.client.proto.V1Networking.IngressBackend.Builder builderForValue) {
        if (defaultBackendBuilder_ == null) {
          defaultBackend_ = builderForValue.build();
          onChanged();
        } else {
          defaultBackendBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      public Builder mergeDefaultBackend(
          io.kubernetes.client.proto.V1Networking.IngressBackend value) {
        if (defaultBackendBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && defaultBackend_ != null
              && defaultBackend_
                  != io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()) {
            defaultBackend_ =
                io.kubernetes.client.proto.V1Networking.IngressBackend.newBuilder(defaultBackend_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            defaultBackend_ = value;
          }
          onChanged();
        } else {
          defaultBackendBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      public Builder clearDefaultBackend() {
        if (defaultBackendBuilder_ == null) {
          defaultBackend_ = null;
          onChanged();
        } else {
          defaultBackendBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressBackend.Builder
          getDefaultBackendBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getDefaultBackendFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder
          getDefaultBackendOrBuilder() {
        if (defaultBackendBuilder_ != null) {
          return defaultBackendBuilder_.getMessageOrBuilder();
        } else {
          return defaultBackend_ == null
              ? io.kubernetes.client.proto.V1Networking.IngressBackend.getDefaultInstance()
              : defaultBackend_;
        }
      }
      /**
       *
       *
       * <pre>
       * DefaultBackend is the backend that should handle requests that don't
       * match any rule. If Rules are not specified, DefaultBackend must be specified.
       * If DefaultBackend is not set, the handling of requests that do not match any
       * of the rules will be up to the Ingress controller.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.IngressBackend defaultBackend = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressBackend,
              io.kubernetes.client.proto.V1Networking.IngressBackend.Builder,
              io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder>
          getDefaultBackendFieldBuilder() {
        if (defaultBackendBuilder_ == null) {
          defaultBackendBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressBackend,
                  io.kubernetes.client.proto.V1Networking.IngressBackend.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressBackendOrBuilder>(
                  getDefaultBackend(), getParentForChildren(), isClean());
          defaultBackend_ = null;
        }
        return defaultBackendBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Networking.IngressTLS> tls_ =
          java.util.Collections.emptyList();

      private void ensureTlsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          tls_ = new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.IngressTLS>(tls_);
          bitField0_ |= 0x00000004;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressTLS,
              io.kubernetes.client.proto.V1Networking.IngressTLS.Builder,
              io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder>
          tlsBuilder_;

      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.IngressTLS> getTlsList() {
        if (tlsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(tls_);
        } else {
          return tlsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public int getTlsCount() {
        if (tlsBuilder_ == null) {
          return tls_.size();
        } else {
          return tlsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressTLS getTls(int index) {
        if (tlsBuilder_ == null) {
          return tls_.get(index);
        } else {
          return tlsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder setTls(int index, io.kubernetes.client.proto.V1Networking.IngressTLS value) {
        if (tlsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTlsIsMutable();
          tls_.set(index, value);
          onChanged();
        } else {
          tlsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder setTls(
          int index, io.kubernetes.client.proto.V1Networking.IngressTLS.Builder builderForValue) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          tls_.set(index, builderForValue.build());
          onChanged();
        } else {
          tlsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder addTls(io.kubernetes.client.proto.V1Networking.IngressTLS value) {
        if (tlsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTlsIsMutable();
          tls_.add(value);
          onChanged();
        } else {
          tlsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder addTls(int index, io.kubernetes.client.proto.V1Networking.IngressTLS value) {
        if (tlsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureTlsIsMutable();
          tls_.add(index, value);
          onChanged();
        } else {
          tlsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder addTls(
          io.kubernetes.client.proto.V1Networking.IngressTLS.Builder builderForValue) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          tls_.add(builderForValue.build());
          onChanged();
        } else {
          tlsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder addTls(
          int index, io.kubernetes.client.proto.V1Networking.IngressTLS.Builder builderForValue) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          tls_.add(index, builderForValue.build());
          onChanged();
        } else {
          tlsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder addAllTls(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.IngressTLS> values) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, tls_);
          onChanged();
        } else {
          tlsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder clearTls() {
        if (tlsBuilder_ == null) {
          tls_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          tlsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public Builder removeTls(int index) {
        if (tlsBuilder_ == null) {
          ensureTlsIsMutable();
          tls_.remove(index);
          onChanged();
        } else {
          tlsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressTLS.Builder getTlsBuilder(int index) {
        return getTlsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder getTlsOrBuilder(
          int index) {
        if (tlsBuilder_ == null) {
          return tls_.get(index);
        } else {
          return tlsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder>
          getTlsOrBuilderList() {
        if (tlsBuilder_ != null) {
          return tlsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(tls_);
        }
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressTLS.Builder addTlsBuilder() {
        return getTlsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Networking.IngressTLS.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressTLS.Builder addTlsBuilder(int index) {
        return getTlsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1Networking.IngressTLS.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * TLS configuration. Currently the Ingress only supports a single TLS
       * port, 443. If multiple members of this list specify different hosts, they
       * will be multiplexed on the same port according to the hostname specified
       * through the SNI TLS extension, if the ingress controller fulfilling the
       * ingress supports SNI.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressTLS tls = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.IngressTLS.Builder>
          getTlsBuilderList() {
        return getTlsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressTLS,
              io.kubernetes.client.proto.V1Networking.IngressTLS.Builder,
              io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder>
          getTlsFieldBuilder() {
        if (tlsBuilder_ == null) {
          tlsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressTLS,
                  io.kubernetes.client.proto.V1Networking.IngressTLS.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder>(
                  tls_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          tls_ = null;
        }
        return tlsBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Networking.IngressRule> rules_ =
          java.util.Collections.emptyList();

      private void ensureRulesIsMutable() {
        if (!((bitField0_ & 0x00000008) == 0x00000008)) {
          rules_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.IngressRule>(rules_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressRule,
              io.kubernetes.client.proto.V1Networking.IngressRule.Builder,
              io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder>
          rulesBuilder_;

      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.IngressRule> getRulesList() {
        if (rulesBuilder_ == null) {
          return java.util.Collections.unmodifiableList(rules_);
        } else {
          return rulesBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public int getRulesCount() {
        if (rulesBuilder_ == null) {
          return rules_.size();
        } else {
          return rulesBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressRule getRules(int index) {
        if (rulesBuilder_ == null) {
          return rules_.get(index);
        } else {
          return rulesBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder setRules(
          int index, io.kubernetes.client.proto.V1Networking.IngressRule value) {
        if (rulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRulesIsMutable();
          rules_.set(index, value);
          onChanged();
        } else {
          rulesBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder setRules(
          int index, io.kubernetes.client.proto.V1Networking.IngressRule.Builder builderForValue) {
        if (rulesBuilder_ == null) {
          ensureRulesIsMutable();
          rules_.set(index, builderForValue.build());
          onChanged();
        } else {
          rulesBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder addRules(io.kubernetes.client.proto.V1Networking.IngressRule value) {
        if (rulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRulesIsMutable();
          rules_.add(value);
          onChanged();
        } else {
          rulesBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder addRules(
          int index, io.kubernetes.client.proto.V1Networking.IngressRule value) {
        if (rulesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureRulesIsMutable();
          rules_.add(index, value);
          onChanged();
        } else {
          rulesBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder addRules(
          io.kubernetes.client.proto.V1Networking.IngressRule.Builder builderForValue) {
        if (rulesBuilder_ == null) {
          ensureRulesIsMutable();
          rules_.add(builderForValue.build());
          onChanged();
        } else {
          rulesBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder addRules(
          int index, io.kubernetes.client.proto.V1Networking.IngressRule.Builder builderForValue) {
        if (rulesBuilder_ == null) {
          ensureRulesIsMutable();
          rules_.add(index, builderForValue.build());
          onChanged();
        } else {
          rulesBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder addAllRules(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.IngressRule>
              values) {
        if (rulesBuilder_ == null) {
          ensureRulesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rules_);
          onChanged();
        } else {
          rulesBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder clearRules() {
        if (rulesBuilder_ == null) {
          rules_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          rulesBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public Builder removeRules(int index) {
        if (rulesBuilder_ == null) {
          ensureRulesIsMutable();
          rules_.remove(index);
          onChanged();
        } else {
          rulesBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressRule.Builder getRulesBuilder(
          int index) {
        return getRulesFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder getRulesOrBuilder(
          int index) {
        if (rulesBuilder_ == null) {
          return rules_.get(index);
        } else {
          return rulesBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public java.util.List<? extends io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder>
          getRulesOrBuilderList() {
        if (rulesBuilder_ != null) {
          return rulesBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(rules_);
        }
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressRule.Builder addRulesBuilder() {
        return getRulesFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Networking.IngressRule.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public io.kubernetes.client.proto.V1Networking.IngressRule.Builder addRulesBuilder(
          int index) {
        return getRulesFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1Networking.IngressRule.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A list of host rules used to configure the Ingress. If unspecified, or
       * no rule matches, all traffic is sent to the default backend.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.IngressRule rules = 3;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.IngressRule.Builder>
          getRulesBuilderList() {
        return getRulesFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.IngressRule,
              io.kubernetes.client.proto.V1Networking.IngressRule.Builder,
              io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder>
          getRulesFieldBuilder() {
        if (rulesBuilder_ == null) {
          rulesBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.IngressRule,
                  io.kubernetes.client.proto.V1Networking.IngressRule.Builder,
                  io.kubernetes.client.proto.V1Networking.IngressRuleOrBuilder>(
                  rules_,
                  ((bitField0_ & 0x00000008) == 0x00000008),
                  getParentForChildren(),
                  isClean());
          rules_ = null;
        }
        return rulesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressSpec)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressSpec)
    private static final io.kubernetes.client.proto.V1Networking.IngressSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressSpec();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressSpec> PARSER =
        new com.google.protobuf.AbstractParser<IngressSpec>() {
          @java.lang.Override
          public IngressSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressSpec(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressStatusOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressStatus)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * LoadBalancer contains the current status of the load-balancer.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
     */
    boolean hasLoadBalancer();
    /**
     *
     *
     * <pre>
     * LoadBalancer contains the current status of the load-balancer.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
     */
    io.kubernetes.client.proto.V1.LoadBalancerStatus getLoadBalancer();
    /**
     *
     *
     * <pre>
     * LoadBalancer contains the current status of the load-balancer.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
     */
    io.kubernetes.client.proto.V1.LoadBalancerStatusOrBuilder getLoadBalancerOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * IngressStatus describe the current state of the Ingress.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressStatus}
   */
  public static final class IngressStatus extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressStatus)
      IngressStatusOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressStatus.newBuilder() to construct.
    private IngressStatus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressStatus() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressStatus(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.V1.LoadBalancerStatus.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = loadBalancer_.toBuilder();
                }
                loadBalancer_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1.LoadBalancerStatus.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(loadBalancer_);
                  loadBalancer_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressStatus.class,
              io.kubernetes.client.proto.V1Networking.IngressStatus.Builder.class);
    }

    private int bitField0_;
    public static final int LOADBALANCER_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.V1.LoadBalancerStatus loadBalancer_;
    /**
     *
     *
     * <pre>
     * LoadBalancer contains the current status of the load-balancer.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
     */
    public boolean hasLoadBalancer() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * LoadBalancer contains the current status of the load-balancer.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
     */
    public io.kubernetes.client.proto.V1.LoadBalancerStatus getLoadBalancer() {
      return loadBalancer_ == null
          ? io.kubernetes.client.proto.V1.LoadBalancerStatus.getDefaultInstance()
          : loadBalancer_;
    }
    /**
     *
     *
     * <pre>
     * LoadBalancer contains the current status of the load-balancer.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
     */
    public io.kubernetes.client.proto.V1.LoadBalancerStatusOrBuilder getLoadBalancerOrBuilder() {
      return loadBalancer_ == null
          ? io.kubernetes.client.proto.V1.LoadBalancerStatus.getDefaultInstance()
          : loadBalancer_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getLoadBalancer());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getLoadBalancer());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressStatus)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressStatus other =
          (io.kubernetes.client.proto.V1Networking.IngressStatus) obj;

      boolean result = true;
      result = result && (hasLoadBalancer() == other.hasLoadBalancer());
      if (hasLoadBalancer()) {
        result = result && getLoadBalancer().equals(other.getLoadBalancer());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasLoadBalancer()) {
        hash = (37 * hash) + LOADBALANCER_FIELD_NUMBER;
        hash = (53 * hash) + getLoadBalancer().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.IngressStatus prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressStatus describe the current state of the Ingress.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressStatus}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressStatus)
        io.kubernetes.client.proto.V1Networking.IngressStatusOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressStatus_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressStatus_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressStatus.class,
                io.kubernetes.client.proto.V1Networking.IngressStatus.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressStatus.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getLoadBalancerFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (loadBalancerBuilder_ == null) {
          loadBalancer_ = null;
        } else {
          loadBalancerBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressStatus_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressStatus getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressStatus.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressStatus build() {
        io.kubernetes.client.proto.V1Networking.IngressStatus result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressStatus buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressStatus result =
            new io.kubernetes.client.proto.V1Networking.IngressStatus(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (loadBalancerBuilder_ == null) {
          result.loadBalancer_ = loadBalancer_;
        } else {
          result.loadBalancer_ = loadBalancerBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressStatus) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressStatus) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressStatus other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressStatus.getDefaultInstance())
          return this;
        if (other.hasLoadBalancer()) {
          mergeLoadBalancer(other.getLoadBalancer());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressStatus parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressStatus) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.V1.LoadBalancerStatus loadBalancer_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.LoadBalancerStatus,
              io.kubernetes.client.proto.V1.LoadBalancerStatus.Builder,
              io.kubernetes.client.proto.V1.LoadBalancerStatusOrBuilder>
          loadBalancerBuilder_;
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      public boolean hasLoadBalancer() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      public io.kubernetes.client.proto.V1.LoadBalancerStatus getLoadBalancer() {
        if (loadBalancerBuilder_ == null) {
          return loadBalancer_ == null
              ? io.kubernetes.client.proto.V1.LoadBalancerStatus.getDefaultInstance()
              : loadBalancer_;
        } else {
          return loadBalancerBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      public Builder setLoadBalancer(io.kubernetes.client.proto.V1.LoadBalancerStatus value) {
        if (loadBalancerBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          loadBalancer_ = value;
          onChanged();
        } else {
          loadBalancerBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      public Builder setLoadBalancer(
          io.kubernetes.client.proto.V1.LoadBalancerStatus.Builder builderForValue) {
        if (loadBalancerBuilder_ == null) {
          loadBalancer_ = builderForValue.build();
          onChanged();
        } else {
          loadBalancerBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      public Builder mergeLoadBalancer(io.kubernetes.client.proto.V1.LoadBalancerStatus value) {
        if (loadBalancerBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && loadBalancer_ != null
              && loadBalancer_
                  != io.kubernetes.client.proto.V1.LoadBalancerStatus.getDefaultInstance()) {
            loadBalancer_ =
                io.kubernetes.client.proto.V1.LoadBalancerStatus.newBuilder(loadBalancer_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            loadBalancer_ = value;
          }
          onChanged();
        } else {
          loadBalancerBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      public Builder clearLoadBalancer() {
        if (loadBalancerBuilder_ == null) {
          loadBalancer_ = null;
          onChanged();
        } else {
          loadBalancerBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      public io.kubernetes.client.proto.V1.LoadBalancerStatus.Builder getLoadBalancerBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getLoadBalancerFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      public io.kubernetes.client.proto.V1.LoadBalancerStatusOrBuilder getLoadBalancerOrBuilder() {
        if (loadBalancerBuilder_ != null) {
          return loadBalancerBuilder_.getMessageOrBuilder();
        } else {
          return loadBalancer_ == null
              ? io.kubernetes.client.proto.V1.LoadBalancerStatus.getDefaultInstance()
              : loadBalancer_;
        }
      }
      /**
       *
       *
       * <pre>
       * LoadBalancer contains the current status of the load-balancer.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.core.v1.LoadBalancerStatus loadBalancer = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1.LoadBalancerStatus,
              io.kubernetes.client.proto.V1.LoadBalancerStatus.Builder,
              io.kubernetes.client.proto.V1.LoadBalancerStatusOrBuilder>
          getLoadBalancerFieldBuilder() {
        if (loadBalancerBuilder_ == null) {
          loadBalancerBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1.LoadBalancerStatus,
                  io.kubernetes.client.proto.V1.LoadBalancerStatus.Builder,
                  io.kubernetes.client.proto.V1.LoadBalancerStatusOrBuilder>(
                  getLoadBalancer(), getParentForChildren(), isClean());
          loadBalancer_ = null;
        }
        return loadBalancerBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressStatus)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressStatus)
    private static final io.kubernetes.client.proto.V1Networking.IngressStatus DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressStatus();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressStatus getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressStatus> PARSER =
        new com.google.protobuf.AbstractParser<IngressStatus>() {
          @java.lang.Override
          public IngressStatus parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressStatus(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressStatus> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressStatus> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressStatus getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface IngressTLSOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.IngressTLS)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Hosts are a list of hosts included in the TLS certificate. The values in
     * this list must match the name/s used in the tlsSecret. Defaults to the
     * wildcard host setting for the loadbalancer controller fulfilling this
     * Ingress, if left unspecified.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     */
    java.util.List<java.lang.String> getHostsList();
    /**
     *
     *
     * <pre>
     * Hosts are a list of hosts included in the TLS certificate. The values in
     * this list must match the name/s used in the tlsSecret. Defaults to the
     * wildcard host setting for the loadbalancer controller fulfilling this
     * Ingress, if left unspecified.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     */
    int getHostsCount();
    /**
     *
     *
     * <pre>
     * Hosts are a list of hosts included in the TLS certificate. The values in
     * this list must match the name/s used in the tlsSecret. Defaults to the
     * wildcard host setting for the loadbalancer controller fulfilling this
     * Ingress, if left unspecified.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     */
    java.lang.String getHosts(int index);
    /**
     *
     *
     * <pre>
     * Hosts are a list of hosts included in the TLS certificate. The values in
     * this list must match the name/s used in the tlsSecret. Defaults to the
     * wildcard host setting for the loadbalancer controller fulfilling this
     * Ingress, if left unspecified.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     */
    com.google.protobuf.ByteString getHostsBytes(int index);

    /**
     *
     *
     * <pre>
     * SecretName is the name of the secret used to terminate TLS traffic on
     * port 443. Field is left optional to allow TLS routing based on SNI
     * hostname alone. If the SNI host in a listener conflicts with the "Host"
     * header field used by an IngressRule, the SNI host is used for termination
     * and value of the Host header is used for routing.
     * +optional
     * </pre>
     *
     * <code>optional string secretName = 2;</code>
     */
    boolean hasSecretName();
    /**
     *
     *
     * <pre>
     * SecretName is the name of the secret used to terminate TLS traffic on
     * port 443. Field is left optional to allow TLS routing based on SNI
     * hostname alone. If the SNI host in a listener conflicts with the "Host"
     * header field used by an IngressRule, the SNI host is used for termination
     * and value of the Host header is used for routing.
     * +optional
     * </pre>
     *
     * <code>optional string secretName = 2;</code>
     */
    java.lang.String getSecretName();
    /**
     *
     *
     * <pre>
     * SecretName is the name of the secret used to terminate TLS traffic on
     * port 443. Field is left optional to allow TLS routing based on SNI
     * hostname alone. If the SNI host in a listener conflicts with the "Host"
     * header field used by an IngressRule, the SNI host is used for termination
     * and value of the Host header is used for routing.
     * +optional
     * </pre>
     *
     * <code>optional string secretName = 2;</code>
     */
    com.google.protobuf.ByteString getSecretNameBytes();
  }
  /**
   *
   *
   * <pre>
   * IngressTLS describes the transport layer security associated with an Ingress.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.IngressTLS}
   */
  public static final class IngressTLS extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.IngressTLS)
      IngressTLSOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use IngressTLS.newBuilder() to construct.
    private IngressTLS(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private IngressTLS() {
      hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      secretName_ = "";
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private IngressTLS(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                  hosts_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                hosts_.add(bs);
                break;
              }
            case 18:
              {
                com.google.protobuf.ByteString bs = input.readBytes();
                bitField0_ |= 0x00000001;
                secretName_ = bs;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          hosts_ = hosts_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressTLS_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_IngressTLS_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.IngressTLS.class,
              io.kubernetes.client.proto.V1Networking.IngressTLS.Builder.class);
    }

    private int bitField0_;
    public static final int HOSTS_FIELD_NUMBER = 1;
    private com.google.protobuf.LazyStringList hosts_;
    /**
     *
     *
     * <pre>
     * Hosts are a list of hosts included in the TLS certificate. The values in
     * this list must match the name/s used in the tlsSecret. Defaults to the
     * wildcard host setting for the loadbalancer controller fulfilling this
     * Ingress, if left unspecified.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     */
    public com.google.protobuf.ProtocolStringList getHostsList() {
      return hosts_;
    }
    /**
     *
     *
     * <pre>
     * Hosts are a list of hosts included in the TLS certificate. The values in
     * this list must match the name/s used in the tlsSecret. Defaults to the
     * wildcard host setting for the loadbalancer controller fulfilling this
     * Ingress, if left unspecified.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     */
    public int getHostsCount() {
      return hosts_.size();
    }
    /**
     *
     *
     * <pre>
     * Hosts are a list of hosts included in the TLS certificate. The values in
     * this list must match the name/s used in the tlsSecret. Defaults to the
     * wildcard host setting for the loadbalancer controller fulfilling this
     * Ingress, if left unspecified.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     */
    public java.lang.String getHosts(int index) {
      return hosts_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Hosts are a list of hosts included in the TLS certificate. The values in
     * this list must match the name/s used in the tlsSecret. Defaults to the
     * wildcard host setting for the loadbalancer controller fulfilling this
     * Ingress, if left unspecified.
     * +listType=atomic
     * +optional
     * </pre>
     *
     * <code>repeated string hosts = 1;</code>
     */
    public com.google.protobuf.ByteString getHostsBytes(int index) {
      return hosts_.getByteString(index);
    }

    public static final int SECRETNAME_FIELD_NUMBER = 2;
    private volatile java.lang.Object secretName_;
    /**
     *
     *
     * <pre>
     * SecretName is the name of the secret used to terminate TLS traffic on
     * port 443. Field is left optional to allow TLS routing based on SNI
     * hostname alone. If the SNI host in a listener conflicts with the "Host"
     * header field used by an IngressRule, the SNI host is used for termination
     * and value of the Host header is used for routing.
     * +optional
     * </pre>
     *
     * <code>optional string secretName = 2;</code>
     */
    public boolean hasSecretName() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * SecretName is the name of the secret used to terminate TLS traffic on
     * port 443. Field is left optional to allow TLS routing based on SNI
     * hostname alone. If the SNI host in a listener conflicts with the "Host"
     * header field used by an IngressRule, the SNI host is used for termination
     * and value of the Host header is used for routing.
     * +optional
     * </pre>
     *
     * <code>optional string secretName = 2;</code>
     */
    public java.lang.String getSecretName() {
      java.lang.Object ref = secretName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          secretName_ = s;
        }
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * SecretName is the name of the secret used to terminate TLS traffic on
     * port 443. Field is left optional to allow TLS routing based on SNI
     * hostname alone. If the SNI host in a listener conflicts with the "Host"
     * header field used by an IngressRule, the SNI host is used for termination
     * and value of the Host header is used for routing.
     * +optional
     * </pre>
     *
     * <code>optional string secretName = 2;</code>
     */
    public com.google.protobuf.ByteString getSecretNameBytes() {
      java.lang.Object ref = secretName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        secretName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < hosts_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, hosts_.getRaw(i));
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, secretName_);
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < hosts_.size(); i++) {
          dataSize += computeStringSizeNoTag(hosts_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getHostsList().size();
      }
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, secretName_);
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.IngressTLS)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.IngressTLS other =
          (io.kubernetes.client.proto.V1Networking.IngressTLS) obj;

      boolean result = true;
      result = result && getHostsList().equals(other.getHostsList());
      result = result && (hasSecretName() == other.hasSecretName());
      if (hasSecretName()) {
        result = result && getSecretName().equals(other.getSecretName());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getHostsCount() > 0) {
        hash = (37 * hash) + HOSTS_FIELD_NUMBER;
        hash = (53 * hash) + getHostsList().hashCode();
      }
      if (hasSecretName()) {
        hash = (37 * hash) + SECRETNAME_FIELD_NUMBER;
        hash = (53 * hash) + getSecretName().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(io.kubernetes.client.proto.V1Networking.IngressTLS prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * IngressTLS describes the transport layer security associated with an Ingress.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.IngressTLS}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.IngressTLS)
        io.kubernetes.client.proto.V1Networking.IngressTLSOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressTLS_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressTLS_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.IngressTLS.class,
                io.kubernetes.client.proto.V1Networking.IngressTLS.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.IngressTLS.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        secretName_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_IngressTLS_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressTLS getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.IngressTLS.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressTLS build() {
        io.kubernetes.client.proto.V1Networking.IngressTLS result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.IngressTLS buildPartial() {
        io.kubernetes.client.proto.V1Networking.IngressTLS result =
            new io.kubernetes.client.proto.V1Networking.IngressTLS(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((bitField0_ & 0x00000001) == 0x00000001)) {
          hosts_ = hosts_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.hosts_ = hosts_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000001;
        }
        result.secretName_ = secretName_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.IngressTLS) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.IngressTLS) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.IngressTLS other) {
        if (other == io.kubernetes.client.proto.V1Networking.IngressTLS.getDefaultInstance())
          return this;
        if (!other.hosts_.isEmpty()) {
          if (hosts_.isEmpty()) {
            hosts_ = other.hosts_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureHostsIsMutable();
            hosts_.addAll(other.hosts_);
          }
          onChanged();
        }
        if (other.hasSecretName()) {
          bitField0_ |= 0x00000002;
          secretName_ = other.secretName_;
          onChanged();
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.IngressTLS parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.IngressTLS) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringList hosts_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureHostsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          hosts_ = new com.google.protobuf.LazyStringArrayList(hosts_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public com.google.protobuf.ProtocolStringList getHostsList() {
        return hosts_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public int getHostsCount() {
        return hosts_.size();
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public java.lang.String getHosts(int index) {
        return hosts_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public com.google.protobuf.ByteString getHostsBytes(int index) {
        return hosts_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public Builder setHosts(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHostsIsMutable();
        hosts_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public Builder addHosts(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHostsIsMutable();
        hosts_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public Builder addAllHosts(java.lang.Iterable<java.lang.String> values) {
        ensureHostsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, hosts_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public Builder clearHosts() {
        hosts_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Hosts are a list of hosts included in the TLS certificate. The values in
       * this list must match the name/s used in the tlsSecret. Defaults to the
       * wildcard host setting for the loadbalancer controller fulfilling this
       * Ingress, if left unspecified.
       * +listType=atomic
       * +optional
       * </pre>
       *
       * <code>repeated string hosts = 1;</code>
       */
      public Builder addHostsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureHostsIsMutable();
        hosts_.add(value);
        onChanged();
        return this;
      }

      private java.lang.Object secretName_ = "";
      /**
       *
       *
       * <pre>
       * SecretName is the name of the secret used to terminate TLS traffic on
       * port 443. Field is left optional to allow TLS routing based on SNI
       * hostname alone. If the SNI host in a listener conflicts with the "Host"
       * header field used by an IngressRule, the SNI host is used for termination
       * and value of the Host header is used for routing.
       * +optional
       * </pre>
       *
       * <code>optional string secretName = 2;</code>
       */
      public boolean hasSecretName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * SecretName is the name of the secret used to terminate TLS traffic on
       * port 443. Field is left optional to allow TLS routing based on SNI
       * hostname alone. If the SNI host in a listener conflicts with the "Host"
       * header field used by an IngressRule, the SNI host is used for termination
       * and value of the Host header is used for routing.
       * +optional
       * </pre>
       *
       * <code>optional string secretName = 2;</code>
       */
      public java.lang.String getSecretName() {
        java.lang.Object ref = secretName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            secretName_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * SecretName is the name of the secret used to terminate TLS traffic on
       * port 443. Field is left optional to allow TLS routing based on SNI
       * hostname alone. If the SNI host in a listener conflicts with the "Host"
       * header field used by an IngressRule, the SNI host is used for termination
       * and value of the Host header is used for routing.
       * +optional
       * </pre>
       *
       * <code>optional string secretName = 2;</code>
       */
      public com.google.protobuf.ByteString getSecretNameBytes() {
        java.lang.Object ref = secretName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          secretName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * SecretName is the name of the secret used to terminate TLS traffic on
       * port 443. Field is left optional to allow TLS routing based on SNI
       * hostname alone. If the SNI host in a listener conflicts with the "Host"
       * header field used by an IngressRule, the SNI host is used for termination
       * and value of the Host header is used for routing.
       * +optional
       * </pre>
       *
       * <code>optional string secretName = 2;</code>
       */
      public Builder setSecretName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        secretName_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * SecretName is the name of the secret used to terminate TLS traffic on
       * port 443. Field is left optional to allow TLS routing based on SNI
       * hostname alone. If the SNI host in a listener conflicts with the "Host"
       * header field used by an IngressRule, the SNI host is used for termination
       * and value of the Host header is used for routing.
       * +optional
       * </pre>
       *
       * <code>optional string secretName = 2;</code>
       */
      public Builder clearSecretName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        secretName_ = getDefaultInstance().getSecretName();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * SecretName is the name of the secret used to terminate TLS traffic on
       * port 443. Field is left optional to allow TLS routing based on SNI
       * hostname alone. If the SNI host in a listener conflicts with the "Host"
       * header field used by an IngressRule, the SNI host is used for termination
       * and value of the Host header is used for routing.
       * +optional
       * </pre>
       *
       * <code>optional string secretName = 2;</code>
       */
      public Builder setSecretNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        secretName_ = value;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.IngressTLS)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.IngressTLS)
    private static final io.kubernetes.client.proto.V1Networking.IngressTLS DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.IngressTLS();
    }

    public static io.kubernetes.client.proto.V1Networking.IngressTLS getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<IngressTLS> PARSER =
        new com.google.protobuf.AbstractParser<IngressTLS>() {
          @java.lang.Override
          public IngressTLS parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new IngressTLS(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<IngressTLS> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<IngressTLS> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.IngressTLS getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkPolicyOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.NetworkPolicy)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Specification of the desired behavior for this NetworkPolicy.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
     */
    boolean hasSpec();
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior for this NetworkPolicy.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicySpec getSpec();
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior for this NetworkPolicy.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicySpecOrBuilder getSpecOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * NetworkPolicy describes what network traffic is allowed for a set of Pods
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicy}
   */
  public static final class NetworkPolicy extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.NetworkPolicy)
      NetworkPolicyOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NetworkPolicy.newBuilder() to construct.
    private NetworkPolicy(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkPolicy() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private NetworkPolicy(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ObjectMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ObjectMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = spec_.toBuilder();
                }
                spec_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.PARSER,
                        extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(spec_);
                  spec_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicy_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicy_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.NetworkPolicy.class,
              io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ObjectMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard object's metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int SPEC_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.V1Networking.NetworkPolicySpec spec_;
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior for this NetworkPolicy.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
     */
    public boolean hasSpec() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior for this NetworkPolicy.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicySpec getSpec() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.getDefaultInstance()
          : spec_;
    }
    /**
     *
     *
     * <pre>
     * Specification of the desired behavior for this NetworkPolicy.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicySpecOrBuilder getSpecOrBuilder() {
      return spec_ == null
          ? io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.getDefaultInstance()
          : spec_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getSpec());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getSpec());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicy)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.NetworkPolicy other =
          (io.kubernetes.client.proto.V1Networking.NetworkPolicy) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && (hasSpec() == other.hasSpec());
      if (hasSpec()) {
        result = result && getSpec().equals(other.getSpec());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (hasSpec()) {
        hash = (37 * hash) + SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSpec().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.NetworkPolicy prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * NetworkPolicy describes what network traffic is allowed for a set of Pods
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicy}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.NetworkPolicy)
        io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicy_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicy_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.NetworkPolicy.class,
                io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.NetworkPolicy.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getSpecFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (specBuilder_ == null) {
          spec_ = null;
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicy_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicy getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.NetworkPolicy.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicy build() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicy result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicy buildPartial() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicy result =
            new io.kubernetes.client.proto.V1Networking.NetworkPolicy(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (specBuilder_ == null) {
          result.spec_ = spec_;
        } else {
          result.spec_ = specBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicy) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.NetworkPolicy) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.NetworkPolicy other) {
        if (other == io.kubernetes.client.proto.V1Networking.NetworkPolicy.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (other.hasSpec()) {
          mergeSpec(other.getSpec());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.NetworkPolicy parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.NetworkPolicy) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ObjectMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder setMetadata(
          io.kubernetes.client.proto.Meta.ObjectMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ObjectMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ObjectMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ObjectMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard object's metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ObjectMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ObjectMeta,
              io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
              io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ObjectMeta,
                  io.kubernetes.client.proto.Meta.ObjectMeta.Builder,
                  io.kubernetes.client.proto.Meta.ObjectMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private io.kubernetes.client.proto.V1Networking.NetworkPolicySpec spec_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicySpec,
              io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicySpecOrBuilder>
          specBuilder_;
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      public boolean hasSpec() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicySpec getSpec() {
        if (specBuilder_ == null) {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.getDefaultInstance()
              : spec_;
        } else {
          return specBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      public Builder setSpec(io.kubernetes.client.proto.V1Networking.NetworkPolicySpec value) {
        if (specBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          spec_ = value;
          onChanged();
        } else {
          specBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      public Builder setSpec(
          io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.Builder builderForValue) {
        if (specBuilder_ == null) {
          spec_ = builderForValue.build();
          onChanged();
        } else {
          specBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      public Builder mergeSpec(io.kubernetes.client.proto.V1Networking.NetworkPolicySpec value) {
        if (specBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && spec_ != null
              && spec_
                  != io.kubernetes.client.proto.V1Networking.NetworkPolicySpec
                      .getDefaultInstance()) {
            spec_ =
                io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.newBuilder(spec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            spec_ = value;
          }
          onChanged();
        } else {
          specBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      public Builder clearSpec() {
        if (specBuilder_ == null) {
          spec_ = null;
          onChanged();
        } else {
          specBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.Builder getSpecBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicySpecOrBuilder getSpecOrBuilder() {
        if (specBuilder_ != null) {
          return specBuilder_.getMessageOrBuilder();
        } else {
          return spec_ == null
              ? io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.getDefaultInstance()
              : spec_;
        }
      }
      /**
       *
       *
       * <pre>
       * Specification of the desired behavior for this NetworkPolicy.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.api.networking.v1.NetworkPolicySpec spec = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicySpec,
              io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicySpecOrBuilder>
          getSpecFieldBuilder() {
        if (specBuilder_ == null) {
          specBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.NetworkPolicySpec,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicySpec.Builder,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicySpecOrBuilder>(
                  getSpec(), getParentForChildren(), isClean());
          spec_ = null;
        }
        return specBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.NetworkPolicy)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.NetworkPolicy)
    private static final io.kubernetes.client.proto.V1Networking.NetworkPolicy DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.NetworkPolicy();
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicy getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<NetworkPolicy> PARSER =
        new com.google.protobuf.AbstractParser<NetworkPolicy>() {
          @java.lang.Override
          public NetworkPolicy parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new NetworkPolicy(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<NetworkPolicy> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NetworkPolicy> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.NetworkPolicy getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkPolicyEgressRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.NetworkPolicyEgressRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort> getPortsList();
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyPort getPorts(int index);
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    int getPortsCount();
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
        getPortsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder getPortsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> getToList();
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer getTo(int index);
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    int getToCount();
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
        getToOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder getToOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods
   * matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to.
   * This type is beta-level in 1.8
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicyEgressRule}
   */
  public static final class NetworkPolicyEgressRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.NetworkPolicyEgressRule)
      NetworkPolicyEgressRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NetworkPolicyEgressRule.newBuilder() to construct.
    private NetworkPolicyEgressRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkPolicyEgressRule() {
      ports_ = java.util.Collections.emptyList();
      to_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private NetworkPolicyEgressRule(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                  ports_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>();
                  mutable_bitField0_ |= 0x00000001;
                }
                ports_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.PARSER,
                        extensionRegistry));
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  to_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer>();
                  mutable_bitField0_ |= 0x00000002;
                }
                to_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          ports_ = java.util.Collections.unmodifiableList(ports_);
        }
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          to_ = java.util.Collections.unmodifiableList(to_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicyEgressRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicyEgressRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule.class,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule.Builder.class);
    }

    public static final int PORTS_FIELD_NUMBER = 1;
    private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort> ports_;
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>
        getPortsList() {
      return ports_;
    }
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public java.util.List<
            ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
        getPortsOrBuilderList() {
      return ports_;
    }
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public int getPortsCount() {
      return ports_.size();
    }
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort getPorts(int index) {
      return ports_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of destination ports for outgoing traffic.
     * Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder getPortsOrBuilder(
        int index) {
      return ports_.get(index);
    }

    public static final int TO_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> to_;
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> getToList() {
      return to_;
    }
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    public java.util.List<
            ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
        getToOrBuilderList() {
      return to_;
    }
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    public int getToCount() {
      return to_.size();
    }
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer getTo(int index) {
      return to_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of destinations for outgoing traffic of pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all destinations (traffic not restricted by
     * destination). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the to list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder getToOrBuilder(
        int index) {
      return to_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < ports_.size(); i++) {
        output.writeMessage(1, ports_.get(i));
      }
      for (int i = 0; i < to_.size(); i++) {
        output.writeMessage(2, to_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < ports_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, ports_.get(i));
      }
      for (int i = 0; i < to_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, to_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule other =
          (io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule) obj;

      boolean result = true;
      result = result && getPortsList().equals(other.getPortsList());
      result = result && getToList().equals(other.getToList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPortsCount() > 0) {
        hash = (37 * hash) + PORTS_FIELD_NUMBER;
        hash = (53 * hash) + getPortsList().hashCode();
      }
      if (getToCount() > 0) {
        hash = (37 * hash) + TO_FIELD_NUMBER;
        hash = (53 * hash) + getToList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * NetworkPolicyEgressRule describes a particular set of traffic that is allowed out of pods
     * matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and to.
     * This type is beta-level in 1.8
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicyEgressRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.NetworkPolicyEgressRule)
        io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyEgressRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyEgressRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule.class,
                io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule.Builder.class);
      }

      // Construct using
      // io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPortsFieldBuilder();
          getToFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (portsBuilder_ == null) {
          ports_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          portsBuilder_.clear();
        }
        if (toBuilder_ == null) {
          to_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          toBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyEgressRule_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule build() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule buildPartial() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule result =
            new io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule(this);
        int from_bitField0_ = bitField0_;
        if (portsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            ports_ = java.util.Collections.unmodifiableList(ports_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.ports_ = ports_;
        } else {
          result.ports_ = portsBuilder_.build();
        }
        if (toBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            to_ = java.util.Collections.unmodifiableList(to_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.to_ = to_;
        } else {
          result.to_ = toBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule other) {
        if (other
            == io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule.getDefaultInstance())
          return this;
        if (portsBuilder_ == null) {
          if (!other.ports_.isEmpty()) {
            if (ports_.isEmpty()) {
              ports_ = other.ports_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePortsIsMutable();
              ports_.addAll(other.ports_);
            }
            onChanged();
          }
        } else {
          if (!other.ports_.isEmpty()) {
            if (portsBuilder_.isEmpty()) {
              portsBuilder_.dispose();
              portsBuilder_ = null;
              ports_ = other.ports_;
              bitField0_ = (bitField0_ & ~0x00000001);
              portsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPortsFieldBuilder()
                      : null;
            } else {
              portsBuilder_.addAllMessages(other.ports_);
            }
          }
        }
        if (toBuilder_ == null) {
          if (!other.to_.isEmpty()) {
            if (to_.isEmpty()) {
              to_ = other.to_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureToIsMutable();
              to_.addAll(other.to_);
            }
            onChanged();
          }
        } else {
          if (!other.to_.isEmpty()) {
            if (toBuilder_.isEmpty()) {
              toBuilder_.dispose();
              toBuilder_ = null;
              to_ = other.to_;
              bitField0_ = (bitField0_ & ~0x00000002);
              toBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getToFieldBuilder()
                      : null;
            } else {
              toBuilder_.addAllMessages(other.to_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort> ports_ =
          java.util.Collections.emptyList();

      private void ensurePortsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          ports_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>(
                  ports_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPort,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
          portsBuilder_;

      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>
          getPortsList() {
        if (portsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(ports_);
        } else {
          return portsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public int getPortsCount() {
        if (portsBuilder_ == null) {
          return ports_.size();
        } else {
          return portsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort getPorts(int index) {
        if (portsBuilder_ == null) {
          return ports_.get(index);
        } else {
          return portsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder setPorts(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicyPort value) {
        if (portsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePortsIsMutable();
          ports_.set(index, value);
          onChanged();
        } else {
          portsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder setPorts(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder builderForValue) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          ports_.set(index, builderForValue.build());
          onChanged();
        } else {
          portsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addPorts(io.kubernetes.client.proto.V1Networking.NetworkPolicyPort value) {
        if (portsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePortsIsMutable();
          ports_.add(value);
          onChanged();
        } else {
          portsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addPorts(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicyPort value) {
        if (portsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePortsIsMutable();
          ports_.add(index, value);
          onChanged();
        } else {
          portsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addPorts(
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder builderForValue) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          ports_.add(builderForValue.build());
          onChanged();
        } else {
          portsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addPorts(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder builderForValue) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          ports_.add(index, builderForValue.build());
          onChanged();
        } else {
          portsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addAllPorts(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>
              values) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ports_);
          onChanged();
        } else {
          portsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder clearPorts() {
        if (portsBuilder_ == null) {
          ports_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          portsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder removePorts(int index) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          ports_.remove(index);
          onChanged();
        } else {
          portsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder getPortsBuilder(
          int index) {
        return getPortsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder getPortsOrBuilder(
          int index) {
        if (portsBuilder_ == null) {
          return ports_.get(index);
        } else {
          return portsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
          getPortsOrBuilderList() {
        if (portsBuilder_ != null) {
          return portsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(ports_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder addPortsBuilder() {
        return getPortsFieldBuilder()
            .addBuilder(
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder addPortsBuilder(
          int index) {
        return getPortsFieldBuilder()
            .addBuilder(
                index,
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of destination ports for outgoing traffic.
       * Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder>
          getPortsBuilderList() {
        return getPortsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPort,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
          getPortsFieldBuilder() {
        if (portsBuilder_ == null) {
          portsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPort,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>(
                  ports_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          ports_ = null;
        }
        return portsBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> to_ =
          java.util.Collections.emptyList();

      private void ensureToIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          to_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer>(
                  to_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
          toBuilder_;

      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> getToList() {
        if (toBuilder_ == null) {
          return java.util.Collections.unmodifiableList(to_);
        } else {
          return toBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public int getToCount() {
        if (toBuilder_ == null) {
          return to_.size();
        } else {
          return toBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer getTo(int index) {
        if (toBuilder_ == null) {
          return to_.get(index);
        } else {
          return toBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder setTo(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer value) {
        if (toBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureToIsMutable();
          to_.set(index, value);
          onChanged();
        } else {
          toBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder setTo(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder builderForValue) {
        if (toBuilder_ == null) {
          ensureToIsMutable();
          to_.set(index, builderForValue.build());
          onChanged();
        } else {
          toBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder addTo(io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer value) {
        if (toBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureToIsMutable();
          to_.add(value);
          onChanged();
        } else {
          toBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder addTo(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer value) {
        if (toBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureToIsMutable();
          to_.add(index, value);
          onChanged();
        } else {
          toBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder addTo(
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder builderForValue) {
        if (toBuilder_ == null) {
          ensureToIsMutable();
          to_.add(builderForValue.build());
          onChanged();
        } else {
          toBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder addTo(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder builderForValue) {
        if (toBuilder_ == null) {
          ensureToIsMutable();
          to_.add(index, builderForValue.build());
          onChanged();
        } else {
          toBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder addAllTo(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer>
              values) {
        if (toBuilder_ == null) {
          ensureToIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, to_);
          onChanged();
        } else {
          toBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder clearTo() {
        if (toBuilder_ == null) {
          to_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          toBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public Builder removeTo(int index) {
        if (toBuilder_ == null) {
          ensureToIsMutable();
          to_.remove(index);
          onChanged();
        } else {
          toBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder getToBuilder(
          int index) {
        return getToFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder getToOrBuilder(
          int index) {
        if (toBuilder_ == null) {
          return to_.get(index);
        } else {
          return toBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
          getToOrBuilderList() {
        if (toBuilder_ != null) {
          return toBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(to_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder addToBuilder() {
        return getToFieldBuilder()
            .addBuilder(
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder addToBuilder(
          int index) {
        return getToFieldBuilder()
            .addBuilder(
                index,
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of destinations for outgoing traffic of pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all destinations (traffic not restricted by
       * destination). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the to list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer to = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder>
          getToBuilderList() {
        return getToFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
          getToFieldBuilder() {
        if (toBuilder_ == null) {
          toBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>(
                  to_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          to_ = null;
        }
        return toBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.NetworkPolicyEgressRule)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.NetworkPolicyEgressRule)
    private static final io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule();
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<NetworkPolicyEgressRule> PARSER =
        new com.google.protobuf.AbstractParser<NetworkPolicyEgressRule>() {
          @java.lang.Override
          public NetworkPolicyEgressRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new NetworkPolicyEgressRule(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<NetworkPolicyEgressRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NetworkPolicyEgressRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyEgressRule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkPolicyIngressRuleOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.NetworkPolicyIngressRule)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort> getPortsList();
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyPort getPorts(int index);
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    int getPortsCount();
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
        getPortsOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder getPortsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> getFromList();
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer getFrom(int index);
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    int getFromCount();
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
        getFromOrBuilderList();
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder getFromOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods
   * matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicyIngressRule}
   */
  public static final class NetworkPolicyIngressRule extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.NetworkPolicyIngressRule)
      NetworkPolicyIngressRuleOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NetworkPolicyIngressRule.newBuilder() to construct.
    private NetworkPolicyIngressRule(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkPolicyIngressRule() {
      ports_ = java.util.Collections.emptyList();
      from_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private NetworkPolicyIngressRule(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                if (!((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
                  ports_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>();
                  mutable_bitField0_ |= 0x00000001;
                }
                ports_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.PARSER,
                        extensionRegistry));
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  from_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer>();
                  mutable_bitField0_ |= 0x00000002;
                }
                from_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) == 0x00000001)) {
          ports_ = java.util.Collections.unmodifiableList(ports_);
        }
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          from_ = java.util.Collections.unmodifiableList(from_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicyIngressRule_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicyIngressRule_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule.class,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule.Builder.class);
    }

    public static final int PORTS_FIELD_NUMBER = 1;
    private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort> ports_;
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>
        getPortsList() {
      return ports_;
    }
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public java.util.List<
            ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
        getPortsOrBuilderList() {
      return ports_;
    }
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public int getPortsCount() {
      return ports_.size();
    }
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort getPorts(int index) {
      return ports_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of ports which should be made accessible on the pods selected for this
     * rule. Each item in this list is combined using a logical OR. If this field is
     * empty or missing, this rule matches all ports (traffic not restricted by port).
     * If this field is present and contains at least one item, then this rule allows
     * traffic only if the traffic matches at least one port in the list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder getPortsOrBuilder(
        int index) {
      return ports_.get(index);
    }

    public static final int FROM_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> from_;
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> getFromList() {
      return from_;
    }
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    public java.util.List<
            ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
        getFromOrBuilderList() {
      return from_;
    }
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    public int getFromCount() {
      return from_.size();
    }
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer getFrom(int index) {
      return from_.get(index);
    }
    /**
     *
     *
     * <pre>
     * List of sources which should be able to access the pods selected for this rule.
     * Items in this list are combined using a logical OR operation. If this field is
     * empty or missing, this rule matches all sources (traffic not restricted by
     * source). If this field is present and contains at least one item, this rule
     * allows traffic only if the traffic matches at least one item in the from list.
     * +optional
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder getFromOrBuilder(
        int index) {
      return from_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < ports_.size(); i++) {
        output.writeMessage(1, ports_.get(i));
      }
      for (int i = 0; i < from_.size(); i++) {
        output.writeMessage(2, from_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < ports_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, ports_.get(i));
      }
      for (int i = 0; i < from_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, from_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule other =
          (io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule) obj;

      boolean result = true;
      result = result && getPortsList().equals(other.getPortsList());
      result = result && getFromList().equals(other.getFromList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getPortsCount() > 0) {
        hash = (37 * hash) + PORTS_FIELD_NUMBER;
        hash = (53 * hash) + getPortsList().hashCode();
      }
      if (getFromCount() > 0) {
        hash = (37 * hash) + FROM_FIELD_NUMBER;
        hash = (53 * hash) + getFromList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * NetworkPolicyIngressRule describes a particular set of traffic that is allowed to the pods
     * matched by a NetworkPolicySpec's podSelector. The traffic must match both ports and from.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicyIngressRule}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.NetworkPolicyIngressRule)
        io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRuleOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyIngressRule_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyIngressRule_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule.class,
                io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule.Builder.class);
      }

      // Construct using
      // io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPortsFieldBuilder();
          getFromFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (portsBuilder_ == null) {
          ports_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
        } else {
          portsBuilder_.clear();
        }
        if (fromBuilder_ == null) {
          from_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          fromBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyIngressRule_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule
          getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule
            .getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule build() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule buildPartial() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule result =
            new io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule(this);
        int from_bitField0_ = bitField0_;
        if (portsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)) {
            ports_ = java.util.Collections.unmodifiableList(ports_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.ports_ = ports_;
        } else {
          result.ports_ = portsBuilder_.build();
        }
        if (fromBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            from_ = java.util.Collections.unmodifiableList(from_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.from_ = from_;
        } else {
          result.from_ = fromBuilder_.build();
        }
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule) {
          return mergeFrom(
              (io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule other) {
        if (other
            == io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule
                .getDefaultInstance()) return this;
        if (portsBuilder_ == null) {
          if (!other.ports_.isEmpty()) {
            if (ports_.isEmpty()) {
              ports_ = other.ports_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensurePortsIsMutable();
              ports_.addAll(other.ports_);
            }
            onChanged();
          }
        } else {
          if (!other.ports_.isEmpty()) {
            if (portsBuilder_.isEmpty()) {
              portsBuilder_.dispose();
              portsBuilder_ = null;
              ports_ = other.ports_;
              bitField0_ = (bitField0_ & ~0x00000001);
              portsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getPortsFieldBuilder()
                      : null;
            } else {
              portsBuilder_.addAllMessages(other.ports_);
            }
          }
        }
        if (fromBuilder_ == null) {
          if (!other.from_.isEmpty()) {
            if (from_.isEmpty()) {
              from_ = other.from_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureFromIsMutable();
              from_.addAll(other.from_);
            }
            onChanged();
          }
        } else {
          if (!other.from_.isEmpty()) {
            if (fromBuilder_.isEmpty()) {
              fromBuilder_.dispose();
              fromBuilder_ = null;
              from_ = other.from_;
              bitField0_ = (bitField0_ & ~0x00000002);
              fromBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFromFieldBuilder()
                      : null;
            } else {
              fromBuilder_.addAllMessages(other.from_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule)
                  e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort> ports_ =
          java.util.Collections.emptyList();

      private void ensurePortsIsMutable() {
        if (!((bitField0_ & 0x00000001) == 0x00000001)) {
          ports_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>(
                  ports_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPort,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
          portsBuilder_;

      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>
          getPortsList() {
        if (portsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(ports_);
        } else {
          return portsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public int getPortsCount() {
        if (portsBuilder_ == null) {
          return ports_.size();
        } else {
          return portsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort getPorts(int index) {
        if (portsBuilder_ == null) {
          return ports_.get(index);
        } else {
          return portsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder setPorts(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicyPort value) {
        if (portsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePortsIsMutable();
          ports_.set(index, value);
          onChanged();
        } else {
          portsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder setPorts(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder builderForValue) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          ports_.set(index, builderForValue.build());
          onChanged();
        } else {
          portsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addPorts(io.kubernetes.client.proto.V1Networking.NetworkPolicyPort value) {
        if (portsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePortsIsMutable();
          ports_.add(value);
          onChanged();
        } else {
          portsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addPorts(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicyPort value) {
        if (portsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensurePortsIsMutable();
          ports_.add(index, value);
          onChanged();
        } else {
          portsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addPorts(
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder builderForValue) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          ports_.add(builderForValue.build());
          onChanged();
        } else {
          portsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addPorts(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder builderForValue) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          ports_.add(index, builderForValue.build());
          onChanged();
        } else {
          portsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder addAllPorts(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPort>
              values) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, ports_);
          onChanged();
        } else {
          portsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder clearPorts() {
        if (portsBuilder_ == null) {
          ports_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          portsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public Builder removePorts(int index) {
        if (portsBuilder_ == null) {
          ensurePortsIsMutable();
          ports_.remove(index);
          onChanged();
        } else {
          portsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder getPortsBuilder(
          int index) {
        return getPortsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder getPortsOrBuilder(
          int index) {
        if (portsBuilder_ == null) {
          return ports_.get(index);
        } else {
          return portsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
          getPortsOrBuilderList() {
        if (portsBuilder_ != null) {
          return portsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(ports_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder addPortsBuilder() {
        return getPortsFieldBuilder()
            .addBuilder(
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder addPortsBuilder(
          int index) {
        return getPortsFieldBuilder()
            .addBuilder(
                index,
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of ports which should be made accessible on the pods selected for this
       * rule. Each item in this list is combined using a logical OR. If this field is
       * empty or missing, this rule matches all ports (traffic not restricted by port).
       * If this field is present and contains at least one item, then this rule allows
       * traffic only if the traffic matches at least one port in the list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPort ports = 1;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder>
          getPortsBuilderList() {
        return getPortsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPort,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>
          getPortsFieldBuilder() {
        if (portsBuilder_ == null) {
          portsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPort,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPort.Builder,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPortOrBuilder>(
                  ports_,
                  ((bitField0_ & 0x00000001) == 0x00000001),
                  getParentForChildren(),
                  isClean());
          ports_ = null;
        }
        return portsBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer> from_ =
          java.util.Collections.emptyList();

      private void ensureFromIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          from_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer>(
                  from_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
          fromBuilder_;

      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer>
          getFromList() {
        if (fromBuilder_ == null) {
          return java.util.Collections.unmodifiableList(from_);
        } else {
          return fromBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public int getFromCount() {
        if (fromBuilder_ == null) {
          return from_.size();
        } else {
          return fromBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer getFrom(int index) {
        if (fromBuilder_ == null) {
          return from_.get(index);
        } else {
          return fromBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder setFrom(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer value) {
        if (fromBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFromIsMutable();
          from_.set(index, value);
          onChanged();
        } else {
          fromBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder setFrom(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder builderForValue) {
        if (fromBuilder_ == null) {
          ensureFromIsMutable();
          from_.set(index, builderForValue.build());
          onChanged();
        } else {
          fromBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder addFrom(io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer value) {
        if (fromBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFromIsMutable();
          from_.add(value);
          onChanged();
        } else {
          fromBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder addFrom(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer value) {
        if (fromBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFromIsMutable();
          from_.add(index, value);
          onChanged();
        } else {
          fromBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder addFrom(
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder builderForValue) {
        if (fromBuilder_ == null) {
          ensureFromIsMutable();
          from_.add(builderForValue.build());
          onChanged();
        } else {
          fromBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder addFrom(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder builderForValue) {
        if (fromBuilder_ == null) {
          ensureFromIsMutable();
          from_.add(index, builderForValue.build());
          onChanged();
        } else {
          fromBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder addAllFrom(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer>
              values) {
        if (fromBuilder_ == null) {
          ensureFromIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, from_);
          onChanged();
        } else {
          fromBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder clearFrom() {
        if (fromBuilder_ == null) {
          from_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          fromBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public Builder removeFrom(int index) {
        if (fromBuilder_ == null) {
          ensureFromIsMutable();
          from_.remove(index);
          onChanged();
        } else {
          fromBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder getFromBuilder(
          int index) {
        return getFromFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder getFromOrBuilder(
          int index) {
        if (fromBuilder_ == null) {
          return from_.get(index);
        } else {
          return fromBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
          getFromOrBuilderList() {
        if (fromBuilder_ != null) {
          return fromBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(from_);
        }
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder addFromBuilder() {
        return getFromFieldBuilder()
            .addBuilder(
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder addFromBuilder(
          int index) {
        return getFromFieldBuilder()
            .addBuilder(
                index,
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * List of sources which should be able to access the pods selected for this rule.
       * Items in this list are combined using a logical OR operation. If this field is
       * empty or missing, this rule matches all sources (traffic not restricted by
       * source). If this field is present and contains at least one item, this rule
       * allows traffic only if the traffic matches at least one item in the from list.
       * +optional
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicyPeer from = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder>
          getFromBuilderList() {
        return getFromFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>
          getFromFieldBuilder() {
        if (fromBuilder_ == null) {
          fromBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder>(
                  from_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          from_ = null;
        }
        return fromBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.NetworkPolicyIngressRule)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.NetworkPolicyIngressRule)
    private static final io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule();
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<NetworkPolicyIngressRule> PARSER =
        new com.google.protobuf.AbstractParser<NetworkPolicyIngressRule>() {
          @java.lang.Override
          public NetworkPolicyIngressRule parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new NetworkPolicyIngressRule(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<NetworkPolicyIngressRule> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NetworkPolicyIngressRule> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyIngressRule
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkPolicyListOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.NetworkPolicyList)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    boolean hasMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMeta getMetadata();
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder();

    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicy> getItemsList();
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicy getItems(int index);
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    int getItemsCount();
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    java.util.List<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder>
        getItemsOrBuilderList();
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder getItemsOrBuilder(int index);
  }
  /**
   *
   *
   * <pre>
   * NetworkPolicyList is a list of NetworkPolicy objects.
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicyList}
   */
  public static final class NetworkPolicyList extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.NetworkPolicyList)
      NetworkPolicyListOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NetworkPolicyList.newBuilder() to construct.
    private NetworkPolicyList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkPolicyList() {
      items_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private NetworkPolicyList(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.ListMeta.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = metadata_.toBuilder();
                }
                metadata_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.ListMeta.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(metadata_);
                  metadata_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                  items_ =
                      new java.util.ArrayList<
                          io.kubernetes.client.proto.V1Networking.NetworkPolicy>();
                  mutable_bitField0_ |= 0x00000002;
                }
                items_.add(
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.NetworkPolicy.PARSER,
                        extensionRegistry));
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          items_ = java.util.Collections.unmodifiableList(items_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicyList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicyList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.NetworkPolicyList.class,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyList.Builder.class);
    }

    private int bitField0_;
    public static final int METADATA_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.ListMeta metadata_;
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }
    /**
     *
     *
     * <pre>
     * Standard list metadata.
     * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
      return metadata_ == null
          ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
          : metadata_;
    }

    public static final int ITEMS_FIELD_NUMBER = 2;
    private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicy> items_;
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicy> getItemsList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    public java.util.List<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder>
        getItemsOrBuilderList() {
      return items_;
    }
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    public int getItemsCount() {
      return items_.size();
    }
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicy getItems(int index) {
      return items_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Items is a list of schema objects.
     * </pre>
     *
     * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
     */
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder getItemsOrBuilder(
        int index) {
      return items_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        output.writeMessage(2, items_.get(i));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
      }
      for (int i = 0; i < items_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, items_.get(i));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicyList)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.NetworkPolicyList other =
          (io.kubernetes.client.proto.V1Networking.NetworkPolicyList) obj;

      boolean result = true;
      result = result && (hasMetadata() == other.hasMetadata());
      if (hasMetadata()) {
        result = result && getMetadata().equals(other.getMetadata());
      }
      result = result && getItemsList().equals(other.getItemsList());
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMetadata()) {
        hash = (37 * hash) + METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getMetadata().hashCode();
      }
      if (getItemsCount() > 0) {
        hash = (37 * hash) + ITEMS_FIELD_NUMBER;
        hash = (53 * hash) + getItemsList().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.NetworkPolicyList prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * NetworkPolicyList is a list of NetworkPolicy objects.
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicyList}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.NetworkPolicyList)
        io.kubernetes.client.proto.V1Networking.NetworkPolicyListOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyList_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyList_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.NetworkPolicyList.class,
                io.kubernetes.client.proto.V1Networking.NetworkPolicyList.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.NetworkPolicyList.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMetadataFieldBuilder();
          getItemsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (metadataBuilder_ == null) {
          metadata_ = null;
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyList_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyList getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.NetworkPolicyList.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyList build() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyList result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyList buildPartial() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyList result =
            new io.kubernetes.client.proto.V1Networking.NetworkPolicyList(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (metadataBuilder_ == null) {
          result.metadata_ = metadata_;
        } else {
          result.metadata_ = metadataBuilder_.build();
        }
        if (itemsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            items_ = java.util.Collections.unmodifiableList(items_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.items_ = items_;
        } else {
          result.items_ = itemsBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicyList) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.NetworkPolicyList) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.NetworkPolicyList other) {
        if (other == io.kubernetes.client.proto.V1Networking.NetworkPolicyList.getDefaultInstance())
          return this;
        if (other.hasMetadata()) {
          mergeMetadata(other.getMetadata());
        }
        if (itemsBuilder_ == null) {
          if (!other.items_.isEmpty()) {
            if (items_.isEmpty()) {
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureItemsIsMutable();
              items_.addAll(other.items_);
            }
            onChanged();
          }
        } else {
          if (!other.items_.isEmpty()) {
            if (itemsBuilder_.isEmpty()) {
              itemsBuilder_.dispose();
              itemsBuilder_ = null;
              items_ = other.items_;
              bitField0_ = (bitField0_ & ~0x00000002);
              itemsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getItemsFieldBuilder()
                      : null;
            } else {
              itemsBuilder_.addAllMessages(other.items_);
            }
          }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyList parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.NetworkPolicyList) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.ListMeta metadata_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          metadataBuilder_;
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public boolean hasMetadata() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta getMetadata() {
        if (metadataBuilder_ == null) {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        } else {
          return metadataBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          metadata_ = value;
          onChanged();
        } else {
          metadataBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder setMetadata(io.kubernetes.client.proto.Meta.ListMeta.Builder builderForValue) {
        if (metadataBuilder_ == null) {
          metadata_ = builderForValue.build();
          onChanged();
        } else {
          metadataBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder mergeMetadata(io.kubernetes.client.proto.Meta.ListMeta value) {
        if (metadataBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && metadata_ != null
              && metadata_ != io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()) {
            metadata_ =
                io.kubernetes.client.proto.Meta.ListMeta.newBuilder(metadata_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            metadata_ = value;
          }
          onChanged();
        } else {
          metadataBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public Builder clearMetadata() {
        if (metadataBuilder_ == null) {
          metadata_ = null;
          onChanged();
        } else {
          metadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMeta.Builder getMetadataBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMetadataFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.ListMetaOrBuilder getMetadataOrBuilder() {
        if (metadataBuilder_ != null) {
          return metadataBuilder_.getMessageOrBuilder();
        } else {
          return metadata_ == null
              ? io.kubernetes.client.proto.Meta.ListMeta.getDefaultInstance()
              : metadata_;
        }
      }
      /**
       *
       *
       * <pre>
       * Standard list metadata.
       * More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.ListMeta metadata = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.ListMeta,
              io.kubernetes.client.proto.Meta.ListMeta.Builder,
              io.kubernetes.client.proto.Meta.ListMetaOrBuilder>
          getMetadataFieldBuilder() {
        if (metadataBuilder_ == null) {
          metadataBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.ListMeta,
                  io.kubernetes.client.proto.Meta.ListMeta.Builder,
                  io.kubernetes.client.proto.Meta.ListMetaOrBuilder>(
                  getMetadata(), getParentForChildren(), isClean());
          metadata_ = null;
        }
        return metadataBuilder_;
      }

      private java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicy> items_ =
          java.util.Collections.emptyList();

      private void ensureItemsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          items_ =
              new java.util.ArrayList<io.kubernetes.client.proto.V1Networking.NetworkPolicy>(
                  items_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicy,
              io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder>
          itemsBuilder_;

      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicy> getItemsList() {
        if (itemsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(items_);
        } else {
          return itemsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public int getItemsCount() {
        if (itemsBuilder_ == null) {
          return items_.size();
        } else {
          return itemsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicy getItems(int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder setItems(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicy value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.set(index, value);
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder setItems(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.set(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder addItems(io.kubernetes.client.proto.V1Networking.NetworkPolicy value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder addItems(
          int index, io.kubernetes.client.proto.V1Networking.NetworkPolicy value) {
        if (itemsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureItemsIsMutable();
          items_.add(index, value);
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder addItems(
          io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder addItems(
          int index,
          io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder builderForValue) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.add(index, builderForValue.build());
          onChanged();
        } else {
          itemsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder addAllItems(
          java.lang.Iterable<? extends io.kubernetes.client.proto.V1Networking.NetworkPolicy>
              values) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, items_);
          onChanged();
        } else {
          itemsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder clearItems() {
        if (itemsBuilder_ == null) {
          items_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          itemsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public Builder removeItems(int index) {
        if (itemsBuilder_ == null) {
          ensureItemsIsMutable();
          items_.remove(index);
          onChanged();
        } else {
          itemsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder getItemsBuilder(
          int index) {
        return getItemsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder getItemsOrBuilder(
          int index) {
        if (itemsBuilder_ == null) {
          return items_.get(index);
        } else {
          return itemsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public java.util.List<
              ? extends io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder>
          getItemsOrBuilderList() {
        if (itemsBuilder_ != null) {
          return itemsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(items_);
        }
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder addItemsBuilder() {
        return getItemsFieldBuilder()
            .addBuilder(io.kubernetes.client.proto.V1Networking.NetworkPolicy.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder addItemsBuilder(
          int index) {
        return getItemsFieldBuilder()
            .addBuilder(
                index, io.kubernetes.client.proto.V1Networking.NetworkPolicy.getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * Items is a list of schema objects.
       * </pre>
       *
       * <code>repeated .k8s.io.api.networking.v1.NetworkPolicy items = 2;</code>
       */
      public java.util.List<io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder>
          getItemsBuilderList() {
        return getItemsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              io.kubernetes.client.proto.V1Networking.NetworkPolicy,
              io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder>
          getItemsFieldBuilder() {
        if (itemsBuilder_ == null) {
          itemsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  io.kubernetes.client.proto.V1Networking.NetworkPolicy,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicy.Builder,
                  io.kubernetes.client.proto.V1Networking.NetworkPolicyOrBuilder>(
                  items_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          items_ = null;
        }
        return itemsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:k8s.io.api.networking.v1.NetworkPolicyList)
    }

    // @@protoc_insertion_point(class_scope:k8s.io.api.networking.v1.NetworkPolicyList)
    private static final io.kubernetes.client.proto.V1Networking.NetworkPolicyList DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new io.kubernetes.client.proto.V1Networking.NetworkPolicyList();
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyList getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    @java.lang.Deprecated
    public static final com.google.protobuf.Parser<NetworkPolicyList> PARSER =
        new com.google.protobuf.AbstractParser<NetworkPolicyList>() {
          @java.lang.Override
          public NetworkPolicyList parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new NetworkPolicyList(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<NetworkPolicyList> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NetworkPolicyList> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public io.kubernetes.client.proto.V1Networking.NetworkPolicyList getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NetworkPolicyPeerOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:k8s.io.api.networking.v1.NetworkPolicyPeer)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * This is a label selector which selects Pods. This field follows standard label
     * selector semantics; if present but empty, it selects all pods.
     * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
     */
    boolean hasPodSelector();
    /**
     *
     *
     * <pre>
     * This is a label selector which selects Pods. This field follows standard label
     * selector semantics; if present but empty, it selects all pods.
     * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelector getPodSelector();
    /**
     *
     *
     * <pre>
     * This is a label selector which selects Pods. This field follows standard label
     * selector semantics; if present but empty, it selects all pods.
     * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
     */
    io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getPodSelectorOrBuilder();

    /**
     *
     *
     * <pre>
     * Selects Namespaces using cluster-scoped labels. This field follows standard label
     * selector semantics; if present but empty, it selects all namespaces.
     * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
     * </code>
     */
    boolean hasNamespaceSelector();
    /**
     *
     *
     * <pre>
     * Selects Namespaces using cluster-scoped labels. This field follows standard label
     * selector semantics; if present but empty, it selects all namespaces.
     * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
     * </code>
     */
    io.kubernetes.client.proto.Meta.LabelSelector getNamespaceSelector();
    /**
     *
     *
     * <pre>
     * Selects Namespaces using cluster-scoped labels. This field follows standard label
     * selector semantics; if present but empty, it selects all namespaces.
     * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
     * </code>
     */
    io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getNamespaceSelectorOrBuilder();

    /**
     *
     *
     * <pre>
     * IPBlock defines policy on a particular IPBlock. If this field is set then
     * neither of the other fields can be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IPBlock ipBlock = 3;</code>
     */
    boolean hasIpBlock();
    /**
     *
     *
     * <pre>
     * IPBlock defines policy on a particular IPBlock. If this field is set then
     * neither of the other fields can be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IPBlock ipBlock = 3;</code>
     */
    io.kubernetes.client.proto.V1Networking.IPBlock getIpBlock();
    /**
     *
     *
     * <pre>
     * IPBlock defines policy on a particular IPBlock. If this field is set then
     * neither of the other fields can be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IPBlock ipBlock = 3;</code>
     */
    io.kubernetes.client.proto.V1Networking.IPBlockOrBuilder getIpBlockOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of
   * fields are allowed
   * </pre>
   *
   * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicyPeer}
   */
  public static final class NetworkPolicyPeer extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:k8s.io.api.networking.v1.NetworkPolicyPeer)
      NetworkPolicyPeerOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use NetworkPolicyPeer.newBuilder() to construct.
    private NetworkPolicyPeer(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NetworkPolicyPeer() {}

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private NetworkPolicyPeer(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                io.kubernetes.client.proto.Meta.LabelSelector.Builder subBuilder = null;
                if (((bitField0_ & 0x00000001) == 0x00000001)) {
                  subBuilder = podSelector_.toBuilder();
                }
                podSelector_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.LabelSelector.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(podSelector_);
                  podSelector_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000001;
                break;
              }
            case 18:
              {
                io.kubernetes.client.proto.Meta.LabelSelector.Builder subBuilder = null;
                if (((bitField0_ & 0x00000002) == 0x00000002)) {
                  subBuilder = namespaceSelector_.toBuilder();
                }
                namespaceSelector_ =
                    input.readMessage(
                        io.kubernetes.client.proto.Meta.LabelSelector.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(namespaceSelector_);
                  namespaceSelector_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000002;
                break;
              }
            case 26:
              {
                io.kubernetes.client.proto.V1Networking.IPBlock.Builder subBuilder = null;
                if (((bitField0_ & 0x00000004) == 0x00000004)) {
                  subBuilder = ipBlock_.toBuilder();
                }
                ipBlock_ =
                    input.readMessage(
                        io.kubernetes.client.proto.V1Networking.IPBlock.PARSER, extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(ipBlock_);
                  ipBlock_ = subBuilder.buildPartial();
                }
                bitField0_ |= 0x00000004;
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicyPeer_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.kubernetes.client.proto.V1Networking
          .internal_static_k8s_io_api_networking_v1_NetworkPolicyPeer_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.class,
              io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder.class);
    }

    private int bitField0_;
    public static final int PODSELECTOR_FIELD_NUMBER = 1;
    private io.kubernetes.client.proto.Meta.LabelSelector podSelector_;
    /**
     *
     *
     * <pre>
     * This is a label selector which selects Pods. This field follows standard label
     * selector semantics; if present but empty, it selects all pods.
     * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
     */
    public boolean hasPodSelector() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     *
     *
     * <pre>
     * This is a label selector which selects Pods. This field follows standard label
     * selector semantics; if present but empty, it selects all pods.
     * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelector getPodSelector() {
      return podSelector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : podSelector_;
    }
    /**
     *
     *
     * <pre>
     * This is a label selector which selects Pods. This field follows standard label
     * selector semantics; if present but empty, it selects all pods.
     * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getPodSelectorOrBuilder() {
      return podSelector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : podSelector_;
    }

    public static final int NAMESPACESELECTOR_FIELD_NUMBER = 2;
    private io.kubernetes.client.proto.Meta.LabelSelector namespaceSelector_;
    /**
     *
     *
     * <pre>
     * Selects Namespaces using cluster-scoped labels. This field follows standard label
     * selector semantics; if present but empty, it selects all namespaces.
     * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
     * </code>
     */
    public boolean hasNamespaceSelector() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     *
     *
     * <pre>
     * Selects Namespaces using cluster-scoped labels. This field follows standard label
     * selector semantics; if present but empty, it selects all namespaces.
     * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
     * </code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelector getNamespaceSelector() {
      return namespaceSelector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : namespaceSelector_;
    }
    /**
     *
     *
     * <pre>
     * Selects Namespaces using cluster-scoped labels. This field follows standard label
     * selector semantics; if present but empty, it selects all namespaces.
     * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
     * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
     * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
     * </code>
     */
    public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getNamespaceSelectorOrBuilder() {
      return namespaceSelector_ == null
          ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
          : namespaceSelector_;
    }

    public static final int IPBLOCK_FIELD_NUMBER = 3;
    private io.kubernetes.client.proto.V1Networking.IPBlock ipBlock_;
    /**
     *
     *
     * <pre>
     * IPBlock defines policy on a particular IPBlock. If this field is set then
     * neither of the other fields can be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IPBlock ipBlock = 3;</code>
     */
    public boolean hasIpBlock() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     *
     *
     * <pre>
     * IPBlock defines policy on a particular IPBlock. If this field is set then
     * neither of the other fields can be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IPBlock ipBlock = 3;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IPBlock getIpBlock() {
      return ipBlock_ == null
          ? io.kubernetes.client.proto.V1Networking.IPBlock.getDefaultInstance()
          : ipBlock_;
    }
    /**
     *
     *
     * <pre>
     * IPBlock defines policy on a particular IPBlock. If this field is set then
     * neither of the other fields can be.
     * +optional
     * </pre>
     *
     * <code>optional .k8s.io.api.networking.v1.IPBlock ipBlock = 3;</code>
     */
    public io.kubernetes.client.proto.V1Networking.IPBlockOrBuilder getIpBlockOrBuilder() {
      return ipBlock_ == null
          ? io.kubernetes.client.proto.V1Networking.IPBlock.getDefaultInstance()
          : ipBlock_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeMessage(1, getPodSelector());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(2, getNamespaceSelector());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeMessage(3, getIpBlock());
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getPodSelector());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getNamespaceSelector());
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getIpBlock());
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer)) {
        return super.equals(obj);
      }
      io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer other =
          (io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer) obj;

      boolean result = true;
      result = result && (hasPodSelector() == other.hasPodSelector());
      if (hasPodSelector()) {
        result = result && getPodSelector().equals(other.getPodSelector());
      }
      result = result && (hasNamespaceSelector() == other.hasNamespaceSelector());
      if (hasNamespaceSelector()) {
        result = result && getNamespaceSelector().equals(other.getNamespaceSelector());
      }
      result = result && (hasIpBlock() == other.hasIpBlock());
      if (hasIpBlock()) {
        result = result && getIpBlock().equals(other.getIpBlock());
      }
      result = result && unknownFields.equals(other.unknownFields);
      return result;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasPodSelector()) {
        hash = (37 * hash) + PODSELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getPodSelector().hashCode();
      }
      if (hasNamespaceSelector()) {
        hash = (37 * hash) + NAMESPACESELECTOR_FIELD_NUMBER;
        hash = (53 * hash) + getNamespaceSelector().hashCode();
      }
      if (hasIpBlock()) {
        hash = (37 * hash) + IPBLOCK_FIELD_NUMBER;
        hash = (53 * hash) + getIpBlock().hashCode();
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * NetworkPolicyPeer describes a peer to allow traffic to/from. Only certain combinations of
     * fields are allowed
     * </pre>
     *
     * Protobuf type {@code k8s.io.api.networking.v1.NetworkPolicyPeer}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:k8s.io.api.networking.v1.NetworkPolicyPeer)
        io.kubernetes.client.proto.V1Networking.NetworkPolicyPeerOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyPeer_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyPeer_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.class,
                io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.Builder.class);
      }

      // Construct using io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getPodSelectorFieldBuilder();
          getNamespaceSelectorFieldBuilder();
          getIpBlockFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        if (podSelectorBuilder_ == null) {
          podSelector_ = null;
        } else {
          podSelectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (namespaceSelectorBuilder_ == null) {
          namespaceSelector_ = null;
        } else {
          namespaceSelectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        if (ipBlockBuilder_ == null) {
          ipBlock_ = null;
        } else {
          ipBlockBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return io.kubernetes.client.proto.V1Networking
            .internal_static_k8s_io_api_networking_v1_NetworkPolicyPeer_descriptor;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer getDefaultInstanceForType() {
        return io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.getDefaultInstance();
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer build() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer buildPartial() {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer result =
            new io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        if (podSelectorBuilder_ == null) {
          result.podSelector_ = podSelector_;
        } else {
          result.podSelector_ = podSelectorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        if (namespaceSelectorBuilder_ == null) {
          result.namespaceSelector_ = namespaceSelector_;
        } else {
          result.namespaceSelector_ = namespaceSelectorBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        if (ipBlockBuilder_ == null) {
          result.ipBlock_ = ipBlock_;
        } else {
          result.ipBlock_ = ipBlockBuilder_.build();
        }
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return (Builder) super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return (Builder) super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return (Builder) super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return (Builder) super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return (Builder) super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer) {
          return mergeFrom((io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer other) {
        if (other == io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer.getDefaultInstance())
          return this;
        if (other.hasPodSelector()) {
          mergePodSelector(other.getPodSelector());
        }
        if (other.hasNamespaceSelector()) {
          mergeNamespaceSelector(other.getNamespaceSelector());
        }
        if (other.hasIpBlock()) {
          mergeIpBlock(other.getIpBlock());
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (io.kubernetes.client.proto.V1Networking.NetworkPolicyPeer) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int bitField0_;

      private io.kubernetes.client.proto.Meta.LabelSelector podSelector_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          podSelectorBuilder_;
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      public boolean hasPodSelector() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector getPodSelector() {
        if (podSelectorBuilder_ == null) {
          return podSelector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : podSelector_;
        } else {
          return podSelectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      public Builder setPodSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (podSelectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          podSelector_ = value;
          onChanged();
        } else {
          podSelectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      public Builder setPodSelector(
          io.kubernetes.client.proto.Meta.LabelSelector.Builder builderForValue) {
        if (podSelectorBuilder_ == null) {
          podSelector_ = builderForValue.build();
          onChanged();
        } else {
          podSelectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      public Builder mergePodSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (podSelectorBuilder_ == null) {
          if (((bitField0_ & 0x00000001) == 0x00000001)
              && podSelector_ != null
              && podSelector_
                  != io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()) {
            podSelector_ =
                io.kubernetes.client.proto.Meta.LabelSelector.newBuilder(podSelector_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            podSelector_ = value;
          }
          onChanged();
        } else {
          podSelectorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      public Builder clearPodSelector() {
        if (podSelectorBuilder_ == null) {
          podSelector_ = null;
          onChanged();
        } else {
          podSelectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector.Builder getPodSelectorBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getPodSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder getPodSelectorOrBuilder() {
        if (podSelectorBuilder_ != null) {
          return podSelectorBuilder_.getMessageOrBuilder();
        } else {
          return podSelector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : podSelector_;
        }
      }
      /**
       *
       *
       * <pre>
       * This is a label selector which selects Pods. This field follows standard label
       * selector semantics; if present but empty, it selects all pods.
       * If NamespaceSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects the Pods matching PodSelector in the policy's own Namespace.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector podSelector = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          getPodSelectorFieldBuilder() {
        if (podSelectorBuilder_ == null) {
          podSelectorBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  io.kubernetes.client.proto.Meta.LabelSelector,
                  io.kubernetes.client.proto.Meta.LabelSelector.Builder,
                  io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>(
                  getPodSelector(), getParentForChildren(), isClean());
          podSelector_ = null;
        }
        return podSelectorBuilder_;
      }

      private io.kubernetes.client.proto.Meta.LabelSelector namespaceSelector_ = null;
      private com.google.protobuf.SingleFieldBuilderV3<
              io.kubernetes.client.proto.Meta.LabelSelector,
              io.kubernetes.client.proto.Meta.LabelSelector.Builder,
              io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder>
          namespaceSelectorBuilder_;
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      public boolean hasNamespaceSelector() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector getNamespaceSelector() {
        if (namespaceSelectorBuilder_ == null) {
          return namespaceSelector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : namespaceSelector_;
        } else {
          return namespaceSelectorBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      public Builder setNamespaceSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (namespaceSelectorBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          namespaceSelector_ = value;
          onChanged();
        } else {
          namespaceSelectorBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      public Builder setNamespaceSelector(
          io.kubernetes.client.proto.Meta.LabelSelector.Builder builderForValue) {
        if (namespaceSelectorBuilder_ == null) {
          namespaceSelector_ = builderForValue.build();
          onChanged();
        } else {
          namespaceSelectorBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      public Builder mergeNamespaceSelector(io.kubernetes.client.proto.Meta.LabelSelector value) {
        if (namespaceSelectorBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)
              && namespaceSelector_ != null
              && namespaceSelector_
                  != io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()) {
            namespaceSelector_ =
                io.kubernetes.client.proto.Meta.LabelSelector.newBuilder(namespaceSelector_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            namespaceSelector_ = value;
          }
          onChanged();
        } else {
          namespaceSelectorBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        return this;
      }
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      public Builder clearNamespaceSelector() {
        if (namespaceSelectorBuilder_ == null) {
          namespaceSelector_ = null;
          onChanged();
        } else {
          namespaceSelectorBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelector.Builder getNamespaceSelectorBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getNamespaceSelectorFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      public io.kubernetes.client.proto.Meta.LabelSelectorOrBuilder
          getNamespaceSelectorOrBuilder() {
        if (namespaceSelectorBuilder_ != null) {
          return namespaceSelectorBuilder_.getMessageOrBuilder();
        } else {
          return namespaceSelector_ == null
              ? io.kubernetes.client.proto.Meta.LabelSelector.getDefaultInstance()
              : namespaceSelector_;
        }
      }
      /**
       *
       *
       * <pre>
       * Selects Namespaces using cluster-scoped labels. This field follows standard label
       * selector semantics; if present but empty, it selects all namespaces.
       * If PodSelector is also set, then the NetworkPolicyPeer as a whole selects
       * the Pods matching PodSelector in the Namespaces selected by NamespaceSelector.
       * Otherwise it selects all Pods in the Namespaces selected by NamespaceSelector.
       * +optional
       * </pre>
       *
       * <code>optional .k8s.io.apimachinery.pkg.apis.meta.v1.LabelSelector namespaceSelector = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
       