/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.extended.controller.builder;

import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.extended.controller.Controller;
import io.kubernetes.client.extended.controller.ControllerWatch;
import io.kubernetes.client.extended.controller.Controllers;
import io.kubernetes.client.extended.controller.DefaultController;
import io.kubernetes.client.extended.controller.reconciler.Reconciler;
import io.kubernetes.client.extended.controller.reconciler.Request;
import io.kubernetes.client.extended.workqueue.DefaultRateLimitingQueue;
import io.kubernetes.client.extended.workqueue.RateLimitingQueue;
import io.kubernetes.client.extended.workqueue.WorkQueue;
import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.function.Supplier;

public class DefaultControllerBuilder {
    private int workerCount = 16;
    private String controllerName = "default-controller";
    private RateLimitingQueue<Request> workQueue = new DefaultRateLimitingQueue<Request>(Executors.newSingleThreadExecutor());
    private Duration readyTimeout;
    private SharedInformerFactory informerFactory;
    private List<Supplier<Boolean>> readyFuncs = new ArrayList<Supplier<Boolean>>();
    private Reconciler reconciler;

    DefaultControllerBuilder() {
    }

    DefaultControllerBuilder(SharedInformerFactory informerFactory) {
        this();
        this.informerFactory = informerFactory;
    }

    public <ApiType extends KubernetesObject> DefaultControllerBuilder watch(Function<WorkQueue<Request>, ControllerWatch<ApiType>> controllerWatchGetter) {
        ControllerWatch<ApiType> watch = controllerWatchGetter.apply(this.workQueue);
        Class<ApiType> apiTypeClass = watch.getResourceClass();
        SharedIndexInformer informer = this.informerFactory.getExistingSharedIndexInformer(apiTypeClass);
        if (informer == null) {
            throw new IllegalStateException(String.format("Missing informer for resource %s, check if informer already constructed in the informerFactory", apiTypeClass));
        }
        informer.addEventHandlerWithResyncPeriod(watch.getResourceEventHandler(), watch.getResyncPeriod().toMillis());
        return this;
    }

    public DefaultControllerBuilder withName(String controllerName) {
        this.controllerName = controllerName;
        return this;
    }

    public DefaultControllerBuilder withWorkQueue(RateLimitingQueue<Request> workQueue) {
        this.workQueue = workQueue;
        return this;
    }

    public DefaultControllerBuilder withReadyFunc(Supplier<Boolean> readyFunc) {
        this.readyFuncs.add(readyFunc);
        return this;
    }

    public DefaultControllerBuilder withReadyTimeout(Duration readyTimeout) {
        this.readyTimeout = readyTimeout;
        return this;
    }

    public DefaultControllerBuilder withWorkerCount(int workerCount) {
        this.workerCount = workerCount;
        return this;
    }

    public DefaultControllerBuilder withReconciler(Reconciler reconciler) {
        this.reconciler = reconciler;
        return this;
    }

    public Controller build() throws IllegalStateException {
        if (this.reconciler == null) {
            throw new IllegalStateException("Missing reconciler when building controller.");
        }
        DefaultController controller = new DefaultController(this.controllerName, this.reconciler, this.workQueue, (Supplier[])this.readyFuncs.stream().toArray(Supplier[]::new));
        if (this.readyTimeout != null) {
            controller.setReadyTimeout(this.readyTimeout);
        }
        controller.setWorkerCount(this.workerCount);
        controller.setWorkerThreadPool(Executors.newScheduledThreadPool(this.workerCount, Controllers.namedControllerThreadFactory(this.controllerName)));
        return controller;
    }
}

