/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointPort represents a Port used by an EndpointSlice")
public class V1beta1EndpointPort {
    public static final String SERIALIZED_NAME_APP_PROTOCOL = "appProtocol";
    @SerializedName(value="appProtocol")
    private String appProtocol;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private Integer port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    private String protocol;

    public V1beta1EndpointPort appProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The application protocol for this port. This field follows standard Kubernetes label syntax. Un-prefixed names are reserved for IANA standard service names (as per RFC-6335 and http://www.iana.org/assignments/service-names). Non-standard protocols should use prefixed names. Default is empty string.")
    public String getAppProtocol() {
        return this.appProtocol;
    }

    public void setAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
    }

    public V1beta1EndpointPort name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of this port. All ports in an EndpointSlice must have a unique name. If the EndpointSlice is dervied from a Kubernetes service, this corresponds to the Service.ports[].name. Name must either be an empty string or pass DNS_LABEL validation: * must be no more than 63 characters long. * must consist of lower case alphanumeric characters or '-'. * must start and end with an alphanumeric character. Default is empty string.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1EndpointPort port(Integer port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The port number of the endpoint. If this is not specified, ports are not restricted and must be interpreted in the context of the specific consumer.")
    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public V1beta1EndpointPort protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The IP protocol for this port. Must be UDP, TCP, or SCTP. Default is TCP.")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1EndpointPort v1beta1EndpointPort = (V1beta1EndpointPort)o;
        return Objects.equals(this.appProtocol, v1beta1EndpointPort.appProtocol) && Objects.equals(this.name, v1beta1EndpointPort.name) && Objects.equals(this.port, v1beta1EndpointPort.port) && Objects.equals(this.protocol, v1beta1EndpointPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1EndpointPort {\n");
        sb.append("    appProtocol: ").append(this.toIndentedString(this.appProtocol)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

