/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1beta1NetworkPolicyEgressRule;
import io.kubernetes.client.openapi.models.V1beta1NetworkPolicyEgressRuleBuilder;
import io.kubernetes.client.openapi.models.V1beta1NetworkPolicyEgressRuleFluentImpl;
import io.kubernetes.client.openapi.models.V1beta1NetworkPolicyIngressRule;
import io.kubernetes.client.openapi.models.V1beta1NetworkPolicyIngressRuleBuilder;
import io.kubernetes.client.openapi.models.V1beta1NetworkPolicyIngressRuleFluentImpl;
import io.kubernetes.client.openapi.models.V1beta1NetworkPolicySpec;
import io.kubernetes.client.openapi.models.V1beta1NetworkPolicySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class V1beta1NetworkPolicySpecFluentImpl<A extends V1beta1NetworkPolicySpecFluent<A>>
extends BaseFluent<A>
implements V1beta1NetworkPolicySpecFluent<A> {
    private List<V1beta1NetworkPolicyEgressRuleBuilder> egress;
    private List<V1beta1NetworkPolicyIngressRuleBuilder> ingress;
    private V1LabelSelectorBuilder podSelector;
    private List<String> policyTypes;

    public V1beta1NetworkPolicySpecFluentImpl() {
    }

    public V1beta1NetworkPolicySpecFluentImpl(V1beta1NetworkPolicySpec instance) {
        this.withEgress(instance.getEgress());
        this.withIngress(instance.getIngress());
        this.withPodSelector(instance.getPodSelector());
        this.withPolicyTypes(instance.getPolicyTypes());
    }

    @Override
    public A addToEgress(int index, V1beta1NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();
        }
        V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);
        this._visitables.get("egress").add(index >= 0 ? index : this._visitables.get("egress").size(), builder);
        this.egress.add(index >= 0 ? index : this.egress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEgress(int index, V1beta1NetworkPolicyEgressRule item) {
        if (this.egress == null) {
            this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();
        }
        V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("egress").size()) {
            this._visitables.get("egress").add(builder);
        } else {
            this._visitables.get("egress").set(index, builder);
        }
        if (index < 0 || index >= this.egress.size()) {
            this.egress.add(builder);
        } else {
            this.egress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEgress(V1beta1NetworkPolicyEgressRule ... items) {
        if (this.egress == null) {
            this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();
        }
        for (V1beta1NetworkPolicyEgressRule item : items) {
            V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEgress(Collection<V1beta1NetworkPolicyEgressRule> items) {
        if (this.egress == null) {
            this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();
        }
        for (V1beta1NetworkPolicyEgressRule item : items) {
            V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").add(builder);
            this.egress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEgress(V1beta1NetworkPolicyEgressRule ... items) {
        for (V1beta1NetworkPolicyEgressRule item : items) {
            V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEgress(Collection<V1beta1NetworkPolicyEgressRule> items) {
        for (V1beta1NetworkPolicyEgressRule item : items) {
            V1beta1NetworkPolicyEgressRuleBuilder builder = new V1beta1NetworkPolicyEgressRuleBuilder(item);
            this._visitables.get("egress").remove(builder);
            if (this.egress == null) continue;
            this.egress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEgress(Predicate<V1beta1NetworkPolicyEgressRuleBuilder> predicate) {
        if (this.egress == null) {
            return (A)this;
        }
        Iterator<V1beta1NetworkPolicyEgressRuleBuilder> each = this.egress.iterator();
        Object visitables = this._visitables.get("egress");
        while (each.hasNext()) {
            V1beta1NetworkPolicyEgressRuleBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1beta1NetworkPolicyEgressRule> getEgress() {
        return V1beta1NetworkPolicySpecFluentImpl.build(this.egress);
    }

    @Override
    public List<V1beta1NetworkPolicyEgressRule> buildEgress() {
        return V1beta1NetworkPolicySpecFluentImpl.build(this.egress);
    }

    @Override
    public V1beta1NetworkPolicyEgressRule buildEgress(int index) {
        return this.egress.get(index).build();
    }

    @Override
    public V1beta1NetworkPolicyEgressRule buildFirstEgress() {
        return this.egress.get(0).build();
    }

    @Override
    public V1beta1NetworkPolicyEgressRule buildLastEgress() {
        return this.egress.get(this.egress.size() - 1).build();
    }

    @Override
    public V1beta1NetworkPolicyEgressRule buildMatchingEgress(Predicate<V1beta1NetworkPolicyEgressRuleBuilder> predicate) {
        for (V1beta1NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEgress(Predicate<V1beta1NetworkPolicyEgressRuleBuilder> predicate) {
        for (V1beta1NetworkPolicyEgressRuleBuilder item : this.egress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEgress(List<V1beta1NetworkPolicyEgressRule> egress) {
        if (this.egress != null) {
            this._visitables.get("egress").removeAll(this.egress);
        }
        if (egress != null) {
            this.egress = new ArrayList<V1beta1NetworkPolicyEgressRuleBuilder>();
            for (V1beta1NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        } else {
            this.egress = null;
        }
        return (A)this;
    }

    @Override
    public A withEgress(V1beta1NetworkPolicyEgressRule ... egress) {
        if (this.egress != null) {
            this.egress.clear();
        }
        if (egress != null) {
            for (V1beta1NetworkPolicyEgressRule item : egress) {
                this.addToEgress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEgress() {
        return this.egress != null && !this.egress.isEmpty();
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.EgressNested<A> addNewEgress() {
        return new EgressNestedImpl();
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.EgressNested<A> addNewEgressLike(V1beta1NetworkPolicyEgressRule item) {
        return new EgressNestedImpl(-1, item);
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.EgressNested<A> setNewEgressLike(int index, V1beta1NetworkPolicyEgressRule item) {
        return new EgressNestedImpl(index, item);
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.EgressNested<A> editEgress(int index) {
        if (this.egress.size() <= index) {
            throw new RuntimeException("Can't edit egress. Index exceeds size.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.EgressNested<A> editFirstEgress() {
        if (this.egress.size() == 0) {
            throw new RuntimeException("Can't edit first egress. The list is empty.");
        }
        return this.setNewEgressLike(0, this.buildEgress(0));
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.EgressNested<A> editLastEgress() {
        int index = this.egress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last egress. The list is empty.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.EgressNested<A> editMatchingEgress(Predicate<V1beta1NetworkPolicyEgressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.egress.size(); ++i) {
            if (!predicate.apply(this.egress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching egress. No match found.");
        }
        return this.setNewEgressLike(index, this.buildEgress(index));
    }

    @Override
    public A addToIngress(int index, V1beta1NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();
        }
        V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);
        this._visitables.get("ingress").add(index >= 0 ? index : this._visitables.get("ingress").size(), builder);
        this.ingress.add(index >= 0 ? index : this.ingress.size(), builder);
        return (A)this;
    }

    @Override
    public A setToIngress(int index, V1beta1NetworkPolicyIngressRule item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();
        }
        V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);
        if (index < 0 || index >= this._visitables.get("ingress").size()) {
            this._visitables.get("ingress").add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
        }
        if (index < 0 || index >= this.ingress.size()) {
            this.ingress.add(builder);
        } else {
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(V1beta1NetworkPolicyIngressRule ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();
        }
        for (V1beta1NetworkPolicyIngressRule item : items) {
            V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<V1beta1NetworkPolicyIngressRule> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();
        }
        for (V1beta1NetworkPolicyIngressRule item : items) {
            V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(V1beta1NetworkPolicyIngressRule ... items) {
        for (V1beta1NetworkPolicyIngressRule item : items) {
            V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<V1beta1NetworkPolicyIngressRule> items) {
        for (V1beta1NetworkPolicyIngressRule item : items) {
            V1beta1NetworkPolicyIngressRuleBuilder builder = new V1beta1NetworkPolicyIngressRuleBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<V1beta1NetworkPolicyIngressRuleBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<V1beta1NetworkPolicyIngressRuleBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            V1beta1NetworkPolicyIngressRuleBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1beta1NetworkPolicyIngressRule> getIngress() {
        return V1beta1NetworkPolicySpecFluentImpl.build(this.ingress);
    }

    @Override
    public List<V1beta1NetworkPolicyIngressRule> buildIngress() {
        return V1beta1NetworkPolicySpecFluentImpl.build(this.ingress);
    }

    @Override
    public V1beta1NetworkPolicyIngressRule buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public V1beta1NetworkPolicyIngressRule buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public V1beta1NetworkPolicyIngressRule buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public V1beta1NetworkPolicyIngressRule buildMatchingIngress(Predicate<V1beta1NetworkPolicyIngressRuleBuilder> predicate) {
        for (V1beta1NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<V1beta1NetworkPolicyIngressRuleBuilder> predicate) {
        for (V1beta1NetworkPolicyIngressRuleBuilder item : this.ingress) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<V1beta1NetworkPolicyIngressRule> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").removeAll(this.ingress);
        }
        if (ingress != null) {
            this.ingress = new ArrayList<V1beta1NetworkPolicyIngressRuleBuilder>();
            for (V1beta1NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(V1beta1NetworkPolicyIngressRule ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
        }
        if (ingress != null) {
            for (V1beta1NetworkPolicyIngressRule item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(V1beta1NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(int index, V1beta1NetworkPolicyIngressRule item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(Predicate<V1beta1NetworkPolicyIngressRuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.apply(this.ingress.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    @Deprecated
    public V1LabelSelector getPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public A withPodSelector(V1LabelSelector podSelector) {
        this._visitables.get("podSelector").remove(this.podSelector);
        if (podSelector != null) {
            this.podSelector = new V1LabelSelectorBuilder(podSelector);
            this._visitables.get("podSelector").add(this.podSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodSelector() {
        return this.podSelector != null;
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNestedImpl();
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(V1LabelSelector item) {
        return new PodSelectorNestedImpl(item);
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector());
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1beta1NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(V1LabelSelector item) {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : item);
    }

    @Override
    public A addToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPolicyTypes(int index, String item) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPolicyTypes(String ... items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPolicyTypes(Collection<String> items) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        for (String item : items) {
            this.policyTypes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPolicyTypes(String ... items) {
        for (String item : items) {
            if (this.policyTypes == null) continue;
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPolicyTypes(Collection<String> items) {
        for (String item : items) {
            if (this.policyTypes == null) continue;
            this.policyTypes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    @Override
    public String getPolicyType(int index) {
        return this.policyTypes.get(index);
    }

    @Override
    public String getFirstPolicyType() {
        return this.policyTypes.get(0);
    }

    @Override
    public String getLastPolicyType() {
        return this.policyTypes.get(this.policyTypes.size() - 1);
    }

    @Override
    public String getMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPolicyType(Predicate<String> predicate) {
        for (String item : this.policyTypes) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPolicyTypes(List<String> policyTypes) {
        if (this.policyTypes != null) {
            this._visitables.get("policyTypes").removeAll(this.policyTypes);
        }
        if (policyTypes != null) {
            this.policyTypes = new ArrayList<String>();
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        } else {
            this.policyTypes = null;
        }
        return (A)this;
    }

    @Override
    public A withPolicyTypes(String ... policyTypes) {
        if (this.policyTypes != null) {
            this.policyTypes.clear();
        }
        if (policyTypes != null) {
            for (String item : policyTypes) {
                this.addToPolicyTypes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicyTypes() {
        return this.policyTypes != null && !this.policyTypes.isEmpty();
    }

    @Override
    public A addNewPolicyType(String arg1) {
        return this.addToPolicyTypes(new String(arg1));
    }

    @Override
    public A addNewPolicyType(StringBuilder arg1) {
        return this.addToPolicyTypes(new String(arg1));
    }

    @Override
    public A addNewPolicyType(StringBuffer arg1) {
        return this.addToPolicyTypes(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1NetworkPolicySpecFluentImpl that = (V1beta1NetworkPolicySpecFluentImpl)o;
        if (this.egress != null ? !this.egress.equals(that.egress) : that.egress != null) {
            return false;
        }
        if (this.ingress != null ? !this.ingress.equals(that.ingress) : that.ingress != null) {
            return false;
        }
        if (this.podSelector != null ? !this.podSelector.equals(that.podSelector) : that.podSelector != null) {
            return false;
        }
        return !(this.policyTypes != null ? !this.policyTypes.equals(that.policyTypes) : that.policyTypes != null);
    }

    public class PodSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1beta1NetworkPolicySpecFluent.PodSelectorNested<N>>
    implements V1beta1NetworkPolicySpecFluent.PodSelectorNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;

        PodSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        PodSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1NetworkPolicySpecFluentImpl.this.withPodSelector(this.builder.build());
        }

        @Override
        public N endPodSelector() {
            return this.and();
        }
    }

    public class IngressNestedImpl<N>
    extends V1beta1NetworkPolicyIngressRuleFluentImpl<V1beta1NetworkPolicySpecFluent.IngressNested<N>>
    implements V1beta1NetworkPolicySpecFluent.IngressNested<N>,
    Nested<N> {
        private final V1beta1NetworkPolicyIngressRuleBuilder builder;
        private final int index;

        IngressNestedImpl(int index, V1beta1NetworkPolicyIngressRule item) {
            this.index = index;
            this.builder = new V1beta1NetworkPolicyIngressRuleBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1NetworkPolicyIngressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1NetworkPolicySpecFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }

    public class EgressNestedImpl<N>
    extends V1beta1NetworkPolicyEgressRuleFluentImpl<V1beta1NetworkPolicySpecFluent.EgressNested<N>>
    implements V1beta1NetworkPolicySpecFluent.EgressNested<N>,
    Nested<N> {
        private final V1beta1NetworkPolicyEgressRuleBuilder builder;
        private final int index;

        EgressNestedImpl(int index, V1beta1NetworkPolicyEgressRule item) {
            this.index = index;
            this.builder = new V1beta1NetworkPolicyEgressRuleBuilder(this, item);
        }

        EgressNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1NetworkPolicyEgressRuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1NetworkPolicySpecFluentImpl.this.setToEgress(this.index, this.builder.build());
        }

        @Override
        public N endEgress() {
            return this.and();
        }
    }
}

