/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha1Endpoint;
import io.kubernetes.client.openapi.models.V1alpha1EndpointPort;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EndpointSlice represents a subset of the endpoints that implement a service. For a given service there may be multiple EndpointSlice objects, selected by labels, which must be joined to produce the full set of endpoints.")
public class V1alpha1EndpointSlice {
    public static final String SERIALIZED_NAME_ADDRESS_TYPE = "addressType";
    @SerializedName(value="addressType")
    private String addressType;
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_ENDPOINTS = "endpoints";
    @SerializedName(value="endpoints")
    private List<V1alpha1Endpoint> endpoints = new ArrayList<V1alpha1Endpoint>();
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    private List<V1alpha1EndpointPort> ports = null;

    public V1alpha1EndpointSlice addressType(String addressType) {
        this.addressType = addressType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="addressType specifies the type of address carried by this EndpointSlice. All addresses in this slice must be the same type. Default is IP")
    public String getAddressType() {
        return this.addressType;
    }

    public void setAddressType(String addressType) {
        this.addressType = addressType;
    }

    public V1alpha1EndpointSlice apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha1EndpointSlice endpoints(List<V1alpha1Endpoint> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public V1alpha1EndpointSlice addEndpointsItem(V1alpha1Endpoint endpointsItem) {
        this.endpoints.add(endpointsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="endpoints is a list of unique endpoints in this slice. Each slice may include a maximum of 1000 endpoints.")
    public List<V1alpha1Endpoint> getEndpoints() {
        return this.endpoints;
    }

    public void setEndpoints(List<V1alpha1Endpoint> endpoints) {
        this.endpoints = endpoints;
    }

    public V1alpha1EndpointSlice kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha1EndpointSlice metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha1EndpointSlice ports(List<V1alpha1EndpointPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1alpha1EndpointSlice addPortsItem(V1alpha1EndpointPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1alpha1EndpointPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ports specifies the list of network ports exposed by each endpoint in this slice. Each port must have a unique name. When ports is empty, it indicates that there are no defined ports. When a port is defined with a nil port value, it indicates \"all ports\". Each slice may include a maximum of 100 ports.")
    public List<V1alpha1EndpointPort> getPorts() {
        return this.ports;
    }

    public void setPorts(List<V1alpha1EndpointPort> ports) {
        this.ports = ports;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1EndpointSlice v1alpha1EndpointSlice = (V1alpha1EndpointSlice)o;
        return Objects.equals(this.addressType, v1alpha1EndpointSlice.addressType) && Objects.equals(this.apiVersion, v1alpha1EndpointSlice.apiVersion) && Objects.equals(this.endpoints, v1alpha1EndpointSlice.endpoints) && Objects.equals(this.kind, v1alpha1EndpointSlice.kind) && Objects.equals(this.metadata, v1alpha1EndpointSlice.metadata) && Objects.equals(this.ports, v1alpha1EndpointSlice.ports);
    }

    public int hashCode() {
        return Objects.hash(this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1EndpointSlice {\n");
        sb.append("    addressType: ").append(this.toIndentedString(this.addressType)).append("\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

