/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.openapi.models.V1Initializer;
import io.kubernetes.client.openapi.models.V1InitializerBuilder;
import io.kubernetes.client.openapi.models.V1InitializerFluentImpl;
import io.kubernetes.client.openapi.models.V1Initializers;
import io.kubernetes.client.openapi.models.V1InitializersFluent;
import io.kubernetes.client.openapi.models.V1Status;
import io.kubernetes.client.openapi.models.V1StatusBuilder;
import io.kubernetes.client.openapi.models.V1StatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class V1InitializersFluentImpl<A extends V1InitializersFluent<A>>
extends BaseFluent<A>
implements V1InitializersFluent<A> {
    private List<V1InitializerBuilder> pending;
    private V1StatusBuilder result;

    public V1InitializersFluentImpl() {
    }

    public V1InitializersFluentImpl(V1Initializers instance) {
        this.withPending(instance.getPending());
        this.withResult(instance.getResult());
    }

    @Override
    public A addToPending(int index, V1Initializer item) {
        if (this.pending == null) {
            this.pending = new ArrayList<V1InitializerBuilder>();
        }
        V1InitializerBuilder builder = new V1InitializerBuilder(item);
        this._visitables.get("pending").add(index >= 0 ? index : this._visitables.get("pending").size(), builder);
        this.pending.add(index >= 0 ? index : this.pending.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPending(int index, V1Initializer item) {
        if (this.pending == null) {
            this.pending = new ArrayList<V1InitializerBuilder>();
        }
        V1InitializerBuilder builder = new V1InitializerBuilder(item);
        if (index < 0 || index >= this._visitables.get("pending").size()) {
            this._visitables.get("pending").add(builder);
        } else {
            this._visitables.get("pending").set(index, builder);
        }
        if (index < 0 || index >= this.pending.size()) {
            this.pending.add(builder);
        } else {
            this.pending.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPending(V1Initializer ... items) {
        if (this.pending == null) {
            this.pending = new ArrayList<V1InitializerBuilder>();
        }
        for (V1Initializer item : items) {
            V1InitializerBuilder builder = new V1InitializerBuilder(item);
            this._visitables.get("pending").add(builder);
            this.pending.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPending(Collection<V1Initializer> items) {
        if (this.pending == null) {
            this.pending = new ArrayList<V1InitializerBuilder>();
        }
        for (V1Initializer item : items) {
            V1InitializerBuilder builder = new V1InitializerBuilder(item);
            this._visitables.get("pending").add(builder);
            this.pending.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPending(V1Initializer ... items) {
        for (V1Initializer item : items) {
            V1InitializerBuilder builder = new V1InitializerBuilder(item);
            this._visitables.get("pending").remove(builder);
            if (this.pending == null) continue;
            this.pending.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPending(Collection<V1Initializer> items) {
        for (V1Initializer item : items) {
            V1InitializerBuilder builder = new V1InitializerBuilder(item);
            this._visitables.get("pending").remove(builder);
            if (this.pending == null) continue;
            this.pending.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPending(Predicate<V1InitializerBuilder> predicate) {
        if (this.pending == null) {
            return (A)this;
        }
        Iterator<V1InitializerBuilder> each = this.pending.iterator();
        Object visitables = this._visitables.get("pending");
        while (each.hasNext()) {
            V1InitializerBuilder builder = each.next();
            if (!predicate.apply(builder).booleanValue()) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1Initializer> getPending() {
        return V1InitializersFluentImpl.build(this.pending);
    }

    @Override
    public List<V1Initializer> buildPending() {
        return V1InitializersFluentImpl.build(this.pending);
    }

    @Override
    public V1Initializer buildPending(int index) {
        return this.pending.get(index).build();
    }

    @Override
    public V1Initializer buildFirstPending() {
        return this.pending.get(0).build();
    }

    @Override
    public V1Initializer buildLastPending() {
        return this.pending.get(this.pending.size() - 1).build();
    }

    @Override
    public V1Initializer buildMatchingPending(Predicate<V1InitializerBuilder> predicate) {
        for (V1InitializerBuilder item : this.pending) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPending(Predicate<V1InitializerBuilder> predicate) {
        for (V1InitializerBuilder item : this.pending) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPending(List<V1Initializer> pending) {
        if (this.pending != null) {
            this._visitables.get("pending").removeAll(this.pending);
        }
        if (pending != null) {
            this.pending = new ArrayList<V1InitializerBuilder>();
            for (V1Initializer item : pending) {
                this.addToPending(item);
            }
        } else {
            this.pending = null;
        }
        return (A)this;
    }

    @Override
    public A withPending(V1Initializer ... pending) {
        if (this.pending != null) {
            this.pending.clear();
        }
        if (pending != null) {
            for (V1Initializer item : pending) {
                this.addToPending(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPending() {
        return this.pending != null && !this.pending.isEmpty();
    }

    @Override
    public V1InitializersFluent.PendingNested<A> addNewPending() {
        return new PendingNestedImpl();
    }

    @Override
    public V1InitializersFluent.PendingNested<A> addNewPendingLike(V1Initializer item) {
        return new PendingNestedImpl(-1, item);
    }

    @Override
    public V1InitializersFluent.PendingNested<A> setNewPendingLike(int index, V1Initializer item) {
        return new PendingNestedImpl(index, item);
    }

    @Override
    public V1InitializersFluent.PendingNested<A> editPending(int index) {
        if (this.pending.size() <= index) {
            throw new RuntimeException("Can't edit pending. Index exceeds size.");
        }
        return this.setNewPendingLike(index, this.buildPending(index));
    }

    @Override
    public V1InitializersFluent.PendingNested<A> editFirstPending() {
        if (this.pending.size() == 0) {
            throw new RuntimeException("Can't edit first pending. The list is empty.");
        }
        return this.setNewPendingLike(0, this.buildPending(0));
    }

    @Override
    public V1InitializersFluent.PendingNested<A> editLastPending() {
        int index = this.pending.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last pending. The list is empty.");
        }
        return this.setNewPendingLike(index, this.buildPending(index));
    }

    @Override
    public V1InitializersFluent.PendingNested<A> editMatchingPending(Predicate<V1InitializerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.pending.size(); ++i) {
            if (!predicate.apply(this.pending.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching pending. No match found.");
        }
        return this.setNewPendingLike(index, this.buildPending(index));
    }

    @Override
    @Deprecated
    public V1Status getResult() {
        return this.result != null ? this.result.build() : null;
    }

    @Override
    public V1Status buildResult() {
        return this.result != null ? this.result.build() : null;
    }

    @Override
    public A withResult(V1Status result) {
        this._visitables.get("result").remove(this.result);
        if (result != null) {
            this.result = new V1StatusBuilder(result);
            this._visitables.get("result").add(this.result);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResult() {
        return this.result != null;
    }

    @Override
    public V1InitializersFluent.ResultNested<A> withNewResult() {
        return new ResultNestedImpl();
    }

    @Override
    public V1InitializersFluent.ResultNested<A> withNewResultLike(V1Status item) {
        return new ResultNestedImpl(item);
    }

    @Override
    public V1InitializersFluent.ResultNested<A> editResult() {
        return this.withNewResultLike(this.getResult());
    }

    @Override
    public V1InitializersFluent.ResultNested<A> editOrNewResult() {
        return this.withNewResultLike(this.getResult() != null ? this.getResult() : new V1StatusBuilder().build());
    }

    @Override
    public V1InitializersFluent.ResultNested<A> editOrNewResultLike(V1Status item) {
        return this.withNewResultLike(this.getResult() != null ? this.getResult() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1InitializersFluentImpl that = (V1InitializersFluentImpl)o;
        if (this.pending != null ? !this.pending.equals(that.pending) : that.pending != null) {
            return false;
        }
        return !(this.result != null ? !this.result.equals(that.result) : that.result != null);
    }

    public class ResultNestedImpl<N>
    extends V1StatusFluentImpl<V1InitializersFluent.ResultNested<N>>
    implements V1InitializersFluent.ResultNested<N>,
    Nested<N> {
        private final V1StatusBuilder builder;

        ResultNestedImpl(V1Status item) {
            this.builder = new V1StatusBuilder(this, item);
        }

        ResultNestedImpl() {
            this.builder = new V1StatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1InitializersFluentImpl.this.withResult(this.builder.build());
        }

        @Override
        public N endResult() {
            return this.and();
        }
    }

    public class PendingNestedImpl<N>
    extends V1InitializerFluentImpl<V1InitializersFluent.PendingNested<N>>
    implements V1InitializersFluent.PendingNested<N>,
    Nested<N> {
        private final V1InitializerBuilder builder;
        private final int index;

        PendingNestedImpl(int index, V1Initializer item) {
            this.index = index;
            this.builder = new V1InitializerBuilder(this, item);
        }

        PendingNestedImpl() {
            this.index = -1;
            this.builder = new V1InitializerBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1InitializersFluentImpl.this.setToPending(this.index, this.builder.build());
        }

        @Override
        public N endPending() {
            return this.and();
        }
    }
}

