/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1beta1CertificateSigningRequestCondition;
import io.kubernetes.client.models.V1beta1CertificateSigningRequestConditionBuilder;
import io.kubernetes.client.models.V1beta1CertificateSigningRequestConditionFluentImpl;
import io.kubernetes.client.models.V1beta1CertificateSigningRequestStatus;
import io.kubernetes.client.models.V1beta1CertificateSigningRequestStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1beta1CertificateSigningRequestStatusFluentImpl<A extends V1beta1CertificateSigningRequestStatusFluent<A>>
extends BaseFluent<A>
implements V1beta1CertificateSigningRequestStatusFluent<A> {
    private List<Byte> certificate;
    private List<V1beta1CertificateSigningRequestConditionBuilder> conditions;

    public V1beta1CertificateSigningRequestStatusFluentImpl() {
    }

    public V1beta1CertificateSigningRequestStatusFluentImpl(V1beta1CertificateSigningRequestStatus instance) {
        this.withCertificate(instance.getCertificate());
        this.withConditions(instance.getConditions());
    }

    @Override
    public A withCertificate(byte ... certificate) {
        if (this.certificate != null) {
            this.certificate.clear();
        }
        if (certificate != null) {
            for (byte item : certificate) {
                this.addToCertificate(item);
            }
        }
        return (A)this;
    }

    @Override
    public byte[] getCertificate() {
        int size = this.certificate != null ? this.certificate.size() : 0;
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (byte item : this.certificate) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCertificate(int index, Byte item) {
        if (this.certificate == null) {
            this.certificate = null;
        }
        this.certificate.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCertificate(int index, Byte item) {
        if (this.certificate == null) {
            this.certificate = null;
        }
        this.certificate.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCertificate(Byte ... items) {
        if (this.certificate == null) {
            this.certificate = null;
        }
        for (Byte item : items) {
            this.certificate.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCertificate(Collection<Byte> items) {
        if (this.certificate == null) {
            this.certificate = null;
        }
        for (Byte item : items) {
            this.certificate.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCertificate(Byte ... items) {
        for (Byte item : items) {
            if (this.certificate == null) continue;
            this.certificate.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCertificate(Collection<Byte> items) {
        for (Byte item : items) {
            if (this.certificate == null) continue;
            this.certificate.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCertificate() {
        return this.certificate != null && !this.certificate.isEmpty();
    }

    @Override
    public A addNewCertificate(byte arg1) {
        return this.addToCertificate(new Byte(arg1));
    }

    @Override
    public A addNewCertificate(String arg1) {
        return this.addToCertificate(new Byte(arg1));
    }

    @Override
    public A addToConditions(int index, V1beta1CertificateSigningRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();
        }
        V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1beta1CertificateSigningRequestCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();
        }
        V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1beta1CertificateSigningRequestCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();
        }
        for (V1beta1CertificateSigningRequestCondition item : items) {
            V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1beta1CertificateSigningRequestCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();
        }
        for (V1beta1CertificateSigningRequestCondition item : items) {
            V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1beta1CertificateSigningRequestCondition ... items) {
        for (V1beta1CertificateSigningRequestCondition item : items) {
            V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1beta1CertificateSigningRequestCondition> items) {
        for (V1beta1CertificateSigningRequestCondition item : items) {
            V1beta1CertificateSigningRequestConditionBuilder builder = new V1beta1CertificateSigningRequestConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1beta1CertificateSigningRequestCondition> getConditions() {
        return V1beta1CertificateSigningRequestStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1beta1CertificateSigningRequestCondition> buildConditions() {
        return V1beta1CertificateSigningRequestStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1beta1CertificateSigningRequestCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1beta1CertificateSigningRequestCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1beta1CertificateSigningRequestCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1beta1CertificateSigningRequestCondition buildMatchingCondition(Predicate<V1beta1CertificateSigningRequestConditionBuilder> predicate) {
        for (V1beta1CertificateSigningRequestConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<V1beta1CertificateSigningRequestCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1beta1CertificateSigningRequestConditionBuilder>();
            for (V1beta1CertificateSigningRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1beta1CertificateSigningRequestCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1beta1CertificateSigningRequestCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewConditionLike(V1beta1CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1beta1CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1beta1CertificateSigningRequestConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1CertificateSigningRequestStatusFluentImpl that = (V1beta1CertificateSigningRequestStatusFluentImpl)o;
        if (this.certificate != null ? !this.certificate.equals(that.certificate) : that.certificate != null) {
            return false;
        }
        return !(this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null);
    }

    public class ConditionsNestedImpl<N>
    extends V1beta1CertificateSigningRequestConditionFluentImpl<V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<N>>
    implements V1beta1CertificateSigningRequestStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1beta1CertificateSigningRequestConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1beta1CertificateSigningRequestCondition item) {
            this.index = index;
            this.builder = new V1beta1CertificateSigningRequestConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1beta1CertificateSigningRequestConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1CertificateSigningRequestStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

