/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1alpha1Initializer;
import io.kubernetes.client.models.V1alpha1InitializerFluent;
import io.kubernetes.client.models.V1alpha1Rule;
import io.kubernetes.client.models.V1alpha1RuleBuilder;
import io.kubernetes.client.models.V1alpha1RuleFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1alpha1InitializerFluentImpl<A extends V1alpha1InitializerFluent<A>>
extends BaseFluent<A>
implements V1alpha1InitializerFluent<A> {
    private String name;
    private List<V1alpha1RuleBuilder> rules;

    public V1alpha1InitializerFluentImpl() {
    }

    public V1alpha1InitializerFluentImpl(V1alpha1Initializer instance) {
        this.withName(instance.getName());
        this.withRules(instance.getRules());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A addToRules(int index, V1alpha1Rule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1RuleBuilder>();
        }
        V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.rules.add(index >= 0 ? index : this.rules.size(), builder);
        return (A)this;
    }

    @Override
    public A setToRules(int index, V1alpha1Rule item) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1RuleBuilder>();
        }
        V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.rules.size()) {
            this.rules.add(builder);
        } else {
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(V1alpha1Rule ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1RuleBuilder>();
        }
        for (V1alpha1Rule item : items) {
            V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<V1alpha1Rule> items) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1alpha1RuleBuilder>();
        }
        for (V1alpha1Rule item : items) {
            V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);
            this._visitables.add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(V1alpha1Rule ... items) {
        for (V1alpha1Rule item : items) {
            V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);
            this._visitables.remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<V1alpha1Rule> items) {
        for (V1alpha1Rule item : items) {
            V1alpha1RuleBuilder builder = new V1alpha1RuleBuilder(item);
            this._visitables.remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha1Rule> getRules() {
        return V1alpha1InitializerFluentImpl.build(this.rules);
    }

    @Override
    public List<V1alpha1Rule> buildRules() {
        return V1alpha1InitializerFluentImpl.build(this.rules);
    }

    @Override
    public V1alpha1Rule buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public V1alpha1Rule buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public V1alpha1Rule buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public V1alpha1Rule buildMatchingRule(Predicate<V1alpha1RuleBuilder> predicate) {
        for (V1alpha1RuleBuilder item : this.rules) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withRules(List<V1alpha1Rule> rules) {
        if (this.rules != null) {
            this._visitables.removeAll(this.rules);
        }
        if (rules != null) {
            this.rules = new ArrayList<V1alpha1RuleBuilder>();
            for (V1alpha1Rule item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(V1alpha1Rule ... rules) {
        if (this.rules != null) {
            this.rules.clear();
        }
        if (rules != null) {
            for (V1alpha1Rule item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public V1alpha1InitializerFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public V1alpha1InitializerFluent.RulesNested<A> addNewRuleLike(V1alpha1Rule item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public V1alpha1InitializerFluent.RulesNested<A> setNewRuleLike(int index, V1alpha1Rule item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public V1alpha1InitializerFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1alpha1InitializerFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public V1alpha1InitializerFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1alpha1InitializerFluent.RulesNested<A> editMatchingRule(Predicate<V1alpha1RuleBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.apply(this.rules.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1InitializerFluentImpl that = (V1alpha1InitializerFluentImpl)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.rules != null ? !this.rules.equals(that.rules) : that.rules != null);
    }

    public class RulesNestedImpl<N>
    extends V1alpha1RuleFluentImpl<V1alpha1InitializerFluent.RulesNested<N>>
    implements V1alpha1InitializerFluent.RulesNested<N>,
    Nested<N> {
        private final V1alpha1RuleBuilder builder;
        private final int index;

        RulesNestedImpl(int index, V1alpha1Rule item) {
            this.index = index;
            this.builder = new V1alpha1RuleBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha1RuleBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1InitializerFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }
}

