/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1StatefulSetCondition;
import io.kubernetes.client.models.V1StatefulSetConditionBuilder;
import io.kubernetes.client.models.V1StatefulSetConditionFluentImpl;
import io.kubernetes.client.models.V1StatefulSetStatus;
import io.kubernetes.client.models.V1StatefulSetStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1StatefulSetStatusFluentImpl<A extends V1StatefulSetStatusFluent<A>>
extends BaseFluent<A>
implements V1StatefulSetStatusFluent<A> {
    private Integer collisionCount;
    private List<V1StatefulSetConditionBuilder> conditions;
    private Integer currentReplicas;
    private String currentRevision;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private String updateRevision;
    private Integer updatedReplicas;

    public V1StatefulSetStatusFluentImpl() {
    }

    public V1StatefulSetStatusFluentImpl(V1StatefulSetStatus instance) {
        this.withCollisionCount(instance.getCollisionCount());
        this.withConditions(instance.getConditions());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withCurrentRevision(instance.getCurrentRevision());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.withUpdateRevision(instance.getUpdateRevision());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
    }

    @Override
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    @Override
    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)this;
    }

    @Override
    public Boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    @Override
    public A withNewCollisionCount(int arg1) {
        return this.withCollisionCount(new Integer(arg1));
    }

    @Override
    public A withNewCollisionCount(String arg1) {
        return this.withCollisionCount(new Integer(arg1));
    }

    @Override
    public A addToConditions(int index, V1StatefulSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1StatefulSetConditionBuilder>();
        }
        V1StatefulSetConditionBuilder builder = new V1StatefulSetConditionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1StatefulSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1StatefulSetConditionBuilder>();
        }
        V1StatefulSetConditionBuilder builder = new V1StatefulSetConditionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1StatefulSetCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1StatefulSetConditionBuilder>();
        }
        for (V1StatefulSetCondition item : items) {
            V1StatefulSetConditionBuilder builder = new V1StatefulSetConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1StatefulSetCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1StatefulSetConditionBuilder>();
        }
        for (V1StatefulSetCondition item : items) {
            V1StatefulSetConditionBuilder builder = new V1StatefulSetConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1StatefulSetCondition ... items) {
        for (V1StatefulSetCondition item : items) {
            V1StatefulSetConditionBuilder builder = new V1StatefulSetConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1StatefulSetCondition> items) {
        for (V1StatefulSetCondition item : items) {
            V1StatefulSetConditionBuilder builder = new V1StatefulSetConditionBuilder(item);
            this._visitables.remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1StatefulSetCondition> getConditions() {
        return V1StatefulSetStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1StatefulSetCondition> buildConditions() {
        return V1StatefulSetStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1StatefulSetCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1StatefulSetCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1StatefulSetCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1StatefulSetCondition buildMatchingCondition(Predicate<V1StatefulSetConditionBuilder> predicate) {
        for (V1StatefulSetConditionBuilder item : this.conditions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withConditions(List<V1StatefulSetCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1StatefulSetConditionBuilder>();
            for (V1StatefulSetCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1StatefulSetCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1StatefulSetCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1StatefulSetStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1StatefulSetStatusFluent.ConditionsNested<A> addNewConditionLike(V1StatefulSetCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1StatefulSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1StatefulSetCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1StatefulSetStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1StatefulSetStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1StatefulSetStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1StatefulSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1StatefulSetConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.apply(this.conditions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    @Override
    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    @Override
    public A withNewCurrentReplicas(int arg1) {
        return this.withCurrentReplicas(new Integer(arg1));
    }

    @Override
    public A withNewCurrentReplicas(String arg1) {
        return this.withCurrentReplicas(new Integer(arg1));
    }

    @Override
    public String getCurrentRevision() {
        return this.currentRevision;
    }

    @Override
    public A withCurrentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentRevision() {
        return this.currentRevision != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A withNewObservedGeneration(String arg1) {
        return this.withObservedGeneration(new Long(arg1));
    }

    @Override
    public A withNewObservedGeneration(long arg1) {
        return this.withObservedGeneration(new Long(arg1));
    }

    @Override
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    @Override
    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    @Override
    public A withNewReadyReplicas(int arg1) {
        return this.withReadyReplicas(new Integer(arg1));
    }

    @Override
    public A withNewReadyReplicas(String arg1) {
        return this.withReadyReplicas(new Integer(arg1));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A withNewReplicas(int arg1) {
        return this.withReplicas(new Integer(arg1));
    }

    @Override
    public A withNewReplicas(String arg1) {
        return this.withReplicas(new Integer(arg1));
    }

    @Override
    public String getUpdateRevision() {
        return this.updateRevision;
    }

    @Override
    public A withUpdateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
        return (A)this;
    }

    @Override
    public Boolean hasUpdateRevision() {
        return this.updateRevision != null;
    }

    @Override
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    @Override
    public A withUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasUpdatedReplicas() {
        return this.updatedReplicas != null;
    }

    @Override
    public A withNewUpdatedReplicas(int arg1) {
        return this.withUpdatedReplicas(new Integer(arg1));
    }

    @Override
    public A withNewUpdatedReplicas(String arg1) {
        return this.withUpdatedReplicas(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1StatefulSetStatusFluentImpl that = (V1StatefulSetStatusFluentImpl)o;
        if (this.collisionCount != null ? !this.collisionCount.equals(that.collisionCount) : that.collisionCount != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentReplicas != null ? !this.currentReplicas.equals(that.currentReplicas) : that.currentReplicas != null) {
            return false;
        }
        if (this.currentRevision != null ? !this.currentRevision.equals(that.currentRevision) : that.currentRevision != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.readyReplicas != null ? !this.readyReplicas.equals(that.readyReplicas) : that.readyReplicas != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.updateRevision != null ? !this.updateRevision.equals(that.updateRevision) : that.updateRevision != null) {
            return false;
        }
        return !(this.updatedReplicas != null ? !this.updatedReplicas.equals(that.updatedReplicas) : that.updatedReplicas != null);
    }

    public class ConditionsNestedImpl<N>
    extends V1StatefulSetConditionFluentImpl<V1StatefulSetStatusFluent.ConditionsNested<N>>
    implements V1StatefulSetStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1StatefulSetConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1StatefulSetCondition item) {
            this.index = index;
            this.builder = new V1StatefulSetConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1StatefulSetConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1StatefulSetStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

