package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1MetricSpecBuilder extends V2beta1MetricSpecFluentImpl<V2beta1MetricSpecBuilder> implements VisitableBuilder<V2beta1MetricSpec,V2beta1MetricSpecBuilder>{

    V2beta1MetricSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta1MetricSpecBuilder(){
            this(true);
    }
    public V2beta1MetricSpecBuilder(Boolean validationEnabled){
            this(new V2beta1MetricSpec(), validationEnabled);
    }
    public V2beta1MetricSpecBuilder(V2beta1MetricSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta1MetricSpecBuilder(V2beta1MetricSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta1MetricSpec(), validationEnabled);
    }
    public V2beta1MetricSpecBuilder(V2beta1MetricSpecFluent<?> fluent,V2beta1MetricSpec instance){
            this(fluent, instance, true);
    }
    public V2beta1MetricSpecBuilder(V2beta1MetricSpecFluent<?> fluent,V2beta1MetricSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withExternal(instance.getExternal());

            fluent.withObject(instance.getObject());

            fluent.withPods(instance.getPods());

            fluent.withResource(instance.getResource());

            fluent.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta1MetricSpecBuilder(V2beta1MetricSpec instance){
            this(instance,true);
    }
    public V2beta1MetricSpecBuilder(V2beta1MetricSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withExternal(instance.getExternal());

            this.withObject(instance.getObject());

            this.withPods(instance.getPods());

            this.withResource(instance.getResource());

            this.withType(instance.getType());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta1MetricSpec build(){
            V2beta1MetricSpec buildable = new V2beta1MetricSpec();
            buildable.setExternal(fluent.getExternal());
            buildable.setObject(fluent.getObject());
            buildable.setPods(fluent.getPods());
            buildable.setResource(fluent.getResource());
            buildable.setType(fluent.getType());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1MetricSpecBuilder that = (V2beta1MetricSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
