package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2alpha1CronJobSpecBuilder extends V2alpha1CronJobSpecFluentImpl<V2alpha1CronJobSpecBuilder> implements VisitableBuilder<V2alpha1CronJobSpec,V2alpha1CronJobSpecBuilder>{

    V2alpha1CronJobSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V2alpha1CronJobSpecBuilder(){
            this(true);
    }
    public V2alpha1CronJobSpecBuilder(Boolean validationEnabled){
            this(new V2alpha1CronJobSpec(), validationEnabled);
    }
    public V2alpha1CronJobSpecBuilder(V2alpha1CronJobSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V2alpha1CronJobSpecBuilder(V2alpha1CronJobSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2alpha1CronJobSpec(), validationEnabled);
    }
    public V2alpha1CronJobSpecBuilder(V2alpha1CronJobSpecFluent<?> fluent,V2alpha1CronJobSpec instance){
            this(fluent, instance, true);
    }
    public V2alpha1CronJobSpecBuilder(V2alpha1CronJobSpecFluent<?> fluent,V2alpha1CronJobSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withConcurrencyPolicy(instance.getConcurrencyPolicy());

            fluent.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());

            fluent.withJobTemplate(instance.getJobTemplate());

            fluent.withSchedule(instance.getSchedule());

            fluent.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());

            fluent.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());

            fluent.withSuspend(instance.isSuspend());

            this.validationEnabled = validationEnabled; 
    }
    public V2alpha1CronJobSpecBuilder(V2alpha1CronJobSpec instance){
            this(instance,true);
    }
    public V2alpha1CronJobSpecBuilder(V2alpha1CronJobSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withConcurrencyPolicy(instance.getConcurrencyPolicy());

            this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());

            this.withJobTemplate(instance.getJobTemplate());

            this.withSchedule(instance.getSchedule());

            this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());

            this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());

            this.withSuspend(instance.isSuspend());

            this.validationEnabled = validationEnabled; 
    }

    public V2alpha1CronJobSpec build(){
            V2alpha1CronJobSpec buildable = new V2alpha1CronJobSpec();
            buildable.setConcurrencyPolicy(fluent.getConcurrencyPolicy());
            buildable.setFailedJobsHistoryLimit(fluent.getFailedJobsHistoryLimit());
            buildable.setJobTemplate(fluent.getJobTemplate());
            buildable.setSchedule(fluent.getSchedule());
            buildable.setStartingDeadlineSeconds(fluent.getStartingDeadlineSeconds());
            buildable.setSuccessfulJobsHistoryLimit(fluent.getSuccessfulJobsHistoryLimit());
            buildable.setSuspend(fluent.isSuspend());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2alpha1CronJobSpecBuilder that = (V2alpha1CronJobSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
