package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2StatefulSetListBuilder extends V1beta2StatefulSetListFluentImpl<V1beta2StatefulSetListBuilder> implements VisitableBuilder<V1beta2StatefulSetList,V1beta2StatefulSetListBuilder>{

    V1beta2StatefulSetListFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2StatefulSetListBuilder(){
            this(true);
    }
    public V1beta2StatefulSetListBuilder(Boolean validationEnabled){
            this(new V1beta2StatefulSetList(), validationEnabled);
    }
    public V1beta2StatefulSetListBuilder(V1beta2StatefulSetListFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2StatefulSetListBuilder(V1beta2StatefulSetListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2StatefulSetList(), validationEnabled);
    }
    public V1beta2StatefulSetListBuilder(V1beta2StatefulSetListFluent<?> fluent,V1beta2StatefulSetList instance){
            this(fluent, instance, true);
    }
    public V1beta2StatefulSetListBuilder(V1beta2StatefulSetListFluent<?> fluent,V1beta2StatefulSetList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2StatefulSetListBuilder(V1beta2StatefulSetList instance){
            this(instance,true);
    }
    public V1beta2StatefulSetListBuilder(V1beta2StatefulSetList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2StatefulSetList build(){
            V1beta2StatefulSetList buildable = new V1beta2StatefulSetList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2StatefulSetListBuilder that = (V1beta2StatefulSetListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
