package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface V1beta1StorageClassFluent<A extends V1beta1StorageClassFluent<A>> extends Fluent<A>{


    public Boolean isAllowVolumeExpansion();
    public A withAllowVolumeExpansion(Boolean allowVolumeExpansion);
    public Boolean hasAllowVolumeExpansion();
    public A withNewAllowVolumeExpansion(boolean arg1);
    public A withNewAllowVolumeExpansion(String arg1);
    public A addToAllowedTopologies(int index,V1TopologySelectorTerm item);
    public A setToAllowedTopologies(int index,V1TopologySelectorTerm item);
    public A addToAllowedTopologies(V1TopologySelectorTerm... items);
    public A addAllToAllowedTopologies(Collection<V1TopologySelectorTerm> items);
    public A removeFromAllowedTopologies(V1TopologySelectorTerm... items);
    public A removeAllFromAllowedTopologies(Collection<V1TopologySelectorTerm> items);
    
/**
 * This method has been deprecated, please use method buildAllowedTopologies instead.
 * @return The buildable object.
 */
@Deprecated public List<V1TopologySelectorTerm> getAllowedTopologies();
    public List<V1TopologySelectorTerm> buildAllowedTopologies();
    public V1TopologySelectorTerm buildAllowedTopology(int index);
    public V1TopologySelectorTerm buildFirstAllowedTopology();
    public V1TopologySelectorTerm buildLastAllowedTopology();
    public V1TopologySelectorTerm buildMatchingAllowedTopology(io.kubernetes.client.fluent.Predicate<V1TopologySelectorTermBuilder> predicate);
    public A withAllowedTopologies(List<V1TopologySelectorTerm> allowedTopologies);
    public A withAllowedTopologies(V1TopologySelectorTerm... allowedTopologies);
    public Boolean hasAllowedTopologies();
    public V1beta1StorageClassFluent.AllowedTopologiesNested<A> addNewAllowedTopology();
    public V1beta1StorageClassFluent.AllowedTopologiesNested<A> addNewAllowedTopologyLike(V1TopologySelectorTerm item);
    public V1beta1StorageClassFluent.AllowedTopologiesNested<A> setNewAllowedTopologyLike(int index,V1TopologySelectorTerm item);
    public V1beta1StorageClassFluent.AllowedTopologiesNested<A> editAllowedTopology(int index);
    public V1beta1StorageClassFluent.AllowedTopologiesNested<A> editFirstAllowedTopology();
    public V1beta1StorageClassFluent.AllowedTopologiesNested<A> editLastAllowedTopology();
    public V1beta1StorageClassFluent.AllowedTopologiesNested<A> editMatchingAllowedTopology(io.kubernetes.client.fluent.Predicate<V1TopologySelectorTermBuilder> predicate);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1beta1StorageClassFluent.MetadataNested<A> withNewMetadata();
    public V1beta1StorageClassFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1beta1StorageClassFluent.MetadataNested<A> editMetadata();
    public V1beta1StorageClassFluent.MetadataNested<A> editOrNewMetadata();
    public V1beta1StorageClassFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    public A addToMountOptions(int index,String item);
    public A setToMountOptions(int index,String item);
    public A addToMountOptions(String... items);
    public A addAllToMountOptions(Collection<String> items);
    public A removeFromMountOptions(String... items);
    public A removeAllFromMountOptions(Collection<String> items);
    public List<String> getMountOptions();
    public String getMountOption(int index);
    public String getFirstMountOption();
    public String getLastMountOption();
    public String getMatchingMountOption(io.kubernetes.client.fluent.Predicate<String> predicate);
    public A withMountOptions(List<String> mountOptions);
    public A withMountOptions(String... mountOptions);
    public Boolean hasMountOptions();
    public A addToParameters(String key,String value);
    public A addToParameters(Map<String,String> map);
    public A removeFromParameters(String key);
    public A removeFromParameters(Map<String,String> map);
    public Map<String,String> getParameters();
    public A withParameters(Map<String,String> parameters);
    public Boolean hasParameters();
    public String getProvisioner();
    public A withProvisioner(String provisioner);
    public Boolean hasProvisioner();
    public String getReclaimPolicy();
    public A withReclaimPolicy(String reclaimPolicy);
    public Boolean hasReclaimPolicy();
    public String getVolumeBindingMode();
    public A withVolumeBindingMode(String volumeBindingMode);
    public Boolean hasVolumeBindingMode();

    public interface AllowedTopologiesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1TopologySelectorTermFluent<V1beta1StorageClassFluent.AllowedTopologiesNested<N>>{

        
    public N and();    public N endAllowedTopology();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1beta1StorageClassFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
