package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1VolumeAttachmentStatusBuilder extends V1alpha1VolumeAttachmentStatusFluentImpl<V1alpha1VolumeAttachmentStatusBuilder> implements VisitableBuilder<V1alpha1VolumeAttachmentStatus,V1alpha1VolumeAttachmentStatusBuilder>{

    V1alpha1VolumeAttachmentStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1VolumeAttachmentStatusBuilder(){
            this(true);
    }
    public V1alpha1VolumeAttachmentStatusBuilder(Boolean validationEnabled){
            this(new V1alpha1VolumeAttachmentStatus(), validationEnabled);
    }
    public V1alpha1VolumeAttachmentStatusBuilder(V1alpha1VolumeAttachmentStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1VolumeAttachmentStatusBuilder(V1alpha1VolumeAttachmentStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1VolumeAttachmentStatus(), validationEnabled);
    }
    public V1alpha1VolumeAttachmentStatusBuilder(V1alpha1VolumeAttachmentStatusFluent<?> fluent,V1alpha1VolumeAttachmentStatus instance){
            this(fluent, instance, true);
    }
    public V1alpha1VolumeAttachmentStatusBuilder(V1alpha1VolumeAttachmentStatusFluent<?> fluent,V1alpha1VolumeAttachmentStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAttachError(instance.getAttachError());

            fluent.withAttached(instance.isAttached());

            fluent.withAttachmentMetadata(instance.getAttachmentMetadata());

            fluent.withDetachError(instance.getDetachError());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1VolumeAttachmentStatusBuilder(V1alpha1VolumeAttachmentStatus instance){
            this(instance,true);
    }
    public V1alpha1VolumeAttachmentStatusBuilder(V1alpha1VolumeAttachmentStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAttachError(instance.getAttachError());

            this.withAttached(instance.isAttached());

            this.withAttachmentMetadata(instance.getAttachmentMetadata());

            this.withDetachError(instance.getDetachError());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1VolumeAttachmentStatus build(){
            V1alpha1VolumeAttachmentStatus buildable = new V1alpha1VolumeAttachmentStatus();
            buildable.setAttachError(fluent.getAttachError());
            buildable.setAttached(fluent.isAttached());
            buildable.setAttachmentMetadata(fluent.getAttachmentMetadata());
            buildable.setDetachError(fluent.getDetachError());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1VolumeAttachmentStatusBuilder that = (V1alpha1VolumeAttachmentStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
