package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1PodPresetListFluentImpl<A extends V1alpha1PodPresetListFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1PodPresetListFluent<A>{

    private String apiVersion;
    private List<V1alpha1PodPresetBuilder> items;
    private String kind;
    private V1ListMetaBuilder metadata;

    public V1alpha1PodPresetListFluentImpl(){
    }
    public V1alpha1PodPresetListFluentImpl(V1alpha1PodPresetList instance){
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToItems(int index,V1alpha1PodPreset item){
            if (this.items == null) {this.items = new ArrayList<V1alpha1PodPresetBuilder>();}
            V1alpha1PodPresetBuilder builder = new V1alpha1PodPresetBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.items.add(index >= 0 ? index : items.size(), builder); return (A)this;
    }

    public A setToItems(int index,V1alpha1PodPreset item){
            if (this.items == null) {this.items = new ArrayList<V1alpha1PodPresetBuilder>();}
            V1alpha1PodPresetBuilder builder = new V1alpha1PodPresetBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= items.size()) { items.add(builder); } else { items.set(index, builder);}
             return (A)this;
    }

    public A addToItems(V1alpha1PodPreset... items){
            if (this.items == null) {this.items = new ArrayList<V1alpha1PodPresetBuilder>();}
            for (V1alpha1PodPreset item : items) {V1alpha1PodPresetBuilder builder = new V1alpha1PodPresetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A addAllToItems(Collection<V1alpha1PodPreset> items){
            if (this.items == null) {this.items = new ArrayList<V1alpha1PodPresetBuilder>();}
            for (V1alpha1PodPreset item : items) {V1alpha1PodPresetBuilder builder = new V1alpha1PodPresetBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(V1alpha1PodPreset... items){
            for (V1alpha1PodPreset item : items) {V1alpha1PodPresetBuilder builder = new V1alpha1PodPresetBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    public A removeAllFromItems(Collection<V1alpha1PodPreset> items){
            for (V1alpha1PodPreset item : items) {V1alpha1PodPresetBuilder builder = new V1alpha1PodPresetBuilder(item);_visitables.remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PodPreset> getItems(){
            return build(items);
    }

    public List<V1alpha1PodPreset> buildItems(){
            return build(items);
    }

    public V1alpha1PodPreset buildItem(int index){
            return this.items.get(index).build();
    }

    public V1alpha1PodPreset buildFirstItem(){
            return this.items.get(0).build();
    }

    public V1alpha1PodPreset buildLastItem(){
            return this.items.get(items.size() - 1).build();
    }

    public V1alpha1PodPreset buildMatchingItem(io.kubernetes.client.fluent.Predicate<V1alpha1PodPresetBuilder> predicate){
            for (V1alpha1PodPresetBuilder item: items) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withItems(List<V1alpha1PodPreset> items){
            if (this.items != null) { _visitables.removeAll(this.items);}
            if (items != null) {this.items = new ArrayList<V1alpha1PodPresetBuilder>(); for (V1alpha1PodPreset item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
    }

    public A withItems(V1alpha1PodPreset... items){
            if (this.items != null) {this.items.clear();}
            if (items != null) {for (V1alpha1PodPreset item :items){ this.addToItems(item);}} return (A) this;
    }

    public Boolean hasItems(){
            return items != null && !items.isEmpty();
    }

    public V1alpha1PodPresetListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public V1alpha1PodPresetListFluent.ItemsNested<A> addNewItemLike(V1alpha1PodPreset item){
            return new ItemsNestedImpl(-1, item);
    }

    public V1alpha1PodPresetListFluent.ItemsNested<A> setNewItemLike(int index,V1alpha1PodPreset item){
            return new ItemsNestedImpl(index, item);
    }

    public V1alpha1PodPresetListFluent.ItemsNested<A> editItem(int index){
            if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1alpha1PodPresetListFluent.ItemsNested<A> editFirstItem(){
            if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
            return setNewItemLike(0, buildItem(0));
    }

    public V1alpha1PodPresetListFluent.ItemsNested<A> editLastItem(){
            int index = items.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
            return setNewItemLike(index, buildItem(index));
    }

    public V1alpha1PodPresetListFluent.ItemsNested<A> editMatchingItem(io.kubernetes.client.fluent.Predicate<V1alpha1PodPresetBuilder> predicate){
            int index = -1;
            for (int i=0;i<items.size();i++) { 
            if (predicate.apply(items.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
            return setNewItemLike(index, buildItem(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ListMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ListMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1alpha1PodPresetListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1alpha1PodPresetListFluent.MetadataNested<A> withNewMetadataLike(V1ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1alpha1PodPresetListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1alpha1PodPresetListFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ListMetaBuilder().build());
    }

    public V1alpha1PodPresetListFluent.MetadataNested<A> editOrNewMetadataLike(V1ListMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PodPresetListFluentImpl that = (V1alpha1PodPresetListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends V1alpha1PodPresetFluentImpl<V1alpha1PodPresetListFluent.ItemsNested<N>> implements V1alpha1PodPresetListFluent.ItemsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1PodPresetBuilder builder;
        private final int index;
    
            ItemsNestedImpl(int index,V1alpha1PodPreset item){
                    this.index = index;
                    this.builder = new V1alpha1PodPresetBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PodPresetBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PodPresetListFluentImpl.this.setToItems(index, builder.build());
    }
    public N endItem(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ListMetaFluentImpl<V1alpha1PodPresetListFluent.MetadataNested<N>> implements V1alpha1PodPresetListFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ListMetaBuilder builder;
    
            MetadataNestedImpl(V1ListMeta item){
                    this.builder = new V1ListMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ListMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1PodPresetListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
