package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1InitializerConfigurationBuilder extends V1alpha1InitializerConfigurationFluentImpl<V1alpha1InitializerConfigurationBuilder> implements VisitableBuilder<V1alpha1InitializerConfiguration,V1alpha1InitializerConfigurationBuilder>{

    V1alpha1InitializerConfigurationFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1InitializerConfigurationBuilder(){
            this(true);
    }
    public V1alpha1InitializerConfigurationBuilder(Boolean validationEnabled){
            this(new V1alpha1InitializerConfiguration(), validationEnabled);
    }
    public V1alpha1InitializerConfigurationBuilder(V1alpha1InitializerConfigurationFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1InitializerConfigurationBuilder(V1alpha1InitializerConfigurationFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1InitializerConfiguration(), validationEnabled);
    }
    public V1alpha1InitializerConfigurationBuilder(V1alpha1InitializerConfigurationFluent<?> fluent,V1alpha1InitializerConfiguration instance){
            this(fluent, instance, true);
    }
    public V1alpha1InitializerConfigurationBuilder(V1alpha1InitializerConfigurationFluent<?> fluent,V1alpha1InitializerConfiguration instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withInitializers(instance.getInitializers());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1InitializerConfigurationBuilder(V1alpha1InitializerConfiguration instance){
            this(instance,true);
    }
    public V1alpha1InitializerConfigurationBuilder(V1alpha1InitializerConfiguration instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withInitializers(instance.getInitializers());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1InitializerConfiguration build(){
            V1alpha1InitializerConfiguration buildable = new V1alpha1InitializerConfiguration();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setInitializers(fluent.getInitializers());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1InitializerConfigurationBuilder that = (V1alpha1InitializerConfigurationBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
