package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1TokenReviewStatusBuilder extends V1TokenReviewStatusFluentImpl<V1TokenReviewStatusBuilder> implements VisitableBuilder<V1TokenReviewStatus,V1TokenReviewStatusBuilder>{

    V1TokenReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1TokenReviewStatusBuilder(){
            this(true);
    }
    public V1TokenReviewStatusBuilder(Boolean validationEnabled){
            this(new V1TokenReviewStatus(), validationEnabled);
    }
    public V1TokenReviewStatusBuilder(V1TokenReviewStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1TokenReviewStatusBuilder(V1TokenReviewStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1TokenReviewStatus(), validationEnabled);
    }
    public V1TokenReviewStatusBuilder(V1TokenReviewStatusFluent<?> fluent,V1TokenReviewStatus instance){
            this(fluent, instance, true);
    }
    public V1TokenReviewStatusBuilder(V1TokenReviewStatusFluent<?> fluent,V1TokenReviewStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuthenticated(instance.isAuthenticated());

            fluent.withError(instance.getError());

            fluent.withUser(instance.getUser());

            this.validationEnabled = validationEnabled; 
    }
    public V1TokenReviewStatusBuilder(V1TokenReviewStatus instance){
            this(instance,true);
    }
    public V1TokenReviewStatusBuilder(V1TokenReviewStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuthenticated(instance.isAuthenticated());

            this.withError(instance.getError());

            this.withUser(instance.getUser());

            this.validationEnabled = validationEnabled; 
    }

    public V1TokenReviewStatus build(){
            V1TokenReviewStatus buildable = new V1TokenReviewStatus();
            buildable.setAuthenticated(fluent.isAuthenticated());
            buildable.setError(fluent.getError());
            buildable.setUser(fluent.getUser());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1TokenReviewStatusBuilder that = (V1TokenReviewStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
