package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1SecretKeySelectorBuilder extends V1SecretKeySelectorFluentImpl<V1SecretKeySelectorBuilder> implements VisitableBuilder<V1SecretKeySelector,V1SecretKeySelectorBuilder>{

    V1SecretKeySelectorFluent<?> fluent;
    Boolean validationEnabled;

    public V1SecretKeySelectorBuilder(){
            this(true);
    }
    public V1SecretKeySelectorBuilder(Boolean validationEnabled){
            this(new V1SecretKeySelector(), validationEnabled);
    }
    public V1SecretKeySelectorBuilder(V1SecretKeySelectorFluent<?> fluent){
            this(fluent, true);
    }
    public V1SecretKeySelectorBuilder(V1SecretKeySelectorFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1SecretKeySelector(), validationEnabled);
    }
    public V1SecretKeySelectorBuilder(V1SecretKeySelectorFluent<?> fluent,V1SecretKeySelector instance){
            this(fluent, instance, true);
    }
    public V1SecretKeySelectorBuilder(V1SecretKeySelectorFluent<?> fluent,V1SecretKeySelector instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withKey(instance.getKey());

            fluent.withName(instance.getName());

            fluent.withOptional(instance.isOptional());

            this.validationEnabled = validationEnabled; 
    }
    public V1SecretKeySelectorBuilder(V1SecretKeySelector instance){
            this(instance,true);
    }
    public V1SecretKeySelectorBuilder(V1SecretKeySelector instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withKey(instance.getKey());

            this.withName(instance.getName());

            this.withOptional(instance.isOptional());

            this.validationEnabled = validationEnabled; 
    }

    public V1SecretKeySelector build(){
            V1SecretKeySelector buildable = new V1SecretKeySelector();
            buildable.setKey(fluent.getKey());
            buildable.setName(fluent.getName());
            buildable.setOptional(fluent.isOptional());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SecretKeySelectorBuilder that = (V1SecretKeySelectorBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
