package io.kubernetes.client.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1ScaleStatusFluentImpl<A extends V1ScaleStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ScaleStatusFluent<A>{

    private Integer replicas;
    private String selector;

    public V1ScaleStatusFluentImpl(){
    }
    public V1ScaleStatusFluentImpl(V1ScaleStatus instance){
            this.withReplicas(instance.getReplicas());

            this.withSelector(instance.getSelector());

    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas != null;
    }

    public A withNewReplicas(int arg1){
            return (A)withReplicas(new Integer(arg1));
    }

    public A withNewReplicas(String arg1){
            return (A)withReplicas(new Integer(arg1));
    }

    public String getSelector(){
            return this.selector;
    }

    public A withSelector(String selector){
            this.selector=selector; return (A) this;
    }

    public Boolean hasSelector(){
            return this.selector != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ScaleStatusFluentImpl that = (V1ScaleStatusFluentImpl) o;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
            return true;
    }




}
