package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1PersistentVolumeListBuilder extends V1PersistentVolumeListFluentImpl<V1PersistentVolumeListBuilder> implements VisitableBuilder<V1PersistentVolumeList,V1PersistentVolumeListBuilder>{

    V1PersistentVolumeListFluent<?> fluent;
    Boolean validationEnabled;

    public V1PersistentVolumeListBuilder(){
            this(true);
    }
    public V1PersistentVolumeListBuilder(Boolean validationEnabled){
            this(new V1PersistentVolumeList(), validationEnabled);
    }
    public V1PersistentVolumeListBuilder(V1PersistentVolumeListFluent<?> fluent){
            this(fluent, true);
    }
    public V1PersistentVolumeListBuilder(V1PersistentVolumeListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1PersistentVolumeList(), validationEnabled);
    }
    public V1PersistentVolumeListBuilder(V1PersistentVolumeListFluent<?> fluent,V1PersistentVolumeList instance){
            this(fluent, instance, true);
    }
    public V1PersistentVolumeListBuilder(V1PersistentVolumeListFluent<?> fluent,V1PersistentVolumeList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1PersistentVolumeListBuilder(V1PersistentVolumeList instance){
            this(instance,true);
    }
    public V1PersistentVolumeListBuilder(V1PersistentVolumeList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1PersistentVolumeList build(){
            V1PersistentVolumeList buildable = new V1PersistentVolumeList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PersistentVolumeListBuilder that = (V1PersistentVolumeListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
