package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public class V1NodeConditionFluentImpl<A extends V1NodeConditionFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NodeConditionFluent<A>{

    private DateTime lastHeartbeatTime;
    private DateTime lastTransitionTime;
    private String message;
    private String reason;
    private String status;
    private String type;

    public V1NodeConditionFluentImpl(){
    }
    public V1NodeConditionFluentImpl(V1NodeCondition instance){
            this.withLastHeartbeatTime(instance.getLastHeartbeatTime());

            this.withLastTransitionTime(instance.getLastTransitionTime());

            this.withMessage(instance.getMessage());

            this.withReason(instance.getReason());

            this.withStatus(instance.getStatus());

            this.withType(instance.getType());

    }

    public DateTime getLastHeartbeatTime(){
            return this.lastHeartbeatTime;
    }

    public A withLastHeartbeatTime(DateTime lastHeartbeatTime){
            this.lastHeartbeatTime=lastHeartbeatTime; return (A) this;
    }

    public Boolean hasLastHeartbeatTime(){
            return this.lastHeartbeatTime != null;
    }

    public A withNewLastHeartbeatTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastHeartbeatTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastHeartbeatTime(long arg0){
            return (A)withLastHeartbeatTime(new DateTime(arg0));
    }

    public A withNewLastHeartbeatTime(Object arg0){
            return (A)withLastHeartbeatTime(new DateTime(arg0));
    }

    public DateTime getLastTransitionTime(){
            return this.lastTransitionTime;
    }

    public A withLastTransitionTime(DateTime lastTransitionTime){
            this.lastTransitionTime=lastTransitionTime; return (A) this;
    }

    public Boolean hasLastTransitionTime(){
            return this.lastTransitionTime != null;
    }

    public A withNewLastTransitionTime(int arg0,int arg1,int arg2,int arg3,int arg4){
            return (A)withLastTransitionTime(new DateTime(arg0, arg1, arg2, arg3, arg4));
    }

    public A withNewLastTransitionTime(long arg0){
            return (A)withLastTransitionTime(new DateTime(arg0));
    }

    public A withNewLastTransitionTime(Object arg0){
            return (A)withLastTransitionTime(new DateTime(arg0));
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public Boolean hasMessage(){
            return this.message != null;
    }

    public String getReason(){
            return this.reason;
    }

    public A withReason(String reason){
            this.reason=reason; return (A) this;
    }

    public Boolean hasReason(){
            return this.reason != null;
    }

    public String getStatus(){
            return this.status;
    }

    public A withStatus(String status){
            this.status=status; return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NodeConditionFluentImpl that = (V1NodeConditionFluentImpl) o;
            if (lastHeartbeatTime != null ? !lastHeartbeatTime.equals(that.lastHeartbeatTime) :that.lastHeartbeatTime != null) return false;
            if (lastTransitionTime != null ? !lastTransitionTime.equals(that.lastTransitionTime) :that.lastTransitionTime != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }




}
