package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1EndpointPortBuilder extends V1EndpointPortFluentImpl<V1EndpointPortBuilder> implements VisitableBuilder<V1EndpointPort,V1EndpointPortBuilder>{

    V1EndpointPortFluent<?> fluent;
    Boolean validationEnabled;

    public V1EndpointPortBuilder(){
            this(true);
    }
    public V1EndpointPortBuilder(Boolean validationEnabled){
            this(new V1EndpointPort(), validationEnabled);
    }
    public V1EndpointPortBuilder(V1EndpointPortFluent<?> fluent){
            this(fluent, true);
    }
    public V1EndpointPortBuilder(V1EndpointPortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1EndpointPort(), validationEnabled);
    }
    public V1EndpointPortBuilder(V1EndpointPortFluent<?> fluent,V1EndpointPort instance){
            this(fluent, instance, true);
    }
    public V1EndpointPortBuilder(V1EndpointPortFluent<?> fluent,V1EndpointPort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withPort(instance.getPort());

            fluent.withProtocol(instance.getProtocol());

            this.validationEnabled = validationEnabled; 
    }
    public V1EndpointPortBuilder(V1EndpointPort instance){
            this(instance,true);
    }
    public V1EndpointPortBuilder(V1EndpointPort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withPort(instance.getPort());

            this.withProtocol(instance.getProtocol());

            this.validationEnabled = validationEnabled; 
    }

    public V1EndpointPort build(){
            V1EndpointPort buildable = new V1EndpointPort();
            buildable.setName(fluent.getName());
            buildable.setPort(fluent.getPort());
            buildable.setProtocol(fluent.getProtocol());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1EndpointPortBuilder that = (V1EndpointPortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
