package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ContainerStatusBuilder extends V1ContainerStatusFluentImpl<V1ContainerStatusBuilder> implements VisitableBuilder<V1ContainerStatus,V1ContainerStatusBuilder>{

    V1ContainerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1ContainerStatusBuilder(){
            this(true);
    }
    public V1ContainerStatusBuilder(Boolean validationEnabled){
            this(new V1ContainerStatus(), validationEnabled);
    }
    public V1ContainerStatusBuilder(V1ContainerStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1ContainerStatusBuilder(V1ContainerStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ContainerStatus(), validationEnabled);
    }
    public V1ContainerStatusBuilder(V1ContainerStatusFluent<?> fluent,V1ContainerStatus instance){
            this(fluent, instance, true);
    }
    public V1ContainerStatusBuilder(V1ContainerStatusFluent<?> fluent,V1ContainerStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withContainerID(instance.getContainerID());

            fluent.withImage(instance.getImage());

            fluent.withImageID(instance.getImageID());

            fluent.withLastState(instance.getLastState());

            fluent.withName(instance.getName());

            fluent.withReady(instance.isReady());

            fluent.withRestartCount(instance.getRestartCount());

            fluent.withState(instance.getState());

            this.validationEnabled = validationEnabled; 
    }
    public V1ContainerStatusBuilder(V1ContainerStatus instance){
            this(instance,true);
    }
    public V1ContainerStatusBuilder(V1ContainerStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withContainerID(instance.getContainerID());

            this.withImage(instance.getImage());

            this.withImageID(instance.getImageID());

            this.withLastState(instance.getLastState());

            this.withName(instance.getName());

            this.withReady(instance.isReady());

            this.withRestartCount(instance.getRestartCount());

            this.withState(instance.getState());

            this.validationEnabled = validationEnabled; 
    }

    public V1ContainerStatus build(){
            V1ContainerStatus buildable = new V1ContainerStatus();
            buildable.setContainerID(fluent.getContainerID());
            buildable.setImage(fluent.getImage());
            buildable.setImageID(fluent.getImageID());
            buildable.setLastState(fluent.getLastState());
            buildable.setName(fluent.getName());
            buildable.setReady(fluent.isReady());
            buildable.setRestartCount(fluent.getRestartCount());
            buildable.setState(fluent.getState());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ContainerStatusBuilder that = (V1ContainerStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
