package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import java.lang.Byte;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;

public class RuntimeRawExtensionFluentImpl<A extends RuntimeRawExtensionFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements RuntimeRawExtensionFluent<A>{

    private List<Byte> raw;

    public RuntimeRawExtensionFluentImpl(){
    }
    public RuntimeRawExtensionFluentImpl(RuntimeRawExtension instance){
            this.withRaw(instance.getRaw());

    }

    public A withRaw(byte... raw){
            if (this.raw != null) {this.raw.clear();}
            if (raw != null) {for (byte item :raw){ this.addToRaw(item);}} return (A) this;
    }

    public byte[] getRaw(){
            //This needs to work with primitives, so we use arrays.
int size = raw != null ? raw.size() : 0;
byte[] result = new byte[size];
if (size == 0) {
   return result;
}
int index = 0;
for (byte item : raw) {
    result[index++]=item;
}
return result;

    }

    public A addToRaw(int index,Byte item){
            if (this.raw == null) {this.raw = null;}
            this.raw.add(index, item);
            return (A)this;
    }

    public A setToRaw(int index,Byte item){
            if (this.raw == null) {this.raw = null;}
            this.raw.set(index, item); return (A)this;
    }

    public A addToRaw(Byte... items){
            if (this.raw == null) {this.raw = null;}
            for (Byte item : items) {this.raw.add(item);} return (A)this;
    }

    public A addAllToRaw(Collection<Byte> items){
            if (this.raw == null) {this.raw = null;}
            for (Byte item : items) {this.raw.add(item);} return (A)this;
    }

    public A removeFromRaw(Byte... items){
            for (Byte item : items) {if (this.raw!= null){ this.raw.remove(item);}} return (A)this;
    }

    public A removeAllFromRaw(Collection<Byte> items){
            for (Byte item : items) {if (this.raw!= null){ this.raw.remove(item);}} return (A)this;
    }

    public Boolean hasRaw(){
            return raw != null && !raw.isEmpty();
    }

    public A addNewRaw(byte arg1){
            return (A)addToRaw(new Byte(arg1));
    }

    public A addNewRaw(String arg1){
            return (A)addToRaw(new Byte(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RuntimeRawExtensionFluentImpl that = (RuntimeRawExtensionFluentImpl) o;
            if (raw != null ? !raw.equals(that.raw) :that.raw != null) return false;
            return true;
    }




}
