package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

public class V2alpha1CronJobFluentImpl<A extends V2alpha1CronJobFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V2alpha1CronJobFluent<A>{

    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V2alpha1CronJobSpecBuilder spec;
    private V2alpha1CronJobStatusBuilder status;

    public V2alpha1CronJobFluentImpl(){
    }
    public V2alpha1CronJobFluentImpl(V2alpha1CronJob instance){
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V2alpha1CronJobFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V2alpha1CronJobFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V2alpha1CronJobFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V2alpha1CronJobFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V2alpha1CronJobFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSpec instead.
 * @return The buildable object.
 */
@Deprecated public V2alpha1CronJobSpec getSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public V2alpha1CronJobSpec buildSpec(){
            return this.spec!=null?this.spec.build():null;
    }

    public A withSpec(V2alpha1CronJobSpec spec){
            _visitables.remove(this.spec);
            if (spec!=null){ this.spec= new V2alpha1CronJobSpecBuilder(spec); _visitables.add(this.spec);} return (A) this;
    }

    public Boolean hasSpec(){
            return this.spec != null;
    }

    public V2alpha1CronJobFluent.SpecNested<A> withNewSpec(){
            return new SpecNestedImpl();
    }

    public V2alpha1CronJobFluent.SpecNested<A> withNewSpecLike(V2alpha1CronJobSpec item){
            return new SpecNestedImpl(item);
    }

    public V2alpha1CronJobFluent.SpecNested<A> editSpec(){
            return withNewSpecLike(getSpec());
    }

    public V2alpha1CronJobFluent.SpecNested<A> editOrNewSpec(){
            return withNewSpecLike(getSpec() != null ? getSpec(): new V2alpha1CronJobSpecBuilder().build());
    }

    public V2alpha1CronJobFluent.SpecNested<A> editOrNewSpecLike(V2alpha1CronJobSpec item){
            return withNewSpecLike(getSpec() != null ? getSpec(): item);
    }

    
/**
 * This method has been deprecated, please use method buildStatus instead.
 * @return The buildable object.
 */
@Deprecated public V2alpha1CronJobStatus getStatus(){
            return this.status!=null?this.status.build():null;
    }

    public V2alpha1CronJobStatus buildStatus(){
            return this.status!=null?this.status.build():null;
    }

    public A withStatus(V2alpha1CronJobStatus status){
            _visitables.remove(this.status);
            if (status!=null){ this.status= new V2alpha1CronJobStatusBuilder(status); _visitables.add(this.status);} return (A) this;
    }

    public Boolean hasStatus(){
            return this.status != null;
    }

    public V2alpha1CronJobFluent.StatusNested<A> withNewStatus(){
            return new StatusNestedImpl();
    }

    public V2alpha1CronJobFluent.StatusNested<A> withNewStatusLike(V2alpha1CronJobStatus item){
            return new StatusNestedImpl(item);
    }

    public V2alpha1CronJobFluent.StatusNested<A> editStatus(){
            return withNewStatusLike(getStatus());
    }

    public V2alpha1CronJobFluent.StatusNested<A> editOrNewStatus(){
            return withNewStatusLike(getStatus() != null ? getStatus(): new V2alpha1CronJobStatusBuilder().build());
    }

    public V2alpha1CronJobFluent.StatusNested<A> editOrNewStatusLike(V2alpha1CronJobStatus item){
            return withNewStatusLike(getStatus() != null ? getStatus(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2alpha1CronJobFluentImpl that = (V2alpha1CronJobFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
            if (status != null ? !status.equals(that.status) :that.status != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V2alpha1CronJobFluent.MetadataNested<N>> implements V2alpha1CronJobFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V2alpha1CronJobFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class SpecNestedImpl<N> extends V2alpha1CronJobSpecFluentImpl<V2alpha1CronJobFluent.SpecNested<N>> implements V2alpha1CronJobFluent.SpecNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2alpha1CronJobSpecBuilder builder;
    
            SpecNestedImpl(V2alpha1CronJobSpec item){
                    this.builder = new V2alpha1CronJobSpecBuilder(this, item);
            }
            SpecNestedImpl(){
                    this.builder = new V2alpha1CronJobSpecBuilder(this);
            }
    
    public N and(){
            return (N) V2alpha1CronJobFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec(){
            return and();
    }

}
    public class StatusNestedImpl<N> extends V2alpha1CronJobStatusFluentImpl<V2alpha1CronJobFluent.StatusNested<N>> implements V2alpha1CronJobFluent.StatusNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V2alpha1CronJobStatusBuilder builder;
    
            StatusNestedImpl(V2alpha1CronJobStatus item){
                    this.builder = new V2alpha1CronJobStatusBuilder(this, item);
            }
            StatusNestedImpl(){
                    this.builder = new V2alpha1CronJobStatusBuilder(this);
            }
    
    public N and(){
            return (N) V2alpha1CronJobFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus(){
            return and();
    }

}


}
