package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1NetworkPolicyPortBuilder extends V1beta1NetworkPolicyPortFluentImpl<V1beta1NetworkPolicyPortBuilder> implements VisitableBuilder<V1beta1NetworkPolicyPort,V1beta1NetworkPolicyPortBuilder>{

    V1beta1NetworkPolicyPortFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1NetworkPolicyPortBuilder(){
            this(true);
    }
    public V1beta1NetworkPolicyPortBuilder(Boolean validationEnabled){
            this(new V1beta1NetworkPolicyPort(), validationEnabled);
    }
    public V1beta1NetworkPolicyPortBuilder(V1beta1NetworkPolicyPortFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1NetworkPolicyPortBuilder(V1beta1NetworkPolicyPortFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1NetworkPolicyPort(), validationEnabled);
    }
    public V1beta1NetworkPolicyPortBuilder(V1beta1NetworkPolicyPortFluent<?> fluent,V1beta1NetworkPolicyPort instance){
            this(fluent, instance, true);
    }
    public V1beta1NetworkPolicyPortBuilder(V1beta1NetworkPolicyPortFluent<?> fluent,V1beta1NetworkPolicyPort instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPort(instance.getPort());

            fluent.withProtocol(instance.getProtocol());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1NetworkPolicyPortBuilder(V1beta1NetworkPolicyPort instance){
            this(instance,true);
    }
    public V1beta1NetworkPolicyPortBuilder(V1beta1NetworkPolicyPort instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPort(instance.getPort());

            this.withProtocol(instance.getProtocol());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1NetworkPolicyPort build(){
            V1beta1NetworkPolicyPort buildable = new V1beta1NetworkPolicyPort();
            buildable.setPort(fluent.getPort());
            buildable.setProtocol(fluent.getProtocol());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1NetworkPolicyPortBuilder that = (V1beta1NetworkPolicyPortBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
