package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServiceStatusFluentImpl<A extends V1ServiceStatusFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ServiceStatusFluent<A>{

    private V1LoadBalancerStatusBuilder loadBalancer;

    public V1ServiceStatusFluentImpl(){
    }
    public V1ServiceStatusFluentImpl(V1ServiceStatus instance){
            this.withLoadBalancer(instance.getLoadBalancer());

    }

    
/**
 * This method has been deprecated, please use method buildLoadBalancer instead.
 * @return The buildable object.
 */
@Deprecated public V1LoadBalancerStatus getLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public V1LoadBalancerStatus buildLoadBalancer(){
            return this.loadBalancer!=null?this.loadBalancer.build():null;
    }

    public A withLoadBalancer(V1LoadBalancerStatus loadBalancer){
            _visitables.remove(this.loadBalancer);
            if (loadBalancer!=null){ this.loadBalancer= new V1LoadBalancerStatusBuilder(loadBalancer); _visitables.add(this.loadBalancer);} return (A) this;
    }

    public Boolean hasLoadBalancer(){
            return this.loadBalancer != null;
    }

    public V1ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancer(){
            return new LoadBalancerNestedImpl();
    }

    public V1ServiceStatusFluent.LoadBalancerNested<A> withNewLoadBalancerLike(V1LoadBalancerStatus item){
            return new LoadBalancerNestedImpl(item);
    }

    public V1ServiceStatusFluent.LoadBalancerNested<A> editLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer());
    }

    public V1ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancer(){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new V1LoadBalancerStatusBuilder().build());
    }

    public V1ServiceStatusFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(V1LoadBalancerStatus item){
            return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ServiceStatusFluentImpl that = (V1ServiceStatusFluentImpl) o;
            if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
            return true;
    }


    public class LoadBalancerNestedImpl<N> extends V1LoadBalancerStatusFluentImpl<V1ServiceStatusFluent.LoadBalancerNested<N>> implements V1ServiceStatusFluent.LoadBalancerNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LoadBalancerStatusBuilder builder;
    
            LoadBalancerNestedImpl(V1LoadBalancerStatus item){
                    this.builder = new V1LoadBalancerStatusBuilder(this, item);
            }
            LoadBalancerNestedImpl(){
                    this.builder = new V1LoadBalancerStatusBuilder(this);
            }
    
    public N and(){
            return (N) V1ServiceStatusFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer(){
            return and();
    }

}


}
