package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class V1SecurityContextFluentImpl<A extends V1SecurityContextFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1SecurityContextFluent<A>{

    private Boolean allowPrivilegeEscalation;
    private V1CapabilitiesBuilder capabilities;
    private Boolean privileged;
    private Boolean readOnlyRootFilesystem;
    private Long runAsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private V1SELinuxOptionsBuilder seLinuxOptions;

    public V1SecurityContextFluentImpl(){
    }
    public V1SecurityContextFluentImpl(V1SecurityContext instance){
            this.withAllowPrivilegeEscalation(instance.isAllowPrivilegeEscalation());

            this.withCapabilities(instance.getCapabilities());

            this.withPrivileged(instance.isPrivileged());

            this.withReadOnlyRootFilesystem(instance.isReadOnlyRootFilesystem());

            this.withRunAsGroup(instance.getRunAsGroup());

            this.withRunAsNonRoot(instance.isRunAsNonRoot());

            this.withRunAsUser(instance.getRunAsUser());

            this.withSeLinuxOptions(instance.getSeLinuxOptions());

    }

    public Boolean isAllowPrivilegeEscalation(){
            return this.allowPrivilegeEscalation;
    }

    public A withAllowPrivilegeEscalation(Boolean allowPrivilegeEscalation){
            this.allowPrivilegeEscalation=allowPrivilegeEscalation; return (A) this;
    }

    public Boolean hasAllowPrivilegeEscalation(){
            return this.allowPrivilegeEscalation != null;
    }

    public A withNewAllowPrivilegeEscalation(boolean arg1){
            return (A)withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    public A withNewAllowPrivilegeEscalation(String arg1){
            return (A)withAllowPrivilegeEscalation(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildCapabilities instead.
 * @return The buildable object.
 */
@Deprecated public V1Capabilities getCapabilities(){
            return this.capabilities!=null?this.capabilities.build():null;
    }

    public V1Capabilities buildCapabilities(){
            return this.capabilities!=null?this.capabilities.build():null;
    }

    public A withCapabilities(V1Capabilities capabilities){
            _visitables.remove(this.capabilities);
            if (capabilities!=null){ this.capabilities= new V1CapabilitiesBuilder(capabilities); _visitables.add(this.capabilities);} return (A) this;
    }

    public Boolean hasCapabilities(){
            return this.capabilities != null;
    }

    public V1SecurityContextFluent.CapabilitiesNested<A> withNewCapabilities(){
            return new CapabilitiesNestedImpl();
    }

    public V1SecurityContextFluent.CapabilitiesNested<A> withNewCapabilitiesLike(V1Capabilities item){
            return new CapabilitiesNestedImpl(item);
    }

    public V1SecurityContextFluent.CapabilitiesNested<A> editCapabilities(){
            return withNewCapabilitiesLike(getCapabilities());
    }

    public V1SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilities(){
            return withNewCapabilitiesLike(getCapabilities() != null ? getCapabilities(): new V1CapabilitiesBuilder().build());
    }

    public V1SecurityContextFluent.CapabilitiesNested<A> editOrNewCapabilitiesLike(V1Capabilities item){
            return withNewCapabilitiesLike(getCapabilities() != null ? getCapabilities(): item);
    }

    public Boolean isPrivileged(){
            return this.privileged;
    }

    public A withPrivileged(Boolean privileged){
            this.privileged=privileged; return (A) this;
    }

    public Boolean hasPrivileged(){
            return this.privileged != null;
    }

    public A withNewPrivileged(boolean arg1){
            return (A)withPrivileged(new Boolean(arg1));
    }

    public A withNewPrivileged(String arg1){
            return (A)withPrivileged(new Boolean(arg1));
    }

    public Boolean isReadOnlyRootFilesystem(){
            return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem){
            this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
    }

    public Boolean hasReadOnlyRootFilesystem(){
            return this.readOnlyRootFilesystem != null;
    }

    public A withNewReadOnlyRootFilesystem(boolean arg1){
            return (A)withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    public A withNewReadOnlyRootFilesystem(String arg1){
            return (A)withReadOnlyRootFilesystem(new Boolean(arg1));
    }

    public Long getRunAsGroup(){
            return this.runAsGroup;
    }

    public A withRunAsGroup(Long runAsGroup){
            this.runAsGroup=runAsGroup; return (A) this;
    }

    public Boolean hasRunAsGroup(){
            return this.runAsGroup != null;
    }

    public A withNewRunAsGroup(String arg1){
            return (A)withRunAsGroup(new Long(arg1));
    }

    public A withNewRunAsGroup(long arg1){
            return (A)withRunAsGroup(new Long(arg1));
    }

    public Boolean isRunAsNonRoot(){
            return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot){
            this.runAsNonRoot=runAsNonRoot; return (A) this;
    }

    public Boolean hasRunAsNonRoot(){
            return this.runAsNonRoot != null;
    }

    public A withNewRunAsNonRoot(boolean arg1){
            return (A)withRunAsNonRoot(new Boolean(arg1));
    }

    public A withNewRunAsNonRoot(String arg1){
            return (A)withRunAsNonRoot(new Boolean(arg1));
    }

    public Long getRunAsUser(){
            return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser){
            this.runAsUser=runAsUser; return (A) this;
    }

    public Boolean hasRunAsUser(){
            return this.runAsUser != null;
    }

    public A withNewRunAsUser(String arg1){
            return (A)withRunAsUser(new Long(arg1));
    }

    public A withNewRunAsUser(long arg1){
            return (A)withRunAsUser(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSeLinuxOptions instead.
 * @return The buildable object.
 */
@Deprecated public V1SELinuxOptions getSeLinuxOptions(){
            return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public V1SELinuxOptions buildSeLinuxOptions(){
            return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public A withSeLinuxOptions(V1SELinuxOptions seLinuxOptions){
            _visitables.remove(this.seLinuxOptions);
            if (seLinuxOptions!=null){ this.seLinuxOptions= new V1SELinuxOptionsBuilder(seLinuxOptions); _visitables.add(this.seLinuxOptions);} return (A) this;
    }

    public Boolean hasSeLinuxOptions(){
            return this.seLinuxOptions != null;
    }

    public V1SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions(){
            return new SeLinuxOptionsNestedImpl();
    }

    public V1SecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(V1SELinuxOptions item){
            return new SeLinuxOptionsNestedImpl(item);
    }

    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }

    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): new V1SELinuxOptionsBuilder().build());
    }

    public V1SecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(V1SELinuxOptions item){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1SecurityContextFluentImpl that = (V1SecurityContextFluentImpl) o;
            if (allowPrivilegeEscalation != null ? !allowPrivilegeEscalation.equals(that.allowPrivilegeEscalation) :that.allowPrivilegeEscalation != null) return false;
            if (capabilities != null ? !capabilities.equals(that.capabilities) :that.capabilities != null) return false;
            if (privileged != null ? !privileged.equals(that.privileged) :that.privileged != null) return false;
            if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
            if (runAsGroup != null ? !runAsGroup.equals(that.runAsGroup) :that.runAsGroup != null) return false;
            if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
            if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
            if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
            return true;
    }


    public class CapabilitiesNestedImpl<N> extends V1CapabilitiesFluentImpl<V1SecurityContextFluent.CapabilitiesNested<N>> implements V1SecurityContextFluent.CapabilitiesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1CapabilitiesBuilder builder;
    
            CapabilitiesNestedImpl(V1Capabilities item){
                    this.builder = new V1CapabilitiesBuilder(this, item);
            }
            CapabilitiesNestedImpl(){
                    this.builder = new V1CapabilitiesBuilder(this);
            }
    
    public N and(){
            return (N) V1SecurityContextFluentImpl.this.withCapabilities(builder.build());
    }
    public N endCapabilities(){
            return and();
    }

}
    public class SeLinuxOptionsNestedImpl<N> extends V1SELinuxOptionsFluentImpl<V1SecurityContextFluent.SeLinuxOptionsNested<N>> implements V1SecurityContextFluent.SeLinuxOptionsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1SELinuxOptionsBuilder builder;
    
            SeLinuxOptionsNestedImpl(V1SELinuxOptions item){
                    this.builder = new V1SELinuxOptionsBuilder(this, item);
            }
            SeLinuxOptionsNestedImpl(){
                    this.builder = new V1SELinuxOptionsBuilder(this);
            }
    
    public N and(){
            return (N) V1SecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
    }
    public N endSeLinuxOptions(){
            return and();
    }

}


}
