package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1ScaleIOVolumeSourceFluentImpl<A extends V1ScaleIOVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1ScaleIOVolumeSourceFluent<A>{

    private String fsType;
    private String gateway;
    private String protectionDomain;
    private Boolean readOnly;
    private V1LocalObjectReferenceBuilder secretRef;
    private Boolean sslEnabled;
    private String storageMode;
    private String storagePool;
    private String system;
    private String volumeName;

    public V1ScaleIOVolumeSourceFluentImpl(){
    }
    public V1ScaleIOVolumeSourceFluentImpl(V1ScaleIOVolumeSource instance){
            this.withFsType(instance.getFsType());

            this.withGateway(instance.getGateway());

            this.withProtectionDomain(instance.getProtectionDomain());

            this.withReadOnly(instance.isReadOnly());

            this.withSecretRef(instance.getSecretRef());

            this.withSslEnabled(instance.isSslEnabled());

            this.withStorageMode(instance.getStorageMode());

            this.withStoragePool(instance.getStoragePool());

            this.withSystem(instance.getSystem());

            this.withVolumeName(instance.getVolumeName());

    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType(){
            return this.fsType != null;
    }

    public String getGateway(){
            return this.gateway;
    }

    public A withGateway(String gateway){
            this.gateway=gateway; return (A) this;
    }

    public Boolean hasGateway(){
            return this.gateway != null;
    }

    public String getProtectionDomain(){
            return this.protectionDomain;
    }

    public A withProtectionDomain(String protectionDomain){
            this.protectionDomain=protectionDomain; return (A) this;
    }

    public Boolean hasProtectionDomain(){
            return this.protectionDomain != null;
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSecretRef instead.
 * @return The buildable object.
 */
@Deprecated public V1LocalObjectReference getSecretRef(){
            return this.secretRef!=null?this.secretRef.build():null;
    }

    public V1LocalObjectReference buildSecretRef(){
            return this.secretRef!=null?this.secretRef.build():null;
    }

    public A withSecretRef(V1LocalObjectReference secretRef){
            _visitables.remove(this.secretRef);
            if (secretRef!=null){ this.secretRef= new V1LocalObjectReferenceBuilder(secretRef); _visitables.add(this.secretRef);} return (A) this;
    }

    public Boolean hasSecretRef(){
            return this.secretRef != null;
    }

    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRef(){
            return new SecretRefNestedImpl();
    }

    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> withNewSecretRefLike(V1LocalObjectReference item){
            return new SecretRefNestedImpl(item);
    }

    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> editSecretRef(){
            return withNewSecretRefLike(getSecretRef());
    }

    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRef(){
            return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new V1LocalObjectReferenceBuilder().build());
    }

    public V1ScaleIOVolumeSourceFluent.SecretRefNested<A> editOrNewSecretRefLike(V1LocalObjectReference item){
            return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
    }

    public Boolean isSslEnabled(){
            return this.sslEnabled;
    }

    public A withSslEnabled(Boolean sslEnabled){
            this.sslEnabled=sslEnabled; return (A) this;
    }

    public Boolean hasSslEnabled(){
            return this.sslEnabled != null;
    }

    public A withNewSslEnabled(boolean arg1){
            return (A)withSslEnabled(new Boolean(arg1));
    }

    public A withNewSslEnabled(String arg1){
            return (A)withSslEnabled(new Boolean(arg1));
    }

    public String getStorageMode(){
            return this.storageMode;
    }

    public A withStorageMode(String storageMode){
            this.storageMode=storageMode; return (A) this;
    }

    public Boolean hasStorageMode(){
            return this.storageMode != null;
    }

    public String getStoragePool(){
            return this.storagePool;
    }

    public A withStoragePool(String storagePool){
            this.storagePool=storagePool; return (A) this;
    }

    public Boolean hasStoragePool(){
            return this.storagePool != null;
    }

    public String getSystem(){
            return this.system;
    }

    public A withSystem(String system){
            this.system=system; return (A) this;
    }

    public Boolean hasSystem(){
            return this.system != null;
    }

    public String getVolumeName(){
            return this.volumeName;
    }

    public A withVolumeName(String volumeName){
            this.volumeName=volumeName; return (A) this;
    }

    public Boolean hasVolumeName(){
            return this.volumeName != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ScaleIOVolumeSourceFluentImpl that = (V1ScaleIOVolumeSourceFluentImpl) o;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (gateway != null ? !gateway.equals(that.gateway) :that.gateway != null) return false;
            if (protectionDomain != null ? !protectionDomain.equals(that.protectionDomain) :that.protectionDomain != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
            if (sslEnabled != null ? !sslEnabled.equals(that.sslEnabled) :that.sslEnabled != null) return false;
            if (storageMode != null ? !storageMode.equals(that.storageMode) :that.storageMode != null) return false;
            if (storagePool != null ? !storagePool.equals(that.storagePool) :that.storagePool != null) return false;
            if (system != null ? !system.equals(that.system) :that.system != null) return false;
            if (volumeName != null ? !volumeName.equals(that.volumeName) :that.volumeName != null) return false;
            return true;
    }


    public class SecretRefNestedImpl<N> extends V1LocalObjectReferenceFluentImpl<V1ScaleIOVolumeSourceFluent.SecretRefNested<N>> implements V1ScaleIOVolumeSourceFluent.SecretRefNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LocalObjectReferenceBuilder builder;
    
            SecretRefNestedImpl(V1LocalObjectReference item){
                    this.builder = new V1LocalObjectReferenceBuilder(this, item);
            }
            SecretRefNestedImpl(){
                    this.builder = new V1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1ScaleIOVolumeSourceFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef(){
            return and();
    }

}


}
