package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.util.LinkedHashMap;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import io.kubernetes.client.fluent.Nested;
import java.lang.Deprecated;
import java.lang.Integer;

public class V1PodSpecFluentImpl<A extends V1PodSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1PodSpecFluent<A>{

    private Long activeDeadlineSeconds;
    private V1AffinityBuilder affinity;
    private Boolean automountServiceAccountToken;
    private List<V1ContainerBuilder> containers;
    private V1PodDNSConfigBuilder dnsConfig;
    private String dnsPolicy;
    private List<V1HostAliasBuilder> hostAliases;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private String hostname;
    private List<V1LocalObjectReferenceBuilder> imagePullSecrets;
    private List<V1ContainerBuilder> initContainers;
    private String nodeName;
    private Map<String,String> nodeSelector;
    private Integer priority;
    private String priorityClassName;
    private List<V1PodReadinessGateBuilder> readinessGates;
    private String restartPolicy;
    private String schedulerName;
    private V1PodSecurityContextBuilder securityContext;
    private String serviceAccount;
    private String serviceAccountName;
    private Boolean shareProcessNamespace;
    private String subdomain;
    private Long terminationGracePeriodSeconds;
    private List<V1TolerationBuilder> tolerations;
    private List<V1VolumeBuilder> volumes;

    public V1PodSpecFluentImpl(){
    }
    public V1PodSpecFluentImpl(V1PodSpec instance){
            this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());

            this.withAffinity(instance.getAffinity());

            this.withAutomountServiceAccountToken(instance.isAutomountServiceAccountToken());

            this.withContainers(instance.getContainers());

            this.withDnsConfig(instance.getDnsConfig());

            this.withDnsPolicy(instance.getDnsPolicy());

            this.withHostAliases(instance.getHostAliases());

            this.withHostIPC(instance.isHostIPC());

            this.withHostNetwork(instance.isHostNetwork());

            this.withHostPID(instance.isHostPID());

            this.withHostname(instance.getHostname());

            this.withImagePullSecrets(instance.getImagePullSecrets());

            this.withInitContainers(instance.getInitContainers());

            this.withNodeName(instance.getNodeName());

            this.withNodeSelector(instance.getNodeSelector());

            this.withPriority(instance.getPriority());

            this.withPriorityClassName(instance.getPriorityClassName());

            this.withReadinessGates(instance.getReadinessGates());

            this.withRestartPolicy(instance.getRestartPolicy());

            this.withSchedulerName(instance.getSchedulerName());

            this.withSecurityContext(instance.getSecurityContext());

            this.withServiceAccount(instance.getServiceAccount());

            this.withServiceAccountName(instance.getServiceAccountName());

            this.withShareProcessNamespace(instance.isShareProcessNamespace());

            this.withSubdomain(instance.getSubdomain());

            this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());

            this.withTolerations(instance.getTolerations());

            this.withVolumes(instance.getVolumes());

    }

    public Long getActiveDeadlineSeconds(){
            return this.activeDeadlineSeconds;
    }

    public A withActiveDeadlineSeconds(Long activeDeadlineSeconds){
            this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
    }

    public Boolean hasActiveDeadlineSeconds(){
            return this.activeDeadlineSeconds != null;
    }

    public A withNewActiveDeadlineSeconds(String arg1){
            return (A)withActiveDeadlineSeconds(new Long(arg1));
    }

    public A withNewActiveDeadlineSeconds(long arg1){
            return (A)withActiveDeadlineSeconds(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildAffinity instead.
 * @return The buildable object.
 */
@Deprecated public V1Affinity getAffinity(){
            return this.affinity!=null?this.affinity.build():null;
    }

    public V1Affinity buildAffinity(){
            return this.affinity!=null?this.affinity.build():null;
    }

    public A withAffinity(V1Affinity affinity){
            _visitables.remove(this.affinity);
            if (affinity!=null){ this.affinity= new V1AffinityBuilder(affinity); _visitables.add(this.affinity);} return (A) this;
    }

    public Boolean hasAffinity(){
            return this.affinity != null;
    }

    public V1PodSpecFluent.AffinityNested<A> withNewAffinity(){
            return new AffinityNestedImpl();
    }

    public V1PodSpecFluent.AffinityNested<A> withNewAffinityLike(V1Affinity item){
            return new AffinityNestedImpl(item);
    }

    public V1PodSpecFluent.AffinityNested<A> editAffinity(){
            return withNewAffinityLike(getAffinity());
    }

    public V1PodSpecFluent.AffinityNested<A> editOrNewAffinity(){
            return withNewAffinityLike(getAffinity() != null ? getAffinity(): new V1AffinityBuilder().build());
    }

    public V1PodSpecFluent.AffinityNested<A> editOrNewAffinityLike(V1Affinity item){
            return withNewAffinityLike(getAffinity() != null ? getAffinity(): item);
    }

    public Boolean isAutomountServiceAccountToken(){
            return this.automountServiceAccountToken;
    }

    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken){
            this.automountServiceAccountToken=automountServiceAccountToken; return (A) this;
    }

    public Boolean hasAutomountServiceAccountToken(){
            return this.automountServiceAccountToken != null;
    }

    public A withNewAutomountServiceAccountToken(boolean arg1){
            return (A)withAutomountServiceAccountToken(new Boolean(arg1));
    }

    public A withNewAutomountServiceAccountToken(String arg1){
            return (A)withAutomountServiceAccountToken(new Boolean(arg1));
    }

    public A addToContainers(int index,V1Container item){
            if (this.containers == null) {this.containers = new ArrayList<V1ContainerBuilder>();}
            V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.containers.add(index >= 0 ? index : containers.size(), builder); return (A)this;
    }

    public A setToContainers(int index,V1Container item){
            if (this.containers == null) {this.containers = new ArrayList<V1ContainerBuilder>();}
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= containers.size()) { containers.add(builder); } else { containers.set(index, builder);}
             return (A)this;
    }

    public A addToContainers(V1Container... items){
            if (this.containers == null) {this.containers = new ArrayList<V1ContainerBuilder>();}
            for (V1Container item : items) {V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.add(builder);this.containers.add(builder);} return (A)this;
    }

    public A addAllToContainers(Collection<V1Container> items){
            if (this.containers == null) {this.containers = new ArrayList<V1ContainerBuilder>();}
            for (V1Container item : items) {V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.add(builder);this.containers.add(builder);} return (A)this;
    }

    public A removeFromContainers(V1Container... items){
            for (V1Container item : items) {V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    public A removeAllFromContainers(Collection<V1Container> items){
            for (V1Container item : items) {V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.remove(builder);if (this.containers != null) {this.containers.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Container> getContainers(){
            return build(containers);
    }

    public List<V1Container> buildContainers(){
            return build(containers);
    }

    public V1Container buildContainer(int index){
            return this.containers.get(index).build();
    }

    public V1Container buildFirstContainer(){
            return this.containers.get(0).build();
    }

    public V1Container buildLastContainer(){
            return this.containers.get(containers.size() - 1).build();
    }

    public V1Container buildMatchingContainer(io.kubernetes.client.fluent.Predicate<V1ContainerBuilder> predicate){
            for (V1ContainerBuilder item: containers) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withContainers(List<V1Container> containers){
            if (this.containers != null) { _visitables.removeAll(this.containers);}
            if (containers != null) {this.containers = new ArrayList<V1ContainerBuilder>(); for (V1Container item : containers){this.addToContainers(item);}} else { this.containers = null;} return (A) this;
    }

    public A withContainers(V1Container... containers){
            if (this.containers != null) {this.containers.clear();}
            if (containers != null) {for (V1Container item :containers){ this.addToContainers(item);}} return (A) this;
    }

    public Boolean hasContainers(){
            return containers != null && !containers.isEmpty();
    }

    public V1PodSpecFluent.ContainersNested<A> addNewContainer(){
            return new ContainersNestedImpl();
    }

    public V1PodSpecFluent.ContainersNested<A> addNewContainerLike(V1Container item){
            return new ContainersNestedImpl(-1, item);
    }

    public V1PodSpecFluent.ContainersNested<A> setNewContainerLike(int index,V1Container item){
            return new ContainersNestedImpl(index, item);
    }

    public V1PodSpecFluent.ContainersNested<A> editContainer(int index){
            if (containers.size() <= index) throw new RuntimeException("Can't edit containers. Index exceeds size.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public V1PodSpecFluent.ContainersNested<A> editFirstContainer(){
            if (containers.size() == 0) throw new RuntimeException("Can't edit first containers. The list is empty.");
            return setNewContainerLike(0, buildContainer(0));
    }

    public V1PodSpecFluent.ContainersNested<A> editLastContainer(){
            int index = containers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last containers. The list is empty.");
            return setNewContainerLike(index, buildContainer(index));
    }

    public V1PodSpecFluent.ContainersNested<A> editMatchingContainer(io.kubernetes.client.fluent.Predicate<V1ContainerBuilder> predicate){
            int index = -1;
            for (int i=0;i<containers.size();i++) { 
            if (predicate.apply(containers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching containers. No match found.");
            return setNewContainerLike(index, buildContainer(index));
    }

    
/**
 * This method has been deprecated, please use method buildDnsConfig instead.
 * @return The buildable object.
 */
@Deprecated public V1PodDNSConfig getDnsConfig(){
            return this.dnsConfig!=null?this.dnsConfig.build():null;
    }

    public V1PodDNSConfig buildDnsConfig(){
            return this.dnsConfig!=null?this.dnsConfig.build():null;
    }

    public A withDnsConfig(V1PodDNSConfig dnsConfig){
            _visitables.remove(this.dnsConfig);
            if (dnsConfig!=null){ this.dnsConfig= new V1PodDNSConfigBuilder(dnsConfig); _visitables.add(this.dnsConfig);} return (A) this;
    }

    public Boolean hasDnsConfig(){
            return this.dnsConfig != null;
    }

    public V1PodSpecFluent.DnsConfigNested<A> withNewDnsConfig(){
            return new DnsConfigNestedImpl();
    }

    public V1PodSpecFluent.DnsConfigNested<A> withNewDnsConfigLike(V1PodDNSConfig item){
            return new DnsConfigNestedImpl(item);
    }

    public V1PodSpecFluent.DnsConfigNested<A> editDnsConfig(){
            return withNewDnsConfigLike(getDnsConfig());
    }

    public V1PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfig(){
            return withNewDnsConfigLike(getDnsConfig() != null ? getDnsConfig(): new V1PodDNSConfigBuilder().build());
    }

    public V1PodSpecFluent.DnsConfigNested<A> editOrNewDnsConfigLike(V1PodDNSConfig item){
            return withNewDnsConfigLike(getDnsConfig() != null ? getDnsConfig(): item);
    }

    public String getDnsPolicy(){
            return this.dnsPolicy;
    }

    public A withDnsPolicy(String dnsPolicy){
            this.dnsPolicy=dnsPolicy; return (A) this;
    }

    public Boolean hasDnsPolicy(){
            return this.dnsPolicy != null;
    }

    public A addToHostAliases(int index,V1HostAlias item){
            if (this.hostAliases == null) {this.hostAliases = new ArrayList<V1HostAliasBuilder>();}
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.hostAliases.add(index >= 0 ? index : hostAliases.size(), builder); return (A)this;
    }

    public A setToHostAliases(int index,V1HostAlias item){
            if (this.hostAliases == null) {this.hostAliases = new ArrayList<V1HostAliasBuilder>();}
            V1HostAliasBuilder builder = new V1HostAliasBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= hostAliases.size()) { hostAliases.add(builder); } else { hostAliases.set(index, builder);}
             return (A)this;
    }

    public A addToHostAliases(V1HostAlias... items){
            if (this.hostAliases == null) {this.hostAliases = new ArrayList<V1HostAliasBuilder>();}
            for (V1HostAlias item : items) {V1HostAliasBuilder builder = new V1HostAliasBuilder(item);_visitables.add(builder);this.hostAliases.add(builder);} return (A)this;
    }

    public A addAllToHostAliases(Collection<V1HostAlias> items){
            if (this.hostAliases == null) {this.hostAliases = new ArrayList<V1HostAliasBuilder>();}
            for (V1HostAlias item : items) {V1HostAliasBuilder builder = new V1HostAliasBuilder(item);_visitables.add(builder);this.hostAliases.add(builder);} return (A)this;
    }

    public A removeFromHostAliases(V1HostAlias... items){
            for (V1HostAlias item : items) {V1HostAliasBuilder builder = new V1HostAliasBuilder(item);_visitables.remove(builder);if (this.hostAliases != null) {this.hostAliases.remove(builder);}} return (A)this;
    }

    public A removeAllFromHostAliases(Collection<V1HostAlias> items){
            for (V1HostAlias item : items) {V1HostAliasBuilder builder = new V1HostAliasBuilder(item);_visitables.remove(builder);if (this.hostAliases != null) {this.hostAliases.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHostAliases instead.
 * @return The buildable object.
 */
@Deprecated public List<V1HostAlias> getHostAliases(){
            return build(hostAliases);
    }

    public List<V1HostAlias> buildHostAliases(){
            return build(hostAliases);
    }

    public V1HostAlias buildHostAlias(int index){
            return this.hostAliases.get(index).build();
    }

    public V1HostAlias buildFirstHostAlias(){
            return this.hostAliases.get(0).build();
    }

    public V1HostAlias buildLastHostAlias(){
            return this.hostAliases.get(hostAliases.size() - 1).build();
    }

    public V1HostAlias buildMatchingHostAlias(io.kubernetes.client.fluent.Predicate<V1HostAliasBuilder> predicate){
            for (V1HostAliasBuilder item: hostAliases) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withHostAliases(List<V1HostAlias> hostAliases){
            if (this.hostAliases != null) { _visitables.removeAll(this.hostAliases);}
            if (hostAliases != null) {this.hostAliases = new ArrayList<V1HostAliasBuilder>(); for (V1HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
    }

    public A withHostAliases(V1HostAlias... hostAliases){
            if (this.hostAliases != null) {this.hostAliases.clear();}
            if (hostAliases != null) {for (V1HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
    }

    public Boolean hasHostAliases(){
            return hostAliases != null && !hostAliases.isEmpty();
    }

    public V1PodSpecFluent.HostAliasesNested<A> addNewHostAlias(){
            return new HostAliasesNestedImpl();
    }

    public V1PodSpecFluent.HostAliasesNested<A> addNewHostAliasLike(V1HostAlias item){
            return new HostAliasesNestedImpl(-1, item);
    }

    public V1PodSpecFluent.HostAliasesNested<A> setNewHostAliasLike(int index,V1HostAlias item){
            return new HostAliasesNestedImpl(index, item);
    }

    public V1PodSpecFluent.HostAliasesNested<A> editHostAlias(int index){
            if (hostAliases.size() <= index) throw new RuntimeException("Can't edit hostAliases. Index exceeds size.");
            return setNewHostAliasLike(index, buildHostAlias(index));
    }

    public V1PodSpecFluent.HostAliasesNested<A> editFirstHostAlias(){
            if (hostAliases.size() == 0) throw new RuntimeException("Can't edit first hostAliases. The list is empty.");
            return setNewHostAliasLike(0, buildHostAlias(0));
    }

    public V1PodSpecFluent.HostAliasesNested<A> editLastHostAlias(){
            int index = hostAliases.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last hostAliases. The list is empty.");
            return setNewHostAliasLike(index, buildHostAlias(index));
    }

    public V1PodSpecFluent.HostAliasesNested<A> editMatchingHostAlias(io.kubernetes.client.fluent.Predicate<V1HostAliasBuilder> predicate){
            int index = -1;
            for (int i=0;i<hostAliases.size();i++) { 
            if (predicate.apply(hostAliases.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching hostAliases. No match found.");
            return setNewHostAliasLike(index, buildHostAlias(index));
    }

    public Boolean isHostIPC(){
            return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC){
            this.hostIPC=hostIPC; return (A) this;
    }

    public Boolean hasHostIPC(){
            return this.hostIPC != null;
    }

    public A withNewHostIPC(boolean arg1){
            return (A)withHostIPC(new Boolean(arg1));
    }

    public A withNewHostIPC(String arg1){
            return (A)withHostIPC(new Boolean(arg1));
    }

    public Boolean isHostNetwork(){
            return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork){
            this.hostNetwork=hostNetwork; return (A) this;
    }

    public Boolean hasHostNetwork(){
            return this.hostNetwork != null;
    }

    public A withNewHostNetwork(boolean arg1){
            return (A)withHostNetwork(new Boolean(arg1));
    }

    public A withNewHostNetwork(String arg1){
            return (A)withHostNetwork(new Boolean(arg1));
    }

    public Boolean isHostPID(){
            return this.hostPID;
    }

    public A withHostPID(Boolean hostPID){
            this.hostPID=hostPID; return (A) this;
    }

    public Boolean hasHostPID(){
            return this.hostPID != null;
    }

    public A withNewHostPID(boolean arg1){
            return (A)withHostPID(new Boolean(arg1));
    }

    public A withNewHostPID(String arg1){
            return (A)withHostPID(new Boolean(arg1));
    }

    public String getHostname(){
            return this.hostname;
    }

    public A withHostname(String hostname){
            this.hostname=hostname; return (A) this;
    }

    public Boolean hasHostname(){
            return this.hostname != null;
    }

    public A addToImagePullSecrets(int index,V1LocalObjectReference item){
            if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();}
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.imagePullSecrets.add(index >= 0 ? index : imagePullSecrets.size(), builder); return (A)this;
    }

    public A setToImagePullSecrets(int index,V1LocalObjectReference item){
            if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();}
            V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= imagePullSecrets.size()) { imagePullSecrets.add(builder); } else { imagePullSecrets.set(index, builder);}
             return (A)this;
    }

    public A addToImagePullSecrets(V1LocalObjectReference... items){
            if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();}
            for (V1LocalObjectReference item : items) {V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);_visitables.add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A addAllToImagePullSecrets(Collection<V1LocalObjectReference> items){
            if (this.imagePullSecrets == null) {this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>();}
            for (V1LocalObjectReference item : items) {V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);_visitables.add(builder);this.imagePullSecrets.add(builder);} return (A)this;
    }

    public A removeFromImagePullSecrets(V1LocalObjectReference... items){
            for (V1LocalObjectReference item : items) {V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);_visitables.remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    public A removeAllFromImagePullSecrets(Collection<V1LocalObjectReference> items){
            for (V1LocalObjectReference item : items) {V1LocalObjectReferenceBuilder builder = new V1LocalObjectReferenceBuilder(item);_visitables.remove(builder);if (this.imagePullSecrets != null) {this.imagePullSecrets.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<V1LocalObjectReference> getImagePullSecrets(){
            return build(imagePullSecrets);
    }

    public List<V1LocalObjectReference> buildImagePullSecrets(){
            return build(imagePullSecrets);
    }

    public V1LocalObjectReference buildImagePullSecret(int index){
            return this.imagePullSecrets.get(index).build();
    }

    public V1LocalObjectReference buildFirstImagePullSecret(){
            return this.imagePullSecrets.get(0).build();
    }

    public V1LocalObjectReference buildLastImagePullSecret(){
            return this.imagePullSecrets.get(imagePullSecrets.size() - 1).build();
    }

    public V1LocalObjectReference buildMatchingImagePullSecret(io.kubernetes.client.fluent.Predicate<V1LocalObjectReferenceBuilder> predicate){
            for (V1LocalObjectReferenceBuilder item: imagePullSecrets) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets){
            if (this.imagePullSecrets != null) { _visitables.removeAll(this.imagePullSecrets);}
            if (imagePullSecrets != null) {this.imagePullSecrets = new ArrayList<V1LocalObjectReferenceBuilder>(); for (V1LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
    }

    public A withImagePullSecrets(V1LocalObjectReference... imagePullSecrets){
            if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
            if (imagePullSecrets != null) {for (V1LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public Boolean hasImagePullSecrets(){
            return imagePullSecrets != null && !imagePullSecrets.isEmpty();
    }

    public V1PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecret(){
            return new ImagePullSecretsNestedImpl();
    }

    public V1PodSpecFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(V1LocalObjectReference item){
            return new ImagePullSecretsNestedImpl(-1, item);
    }

    public V1PodSpecFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,V1LocalObjectReference item){
            return new ImagePullSecretsNestedImpl(index, item);
    }

    public V1PodSpecFluent.ImagePullSecretsNested<A> editImagePullSecret(int index){
            if (imagePullSecrets.size() <= index) throw new RuntimeException("Can't edit imagePullSecrets. Index exceeds size.");
            return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public V1PodSpecFluent.ImagePullSecretsNested<A> editFirstImagePullSecret(){
            if (imagePullSecrets.size() == 0) throw new RuntimeException("Can't edit first imagePullSecrets. The list is empty.");
            return setNewImagePullSecretLike(0, buildImagePullSecret(0));
    }

    public V1PodSpecFluent.ImagePullSecretsNested<A> editLastImagePullSecret(){
            int index = imagePullSecrets.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last imagePullSecrets. The list is empty.");
            return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public V1PodSpecFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(io.kubernetes.client.fluent.Predicate<V1LocalObjectReferenceBuilder> predicate){
            int index = -1;
            for (int i=0;i<imagePullSecrets.size();i++) { 
            if (predicate.apply(imagePullSecrets.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching imagePullSecrets. No match found.");
            return setNewImagePullSecretLike(index, buildImagePullSecret(index));
    }

    public A addToInitContainers(int index,V1Container item){
            if (this.initContainers == null) {this.initContainers = new ArrayList<V1ContainerBuilder>();}
            V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.initContainers.add(index >= 0 ? index : initContainers.size(), builder); return (A)this;
    }

    public A setToInitContainers(int index,V1Container item){
            if (this.initContainers == null) {this.initContainers = new ArrayList<V1ContainerBuilder>();}
            V1ContainerBuilder builder = new V1ContainerBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= initContainers.size()) { initContainers.add(builder); } else { initContainers.set(index, builder);}
             return (A)this;
    }

    public A addToInitContainers(V1Container... items){
            if (this.initContainers == null) {this.initContainers = new ArrayList<V1ContainerBuilder>();}
            for (V1Container item : items) {V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A addAllToInitContainers(Collection<V1Container> items){
            if (this.initContainers == null) {this.initContainers = new ArrayList<V1ContainerBuilder>();}
            for (V1Container item : items) {V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.add(builder);this.initContainers.add(builder);} return (A)this;
    }

    public A removeFromInitContainers(V1Container... items){
            for (V1Container item : items) {V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    public A removeAllFromInitContainers(Collection<V1Container> items){
            for (V1Container item : items) {V1ContainerBuilder builder = new V1ContainerBuilder(item);_visitables.remove(builder);if (this.initContainers != null) {this.initContainers.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInitContainers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Container> getInitContainers(){
            return build(initContainers);
    }

    public List<V1Container> buildInitContainers(){
            return build(initContainers);
    }

    public V1Container buildInitContainer(int index){
            return this.initContainers.get(index).build();
    }

    public V1Container buildFirstInitContainer(){
            return this.initContainers.get(0).build();
    }

    public V1Container buildLastInitContainer(){
            return this.initContainers.get(initContainers.size() - 1).build();
    }

    public V1Container buildMatchingInitContainer(io.kubernetes.client.fluent.Predicate<V1ContainerBuilder> predicate){
            for (V1ContainerBuilder item: initContainers) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withInitContainers(List<V1Container> initContainers){
            if (this.initContainers != null) { _visitables.removeAll(this.initContainers);}
            if (initContainers != null) {this.initContainers = new ArrayList<V1ContainerBuilder>(); for (V1Container item : initContainers){this.addToInitContainers(item);}} else { this.initContainers = null;} return (A) this;
    }

    public A withInitContainers(V1Container... initContainers){
            if (this.initContainers != null) {this.initContainers.clear();}
            if (initContainers != null) {for (V1Container item :initContainers){ this.addToInitContainers(item);}} return (A) this;
    }

    public Boolean hasInitContainers(){
            return initContainers != null && !initContainers.isEmpty();
    }

    public V1PodSpecFluent.InitContainersNested<A> addNewInitContainer(){
            return new InitContainersNestedImpl();
    }

    public V1PodSpecFluent.InitContainersNested<A> addNewInitContainerLike(V1Container item){
            return new InitContainersNestedImpl(-1, item);
    }

    public V1PodSpecFluent.InitContainersNested<A> setNewInitContainerLike(int index,V1Container item){
            return new InitContainersNestedImpl(index, item);
    }

    public V1PodSpecFluent.InitContainersNested<A> editInitContainer(int index){
            if (initContainers.size() <= index) throw new RuntimeException("Can't edit initContainers. Index exceeds size.");
            return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public V1PodSpecFluent.InitContainersNested<A> editFirstInitContainer(){
            if (initContainers.size() == 0) throw new RuntimeException("Can't edit first initContainers. The list is empty.");
            return setNewInitContainerLike(0, buildInitContainer(0));
    }

    public V1PodSpecFluent.InitContainersNested<A> editLastInitContainer(){
            int index = initContainers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last initContainers. The list is empty.");
            return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public V1PodSpecFluent.InitContainersNested<A> editMatchingInitContainer(io.kubernetes.client.fluent.Predicate<V1ContainerBuilder> predicate){
            int index = -1;
            for (int i=0;i<initContainers.size();i++) { 
            if (predicate.apply(initContainers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching initContainers. No match found.");
            return setNewInitContainerLike(index, buildInitContainer(index));
    }

    public String getNodeName(){
            return this.nodeName;
    }

    public A withNodeName(String nodeName){
            this.nodeName=nodeName; return (A) this;
    }

    public Boolean hasNodeName(){
            return this.nodeName != null;
    }

    public A addToNodeSelector(String key,String value){
            if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(Map<String,String> map){
            if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
            if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key){
            if(this.nodeSelector == null) { return (A) this; }
            if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(Map<String,String> map){
            if(this.nodeSelector == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public Map<String,String> getNodeSelector(){
            return this.nodeSelector;
    }

    public A withNodeSelector(Map<String,String> nodeSelector){
            if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector(){
            return this.nodeSelector != null;
    }

    public Integer getPriority(){
            return this.priority;
    }

    public A withPriority(Integer priority){
            this.priority=priority; return (A) this;
    }

    public Boolean hasPriority(){
            return this.priority != null;
    }

    public A withNewPriority(int arg1){
            return (A)withPriority(new Integer(arg1));
    }

    public A withNewPriority(String arg1){
            return (A)withPriority(new Integer(arg1));
    }

    public String getPriorityClassName(){
            return this.priorityClassName;
    }

    public A withPriorityClassName(String priorityClassName){
            this.priorityClassName=priorityClassName; return (A) this;
    }

    public Boolean hasPriorityClassName(){
            return this.priorityClassName != null;
    }

    public A addToReadinessGates(int index,V1PodReadinessGate item){
            if (this.readinessGates == null) {this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();}
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.readinessGates.add(index >= 0 ? index : readinessGates.size(), builder); return (A)this;
    }

    public A setToReadinessGates(int index,V1PodReadinessGate item){
            if (this.readinessGates == null) {this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();}
            V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= readinessGates.size()) { readinessGates.add(builder); } else { readinessGates.set(index, builder);}
             return (A)this;
    }

    public A addToReadinessGates(V1PodReadinessGate... items){
            if (this.readinessGates == null) {this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();}
            for (V1PodReadinessGate item : items) {V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);_visitables.add(builder);this.readinessGates.add(builder);} return (A)this;
    }

    public A addAllToReadinessGates(Collection<V1PodReadinessGate> items){
            if (this.readinessGates == null) {this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>();}
            for (V1PodReadinessGate item : items) {V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);_visitables.add(builder);this.readinessGates.add(builder);} return (A)this;
    }

    public A removeFromReadinessGates(V1PodReadinessGate... items){
            for (V1PodReadinessGate item : items) {V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);_visitables.remove(builder);if (this.readinessGates != null) {this.readinessGates.remove(builder);}} return (A)this;
    }

    public A removeAllFromReadinessGates(Collection<V1PodReadinessGate> items){
            for (V1PodReadinessGate item : items) {V1PodReadinessGateBuilder builder = new V1PodReadinessGateBuilder(item);_visitables.remove(builder);if (this.readinessGates != null) {this.readinessGates.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildReadinessGates instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PodReadinessGate> getReadinessGates(){
            return build(readinessGates);
    }

    public List<V1PodReadinessGate> buildReadinessGates(){
            return build(readinessGates);
    }

    public V1PodReadinessGate buildReadinessGate(int index){
            return this.readinessGates.get(index).build();
    }

    public V1PodReadinessGate buildFirstReadinessGate(){
            return this.readinessGates.get(0).build();
    }

    public V1PodReadinessGate buildLastReadinessGate(){
            return this.readinessGates.get(readinessGates.size() - 1).build();
    }

    public V1PodReadinessGate buildMatchingReadinessGate(io.kubernetes.client.fluent.Predicate<V1PodReadinessGateBuilder> predicate){
            for (V1PodReadinessGateBuilder item: readinessGates) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withReadinessGates(List<V1PodReadinessGate> readinessGates){
            if (this.readinessGates != null) { _visitables.removeAll(this.readinessGates);}
            if (readinessGates != null) {this.readinessGates = new ArrayList<V1PodReadinessGateBuilder>(); for (V1PodReadinessGate item : readinessGates){this.addToReadinessGates(item);}} else { this.readinessGates = null;} return (A) this;
    }

    public A withReadinessGates(V1PodReadinessGate... readinessGates){
            if (this.readinessGates != null) {this.readinessGates.clear();}
            if (readinessGates != null) {for (V1PodReadinessGate item :readinessGates){ this.addToReadinessGates(item);}} return (A) this;
    }

    public Boolean hasReadinessGates(){
            return readinessGates != null && !readinessGates.isEmpty();
    }

    public V1PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGate(){
            return new ReadinessGatesNestedImpl();
    }

    public V1PodSpecFluent.ReadinessGatesNested<A> addNewReadinessGateLike(V1PodReadinessGate item){
            return new ReadinessGatesNestedImpl(-1, item);
    }

    public V1PodSpecFluent.ReadinessGatesNested<A> setNewReadinessGateLike(int index,V1PodReadinessGate item){
            return new ReadinessGatesNestedImpl(index, item);
    }

    public V1PodSpecFluent.ReadinessGatesNested<A> editReadinessGate(int index){
            if (readinessGates.size() <= index) throw new RuntimeException("Can't edit readinessGates. Index exceeds size.");
            return setNewReadinessGateLike(index, buildReadinessGate(index));
    }

    public V1PodSpecFluent.ReadinessGatesNested<A> editFirstReadinessGate(){
            if (readinessGates.size() == 0) throw new RuntimeException("Can't edit first readinessGates. The list is empty.");
            return setNewReadinessGateLike(0, buildReadinessGate(0));
    }

    public V1PodSpecFluent.ReadinessGatesNested<A> editLastReadinessGate(){
            int index = readinessGates.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last readinessGates. The list is empty.");
            return setNewReadinessGateLike(index, buildReadinessGate(index));
    }

    public V1PodSpecFluent.ReadinessGatesNested<A> editMatchingReadinessGate(io.kubernetes.client.fluent.Predicate<V1PodReadinessGateBuilder> predicate){
            int index = -1;
            for (int i=0;i<readinessGates.size();i++) { 
            if (predicate.apply(readinessGates.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching readinessGates. No match found.");
            return setNewReadinessGateLike(index, buildReadinessGate(index));
    }

    public String getRestartPolicy(){
            return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy){
            this.restartPolicy=restartPolicy; return (A) this;
    }

    public Boolean hasRestartPolicy(){
            return this.restartPolicy != null;
    }

    public String getSchedulerName(){
            return this.schedulerName;
    }

    public A withSchedulerName(String schedulerName){
            this.schedulerName=schedulerName; return (A) this;
    }

    public Boolean hasSchedulerName(){
            return this.schedulerName != null;
    }

    
/**
 * This method has been deprecated, please use method buildSecurityContext instead.
 * @return The buildable object.
 */
@Deprecated public V1PodSecurityContext getSecurityContext(){
            return this.securityContext!=null?this.securityContext.build():null;
    }

    public V1PodSecurityContext buildSecurityContext(){
            return this.securityContext!=null?this.securityContext.build():null;
    }

    public A withSecurityContext(V1PodSecurityContext securityContext){
            _visitables.remove(this.securityContext);
            if (securityContext!=null){ this.securityContext= new V1PodSecurityContextBuilder(securityContext); _visitables.add(this.securityContext);} return (A) this;
    }

    public Boolean hasSecurityContext(){
            return this.securityContext != null;
    }

    public V1PodSpecFluent.SecurityContextNested<A> withNewSecurityContext(){
            return new SecurityContextNestedImpl();
    }

    public V1PodSpecFluent.SecurityContextNested<A> withNewSecurityContextLike(V1PodSecurityContext item){
            return new SecurityContextNestedImpl(item);
    }

    public V1PodSpecFluent.SecurityContextNested<A> editSecurityContext(){
            return withNewSecurityContextLike(getSecurityContext());
    }

    public V1PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContext(){
            return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): new V1PodSecurityContextBuilder().build());
    }

    public V1PodSpecFluent.SecurityContextNested<A> editOrNewSecurityContextLike(V1PodSecurityContext item){
            return withNewSecurityContextLike(getSecurityContext() != null ? getSecurityContext(): item);
    }

    public String getServiceAccount(){
            return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount){
            this.serviceAccount=serviceAccount; return (A) this;
    }

    public Boolean hasServiceAccount(){
            return this.serviceAccount != null;
    }

    public String getServiceAccountName(){
            return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName){
            this.serviceAccountName=serviceAccountName; return (A) this;
    }

    public Boolean hasServiceAccountName(){
            return this.serviceAccountName != null;
    }

    public Boolean isShareProcessNamespace(){
            return this.shareProcessNamespace;
    }

    public A withShareProcessNamespace(Boolean shareProcessNamespace){
            this.shareProcessNamespace=shareProcessNamespace; return (A) this;
    }

    public Boolean hasShareProcessNamespace(){
            return this.shareProcessNamespace != null;
    }

    public A withNewShareProcessNamespace(boolean arg1){
            return (A)withShareProcessNamespace(new Boolean(arg1));
    }

    public A withNewShareProcessNamespace(String arg1){
            return (A)withShareProcessNamespace(new Boolean(arg1));
    }

    public String getSubdomain(){
            return this.subdomain;
    }

    public A withSubdomain(String subdomain){
            this.subdomain=subdomain; return (A) this;
    }

    public Boolean hasSubdomain(){
            return this.subdomain != null;
    }

    public Long getTerminationGracePeriodSeconds(){
            return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(Long terminationGracePeriodSeconds){
            this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
    }

    public Boolean hasTerminationGracePeriodSeconds(){
            return this.terminationGracePeriodSeconds != null;
    }

    public A withNewTerminationGracePeriodSeconds(String arg1){
            return (A)withTerminationGracePeriodSeconds(new Long(arg1));
    }

    public A withNewTerminationGracePeriodSeconds(long arg1){
            return (A)withTerminationGracePeriodSeconds(new Long(arg1));
    }

    public A addToTolerations(int index,V1Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<V1TolerationBuilder>();}
            V1TolerationBuilder builder = new V1TolerationBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.tolerations.add(index >= 0 ? index : tolerations.size(), builder); return (A)this;
    }

    public A setToTolerations(int index,V1Toleration item){
            if (this.tolerations == null) {this.tolerations = new ArrayList<V1TolerationBuilder>();}
            V1TolerationBuilder builder = new V1TolerationBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= tolerations.size()) { tolerations.add(builder); } else { tolerations.set(index, builder);}
             return (A)this;
    }

    public A addToTolerations(V1Toleration... items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<V1TolerationBuilder>();}
            for (V1Toleration item : items) {V1TolerationBuilder builder = new V1TolerationBuilder(item);_visitables.add(builder);this.tolerations.add(builder);} return (A)this;
    }

    public A addAllToTolerations(Collection<V1Toleration> items){
            if (this.tolerations == null) {this.tolerations = new ArrayList<V1TolerationBuilder>();}
            for (V1Toleration item : items) {V1TolerationBuilder builder = new V1TolerationBuilder(item);_visitables.add(builder);this.tolerations.add(builder);} return (A)this;
    }

    public A removeFromTolerations(V1Toleration... items){
            for (V1Toleration item : items) {V1TolerationBuilder builder = new V1TolerationBuilder(item);_visitables.remove(builder);if (this.tolerations != null) {this.tolerations.remove(builder);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<V1Toleration> items){
            for (V1Toleration item : items) {V1TolerationBuilder builder = new V1TolerationBuilder(item);_visitables.remove(builder);if (this.tolerations != null) {this.tolerations.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildTolerations instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Toleration> getTolerations(){
            return build(tolerations);
    }

    public List<V1Toleration> buildTolerations(){
            return build(tolerations);
    }

    public V1Toleration buildToleration(int index){
            return this.tolerations.get(index).build();
    }

    public V1Toleration buildFirstToleration(){
            return this.tolerations.get(0).build();
    }

    public V1Toleration buildLastToleration(){
            return this.tolerations.get(tolerations.size() - 1).build();
    }

    public V1Toleration buildMatchingToleration(io.kubernetes.client.fluent.Predicate<V1TolerationBuilder> predicate){
            for (V1TolerationBuilder item: tolerations) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withTolerations(List<V1Toleration> tolerations){
            if (this.tolerations != null) { _visitables.removeAll(this.tolerations);}
            if (tolerations != null) {this.tolerations = new ArrayList<V1TolerationBuilder>(); for (V1Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(V1Toleration... tolerations){
            if (this.tolerations != null) {this.tolerations.clear();}
            if (tolerations != null) {for (V1Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations(){
            return tolerations != null && !tolerations.isEmpty();
    }

    public V1PodSpecFluent.TolerationsNested<A> addNewToleration(){
            return new TolerationsNestedImpl();
    }

    public V1PodSpecFluent.TolerationsNested<A> addNewTolerationLike(V1Toleration item){
            return new TolerationsNestedImpl(-1, item);
    }

    public V1PodSpecFluent.TolerationsNested<A> setNewTolerationLike(int index,V1Toleration item){
            return new TolerationsNestedImpl(index, item);
    }

    public V1PodSpecFluent.TolerationsNested<A> editToleration(int index){
            if (tolerations.size() <= index) throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
            return setNewTolerationLike(index, buildToleration(index));
    }

    public V1PodSpecFluent.TolerationsNested<A> editFirstToleration(){
            if (tolerations.size() == 0) throw new RuntimeException("Can't edit first tolerations. The list is empty.");
            return setNewTolerationLike(0, buildToleration(0));
    }

    public V1PodSpecFluent.TolerationsNested<A> editLastToleration(){
            int index = tolerations.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last tolerations. The list is empty.");
            return setNewTolerationLike(index, buildToleration(index));
    }

    public V1PodSpecFluent.TolerationsNested<A> editMatchingToleration(io.kubernetes.client.fluent.Predicate<V1TolerationBuilder> predicate){
            int index = -1;
            for (int i=0;i<tolerations.size();i++) { 
            if (predicate.apply(tolerations.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching tolerations. No match found.");
            return setNewTolerationLike(index, buildToleration(index));
    }

    public A addToVolumes(int index,V1Volume item){
            if (this.volumes == null) {this.volumes = new ArrayList<V1VolumeBuilder>();}
            V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,V1Volume item){
            if (this.volumes == null) {this.volumes = new ArrayList<V1VolumeBuilder>();}
            V1VolumeBuilder builder = new V1VolumeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
             return (A)this;
    }

    public A addToVolumes(V1Volume... items){
            if (this.volumes == null) {this.volumes = new ArrayList<V1VolumeBuilder>();}
            for (V1Volume item : items) {V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<V1Volume> items){
            if (this.volumes == null) {this.volumes = new ArrayList<V1VolumeBuilder>();}
            for (V1Volume item : items) {V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(V1Volume... items){
            for (V1Volume item : items) {V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<V1Volume> items){
            for (V1Volume item : items) {V1VolumeBuilder builder = new V1VolumeBuilder(item);_visitables.remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Volume> getVolumes(){
            return build(volumes);
    }

    public List<V1Volume> buildVolumes(){
            return build(volumes);
    }

    public V1Volume buildVolume(int index){
            return this.volumes.get(index).build();
    }

    public V1Volume buildFirstVolume(){
            return this.volumes.get(0).build();
    }

    public V1Volume buildLastVolume(){
            return this.volumes.get(volumes.size() - 1).build();
    }

    public V1Volume buildMatchingVolume(io.kubernetes.client.fluent.Predicate<V1VolumeBuilder> predicate){
            for (V1VolumeBuilder item: volumes) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withVolumes(List<V1Volume> volumes){
            if (this.volumes != null) { _visitables.removeAll(this.volumes);}
            if (volumes != null) {this.volumes = new ArrayList<V1VolumeBuilder>(); for (V1Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(V1Volume... volumes){
            if (this.volumes != null) {this.volumes.clear();}
            if (volumes != null) {for (V1Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return volumes != null && !volumes.isEmpty();
    }

    public V1PodSpecFluent.VolumesNested<A> addNewVolume(){
            return new VolumesNestedImpl();
    }

    public V1PodSpecFluent.VolumesNested<A> addNewVolumeLike(V1Volume item){
            return new VolumesNestedImpl(-1, item);
    }

    public V1PodSpecFluent.VolumesNested<A> setNewVolumeLike(int index,V1Volume item){
            return new VolumesNestedImpl(index, item);
    }

    public V1PodSpecFluent.VolumesNested<A> editVolume(int index){
            if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public V1PodSpecFluent.VolumesNested<A> editFirstVolume(){
            if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
            return setNewVolumeLike(0, buildVolume(0));
    }

    public V1PodSpecFluent.VolumesNested<A> editLastVolume(){
            int index = volumes.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public V1PodSpecFluent.VolumesNested<A> editMatchingVolume(io.kubernetes.client.fluent.Predicate<V1VolumeBuilder> predicate){
            int index = -1;
            for (int i=0;i<volumes.size();i++) { 
            if (predicate.apply(volumes.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
            return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1PodSpecFluentImpl that = (V1PodSpecFluentImpl) o;
            if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
            if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
            if (automountServiceAccountToken != null ? !automountServiceAccountToken.equals(that.automountServiceAccountToken) :that.automountServiceAccountToken != null) return false;
            if (containers != null ? !containers.equals(that.containers) :that.containers != null) return false;
            if (dnsConfig != null ? !dnsConfig.equals(that.dnsConfig) :that.dnsConfig != null) return false;
            if (dnsPolicy != null ? !dnsPolicy.equals(that.dnsPolicy) :that.dnsPolicy != null) return false;
            if (hostAliases != null ? !hostAliases.equals(that.hostAliases) :that.hostAliases != null) return false;
            if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
            if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
            if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
            if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
            if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
            if (initContainers != null ? !initContainers.equals(that.initContainers) :that.initContainers != null) return false;
            if (nodeName != null ? !nodeName.equals(that.nodeName) :that.nodeName != null) return false;
            if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
            if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
            if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
            if (readinessGates != null ? !readinessGates.equals(that.readinessGates) :that.readinessGates != null) return false;
            if (restartPolicy != null ? !restartPolicy.equals(that.restartPolicy) :that.restartPolicy != null) return false;
            if (schedulerName != null ? !schedulerName.equals(that.schedulerName) :that.schedulerName != null) return false;
            if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
            if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
            if (serviceAccountName != null ? !serviceAccountName.equals(that.serviceAccountName) :that.serviceAccountName != null) return false;
            if (shareProcessNamespace != null ? !shareProcessNamespace.equals(that.shareProcessNamespace) :that.shareProcessNamespace != null) return false;
            if (subdomain != null ? !subdomain.equals(that.subdomain) :that.subdomain != null) return false;
            if (terminationGracePeriodSeconds != null ? !terminationGracePeriodSeconds.equals(that.terminationGracePeriodSeconds) :that.terminationGracePeriodSeconds != null) return false;
            if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }


    public class AffinityNestedImpl<N> extends V1AffinityFluentImpl<V1PodSpecFluent.AffinityNested<N>> implements V1PodSpecFluent.AffinityNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1AffinityBuilder builder;
    
            AffinityNestedImpl(V1Affinity item){
                    this.builder = new V1AffinityBuilder(this, item);
            }
            AffinityNestedImpl(){
                    this.builder = new V1AffinityBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.withAffinity(builder.build());
    }
    public N endAffinity(){
            return and();
    }

}
    public class ContainersNestedImpl<N> extends V1ContainerFluentImpl<V1PodSpecFluent.ContainersNested<N>> implements V1PodSpecFluent.ContainersNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ContainerBuilder builder;
        private final int index;
    
            ContainersNestedImpl(int index,V1Container item){
                    this.index = index;
                    this.builder = new V1ContainerBuilder(this, item);
            }
            ContainersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1ContainerBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.setToContainers(index, builder.build());
    }
    public N endContainer(){
            return and();
    }

}
    public class DnsConfigNestedImpl<N> extends V1PodDNSConfigFluentImpl<V1PodSpecFluent.DnsConfigNested<N>> implements V1PodSpecFluent.DnsConfigNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodDNSConfigBuilder builder;
    
            DnsConfigNestedImpl(V1PodDNSConfig item){
                    this.builder = new V1PodDNSConfigBuilder(this, item);
            }
            DnsConfigNestedImpl(){
                    this.builder = new V1PodDNSConfigBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.withDnsConfig(builder.build());
    }
    public N endDnsConfig(){
            return and();
    }

}
    public class HostAliasesNestedImpl<N> extends V1HostAliasFluentImpl<V1PodSpecFluent.HostAliasesNested<N>> implements V1PodSpecFluent.HostAliasesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1HostAliasBuilder builder;
        private final int index;
    
            HostAliasesNestedImpl(int index,V1HostAlias item){
                    this.index = index;
                    this.builder = new V1HostAliasBuilder(this, item);
            }
            HostAliasesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1HostAliasBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.setToHostAliases(index, builder.build());
    }
    public N endHostAlias(){
            return and();
    }

}
    public class ImagePullSecretsNestedImpl<N> extends V1LocalObjectReferenceFluentImpl<V1PodSpecFluent.ImagePullSecretsNested<N>> implements V1PodSpecFluent.ImagePullSecretsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1LocalObjectReferenceBuilder builder;
        private final int index;
    
            ImagePullSecretsNestedImpl(int index,V1LocalObjectReference item){
                    this.index = index;
                    this.builder = new V1LocalObjectReferenceBuilder(this, item);
            }
            ImagePullSecretsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.setToImagePullSecrets(index, builder.build());
    }
    public N endImagePullSecret(){
            return and();
    }

}
    public class InitContainersNestedImpl<N> extends V1ContainerFluentImpl<V1PodSpecFluent.InitContainersNested<N>> implements V1PodSpecFluent.InitContainersNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ContainerBuilder builder;
        private final int index;
    
            InitContainersNestedImpl(int index,V1Container item){
                    this.index = index;
                    this.builder = new V1ContainerBuilder(this, item);
            }
            InitContainersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1ContainerBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.setToInitContainers(index, builder.build());
    }
    public N endInitContainer(){
            return and();
    }

}
    public class ReadinessGatesNestedImpl<N> extends V1PodReadinessGateFluentImpl<V1PodSpecFluent.ReadinessGatesNested<N>> implements V1PodSpecFluent.ReadinessGatesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodReadinessGateBuilder builder;
        private final int index;
    
            ReadinessGatesNestedImpl(int index,V1PodReadinessGate item){
                    this.index = index;
                    this.builder = new V1PodReadinessGateBuilder(this, item);
            }
            ReadinessGatesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1PodReadinessGateBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.setToReadinessGates(index, builder.build());
    }
    public N endReadinessGate(){
            return and();
    }

}
    public class SecurityContextNestedImpl<N> extends V1PodSecurityContextFluentImpl<V1PodSpecFluent.SecurityContextNested<N>> implements V1PodSpecFluent.SecurityContextNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1PodSecurityContextBuilder builder;
    
            SecurityContextNestedImpl(V1PodSecurityContext item){
                    this.builder = new V1PodSecurityContextBuilder(this, item);
            }
            SecurityContextNestedImpl(){
                    this.builder = new V1PodSecurityContextBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.withSecurityContext(builder.build());
    }
    public N endSecurityContext(){
            return and();
    }

}
    public class TolerationsNestedImpl<N> extends V1TolerationFluentImpl<V1PodSpecFluent.TolerationsNested<N>> implements V1PodSpecFluent.TolerationsNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1TolerationBuilder builder;
        private final int index;
    
            TolerationsNestedImpl(int index,V1Toleration item){
                    this.index = index;
                    this.builder = new V1TolerationBuilder(this, item);
            }
            TolerationsNestedImpl(){
                    this.index = -1;
                    this.builder = new V1TolerationBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.setToTolerations(index, builder.build());
    }
    public N endToleration(){
            return and();
    }

}
    public class VolumesNestedImpl<N> extends V1VolumeFluentImpl<V1PodSpecFluent.VolumesNested<N>> implements V1PodSpecFluent.VolumesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1VolumeBuilder builder;
        private final int index;
    
            VolumesNestedImpl(int index,V1Volume item){
                    this.index = index;
                    this.builder = new V1VolumeBuilder(this, item);
            }
            VolumesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1VolumeBuilder(this);
            }
    
    public N and(){
            return (N) V1PodSpecFluentImpl.this.setToVolumes(index, builder.build());
    }
    public N endVolume(){
            return and();
    }

}


}
