package io.kubernetes.client.models;

import java.lang.Integer;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import org.joda.time.DateTime;

public interface V1HorizontalPodAutoscalerStatusFluent<A extends V1HorizontalPodAutoscalerStatusFluent<A>> extends Fluent<A>{


    public Integer getCurrentCPUUtilizationPercentage();
    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage);
    public Boolean hasCurrentCPUUtilizationPercentage();
    public A withNewCurrentCPUUtilizationPercentage(int arg1);
    public A withNewCurrentCPUUtilizationPercentage(String arg1);
    public Integer getCurrentReplicas();
    public A withCurrentReplicas(Integer currentReplicas);
    public Boolean hasCurrentReplicas();
    public A withNewCurrentReplicas(int arg1);
    public A withNewCurrentReplicas(String arg1);
    public Integer getDesiredReplicas();
    public A withDesiredReplicas(Integer desiredReplicas);
    public Boolean hasDesiredReplicas();
    public A withNewDesiredReplicas(int arg1);
    public A withNewDesiredReplicas(String arg1);
    public DateTime getLastScaleTime();
    public A withLastScaleTime(DateTime lastScaleTime);
    public Boolean hasLastScaleTime();
    public A withNewLastScaleTime(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewLastScaleTime(long arg0);
    public A withNewLastScaleTime(Object arg0);
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(String arg1);
    public A withNewObservedGeneration(long arg1);



}
