package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1RollbackConfigBuilder extends ExtensionsV1beta1RollbackConfigFluentImpl<ExtensionsV1beta1RollbackConfigBuilder> implements VisitableBuilder<ExtensionsV1beta1RollbackConfig,ExtensionsV1beta1RollbackConfigBuilder>{

    ExtensionsV1beta1RollbackConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1RollbackConfigBuilder(){
            this(true);
    }
    public ExtensionsV1beta1RollbackConfigBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1RollbackConfig(), validationEnabled);
    }
    public ExtensionsV1beta1RollbackConfigBuilder(ExtensionsV1beta1RollbackConfigFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1RollbackConfigBuilder(ExtensionsV1beta1RollbackConfigFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1RollbackConfig(), validationEnabled);
    }
    public ExtensionsV1beta1RollbackConfigBuilder(ExtensionsV1beta1RollbackConfigFluent<?> fluent,ExtensionsV1beta1RollbackConfig instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1RollbackConfigBuilder(ExtensionsV1beta1RollbackConfigFluent<?> fluent,ExtensionsV1beta1RollbackConfig instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRevision(instance.getRevision());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1RollbackConfigBuilder(ExtensionsV1beta1RollbackConfig instance){
            this(instance,true);
    }
    public ExtensionsV1beta1RollbackConfigBuilder(ExtensionsV1beta1RollbackConfig instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRevision(instance.getRevision());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1RollbackConfig build(){
            ExtensionsV1beta1RollbackConfig buildable = new ExtensionsV1beta1RollbackConfig();
            buildable.setRevision(fluent.getRevision());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1RollbackConfigBuilder that = (ExtensionsV1beta1RollbackConfigBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
