package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class AppsV1beta1ScaleStatusBuilder extends AppsV1beta1ScaleStatusFluentImpl<AppsV1beta1ScaleStatusBuilder> implements VisitableBuilder<AppsV1beta1ScaleStatus,AppsV1beta1ScaleStatusBuilder>{

    AppsV1beta1ScaleStatusFluent<?> fluent;
    Boolean validationEnabled;

    public AppsV1beta1ScaleStatusBuilder(){
            this(true);
    }
    public AppsV1beta1ScaleStatusBuilder(Boolean validationEnabled){
            this(new AppsV1beta1ScaleStatus(), validationEnabled);
    }
    public AppsV1beta1ScaleStatusBuilder(AppsV1beta1ScaleStatusFluent<?> fluent){
            this(fluent, true);
    }
    public AppsV1beta1ScaleStatusBuilder(AppsV1beta1ScaleStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new AppsV1beta1ScaleStatus(), validationEnabled);
    }
    public AppsV1beta1ScaleStatusBuilder(AppsV1beta1ScaleStatusFluent<?> fluent,AppsV1beta1ScaleStatus instance){
            this(fluent, instance, true);
    }
    public AppsV1beta1ScaleStatusBuilder(AppsV1beta1ScaleStatusFluent<?> fluent,AppsV1beta1ScaleStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas());

            fluent.withSelector(instance.getSelector());

            fluent.withTargetSelector(instance.getTargetSelector());

            this.validationEnabled = validationEnabled; 
    }
    public AppsV1beta1ScaleStatusBuilder(AppsV1beta1ScaleStatus instance){
            this(instance,true);
    }
    public AppsV1beta1ScaleStatusBuilder(AppsV1beta1ScaleStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas());

            this.withSelector(instance.getSelector());

            this.withTargetSelector(instance.getTargetSelector());

            this.validationEnabled = validationEnabled; 
    }

    public AppsV1beta1ScaleStatus build(){
            AppsV1beta1ScaleStatus buildable = new AppsV1beta1ScaleStatus();
            buildable.setReplicas(fluent.getReplicas());
            buildable.setSelector(fluent.getSelector());
            buildable.setTargetSelector(fluent.getTargetSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AppsV1beta1ScaleStatusBuilder that = (AppsV1beta1ScaleStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
