/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1beta2StatefulSetCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="StatefulSetStatus represents the current state of a StatefulSet.")
public class V1beta2StatefulSetStatus {
    @SerializedName(value="collisionCount")
    private Integer collisionCount = null;
    @SerializedName(value="conditions")
    private List<V1beta2StatefulSetCondition> conditions = null;
    @SerializedName(value="currentReplicas")
    private Integer currentReplicas = null;
    @SerializedName(value="currentRevision")
    private String currentRevision = null;
    @SerializedName(value="observedGeneration")
    private Long observedGeneration = null;
    @SerializedName(value="readyReplicas")
    private Integer readyReplicas = null;
    @SerializedName(value="replicas")
    private Integer replicas = null;
    @SerializedName(value="updateRevision")
    private String updateRevision = null;
    @SerializedName(value="updatedReplicas")
    private Integer updatedReplicas = null;

    public V1beta2StatefulSetStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @ApiModelProperty(value="collisionCount is the count of hash collisions for the StatefulSet. The StatefulSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.")
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1beta2StatefulSetStatus conditions(List<V1beta2StatefulSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1beta2StatefulSetStatus addConditionsItem(V1beta2StatefulSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta2StatefulSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="Represents the latest available observations of a statefulset's current state.")
    public List<V1beta2StatefulSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1beta2StatefulSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1beta2StatefulSetStatus currentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return this;
    }

    @ApiModelProperty(value="currentReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by currentRevision.")
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    public void setCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
    }

    public V1beta2StatefulSetStatus currentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
        return this;
    }

    @ApiModelProperty(value="currentRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [0,currentReplicas).")
    public String getCurrentRevision() {
        return this.currentRevision;
    }

    public void setCurrentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
    }

    public V1beta2StatefulSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @ApiModelProperty(value="observedGeneration is the most recent generation observed for this StatefulSet. It corresponds to the StatefulSet's generation, which is updated on mutation by the API Server.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1beta2StatefulSetStatus readyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return this;
    }

    @ApiModelProperty(value="readyReplicas is the number of Pods created by the StatefulSet controller that have a Ready Condition.")
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    public void setReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
    }

    public V1beta2StatefulSetStatus replicas(Integer replicas) {
        this.replicas = replicas;
        return this;
    }

    @ApiModelProperty(required=true, value="replicas is the number of Pods created by the StatefulSet controller.")
    public Integer getReplicas() {
        return this.replicas;
    }

    public void setReplicas(Integer replicas) {
        this.replicas = replicas;
    }

    public V1beta2StatefulSetStatus updateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
        return this;
    }

    @ApiModelProperty(value="updateRevision, if not empty, indicates the version of the StatefulSet used to generate Pods in the sequence [replicas-updatedReplicas,replicas)")
    public String getUpdateRevision() {
        return this.updateRevision;
    }

    public void setUpdateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
    }

    public V1beta2StatefulSetStatus updatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return this;
    }

    @ApiModelProperty(value="updatedReplicas is the number of Pods created by the StatefulSet controller from the StatefulSet version indicated by updateRevision.")
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    public void setUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta2StatefulSetStatus v1beta2StatefulSetStatus = (V1beta2StatefulSetStatus)o;
        return Objects.equals(this.collisionCount, v1beta2StatefulSetStatus.collisionCount) && Objects.equals(this.conditions, v1beta2StatefulSetStatus.conditions) && Objects.equals(this.currentReplicas, v1beta2StatefulSetStatus.currentReplicas) && Objects.equals(this.currentRevision, v1beta2StatefulSetStatus.currentRevision) && Objects.equals(this.observedGeneration, v1beta2StatefulSetStatus.observedGeneration) && Objects.equals(this.readyReplicas, v1beta2StatefulSetStatus.readyReplicas) && Objects.equals(this.replicas, v1beta2StatefulSetStatus.replicas) && Objects.equals(this.updateRevision, v1beta2StatefulSetStatus.updateRevision) && Objects.equals(this.updatedReplicas, v1beta2StatefulSetStatus.updatedReplicas);
    }

    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentReplicas, this.currentRevision, this.observedGeneration, this.readyReplicas, this.replicas, this.updateRevision, this.updatedReplicas);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta2StatefulSetStatus {\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentReplicas: ").append(this.toIndentedString(this.currentReplicas)).append("\n");
        sb.append("    currentRevision: ").append(this.toIndentedString(this.currentRevision)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    readyReplicas: ").append(this.toIndentedString(this.readyReplicas)).append("\n");
        sb.append("    replicas: ").append(this.toIndentedString(this.replicas)).append("\n");
        sb.append("    updateRevision: ").append(this.toIndentedString(this.updateRevision)).append("\n");
        sb.append("    updatedReplicas: ").append(this.toIndentedString(this.updatedReplicas)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

