/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.models.V1TokenReviewStatus;
import io.kubernetes.client.models.V1TokenReviewStatusFluent;
import io.kubernetes.client.models.V1UserInfo;
import io.kubernetes.client.models.V1UserInfoBuilder;
import io.kubernetes.client.models.V1UserInfoFluentImpl;

public class V1TokenReviewStatusFluentImpl<A extends V1TokenReviewStatusFluent<A>>
extends BaseFluent<A>
implements V1TokenReviewStatusFluent<A> {
    private Boolean authenticated;
    private String error;
    private V1UserInfoBuilder user;

    public V1TokenReviewStatusFluentImpl() {
    }

    public V1TokenReviewStatusFluentImpl(V1TokenReviewStatus instance) {
        this.withAuthenticated(instance.isAuthenticated());
        this.withError(instance.getError());
        this.withUser(instance.getUser());
    }

    @Override
    public Boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public A withAuthenticated(Boolean authenticated) {
        this.authenticated = authenticated;
        return (A)this;
    }

    @Override
    public Boolean hasAuthenticated() {
        return this.authenticated != null;
    }

    @Override
    public A withNewAuthenticated(boolean arg1) {
        return this.withAuthenticated(new Boolean(arg1));
    }

    @Override
    public A withNewAuthenticated(String arg1) {
        return this.withAuthenticated(new Boolean(arg1));
    }

    @Override
    public String getError() {
        return this.error;
    }

    @Override
    public A withError(String error) {
        this.error = error;
        return (A)this;
    }

    @Override
    public Boolean hasError() {
        return this.error != null;
    }

    @Override
    @Deprecated
    public V1UserInfo getUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public V1UserInfo buildUser() {
        return this.user != null ? this.user.build() : null;
    }

    @Override
    public A withUser(V1UserInfo user) {
        this._visitables.remove(this.user);
        if (user != null) {
            this.user = new V1UserInfoBuilder(user);
            this._visitables.add(this.user);
        }
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> withNewUser() {
        return new UserNestedImpl();
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> withNewUserLike(V1UserInfo item) {
        return new UserNestedImpl(item);
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> editUser() {
        return this.withNewUserLike(this.getUser());
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> editOrNewUser() {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : new V1UserInfoBuilder().build());
    }

    @Override
    public V1TokenReviewStatusFluent.UserNested<A> editOrNewUserLike(V1UserInfo item) {
        return this.withNewUserLike(this.getUser() != null ? this.getUser() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1TokenReviewStatusFluentImpl that = (V1TokenReviewStatusFluentImpl)o;
        if (this.authenticated != null ? !this.authenticated.equals(that.authenticated) : that.authenticated != null) {
            return false;
        }
        if (this.error != null ? !this.error.equals(that.error) : that.error != null) {
            return false;
        }
        return !(this.user != null ? !this.user.equals(that.user) : that.user != null);
    }

    public class UserNestedImpl<N>
    extends V1UserInfoFluentImpl<V1TokenReviewStatusFluent.UserNested<N>>
    implements V1TokenReviewStatusFluent.UserNested<N>,
    Nested<N> {
        private final V1UserInfoBuilder builder;

        UserNestedImpl(V1UserInfo item) {
            this.builder = new V1UserInfoBuilder(this, item);
        }

        UserNestedImpl() {
            this.builder = new V1UserInfoBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1TokenReviewStatusFluentImpl.this.withUser(this.builder.build());
        }

        @Override
        public N endUser() {
            return this.and();
        }
    }
}

