/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1beta1CapacityRequestPolicyRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="CapacityRequestPolicy defines how requests consume device capacity.  Must not set more than one ValidRequestValues.")
public class V1beta1CapacityRequestPolicy {
    public static final String SERIALIZED_NAME_DEFAULT = "default";
    @SerializedName(value="default")
    @Nullable
    private Quantity _default;
    public static final String SERIALIZED_NAME_VALID_RANGE = "validRange";
    @SerializedName(value="validRange")
    @Nullable
    private V1beta1CapacityRequestPolicyRange validRange;
    public static final String SERIALIZED_NAME_VALID_VALUES = "validValues";
    @SerializedName(value="validValues")
    @Nullable
    private List<Quantity> validValues = new ArrayList<Quantity>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1beta1CapacityRequestPolicy _default(@Nullable Quantity _default) {
        this._default = _default;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Quantity is a fixed-point representation of a number. It provides convenient marshaling/unmarshaling in JSON and YAML, in addition to String() and AsInt64() accessors.  The serialization format is:  ``` <quantity>        ::= <signedNumber><suffix>   (Note that <suffix> may be empty, from the \"\" case in <decimalSI>.)  <digit>           ::= 0 | 1 | ... | 9 <digits>          ::= <digit> | <digit><digits> <number>          ::= <digits> | <digits>.<digits> | <digits>. | .<digits> <sign>            ::= \"+\" | \"-\" <signedNumber>    ::= <number> | <sign><number> <suffix>          ::= <binarySI> | <decimalExponent> | <decimalSI> <binarySI>        ::= Ki | Mi | Gi | Ti | Pi | Ei   (International System of units; See: http://physics.nist.gov/cuu/Units/binary.html)  <decimalSI>       ::= m | \"\" | k | M | G | T | P | E   (Note that 1024 = 1Ki but 1000 = 1k; I didn't choose the capitalization.)  <decimalExponent> ::= \"e\" <signedNumber> | \"E\" <signedNumber> ```  No matter which of the three exponent forms is used, no quantity may represent a number greater than 2^63-1 in magnitude, nor may it have more than 3 decimal places. Numbers larger or more precise will be capped or rounded up. (E.g.: 0.1m will rounded up to 1m.) This may be extended in the future if we require larger or smaller quantities.  When a Quantity is parsed from a string, it will remember the type of suffix it had, and will use the same type again when it is serialized.  Before serializing, Quantity will be put in \"canonical form\". This means that Exponent/suffix will be adjusted up or down (with a corresponding increase or decrease in Mantissa) such that:  - No precision is lost - No fractional digits will be emitted - The exponent (or suffix) is as large as possible.  The sign will be omitted unless the number is negative.  Examples:  - 1.5 will be serialized as \"1500m\" - 1.5Gi will be serialized as \"1536Mi\"  Note that the quantity will NEVER be internally represented by a floating point number. That is the whole point of this exercise.  Non-canonical values will still parse as long as they are well formed, but will be re-emitted in their canonical form. (So always use canonical form, or don't diff.)  This format is intended to make it difficult to use these numbers without writing some sort of special handling code in the hopes that that will cause implementors to also use a fixed point implementation.")
    public Quantity getDefault() {
        return this._default;
    }

    public void setDefault(@Nullable Quantity _default) {
        this._default = _default;
    }

    public V1beta1CapacityRequestPolicy validRange(@Nullable V1beta1CapacityRequestPolicyRange validRange) {
        this.validRange = validRange;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1beta1CapacityRequestPolicyRange getValidRange() {
        return this.validRange;
    }

    public void setValidRange(@Nullable V1beta1CapacityRequestPolicyRange validRange) {
        this.validRange = validRange;
    }

    public V1beta1CapacityRequestPolicy validValues(@Nullable List<Quantity> validValues) {
        this.validValues = validValues;
        return this;
    }

    public V1beta1CapacityRequestPolicy addValidValuesItem(Quantity validValuesItem) {
        if (this.validValues == null) {
            this.validValues = new ArrayList<Quantity>();
        }
        this.validValues.add(validValuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ValidValues defines a set of acceptable quantity values in consuming requests.  Must not contain more than 10 entries. Must be sorted in ascending order.  If this field is set, Default must be defined and it must be included in ValidValues list.  If the requested amount does not match any valid value but smaller than some valid values, the scheduler calculates the smallest valid value that is greater than or equal to the request. That is: min(ceil(requestedValue) \u2208 validValues), where requestedValue \u2264 max(validValues).  If the requested amount exceeds all valid values, the request violates the policy, and this device cannot be allocated.")
    public List<Quantity> getValidValues() {
        return this.validValues;
    }

    public void setValidValues(@Nullable List<Quantity> validValues) {
        this.validValues = validValues;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CapacityRequestPolicy v1beta1CapacityRequestPolicy = (V1beta1CapacityRequestPolicy)o;
        return Objects.equals(this._default, v1beta1CapacityRequestPolicy._default) && Objects.equals(this.validRange, v1beta1CapacityRequestPolicy.validRange) && Objects.equals(this.validValues, v1beta1CapacityRequestPolicy.validValues);
    }

    public int hashCode() {
        return Objects.hash(this._default, this.validRange, this.validValues);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CapacityRequestPolicy {\n");
        sb.append("    _default: ").append(this.toIndentedString(this._default)).append("\n");
        sb.append("    validRange: ").append(this.toIndentedString(this.validRange)).append("\n");
        sb.append("    validValues: ").append(this.toIndentedString(this.validValues)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1beta1CapacityRequestPolicy is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1beta1CapacityRequestPolicy` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_DEFAULT) != null && !jsonObj.get(SERIALIZED_NAME_DEFAULT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEFAULT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `default` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEFAULT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALID_RANGE) != null && !jsonObj.get(SERIALIZED_NAME_VALID_RANGE).isJsonNull()) {
            V1beta1CapacityRequestPolicyRange.validateJsonElement(jsonObj.get(SERIALIZED_NAME_VALID_RANGE));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALID_VALUES) != null && !jsonObj.get(SERIALIZED_NAME_VALID_VALUES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VALID_VALUES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `validValues` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALID_VALUES).toString()));
        }
    }

    public static V1beta1CapacityRequestPolicy fromJson(String jsonString) throws IOException {
        return (V1beta1CapacityRequestPolicy)JSON.getGson().fromJson(jsonString, V1beta1CapacityRequestPolicy.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DEFAULT);
        openapiFields.add(SERIALIZED_NAME_VALID_RANGE);
        openapiFields.add(SERIALIZED_NAME_VALID_VALUES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1beta1CapacityRequestPolicy.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1beta1CapacityRequestPolicy.class));
            return new TypeAdapter<V1beta1CapacityRequestPolicy>(){

                public void write(JsonWriter out, V1beta1CapacityRequestPolicy value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1beta1CapacityRequestPolicy read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1beta1CapacityRequestPolicy.validateJsonElement(jsonElement);
                    return (V1beta1CapacityRequestPolicy)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

