/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1alpha1ClusterTrustBundleSpec;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ClusterTrustBundle is a cluster-scoped container for X.509 trust anchors (root certificates).  ClusterTrustBundle objects are considered to be readable by any authenticated user in the cluster, because they can be mounted by pods using the `clusterTrustBundle` projection.  All service accounts have read access to ClusterTrustBundles by default.  Users who only have namespace-level access to a cluster can read ClusterTrustBundles by impersonating a serviceaccount that they have access to.  It can be optionally associated with a particular assigner, in which case it contains one valid set of trust anchors for that signer. Signers may have multiple associated ClusterTrustBundles; each is an independent set of trust anchors for that signer. Admission control is used to enforce that only users with permissions on the signer can create or modify the corresponding bundle.")
public class V1alpha1ClusterTrustBundle
implements KubernetesObject {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    @Nullable
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    @Nullable
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    @Nullable
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_SPEC = "spec";
    @SerializedName(value="spec")
    @Nonnull
    private V1alpha1ClusterTrustBundleSpec spec;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha1ClusterTrustBundle apiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha1ClusterTrustBundle kind(@Nullable String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(@Nullable String kind) {
        this.kind = kind;
    }

    public V1alpha1ClusterTrustBundle metadata(@Nullable V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Override
    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1alpha1ClusterTrustBundle spec(@Nonnull V1alpha1ClusterTrustBundleSpec spec) {
        this.spec = spec;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public V1alpha1ClusterTrustBundleSpec getSpec() {
        return this.spec;
    }

    public void setSpec(@Nonnull V1alpha1ClusterTrustBundleSpec spec) {
        this.spec = spec;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ClusterTrustBundle v1alpha1ClusterTrustBundle = (V1alpha1ClusterTrustBundle)o;
        return Objects.equals(this.apiVersion, v1alpha1ClusterTrustBundle.apiVersion) && Objects.equals(this.kind, v1alpha1ClusterTrustBundle.kind) && Objects.equals(this.metadata, v1alpha1ClusterTrustBundle.metadata) && Objects.equals(this.spec, v1alpha1ClusterTrustBundle.spec);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ClusterTrustBundle {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha1ClusterTrustBundle is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha1ClusterTrustBundle` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_VERSION) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_VERSION).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersion` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_KIND) != null && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_KIND).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `kind` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_KIND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_METADATA) != null && !jsonObj.get(SERIALIZED_NAME_METADATA).isJsonNull()) {
            V1ObjectMeta.validateJsonElement(jsonObj.get(SERIALIZED_NAME_METADATA));
        }
        V1alpha1ClusterTrustBundleSpec.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SPEC));
    }

    public static V1alpha1ClusterTrustBundle fromJson(String jsonString) throws IOException {
        return (V1alpha1ClusterTrustBundle)JSON.getGson().fromJson(jsonString, V1alpha1ClusterTrustBundle.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_VERSION);
        openapiFields.add(SERIALIZED_NAME_KIND);
        openapiFields.add(SERIALIZED_NAME_METADATA);
        openapiFields.add(SERIALIZED_NAME_SPEC);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SPEC);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha1ClusterTrustBundle.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha1ClusterTrustBundle.class));
            return new TypeAdapter<V1alpha1ClusterTrustBundle>(){

                public void write(JsonWriter out, V1alpha1ClusterTrustBundle value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha1ClusterTrustBundle read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha1ClusterTrustBundle.validateJsonElement(jsonElement);
                    return (V1alpha1ClusterTrustBundle)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

