/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PortworxVolumeSource represents a Portworx volume resource.")
public class V1PortworxVolumeSource {
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    @Nullable
    private String fsType;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    @Nullable
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_VOLUME_I_D = "volumeID";
    @SerializedName(value="volumeID")
    @Nonnull
    private String volumeID;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PortworxVolumeSource fsType(@Nullable String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\". Implicitly inferred to be \"ext4\" if unspecified.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(@Nullable String fsType) {
        this.fsType = fsType;
    }

    public V1PortworxVolumeSource readOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(@Nullable Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1PortworxVolumeSource volumeID(@Nonnull String volumeID) {
        this.volumeID = volumeID;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="volumeID uniquely identifies a Portworx volume")
    public String getVolumeID() {
        return this.volumeID;
    }

    public void setVolumeID(@Nonnull String volumeID) {
        this.volumeID = volumeID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PortworxVolumeSource v1PortworxVolumeSource = (V1PortworxVolumeSource)o;
        return Objects.equals(this.fsType, v1PortworxVolumeSource.fsType) && Objects.equals(this.readOnly, v1PortworxVolumeSource.readOnly) && Objects.equals(this.volumeID, v1PortworxVolumeSource.volumeID);
    }

    public int hashCode() {
        return Objects.hash(this.fsType, this.readOnly, this.volumeID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PortworxVolumeSource {\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    volumeID: ").append(this.toIndentedString(this.volumeID)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PortworxVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PortworxVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_FS_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FS_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `fsType` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FS_TYPE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_VOLUME_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumeID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_I_D).toString()));
        }
    }

    public static V1PortworxVolumeSource fromJson(String jsonString) throws IOException {
        return (V1PortworxVolumeSource)JSON.getGson().fromJson(jsonString, V1PortworxVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FS_TYPE);
        openapiFields.add(SERIALIZED_NAME_READ_ONLY);
        openapiFields.add(SERIALIZED_NAME_VOLUME_I_D);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_VOLUME_I_D);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PortworxVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PortworxVolumeSource.class));
            return new TypeAdapter<V1PortworxVolumeSource>(){

                public void write(JsonWriter out, V1PortworxVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PortworxVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PortworxVolumeSource.validateJsonElement(jsonElement);
                    return (V1PortworxVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

