/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ModifyVolumeStatus;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PersistentVolumeClaimStatus is the current status of a persistent volume claim.")
public class V1PersistentVolumeClaimStatus {
    public static final String SERIALIZED_NAME_ACCESS_MODES = "accessModes";
    @SerializedName(value="accessModes")
    @Nullable
    private List<String> accessModes = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ALLOCATED_RESOURCE_STATUSES = "allocatedResourceStatuses";
    @SerializedName(value="allocatedResourceStatuses")
    @Nullable
    private Map<String, String> allocatedResourceStatuses = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_ALLOCATED_RESOURCES = "allocatedResources";
    @SerializedName(value="allocatedResources")
    @Nullable
    private Map<String, Quantity> allocatedResources = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_CAPACITY = "capacity";
    @SerializedName(value="capacity")
    @Nullable
    private Map<String, Quantity> capacity = new HashMap<String, Quantity>();
    public static final String SERIALIZED_NAME_CONDITIONS = "conditions";
    @SerializedName(value="conditions")
    @Nullable
    private List<V1PersistentVolumeClaimCondition> conditions = new ArrayList<V1PersistentVolumeClaimCondition>();
    public static final String SERIALIZED_NAME_CURRENT_VOLUME_ATTRIBUTES_CLASS_NAME = "currentVolumeAttributesClassName";
    @SerializedName(value="currentVolumeAttributesClassName")
    @Nullable
    private String currentVolumeAttributesClassName;
    public static final String SERIALIZED_NAME_MODIFY_VOLUME_STATUS = "modifyVolumeStatus";
    @SerializedName(value="modifyVolumeStatus")
    @Nullable
    private V1ModifyVolumeStatus modifyVolumeStatus;
    public static final String SERIALIZED_NAME_PHASE = "phase";
    @SerializedName(value="phase")
    @Nullable
    private String phase;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PersistentVolumeClaimStatus accessModes(@Nullable List<String> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public V1PersistentVolumeClaimStatus addAccessModesItem(String accessModesItem) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(accessModesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="accessModes contains the actual access modes the volume backing the PVC has. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1")
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    public void setAccessModes(@Nullable List<String> accessModes) {
        this.accessModes = accessModes;
    }

    public V1PersistentVolumeClaimStatus allocatedResourceStatuses(@Nullable Map<String, String> allocatedResourceStatuses) {
        this.allocatedResourceStatuses = allocatedResourceStatuses;
        return this;
    }

    public V1PersistentVolumeClaimStatus putAllocatedResourceStatusesItem(String key, String allocatedResourceStatusesItem) {
        if (this.allocatedResourceStatuses == null) {
            this.allocatedResourceStatuses = new HashMap<String, String>();
        }
        this.allocatedResourceStatuses.put(key, allocatedResourceStatusesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allocatedResourceStatuses stores status of resource being resized for the given PVC. Key names follow standard Kubernetes label syntax. Valid values are either:  * Un-prefixed keys:   - storage - the capacity of the volume.  * Custom resources must use implementation-defined prefixed names such as \"example.com/my-custom-resource\" Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.  ClaimResourceStatus can be in any of following states:  - ControllerResizeInProgress:   State set when resize controller starts resizing the volume in control-plane.  - ControllerResizeFailed:   State set when resize has failed in resize controller with a terminal error.  - NodeResizePending:   State set when resize controller has finished resizing the volume but further resizing of   volume is needed on the node.  - NodeResizeInProgress:   State set when kubelet starts resizing the volume.  - NodeResizeFailed:   State set when resizing has failed in kubelet with a terminal error. Transient errors don't set   NodeResizeFailed. For example: if expanding a PVC for more capacity - this field can be one of the following states:  - pvc.status.allocatedResourceStatus['storage'] = \"ControllerResizeInProgress\"      - pvc.status.allocatedResourceStatus['storage'] = \"ControllerResizeFailed\"      - pvc.status.allocatedResourceStatus['storage'] = \"NodeResizePending\"      - pvc.status.allocatedResourceStatus['storage'] = \"NodeResizeInProgress\"      - pvc.status.allocatedResourceStatus['storage'] = \"NodeResizeFailed\" When this field is not set, it means that no resize operation is in progress for the given PVC.  A controller that receives PVC update with previously unknown resourceName or ClaimResourceStatus should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.  This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.")
    public Map<String, String> getAllocatedResourceStatuses() {
        return this.allocatedResourceStatuses;
    }

    public void setAllocatedResourceStatuses(@Nullable Map<String, String> allocatedResourceStatuses) {
        this.allocatedResourceStatuses = allocatedResourceStatuses;
    }

    public V1PersistentVolumeClaimStatus allocatedResources(@Nullable Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
        return this;
    }

    public V1PersistentVolumeClaimStatus putAllocatedResourcesItem(String key, Quantity allocatedResourcesItem) {
        if (this.allocatedResources == null) {
            this.allocatedResources = new HashMap<String, Quantity>();
        }
        this.allocatedResources.put(key, allocatedResourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="allocatedResources tracks the resources allocated to a PVC including its capacity. Key names follow standard Kubernetes label syntax. Valid values are either:  * Un-prefixed keys:   - storage - the capacity of the volume.  * Custom resources must use implementation-defined prefixed names such as \"example.com/my-custom-resource\" Apart from above values - keys that are unprefixed or have kubernetes.io prefix are considered reserved and hence may not be used.  Capacity reported here may be larger than the actual capacity when a volume expansion operation is requested. For storage quota, the larger value from allocatedResources and PVC.spec.resources is used. If allocatedResources is not set, PVC.spec.resources alone is used for quota calculation. If a volume expansion capacity request is lowered, allocatedResources is only lowered if there are no expansion operations in progress and if the actual volume capacity is equal or lower than the requested capacity.  A controller that receives PVC update with previously unknown resourceName should ignore the update for the purpose it was designed. For example - a controller that only is responsible for resizing capacity of the volume, should ignore PVC updates that change other valid resources associated with PVC.  This is an alpha field and requires enabling RecoverVolumeExpansionFailure feature.")
    public Map<String, Quantity> getAllocatedResources() {
        return this.allocatedResources;
    }

    public void setAllocatedResources(@Nullable Map<String, Quantity> allocatedResources) {
        this.allocatedResources = allocatedResources;
    }

    public V1PersistentVolumeClaimStatus capacity(@Nullable Map<String, Quantity> capacity) {
        this.capacity = capacity;
        return this;
    }

    public V1PersistentVolumeClaimStatus putCapacityItem(String key, Quantity capacityItem) {
        if (this.capacity == null) {
            this.capacity = new HashMap<String, Quantity>();
        }
        this.capacity.put(key, capacityItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="capacity represents the actual resources of the underlying volume.")
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    public void setCapacity(@Nullable Map<String, Quantity> capacity) {
        this.capacity = capacity;
    }

    public V1PersistentVolumeClaimStatus conditions(@Nullable List<V1PersistentVolumeClaimCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1PersistentVolumeClaimStatus addConditionsItem(V1PersistentVolumeClaimCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PersistentVolumeClaimCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="conditions is the current Condition of persistent volume claim. If underlying persistent volume is being resized then the Condition will be set to 'Resizing'.")
    public List<V1PersistentVolumeClaimCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable List<V1PersistentVolumeClaimCondition> conditions) {
        this.conditions = conditions;
    }

    public V1PersistentVolumeClaimStatus currentVolumeAttributesClassName(@Nullable String currentVolumeAttributesClassName) {
        this.currentVolumeAttributesClassName = currentVolumeAttributesClassName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="currentVolumeAttributesClassName is the current name of the VolumeAttributesClass the PVC is using. When unset, there is no VolumeAttributeClass applied to this PersistentVolumeClaim")
    public String getCurrentVolumeAttributesClassName() {
        return this.currentVolumeAttributesClassName;
    }

    public void setCurrentVolumeAttributesClassName(@Nullable String currentVolumeAttributesClassName) {
        this.currentVolumeAttributesClassName = currentVolumeAttributesClassName;
    }

    public V1PersistentVolumeClaimStatus modifyVolumeStatus(@Nullable V1ModifyVolumeStatus modifyVolumeStatus) {
        this.modifyVolumeStatus = modifyVolumeStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ModifyVolumeStatus getModifyVolumeStatus() {
        return this.modifyVolumeStatus;
    }

    public void setModifyVolumeStatus(@Nullable V1ModifyVolumeStatus modifyVolumeStatus) {
        this.modifyVolumeStatus = modifyVolumeStatus;
    }

    public V1PersistentVolumeClaimStatus phase(@Nullable String phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="phase represents the current phase of PersistentVolumeClaim.")
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(@Nullable String phase) {
        this.phase = phase;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimStatus v1PersistentVolumeClaimStatus = (V1PersistentVolumeClaimStatus)o;
        return Objects.equals(this.accessModes, v1PersistentVolumeClaimStatus.accessModes) && Objects.equals(this.allocatedResourceStatuses, v1PersistentVolumeClaimStatus.allocatedResourceStatuses) && Objects.equals(this.allocatedResources, v1PersistentVolumeClaimStatus.allocatedResources) && Objects.equals(this.capacity, v1PersistentVolumeClaimStatus.capacity) && Objects.equals(this.conditions, v1PersistentVolumeClaimStatus.conditions) && Objects.equals(this.currentVolumeAttributesClassName, v1PersistentVolumeClaimStatus.currentVolumeAttributesClassName) && Objects.equals(this.modifyVolumeStatus, v1PersistentVolumeClaimStatus.modifyVolumeStatus) && Objects.equals(this.phase, v1PersistentVolumeClaimStatus.phase);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.allocatedResourceStatuses, this.allocatedResources, this.capacity, this.conditions, this.currentVolumeAttributesClassName, this.modifyVolumeStatus, this.phase);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PersistentVolumeClaimStatus {\n");
        sb.append("    accessModes: ").append(this.toIndentedString(this.accessModes)).append("\n");
        sb.append("    allocatedResourceStatuses: ").append(this.toIndentedString(this.allocatedResourceStatuses)).append("\n");
        sb.append("    allocatedResources: ").append(this.toIndentedString(this.allocatedResources)).append("\n");
        sb.append("    capacity: ").append(this.toIndentedString(this.capacity)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentVolumeAttributesClassName: ").append(this.toIndentedString(this.currentVolumeAttributesClassName)).append("\n");
        sb.append("    modifyVolumeStatus: ").append(this.toIndentedString(this.modifyVolumeStatus)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString(this.phase)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayconditions;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PersistentVolumeClaimStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PersistentVolumeClaimStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ACCESS_MODES) != null && !jsonObj.get(SERIALIZED_NAME_ACCESS_MODES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ACCESS_MODES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `accessModes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACCESS_MODES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonNull() && (jsonArrayconditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `conditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONDITIONS).toString()));
            }
            for (int i = 0; i < jsonArrayconditions.size(); ++i) {
                V1PersistentVolumeClaimCondition.validateJsonElement(jsonArrayconditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_CURRENT_VOLUME_ATTRIBUTES_CLASS_NAME) != null && !jsonObj.get(SERIALIZED_NAME_CURRENT_VOLUME_ATTRIBUTES_CLASS_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CURRENT_VOLUME_ATTRIBUTES_CLASS_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `currentVolumeAttributesClassName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CURRENT_VOLUME_ATTRIBUTES_CLASS_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MODIFY_VOLUME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_MODIFY_VOLUME_STATUS).isJsonNull()) {
            V1ModifyVolumeStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MODIFY_VOLUME_STATUS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PHASE) != null && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PHASE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `phase` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PHASE).toString()));
        }
    }

    public static V1PersistentVolumeClaimStatus fromJson(String jsonString) throws IOException {
        return (V1PersistentVolumeClaimStatus)JSON.getGson().fromJson(jsonString, V1PersistentVolumeClaimStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACCESS_MODES);
        openapiFields.add(SERIALIZED_NAME_ALLOCATED_RESOURCE_STATUSES);
        openapiFields.add(SERIALIZED_NAME_ALLOCATED_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_CAPACITY);
        openapiFields.add(SERIALIZED_NAME_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_CURRENT_VOLUME_ATTRIBUTES_CLASS_NAME);
        openapiFields.add(SERIALIZED_NAME_MODIFY_VOLUME_STATUS);
        openapiFields.add(SERIALIZED_NAME_PHASE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PersistentVolumeClaimStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PersistentVolumeClaimStatus.class));
            return new TypeAdapter<V1PersistentVolumeClaimStatus>(){

                public void write(JsonWriter out, V1PersistentVolumeClaimStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PersistentVolumeClaimStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PersistentVolumeClaimStatus.validateJsonElement(jsonElement);
                    return (V1PersistentVolumeClaimStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

