/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1NetworkPolicyEgressRule;
import io.kubernetes.client.openapi.models.V1NetworkPolicyIngressRule;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="NetworkPolicySpec provides the specification of a NetworkPolicy")
public class V1NetworkPolicySpec {
    public static final String SERIALIZED_NAME_EGRESS = "egress";
    @SerializedName(value="egress")
    @Nullable
    private List<V1NetworkPolicyEgressRule> egress = new ArrayList<V1NetworkPolicyEgressRule>();
    public static final String SERIALIZED_NAME_INGRESS = "ingress";
    @SerializedName(value="ingress")
    @Nullable
    private List<V1NetworkPolicyIngressRule> ingress = new ArrayList<V1NetworkPolicyIngressRule>();
    public static final String SERIALIZED_NAME_POD_SELECTOR = "podSelector";
    @SerializedName(value="podSelector")
    @Nullable
    private V1LabelSelector podSelector;
    public static final String SERIALIZED_NAME_POLICY_TYPES = "policyTypes";
    @SerializedName(value="policyTypes")
    @Nullable
    private List<String> policyTypes = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NetworkPolicySpec egress(@Nullable List<V1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
        return this;
    }

    public V1NetworkPolicySpec addEgressItem(V1NetworkPolicyEgressRule egressItem) {
        if (this.egress == null) {
            this.egress = new ArrayList<V1NetworkPolicyEgressRule>();
        }
        this.egress.add(egressItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="egress is a list of egress rules to be applied to the selected pods. Outgoing traffic is allowed if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic matches at least one egress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy limits all outgoing traffic (and serves solely to ensure that the pods it selects are isolated by default). This field is beta-level in 1.8")
    public List<V1NetworkPolicyEgressRule> getEgress() {
        return this.egress;
    }

    public void setEgress(@Nullable List<V1NetworkPolicyEgressRule> egress) {
        this.egress = egress;
    }

    public V1NetworkPolicySpec ingress(@Nullable List<V1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
        return this;
    }

    public V1NetworkPolicySpec addIngressItem(V1NetworkPolicyIngressRule ingressItem) {
        if (this.ingress == null) {
            this.ingress = new ArrayList<V1NetworkPolicyIngressRule>();
        }
        this.ingress.add(ingressItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ingress is a list of ingress rules to be applied to the selected pods. Traffic is allowed to a pod if there are no NetworkPolicies selecting the pod (and cluster policy otherwise allows the traffic), OR if the traffic source is the pod's local node, OR if the traffic matches at least one ingress rule across all of the NetworkPolicy objects whose podSelector matches the pod. If this field is empty then this NetworkPolicy does not allow any traffic (and serves solely to ensure that the pods it selects are isolated by default)")
    public List<V1NetworkPolicyIngressRule> getIngress() {
        return this.ingress;
    }

    public void setIngress(@Nullable List<V1NetworkPolicyIngressRule> ingress) {
        this.ingress = ingress;
    }

    public V1NetworkPolicySpec podSelector(@Nullable V1LabelSelector podSelector) {
        this.podSelector = podSelector;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LabelSelector getPodSelector() {
        return this.podSelector;
    }

    public void setPodSelector(@Nullable V1LabelSelector podSelector) {
        this.podSelector = podSelector;
    }

    public V1NetworkPolicySpec policyTypes(@Nullable List<String> policyTypes) {
        this.policyTypes = policyTypes;
        return this;
    }

    public V1NetworkPolicySpec addPolicyTypesItem(String policyTypesItem) {
        if (this.policyTypes == null) {
            this.policyTypes = new ArrayList<String>();
        }
        this.policyTypes.add(policyTypesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="policyTypes is a list of rule types that the NetworkPolicy relates to. Valid options are [\"Ingress\"], [\"Egress\"], or [\"Ingress\", \"Egress\"]. If this field is not specified, it will default based on the existence of ingress or egress rules; policies that contain an egress section are assumed to affect egress, and all policies (whether or not they contain an ingress section) are assumed to affect ingress. If you want to write an egress-only policy, you must explicitly specify policyTypes [ \"Egress\" ]. Likewise, if you want to write a policy that specifies that no egress is allowed, you must specify a policyTypes value that include \"Egress\" (since such a policy would not include an egress section and would otherwise default to just [ \"Ingress\" ]). This field is beta-level in 1.8")
    public List<String> getPolicyTypes() {
        return this.policyTypes;
    }

    public void setPolicyTypes(@Nullable List<String> policyTypes) {
        this.policyTypes = policyTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NetworkPolicySpec v1NetworkPolicySpec = (V1NetworkPolicySpec)o;
        return Objects.equals(this.egress, v1NetworkPolicySpec.egress) && Objects.equals(this.ingress, v1NetworkPolicySpec.ingress) && Objects.equals(this.podSelector, v1NetworkPolicySpec.podSelector) && Objects.equals(this.policyTypes, v1NetworkPolicySpec.policyTypes);
    }

    public int hashCode() {
        return Objects.hash(this.egress, this.ingress, this.podSelector, this.policyTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NetworkPolicySpec {\n");
        sb.append("    egress: ").append(this.toIndentedString(this.egress)).append("\n");
        sb.append("    ingress: ").append(this.toIndentedString(this.ingress)).append("\n");
        sb.append("    podSelector: ").append(this.toIndentedString(this.podSelector)).append("\n");
        sb.append("    policyTypes: ").append(this.toIndentedString(this.policyTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayingress;
        int i;
        JsonArray jsonArrayegress;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NetworkPolicySpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NetworkPolicySpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_EGRESS) != null && !jsonObj.get(SERIALIZED_NAME_EGRESS).isJsonNull() && (jsonArrayegress = jsonObj.getAsJsonArray(SERIALIZED_NAME_EGRESS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_EGRESS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `egress` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EGRESS).toString()));
            }
            for (i = 0; i < jsonArrayegress.size(); ++i) {
                V1NetworkPolicyEgressRule.validateJsonElement(jsonArrayegress.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_INGRESS) != null && !jsonObj.get(SERIALIZED_NAME_INGRESS).isJsonNull() && (jsonArrayingress = jsonObj.getAsJsonArray(SERIALIZED_NAME_INGRESS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_INGRESS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ingress` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INGRESS).toString()));
            }
            for (i = 0; i < jsonArrayingress.size(); ++i) {
                V1NetworkPolicyIngressRule.validateJsonElement(jsonArrayingress.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_POD_SELECTOR) != null && !jsonObj.get(SERIALIZED_NAME_POD_SELECTOR).isJsonNull()) {
            V1LabelSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_POD_SELECTOR));
        }
        if (jsonObj.get(SERIALIZED_NAME_POLICY_TYPES) != null && !jsonObj.get(SERIALIZED_NAME_POLICY_TYPES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POLICY_TYPES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `policyTypes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POLICY_TYPES).toString()));
        }
    }

    public static V1NetworkPolicySpec fromJson(String jsonString) throws IOException {
        return (V1NetworkPolicySpec)JSON.getGson().fromJson(jsonString, V1NetworkPolicySpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EGRESS);
        openapiFields.add(SERIALIZED_NAME_INGRESS);
        openapiFields.add(SERIALIZED_NAME_POD_SELECTOR);
        openapiFields.add(SERIALIZED_NAME_POLICY_TYPES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NetworkPolicySpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NetworkPolicySpec.class));
            return new TypeAdapter<V1NetworkPolicySpec>(){

                public void write(JsonWriter out, V1NetworkPolicySpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NetworkPolicySpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1NetworkPolicySpec.validateJsonElement(jsonElement);
                    return (V1NetworkPolicySpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

