/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ContainerRestartRuleOnExitCodes describes the condition for handling an exited container based on its exit codes.")
public class V1ContainerRestartRuleOnExitCodes {
    public static final String SERIALIZED_NAME_OPERATOR = "operator";
    @SerializedName(value="operator")
    @Nonnull
    private String operator;
    public static final String SERIALIZED_NAME_VALUES = "values";
    @SerializedName(value="values")
    @Nullable
    private List<Integer> values = new ArrayList<Integer>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ContainerRestartRuleOnExitCodes operator(@Nonnull String operator) {
        this.operator = operator;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Represents the relationship between the container exit code(s) and the specified values. Possible values are: - In: the requirement is satisfied if the container exit code is in the   set of specified values. - NotIn: the requirement is satisfied if the container exit code is   not in the set of specified values.")
    public String getOperator() {
        return this.operator;
    }

    public void setOperator(@Nonnull String operator) {
        this.operator = operator;
    }

    public V1ContainerRestartRuleOnExitCodes values(@Nullable List<Integer> values) {
        this.values = values;
        return this;
    }

    public V1ContainerRestartRuleOnExitCodes addValuesItem(Integer valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<Integer>();
        }
        this.values.add(valuesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specifies the set of values to check for container exit codes. At most 255 elements are allowed.")
    public List<Integer> getValues() {
        return this.values;
    }

    public void setValues(@Nullable List<Integer> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerRestartRuleOnExitCodes v1ContainerRestartRuleOnExitCodes = (V1ContainerRestartRuleOnExitCodes)o;
        return Objects.equals(this.operator, v1ContainerRestartRuleOnExitCodes.operator) && Objects.equals(this.values, v1ContainerRestartRuleOnExitCodes.values);
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerRestartRuleOnExitCodes {\n");
        sb.append("    operator: ").append(this.toIndentedString(this.operator)).append("\n");
        sb.append("    values: ").append(this.toIndentedString(this.values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ContainerRestartRuleOnExitCodes is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ContainerRestartRuleOnExitCodes` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_OPERATOR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `operator` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATOR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALUES) != null && !jsonObj.get(SERIALIZED_NAME_VALUES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_VALUES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `values` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALUES).toString()));
        }
    }

    public static V1ContainerRestartRuleOnExitCodes fromJson(String jsonString) throws IOException {
        return (V1ContainerRestartRuleOnExitCodes)JSON.getGson().fromJson(jsonString, V1ContainerRestartRuleOnExitCodes.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_OPERATOR);
        openapiFields.add(SERIALIZED_NAME_VALUES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_OPERATOR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ContainerRestartRuleOnExitCodes.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ContainerRestartRuleOnExitCodes.class));
            return new TypeAdapter<V1ContainerRestartRuleOnExitCodes>(){

                public void write(JsonWriter out, V1ContainerRestartRuleOnExitCodes value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ContainerRestartRuleOnExitCodes read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ContainerRestartRuleOnExitCodes.validateJsonElement(jsonElement);
                    return (V1ContainerRestartRuleOnExitCodes)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

