/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ContainerExtendedResourceRequest has the mapping of container name, extended resource name to the device request name.")
public class V1ContainerExtendedResourceRequest {
    public static final String SERIALIZED_NAME_CONTAINER_NAME = "containerName";
    @SerializedName(value="containerName")
    @Nonnull
    private String containerName;
    public static final String SERIALIZED_NAME_REQUEST_NAME = "requestName";
    @SerializedName(value="requestName")
    @Nonnull
    private String requestName;
    public static final String SERIALIZED_NAME_RESOURCE_NAME = "resourceName";
    @SerializedName(value="resourceName")
    @Nonnull
    private String resourceName;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ContainerExtendedResourceRequest containerName(@Nonnull String containerName) {
        this.containerName = containerName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the container requesting resources.")
    public String getContainerName() {
        return this.containerName;
    }

    public void setContainerName(@Nonnull String containerName) {
        this.containerName = containerName;
    }

    public V1ContainerExtendedResourceRequest requestName(@Nonnull String requestName) {
        this.requestName = requestName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the request in the special ResourceClaim which corresponds to the extended resource.")
    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(@Nonnull String requestName) {
        this.requestName = requestName;
    }

    public V1ContainerExtendedResourceRequest resourceName(@Nonnull String resourceName) {
        this.resourceName = resourceName;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the extended resource in that container which gets backed by DRA.")
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(@Nonnull String resourceName) {
        this.resourceName = resourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ContainerExtendedResourceRequest v1ContainerExtendedResourceRequest = (V1ContainerExtendedResourceRequest)o;
        return Objects.equals(this.containerName, v1ContainerExtendedResourceRequest.containerName) && Objects.equals(this.requestName, v1ContainerExtendedResourceRequest.requestName) && Objects.equals(this.resourceName, v1ContainerExtendedResourceRequest.resourceName);
    }

    public int hashCode() {
        return Objects.hash(this.containerName, this.requestName, this.resourceName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ContainerExtendedResourceRequest {\n");
        sb.append("    containerName: ").append(this.toIndentedString(this.containerName)).append("\n");
        sb.append("    requestName: ").append(this.toIndentedString(this.requestName)).append("\n");
        sb.append("    resourceName: ").append(this.toIndentedString(this.resourceName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ContainerExtendedResourceRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ContainerExtendedResourceRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_CONTAINER_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `containerName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_REQUEST_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `requestName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REQUEST_NAME).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_RESOURCE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceName` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_NAME).toString()));
        }
    }

    public static V1ContainerExtendedResourceRequest fromJson(String jsonString) throws IOException {
        return (V1ContainerExtendedResourceRequest)JSON.getGson().fromJson(jsonString, V1ContainerExtendedResourceRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINER_NAME);
        openapiFields.add(SERIALIZED_NAME_REQUEST_NAME);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONTAINER_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_REQUEST_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_RESOURCE_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ContainerExtendedResourceRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ContainerExtendedResourceRequest.class));
            return new TypeAdapter<V1ContainerExtendedResourceRequest>(){

                public void write(JsonWriter out, V1ContainerExtendedResourceRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ContainerExtendedResourceRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ContainerExtendedResourceRequest.validateJsonElement(jsonElement);
                    return (V1ContainerExtendedResourceRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

