/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1ContainerResizePolicy;
import io.kubernetes.client.openapi.models.V1ContainerRestartRule;
import io.kubernetes.client.openapi.models.V1EnvFromSource;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1Lifecycle;
import io.kubernetes.client.openapi.models.V1Probe;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1SecurityContext;
import io.kubernetes.client.openapi.models.V1VolumeDevice;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="A single application container that you want to run within a pod.")
public class V1Container {
    public static final String SERIALIZED_NAME_ARGS = "args";
    @SerializedName(value="args")
    @Nullable
    private List<String> args = new ArrayList<String>();
    public static final String SERIALIZED_NAME_COMMAND = "command";
    @SerializedName(value="command")
    @Nullable
    private List<String> command = new ArrayList<String>();
    public static final String SERIALIZED_NAME_ENV = "env";
    @SerializedName(value="env")
    @Nullable
    private List<V1EnvVar> env = new ArrayList<V1EnvVar>();
    public static final String SERIALIZED_NAME_ENV_FROM = "envFrom";
    @SerializedName(value="envFrom")
    @Nullable
    private List<V1EnvFromSource> envFrom = new ArrayList<V1EnvFromSource>();
    public static final String SERIALIZED_NAME_IMAGE = "image";
    @SerializedName(value="image")
    @Nullable
    private String image;
    public static final String SERIALIZED_NAME_IMAGE_PULL_POLICY = "imagePullPolicy";
    @SerializedName(value="imagePullPolicy")
    @Nullable
    private String imagePullPolicy;
    public static final String SERIALIZED_NAME_LIFECYCLE = "lifecycle";
    @SerializedName(value="lifecycle")
    @Nullable
    private V1Lifecycle lifecycle;
    public static final String SERIALIZED_NAME_LIVENESS_PROBE = "livenessProbe";
    @SerializedName(value="livenessProbe")
    @Nullable
    private V1Probe livenessProbe;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_PORTS = "ports";
    @SerializedName(value="ports")
    @Nullable
    private List<V1ContainerPort> ports = new ArrayList<V1ContainerPort>();
    public static final String SERIALIZED_NAME_READINESS_PROBE = "readinessProbe";
    @SerializedName(value="readinessProbe")
    @Nullable
    private V1Probe readinessProbe;
    public static final String SERIALIZED_NAME_RESIZE_POLICY = "resizePolicy";
    @SerializedName(value="resizePolicy")
    @Nullable
    private List<V1ContainerResizePolicy> resizePolicy = new ArrayList<V1ContainerResizePolicy>();
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    @Nullable
    private V1ResourceRequirements resources;
    public static final String SERIALIZED_NAME_RESTART_POLICY = "restartPolicy";
    @SerializedName(value="restartPolicy")
    @Nullable
    private String restartPolicy;
    public static final String SERIALIZED_NAME_RESTART_POLICY_RULES = "restartPolicyRules";
    @SerializedName(value="restartPolicyRules")
    @Nullable
    private List<V1ContainerRestartRule> restartPolicyRules = new ArrayList<V1ContainerRestartRule>();
    public static final String SERIALIZED_NAME_SECURITY_CONTEXT = "securityContext";
    @SerializedName(value="securityContext")
    @Nullable
    private V1SecurityContext securityContext;
    public static final String SERIALIZED_NAME_STARTUP_PROBE = "startupProbe";
    @SerializedName(value="startupProbe")
    @Nullable
    private V1Probe startupProbe;
    public static final String SERIALIZED_NAME_STDIN = "stdin";
    @SerializedName(value="stdin")
    @Nullable
    private Boolean stdin;
    public static final String SERIALIZED_NAME_STDIN_ONCE = "stdinOnce";
    @SerializedName(value="stdinOnce")
    @Nullable
    private Boolean stdinOnce;
    public static final String SERIALIZED_NAME_TERMINATION_MESSAGE_PATH = "terminationMessagePath";
    @SerializedName(value="terminationMessagePath")
    @Nullable
    private String terminationMessagePath;
    public static final String SERIALIZED_NAME_TERMINATION_MESSAGE_POLICY = "terminationMessagePolicy";
    @SerializedName(value="terminationMessagePolicy")
    @Nullable
    private String terminationMessagePolicy;
    public static final String SERIALIZED_NAME_TTY = "tty";
    @SerializedName(value="tty")
    @Nullable
    private Boolean tty;
    public static final String SERIALIZED_NAME_VOLUME_DEVICES = "volumeDevices";
    @SerializedName(value="volumeDevices")
    @Nullable
    private List<V1VolumeDevice> volumeDevices = new ArrayList<V1VolumeDevice>();
    public static final String SERIALIZED_NAME_VOLUME_MOUNTS = "volumeMounts";
    @SerializedName(value="volumeMounts")
    @Nullable
    private List<V1VolumeMount> volumeMounts = new ArrayList<V1VolumeMount>();
    public static final String SERIALIZED_NAME_WORKING_DIR = "workingDir";
    @SerializedName(value="workingDir")
    @Nullable
    private String workingDir;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1Container args(@Nullable List<String> args) {
        this.args = args;
        return this;
    }

    public V1Container addArgsItem(String argsItem) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(argsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Arguments to the entrypoint. The container image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will produce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(@Nullable List<String> args) {
        this.args = args;
    }

    public V1Container command(@Nullable List<String> command) {
        this.command = command;
        return this;
    }

    public V1Container addCommandItem(String commandItem) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(commandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Entrypoint array. Not executed within a shell. The container image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. Double $$ are reduced to a single $, which allows for escaping the $(VAR_NAME) syntax: i.e. \"$$(VAR_NAME)\" will produce the string literal \"$(VAR_NAME)\". Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell")
    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(@Nullable List<String> command) {
        this.command = command;
    }

    public V1Container env(@Nullable List<V1EnvVar> env) {
        this.env = env;
        return this;
    }

    public V1Container addEnvItem(V1EnvVar envItem) {
        if (this.env == null) {
            this.env = new ArrayList<V1EnvVar>();
        }
        this.env.add(envItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of environment variables to set in the container. Cannot be updated.")
    public List<V1EnvVar> getEnv() {
        return this.env;
    }

    public void setEnv(@Nullable List<V1EnvVar> env) {
        this.env = env;
    }

    public V1Container envFrom(@Nullable List<V1EnvFromSource> envFrom) {
        this.envFrom = envFrom;
        return this;
    }

    public V1Container addEnvFromItem(V1EnvFromSource envFromItem) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList<V1EnvFromSource>();
        }
        this.envFrom.add(envFromItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of sources to populate environment variables in the container. The keys defined within a source may consist of any printable ASCII characters except '='. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated.")
    public List<V1EnvFromSource> getEnvFrom() {
        return this.envFrom;
    }

    public void setEnvFrom(@Nullable List<V1EnvFromSource> envFrom) {
        this.envFrom = envFrom;
    }

    public V1Container image(@Nullable String image) {
        this.image = image;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container image name. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.")
    public String getImage() {
        return this.image;
    }

    public void setImage(@Nullable String image) {
        this.image = image;
    }

    public V1Container imagePullPolicy(@Nullable String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images")
    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public void setImagePullPolicy(@Nullable String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
    }

    public V1Container lifecycle(@Nullable V1Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    public void setLifecycle(@Nullable V1Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    public V1Container livenessProbe(@Nullable V1Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public void setLivenessProbe(@Nullable V1Probe livenessProbe) {
        this.livenessProbe = livenessProbe;
    }

    public V1Container name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL). Cannot be updated.")
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public V1Container ports(@Nullable List<V1ContainerPort> ports) {
        this.ports = ports;
        return this;
    }

    public V1Container addPortsItem(V1ContainerPort portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<V1ContainerPort>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="List of ports to expose from the container. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default \"0.0.0.0\" address inside a container will be accessible from the network. Modifying this array with strategic merge patch may corrupt the data. For more information See https://github.com/kubernetes/kubernetes/issues/108255. Cannot be updated.")
    public List<V1ContainerPort> getPorts() {
        return this.ports;
    }

    public void setPorts(@Nullable List<V1ContainerPort> ports) {
        this.ports = ports;
    }

    public V1Container readinessProbe(@Nullable V1Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public void setReadinessProbe(@Nullable V1Probe readinessProbe) {
        this.readinessProbe = readinessProbe;
    }

    public V1Container resizePolicy(@Nullable List<V1ContainerResizePolicy> resizePolicy) {
        this.resizePolicy = resizePolicy;
        return this;
    }

    public V1Container addResizePolicyItem(V1ContainerResizePolicy resizePolicyItem) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList<V1ContainerResizePolicy>();
        }
        this.resizePolicy.add(resizePolicyItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resources resize policy for the container.")
    public List<V1ContainerResizePolicy> getResizePolicy() {
        return this.resizePolicy;
    }

    public void setResizePolicy(@Nullable List<V1ContainerResizePolicy> resizePolicy) {
        this.resizePolicy = resizePolicy;
    }

    public V1Container resources(@Nullable V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(@Nullable V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1Container restartPolicy(@Nullable String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RestartPolicy defines the restart behavior of individual containers in a pod. This overrides the pod-level restart policy. When this field is not specified, the restart behavior is defined by the Pod's restart policy and the container type. Additionally, setting the RestartPolicy as \"Always\" for the init container will have the following effect: this init container will be continually restarted on exit until all regular containers have terminated. Once all regular containers have completed, all init containers with restartPolicy \"Always\" will be shut down. This lifecycle differs from normal init containers and is often referred to as a \"sidecar\" container. Although this init container still starts in the init container sequence, it does not wait for the container to complete before proceeding to the next init container. Instead, the next init container starts immediately after this init container is started, or after any startupProbe has successfully completed.")
    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(@Nullable String restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public V1Container restartPolicyRules(@Nullable List<V1ContainerRestartRule> restartPolicyRules) {
        this.restartPolicyRules = restartPolicyRules;
        return this;
    }

    public V1Container addRestartPolicyRulesItem(V1ContainerRestartRule restartPolicyRulesItem) {
        if (this.restartPolicyRules == null) {
            this.restartPolicyRules = new ArrayList<V1ContainerRestartRule>();
        }
        this.restartPolicyRules.add(restartPolicyRulesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Represents a list of rules to be checked to determine if the container should be restarted on exit. The rules are evaluated in order. Once a rule matches a container exit condition, the remaining rules are ignored. If no rule matches the container exit condition, the Container-level restart policy determines the whether the container is restarted or not. Constraints on the rules: - At most 20 rules are allowed. - Rules can have the same action. - Identical rules are not forbidden in validations. When rules are specified, container MUST set RestartPolicy explicitly even it if matches the Pod's RestartPolicy.")
    public List<V1ContainerRestartRule> getRestartPolicyRules() {
        return this.restartPolicyRules;
    }

    public void setRestartPolicyRules(@Nullable List<V1ContainerRestartRule> restartPolicyRules) {
        this.restartPolicyRules = restartPolicyRules;
    }

    public V1Container securityContext(@Nullable V1SecurityContext securityContext) {
        this.securityContext = securityContext;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(@Nullable V1SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public V1Container startupProbe(@Nullable V1Probe startupProbe) {
        this.startupProbe = startupProbe;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1Probe getStartupProbe() {
        return this.startupProbe;
    }

    public void setStartupProbe(@Nullable V1Probe startupProbe) {
        this.startupProbe = startupProbe;
    }

    public V1Container stdin(@Nullable Boolean stdin) {
        this.stdin = stdin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false.")
    public Boolean getStdin() {
        return this.stdin;
    }

    public void setStdin(@Nullable Boolean stdin) {
        this.stdin = stdin;
    }

    public V1Container stdinOnce(@Nullable Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false")
    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public void setStdinOnce(@Nullable Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
    }

    public V1Container terminationMessagePath(@Nullable String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated.")
    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public void setTerminationMessagePath(@Nullable String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
    }

    public V1Container terminationMessagePolicy(@Nullable String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated.")
    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public void setTerminationMessagePolicy(@Nullable String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
    }

    public V1Container tty(@Nullable Boolean tty) {
        this.tty = tty;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false.")
    public Boolean getTty() {
        return this.tty;
    }

    public void setTty(@Nullable Boolean tty) {
        this.tty = tty;
    }

    public V1Container volumeDevices(@Nullable List<V1VolumeDevice> volumeDevices) {
        this.volumeDevices = volumeDevices;
        return this;
    }

    public V1Container addVolumeDevicesItem(V1VolumeDevice volumeDevicesItem) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList<V1VolumeDevice>();
        }
        this.volumeDevices.add(volumeDevicesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="volumeDevices is the list of block devices to be used by the container.")
    public List<V1VolumeDevice> getVolumeDevices() {
        return this.volumeDevices;
    }

    public void setVolumeDevices(@Nullable List<V1VolumeDevice> volumeDevices) {
        this.volumeDevices = volumeDevices;
    }

    public V1Container volumeMounts(@Nullable List<V1VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public V1Container addVolumeMountsItem(V1VolumeMount volumeMountsItem) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList<V1VolumeMount>();
        }
        this.volumeMounts.add(volumeMountsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pod volumes to mount into the container's filesystem. Cannot be updated.")
    public List<V1VolumeMount> getVolumeMounts() {
        return this.volumeMounts;
    }

    public void setVolumeMounts(@Nullable List<V1VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
    }

    public V1Container workingDir(@Nullable String workingDir) {
        this.workingDir = workingDir;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated.")
    public String getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(@Nullable String workingDir) {
        this.workingDir = workingDir;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Container v1Container = (V1Container)o;
        return Objects.equals(this.args, v1Container.args) && Objects.equals(this.command, v1Container.command) && Objects.equals(this.env, v1Container.env) && Objects.equals(this.envFrom, v1Container.envFrom) && Objects.equals(this.image, v1Container.image) && Objects.equals(this.imagePullPolicy, v1Container.imagePullPolicy) && Objects.equals(this.lifecycle, v1Container.lifecycle) && Objects.equals(this.livenessProbe, v1Container.livenessProbe) && Objects.equals(this.name, v1Container.name) && Objects.equals(this.ports, v1Container.ports) && Objects.equals(this.readinessProbe, v1Container.readinessProbe) && Objects.equals(this.resizePolicy, v1Container.resizePolicy) && Objects.equals(this.resources, v1Container.resources) && Objects.equals(this.restartPolicy, v1Container.restartPolicy) && Objects.equals(this.restartPolicyRules, v1Container.restartPolicyRules) && Objects.equals(this.securityContext, v1Container.securityContext) && Objects.equals(this.startupProbe, v1Container.startupProbe) && Objects.equals(this.stdin, v1Container.stdin) && Objects.equals(this.stdinOnce, v1Container.stdinOnce) && Objects.equals(this.terminationMessagePath, v1Container.terminationMessagePath) && Objects.equals(this.terminationMessagePolicy, v1Container.terminationMessagePolicy) && Objects.equals(this.tty, v1Container.tty) && Objects.equals(this.volumeDevices, v1Container.volumeDevices) && Objects.equals(this.volumeMounts, v1Container.volumeMounts) && Objects.equals(this.workingDir, v1Container.workingDir);
    }

    public int hashCode() {
        return Objects.hash(this.args, this.command, this.env, this.envFrom, this.image, this.imagePullPolicy, this.lifecycle, this.livenessProbe, this.name, this.ports, this.readinessProbe, this.resizePolicy, this.resources, this.restartPolicy, this.restartPolicyRules, this.securityContext, this.startupProbe, this.stdin, this.stdinOnce, this.terminationMessagePath, this.terminationMessagePolicy, this.tty, this.volumeDevices, this.volumeMounts, this.workingDir);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Container {\n");
        sb.append("    args: ").append(this.toIndentedString(this.args)).append("\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("    env: ").append(this.toIndentedString(this.env)).append("\n");
        sb.append("    envFrom: ").append(this.toIndentedString(this.envFrom)).append("\n");
        sb.append("    image: ").append(this.toIndentedString(this.image)).append("\n");
        sb.append("    imagePullPolicy: ").append(this.toIndentedString(this.imagePullPolicy)).append("\n");
        sb.append("    lifecycle: ").append(this.toIndentedString(this.lifecycle)).append("\n");
        sb.append("    livenessProbe: ").append(this.toIndentedString(this.livenessProbe)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    readinessProbe: ").append(this.toIndentedString(this.readinessProbe)).append("\n");
        sb.append("    resizePolicy: ").append(this.toIndentedString(this.resizePolicy)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    restartPolicy: ").append(this.toIndentedString(this.restartPolicy)).append("\n");
        sb.append("    restartPolicyRules: ").append(this.toIndentedString(this.restartPolicyRules)).append("\n");
        sb.append("    securityContext: ").append(this.toIndentedString(this.securityContext)).append("\n");
        sb.append("    startupProbe: ").append(this.toIndentedString(this.startupProbe)).append("\n");
        sb.append("    stdin: ").append(this.toIndentedString(this.stdin)).append("\n");
        sb.append("    stdinOnce: ").append(this.toIndentedString(this.stdinOnce)).append("\n");
        sb.append("    terminationMessagePath: ").append(this.toIndentedString(this.terminationMessagePath)).append("\n");
        sb.append("    terminationMessagePolicy: ").append(this.toIndentedString(this.terminationMessagePolicy)).append("\n");
        sb.append("    tty: ").append(this.toIndentedString(this.tty)).append("\n");
        sb.append("    volumeDevices: ").append(this.toIndentedString(this.volumeDevices)).append("\n");
        sb.append("    volumeMounts: ").append(this.toIndentedString(this.volumeMounts)).append("\n");
        sb.append("    workingDir: ").append(this.toIndentedString(this.workingDir)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvolumeMounts;
        JsonArray jsonArrayvolumeDevices;
        JsonArray jsonArrayrestartPolicyRules;
        JsonArray jsonArrayresizePolicy;
        JsonArray jsonArrayports;
        JsonArray jsonArrayenvFrom;
        int i;
        JsonArray jsonArrayenv;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1Container is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1Container` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ARGS) != null && !jsonObj.get(SERIALIZED_NAME_ARGS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ARGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `args` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ARGS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMAND).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ENV) != null && !jsonObj.get(SERIALIZED_NAME_ENV).isJsonNull() && (jsonArrayenv = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENV)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENV).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `env` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENV).toString()));
            }
            for (i = 0; i < jsonArrayenv.size(); ++i) {
                V1EnvVar.validateJsonElement(jsonArrayenv.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ENV_FROM) != null && !jsonObj.get(SERIALIZED_NAME_ENV_FROM).isJsonNull() && (jsonArrayenvFrom = jsonObj.getAsJsonArray(SERIALIZED_NAME_ENV_FROM)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_ENV_FROM).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `envFrom` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENV_FROM).toString()));
            }
            for (i = 0; i < jsonArrayenvFrom.size(); ++i) {
                V1EnvFromSource.validateJsonElement(jsonArrayenvFrom.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `image` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `imagePullPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGE_PULL_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIFECYCLE) != null && !jsonObj.get(SERIALIZED_NAME_LIFECYCLE).isJsonNull()) {
            V1Lifecycle.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LIFECYCLE));
        }
        if (jsonObj.get(SERIALIZED_NAME_LIVENESS_PROBE) != null && !jsonObj.get(SERIALIZED_NAME_LIVENESS_PROBE).isJsonNull()) {
            V1Probe.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LIVENESS_PROBE));
        }
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTS) != null && !jsonObj.get(SERIALIZED_NAME_PORTS).isJsonNull() && (jsonArrayports = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `ports` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTS).toString()));
            }
            for (i = 0; i < jsonArrayports.size(); ++i) {
                V1ContainerPort.validateJsonElement(jsonArrayports.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_READINESS_PROBE) != null && !jsonObj.get(SERIALIZED_NAME_READINESS_PROBE).isJsonNull()) {
            V1Probe.validateJsonElement(jsonObj.get(SERIALIZED_NAME_READINESS_PROBE));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESIZE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESIZE_POLICY).isJsonNull() && (jsonArrayresizePolicy = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESIZE_POLICY)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESIZE_POLICY).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `resizePolicy` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESIZE_POLICY).toString()));
            }
            for (i = 0; i < jsonArrayresizePolicy.size(); ++i) {
                V1ContainerResizePolicy.validateJsonElement(jsonArrayresizePolicy.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull()) {
            V1ResourceRequirements.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RESOURCES));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `restartPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTART_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESTART_POLICY_RULES) != null && !jsonObj.get(SERIALIZED_NAME_RESTART_POLICY_RULES).isJsonNull() && (jsonArrayrestartPolicyRules = jsonObj.getAsJsonArray(SERIALIZED_NAME_RESTART_POLICY_RULES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_RESTART_POLICY_RULES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `restartPolicyRules` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESTART_POLICY_RULES).toString()));
            }
            for (i = 0; i < jsonArrayrestartPolicyRules.size(); ++i) {
                V1ContainerRestartRule.validateJsonElement(jsonArrayrestartPolicyRules.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT) != null && !jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT).isJsonNull()) {
            V1SecurityContext.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SECURITY_CONTEXT));
        }
        if (jsonObj.get(SERIALIZED_NAME_STARTUP_PROBE) != null && !jsonObj.get(SERIALIZED_NAME_STARTUP_PROBE).isJsonNull()) {
            V1Probe.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STARTUP_PROBE));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINATION_MESSAGE_PATH) != null && !jsonObj.get(SERIALIZED_NAME_TERMINATION_MESSAGE_PATH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TERMINATION_MESSAGE_PATH).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `terminationMessagePath` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINATION_MESSAGE_PATH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TERMINATION_MESSAGE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_TERMINATION_MESSAGE_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TERMINATION_MESSAGE_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `terminationMessagePolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TERMINATION_MESSAGE_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_DEVICES).isJsonNull() && (jsonArrayvolumeDevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumeDevices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_DEVICES).toString()));
            }
            for (i = 0; i < jsonArrayvolumeDevices.size(); ++i) {
                V1VolumeDevice.validateJsonElement(jsonArrayvolumeDevices.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUME_MOUNTS) != null && !jsonObj.get(SERIALIZED_NAME_VOLUME_MOUNTS).isJsonNull() && (jsonArrayvolumeMounts = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUME_MOUNTS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUME_MOUNTS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `volumeMounts` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUME_MOUNTS).toString()));
            }
            for (i = 0; i < jsonArrayvolumeMounts.size(); ++i) {
                V1VolumeMount.validateJsonElement(jsonArrayvolumeMounts.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_WORKING_DIR) != null && !jsonObj.get(SERIALIZED_NAME_WORKING_DIR).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_WORKING_DIR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `workingDir` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_WORKING_DIR).toString()));
        }
    }

    public static V1Container fromJson(String jsonString) throws IOException {
        return (V1Container)JSON.getGson().fromJson(jsonString, V1Container.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ARGS);
        openapiFields.add(SERIALIZED_NAME_COMMAND);
        openapiFields.add(SERIALIZED_NAME_ENV);
        openapiFields.add(SERIALIZED_NAME_ENV_FROM);
        openapiFields.add(SERIALIZED_NAME_IMAGE);
        openapiFields.add(SERIALIZED_NAME_IMAGE_PULL_POLICY);
        openapiFields.add(SERIALIZED_NAME_LIFECYCLE);
        openapiFields.add(SERIALIZED_NAME_LIVENESS_PROBE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PORTS);
        openapiFields.add(SERIALIZED_NAME_READINESS_PROBE);
        openapiFields.add(SERIALIZED_NAME_RESIZE_POLICY);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY);
        openapiFields.add(SERIALIZED_NAME_RESTART_POLICY_RULES);
        openapiFields.add(SERIALIZED_NAME_SECURITY_CONTEXT);
        openapiFields.add(SERIALIZED_NAME_STARTUP_PROBE);
        openapiFields.add(SERIALIZED_NAME_STDIN);
        openapiFields.add(SERIALIZED_NAME_STDIN_ONCE);
        openapiFields.add(SERIALIZED_NAME_TERMINATION_MESSAGE_PATH);
        openapiFields.add(SERIALIZED_NAME_TERMINATION_MESSAGE_POLICY);
        openapiFields.add(SERIALIZED_NAME_TTY);
        openapiFields.add(SERIALIZED_NAME_VOLUME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_VOLUME_MOUNTS);
        openapiFields.add(SERIALIZED_NAME_WORKING_DIR);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1Container.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1Container.class));
            return new TypeAdapter<V1Container>(){

                public void write(JsonWriter out, V1Container value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1Container read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1Container.validateJsonElement(jsonElement);
                    return (V1Container)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

